import numpy as np
from ase.build import fcc100
from hiphive import ClusterSpace, StructureContainer
from hiphive.core.rotational_constraints import get_rotational_constraint_matrix
from trainstation import Optimizer
from hiphive.utilities import prepare_structure
from ase.calculators.emt import EMT


def test_rotational_constraint_matrix():
    np.random.seed(42)

    # make dummy model
    prim = fcc100('Al', (1, 1, 3), vacuum=10, a=4.0)
    prim.pbc = True
    cs = ClusterSpace(prim, [5.0])
    atoms_ideal = prim.repeat((5, 5, 1))
    atoms = atoms_ideal.copy()
    atoms.rattle(0.05, seed=100)
    atoms = prepare_structure(atoms, atoms_ideal, calc=EMT())
    sc = StructureContainer(cs)
    sc.add_structure(atoms)
    A, y = sc.get_fit_data()
    opt = Optimizer((A, y), train_size=1.0)
    opt.train()

    # get constraint matrix
    Ac = get_rotational_constraint_matrix(cs)

    if False:
        np.set_printoptions(precision=25, threshold=1000000)
        print(repr(Ac))

    Ac_target = np.array([
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.8421709430404007e-14,
             -1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.8421709430404007e-14,
             -1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.4116620165382783e-13,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.0048591735576159e-14,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.8284271247235614e+02,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.3474201390907385e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.9876159799998138e+01,
             3.5777087639710402e+02,  3.5777087639710402e+02,
             0.0000000000000000e+00, -1.3474201390907385e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.6948402781814771e+00,
             -8.8888888888177718e+01,  6.1728395061728358e-01,
             -1.3926212476344406e+02, -1.3926212476344406e+02,
             -1.1102230246251565e-15,  0.0000000000000000e+00,
             -1.7457431218739717e+02, -1.2123216124221812e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.8421709430404007e-14,
             1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -5.6843418860808015e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.8421709430404007e-14,
             1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.9381642090009908e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00, -7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -7.1054273576010019e-15,  0.0000000000000000e+00,
             7.1054273576010019e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.8421709430404007e-14,
             1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             5.6843418860808015e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.8421709430404007e-14,
             1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.9381642090009908e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.4116620165382783e-13,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.0048591735576159e-14,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.8421709430404007e-14,
             -1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.8421709430404007e-14,
             -1.2404250937606341e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.8284271247235614e+02,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.3474201390907385e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.9876159799998153e+01,
             3.5777087639710402e+02,  3.5777087639710402e+02,
             0.0000000000000000e+00, -1.3474201390907385e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.6948402781814771e+00,
             -8.8888888888177718e+01,  6.1728395061728358e-01,
             -1.3926212476344406e+02, -1.3926212476344406e+02,
             -1.1102230246251565e-15,  0.0000000000000000e+00,
             -1.7457431218739717e+02, -1.2123216124221812e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00, -7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -7.1054273576010019e-15,  0.0000000000000000e+00,
             7.1054273576010019e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             7.1054273576010019e-15,  0.0000000000000000e+00,
             -7.1054273576010019e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  3.9720546451956367e-16,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             7.1054273576010019e-15,  0.0000000000000000e+00,
             -7.1054273576010019e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -7.1054273576010019e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.8284271247235614e+02,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.3474201390907385e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.9876159799998138e+01,
             -3.5777087639710402e+02, -3.5777087639710402e+02,
             0.0000000000000000e+00,  1.3474201390907385e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.6948402781814771e+00,
             8.8888888888177718e+01, -6.1728395061728358e-01,
             1.3926212476344406e+02,  1.3926212476344406e+02,
             1.1102230246251565e-15,  0.0000000000000000e+00,
             1.7457431218739717e+02,  1.2123216124221812e+00],
            [-1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.9381642090009908e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [-1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.9381642090009908e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.8284271247235614e+02,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.3474201390907385e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.9876159799998153e+01,
             -3.5777087639710402e+02, -3.5777087639710402e+02,
             0.0000000000000000e+00,  1.3474201390907385e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.6948402781814771e+00,
             8.8888888888177718e+01, -6.1728395061728358e-01,
             1.3926212476344406e+02,  1.3926212476344406e+02,
             1.1102230246251565e-15,  0.0000000000000000e+00,
             1.7457431218739717e+02,  1.2123216124221812e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -3.9720546451956367e-16,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             4.4721359549816924e+01,  4.4721359549816924e+01,
             -8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.6666666666666664e+01,  0.0000000000000000e+00,
             -1.1111111111066670e+01,  0.0000000000000000e+00,
             -1.7407765595500152e+01, -1.7407765595500152e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.1821789023511954e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00, -3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -4.4721359549816924e+01, -4.4721359549816924e+01,
             8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.6666666666666664e+01,  0.0000000000000000e+00,
             1.1111111111066670e+01,  0.0000000000000000e+00,
             1.7407765595500152e+01,  1.7407765595500152e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.1821789023511954e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             4.4721359549816924e+01,  4.4721359549816924e+01,
             -8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.6666666666666664e+01,  0.0000000000000000e+00,
             -1.1111111111066670e+01,  0.0000000000000000e+00,
             -1.7407765595500152e+01, -1.7407765595500152e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.1821789023511954e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00, -3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -4.4721359549816924e+01, -4.4721359549816924e+01,
             8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.6666666666666664e+01,  0.0000000000000000e+00,
             1.1111111111066670e+01,  0.0000000000000000e+00,
             1.7407765595500152e+01,  1.7407765595500152e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.1821789023511954e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  4.2632564145606011e-14,
             1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.0658141036401503e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.4210854715202004e-14,
             1.0658141036401503e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -4.2632564145606011e-14,
             -1.4210854715202004e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.0658141036401503e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.4210854715202004e-14,
             -1.0658141036401503e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -3.5527136788005009e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.7763568394002505e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  3.5527136788005009e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.0658141036401503e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.4210854715202004e-14,
             -1.0658141036401503e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.7763568394002505e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.0658141036401503e-14,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.4210854715202004e-14,
             1.0658141036401503e-14,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             3.5527136788005009e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.7763568394002505e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -3.5527136788005009e-15,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -1.7763568394002505e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.2204460492503131e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  1.7763568394002505e-15,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.1102230246251565e-16,  0.0000000000000000e+00,
             0.0000000000000000e+00,  2.2204460492503131e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.2204460492503131e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.1102230246251565e-16,  0.0000000000000000e+00,
             0.0000000000000000e+00, -2.2204460492503131e-16],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00, -3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -4.4721359549816924e+01, -4.4721359549816924e+01,
             8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.6666666666666664e+01,  0.0000000000000000e+00,
             1.1111111111066677e+01,  0.0000000000000000e+00,
             1.7407765595500166e+01,  1.7407765595500166e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.1821789023511968e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             4.4721359549816924e+01,  4.4721359549816924e+01,
             -8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.6666666666666664e+01,  0.0000000000000000e+00,
             -1.1111111111066677e+01,  0.0000000000000000e+00,
             -1.7407765595500166e+01, -1.7407765595500166e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.1821789023511968e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00, -3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -4.4721359549816924e+01, -4.4721359549816924e+01,
             8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             1.6666666666666664e+01,  0.0000000000000000e+00,
             1.1111111111066677e+01,  0.0000000000000000e+00,
             1.7407765595500166e+01,  1.7407765595500166e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             2.1821789023511968e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  3.5355339059185965e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00, -8.3333333333333321e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.4999999999999993e+01,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             4.4721359549816924e+01,  4.4721359549816924e+01,
             -8.3333333333333321e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -1.6666666666666664e+01,  0.0000000000000000e+00,
             -1.1111111111066677e+01,  0.0000000000000000e+00,
             -1.7407765595500166e+01, -1.7407765595500166e+01,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             -2.1821789023511968e+01,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00],
            [0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00,
             0.0000000000000000e+00,  0.0000000000000000e+00]])

    assert np.allclose(Ac, Ac_target)
