#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import importlib

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.coverage',
    'sphinx.ext.doctest',
    'sphinx.ext.graphviz',
    'sphinx.ext.ifconfig',
    'sphinx.ext.intersphinx',
    'sphinx.ext.mathjax',
    'sphinx.ext.napoleon',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinx_autodoc_typehints',
    'sphinx_sitemap',
    'sphinx_design',
    'nbsphinx',
]

graphviz_output_format = 'svg'
templates_path = ['_templates']
default_role = 'code'
source_suffix = '.rst'
master_doc = 'index'
pygments_style = 'sphinx'
todo_include_todos = False

# Collect basic information from main module
metadata = importlib.metadata.metadata('hiphive')
version = metadata.get('Version', 'n/a')
project = metadata.get('Name', 'n/a')
author = metadata.get('Author', 'n/a')

site_url = 'https://hiphive.materialsmodeling.org'
html_css_files = ['custom.css']
html_logo = '_static/logo.png'
html_favicon = '_static/logo.ico'
html_static_path = ['_static']
htmlhelp_basename = 'hiPhivedoc'
intersphinx_mapping = {
    'ase': ('https://wiki.fysik.dtu.dk/ase', None),
    'numpy': ('https://numpy.org/doc/stable/', None),
    'h5py': ('http://docs.h5py.org/en/latest/', None),
    'scipy': ('https://scipy.github.io/devdocs/', None),
    'sklearn': ('https://scikit-learn.org/stable', None),
    'trainstation': ('https://trainstation.materialsmodeling.org/', None),
}

# sphinx theme configuration
html_theme = 'pydata_sphinx_theme'
html_theme_options = {
    'secondary_sidebar_items': ['page-toc'],
    'switcher': {
        'json_url': 'https://hiphive.materialsmodeling.org/_static/switcher.json',
        'version_match': version,
    },
    'navbar_start': ['navbar-logo', 'version-switcher'],
}
html_sidebars = {
    'credits': [],
}

# Settings for nbsphinx
nbsphinx_execute = 'never'

# Options for LaTeX output
_PREAMBLE = r"""
\usepackage{amsmath,amssymb}
\renewcommand{\vec}[1]{\boldsymbol{#1}}
\DeclareMathOperator*{\argmin}{\arg\!\min}
\DeclareMathOperator{\argmin}{\arg\!\min}
"""

latex_elements = {
    'preamble': _PREAMBLE,
}
latex_documents = [
    (master_doc, 'hiPhive.tex', 'hiPhive Documentation',
     'The hiPhive developer team', 'manual'),
]


# Options for manual page output
man_pages = [
    (master_doc, 'hiPhive', 'hiPhive Documentation',
     [author], 1)
]


# Options for Texinfo output
texinfo_documents = [
    (master_doc, 'hiPhive', 'hiPhive Documentation',
     author, 'hiPhive', 'Higher order force constants for everyone',
     'Miscellaneous'),
]
