#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Jan  9 15:26:46 2024

@author: ludovicocoletta
"""

import numpy as np
import pandas as pd
import glob

def main():
    
    dfs=sorted(glob.glob('*endpoints.txt'))
    dfs_filt=[]
    for datfr in dfs:
        df=pd.read_csv(datfr,sep=' ',header=None,dtype=float)
        df=df.round(0)
        df["quantity"] = 1
        df["quantity"] = df.groupby([0, 1, 2]).transform(sum)
        df = df.drop_duplicates(subset=[0, 1, 2], keep="first").reset_index(drop=True)
        dfs_filt.append(df)
    
    final_df=pd.concat(dfs_filt)
    final_df['quantity']=1
    final_df["quantity"] = final_df.groupby([0, 1, 2]).transform(sum)
    final_df=final_df.loc[final_df['quantity'] > 1 ]
    final_df['size']=0.5
    final_df['trans']=0.5
    final_df[0]=(final_df[0]-90)
    final_df[1]=final_df[1]-126
    final_df[2]=final_df[2]-72
    
    final_df.to_csv('nodefile_endpoints_overlap.node',sep=' ',columns=[0,1,2,'size','trans'], header=False, index=False, index_label=None)

    
if __name__ == "__main__":
    main() 
