#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Jan 15 15:56:11 2024

@author: ludovicocoletta
"""

import os 
import glob
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt 
import scipy.stats as stats

def main():
    
    os.makedirs('fig_clinical_validation',exist_ok=True)
    
    func_of_int=['SEMANTIC', 'PHONOLOGICAL','TOT_LES_VOLUME']
    r2=[0.35,0.34,0.15] # same order as func_of_int
    
    for func_index,func in enumerate(func_of_int):
        data=np.load(func+'_r2_nulls.npy')
        a,my_bins=np.histogram(data,30)
        a=a/np.sum(a)
        
        if ('SEM'in func+'_r2_nulls.py') or ('PHONO'in func+'_r2_nulls.py') :
            col='lime'
        else:
            col='red'
        
        fig, ax = plt.subplots()
        ax.bar(x=my_bins[:-1], height=a, width=np.diff(my_bins), align='edge', fc=col, ec='none')
        ax.set_ylim([0,0.1])
        ax.set_xlim([-0.2,0.4])
        ax.set_yticks([0,0.05])
        ax.set_xticks([-0.2,0,0.4])
        ax.tick_params(labelsize=25)
        ax.xaxis.set_ticks_position('bottom')
        ax.yaxis.set_ticks_position('left')
        ax.set_ylabel('Frequency',fontsize=25,labelpad=5)
        ax.set_xlabel('Shuffled R squared',fontsize=25,labelpad=5)
        ax.spines['top'].set_visible(False)
        ax.spines['right'].set_visible(False)
        ax.spines['left'].set_position(('outward',10))
        #ax.spines['bottom'].set_position(('outward',5))
        ax.xaxis.set_ticks_position('bottom')
        ax.yaxis.set_ticks_position('left')
        ax.vlines(r2[func_index],0,0.1, colors='black',linestyles='dashed')
        plt.savefig('fig_clinical_validation'+'/'+func+'_shuffled_vs_emp.png', format='png', dpi=900, transparent=True,bbox_inches='tight')

if __name__ == "__main__": 
    main()