module TestExamples3DLatticeBoltzmann

using Test
using Trixi

include("test_trixi.jl")

EXAMPLES_DIR = pkgdir(Trixi, "examples", "tree_3d_dgsem")

@testset "Lattice-Boltzmann" begin
#! format: noindent

@trixi_testset "elixir_lbm_constant.jl" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_lbm_constant.jl"),
                        l2=[5.861930511199053e-16, 6.282772442363201e-16,
                            5.47591540767842e-16,
                            6.379244339335046e-16, 5.81421258408584e-16,
                            6.634626069779352e-16,
                            2.9188639102691596e-16, 2.1539168764807097e-16,
                            3.0131714783573674e-16,
                            2.2126555191449657e-16, 2.622901122013102e-16,
                            2.2115776381362187e-16,
                            6.32031843208421e-17, 6.103875364141341e-17,
                            6.821138567646266e-17,
                            6.48022057541854e-17, 5.013642264182462e-17,
                            7.169498358338181e-17,
                            1.3879946832660896e-16, 5.649850447603551e-17,
                            3.4686869828797276e-17,
                            3.8719518141614167e-17, 3.5852179230919525e-17,
                            4.292415147083455e-17,
                            3.608945206319316e-17, 4.187850903422495e-17,
                            8.254587760492495e-16],
                        linf=[1.1657341758564144e-15, 1.5543122344752192e-15,
                            1.1657341758564144e-15,
                            1.4710455076283324e-15, 1.0547118733938987e-15,
                            1.4988010832439613e-15,
                            5.273559366969494e-16, 5.065392549852277e-16,
                            5.967448757360216e-16,
                            5.342948306008566e-16, 5.412337245047638e-16,
                            5.967448757360216e-16,
                            3.608224830031759e-16, 3.469446951953614e-16,
                            2.42861286636753e-16,
                            2.498001805406602e-16, 2.2898349882893854e-16,
                            4.3021142204224816e-16,
                            2.1510571102112408e-16, 1.43982048506075e-16,
                            1.214306433183765e-16,
                            1.4224732503009818e-16, 1.214306433183765e-16,
                            1.3877787807814457e-16,
                            8.673617379884035e-17, 9.71445146547012e-17,
                            2.7755575615628914e-15],
                        tspan=(0.0, 0.5))
    # Ensure that we do not have excessive memory allocations
    # (e.g., from type instabilities)
    let
        t = sol.t[end]
        u_ode = sol.u[end]
        du_ode = similar(u_ode)
        @test (@allocated Trixi.rhs!(du_ode, u_ode, semi, t)) < 1000
    end
end

@trixi_testset "elixir_lbm_taylor_green_vortex.jl" begin
    @test_trixi_include(joinpath(EXAMPLES_DIR, "elixir_lbm_taylor_green_vortex.jl"),
                        l2=[7.516128821554829e-5, 7.516128821554695e-5,
                            7.516128821554932e-5,
                            7.516128821554856e-5, 7.022624942862394e-6,
                            7.022624942862171e-6,
                            2.961794427142361e-6, 2.961794427142168e-6,
                            2.6527195181287848e-5,
                            2.6527195181287404e-5, 2.652719518128811e-5,
                            2.6527195181287916e-5,
                            2.9617944271423104e-6, 2.961794427142108e-6,
                            2.652719518128758e-5,
                            2.6527195181287513e-5, 2.6527195181287916e-5,
                            2.6527195181287872e-5,
                            6.697526775466e-6, 6.697526775466029e-6,
                            6.697526775465903e-6, 6.697526775465986e-6,
                            6.697526775466051e-6, 6.697526775465938e-6,
                            6.697526775465983e-6,
                            6.697526775466005e-6, 2.8805380887802028e-6],
                        linf=[0.00021570074723312183, 0.0002157007472331357,
                            0.00021570074723314958,
                            0.00021570074723316346, 1.9675688146578163e-5,
                            1.967568814660592e-5,
                            9.53539471547013e-6, 9.53539471547013e-6,
                            5.7339968249785905e-5,
                            5.7339968249778966e-5, 5.7339968249792844e-5,
                            5.7339968249778966e-5,
                            9.535394715480539e-6, 9.53539471546666e-6,
                            5.73399682497755e-5, 5.7339968249785905e-5,
                            5.7339968249782436e-5, 5.7339968249782436e-5,
                            1.3570400471223966e-5,
                            1.3570400471222231e-5, 1.3570400471220496e-5,
                            1.3570400471224833e-5,
                            1.3570400471223966e-5, 1.3570400471221364e-5,
                            1.3570400471224833e-5,
                            1.3570400471224833e-5, 1.4249297322244114e-5],
                        tspan=(0.0, 0.1),
                        initial_refinement_level=3)
    # Ensure that we do not have excessive memory allocations
    # (e.g., from type instabilities)
    let
        t = sol.t[end]
        u_ode = sol.u[end]
        du_ode = similar(u_ode)
        @test (@allocated Trixi.rhs!(du_ode, u_ode, semi, t)) < 1000
    end
end
end

end # module
