# Security Policy

The Trixi.jl development team takes security issues seriously. We appreciate
all efforts to responsibly disclose any security issues and will make every
effort to acknowledge contributions.


## Supported Versions

The current stable release following the interpretation of
[semantic versioning (SemVer)](https://julialang.github.io/Pkg.jl/dev/compatibility/#Version-specifier-format-1)
used in the Julia ecosystem is supported with security updates.


## Reporting a Vulnerability

To report a security issue, please use the GitHub Security Advisory
["Report a Vulnerability"](https://github.com/trixi-framework/Trixi.jl/security/advisories/new)
tab.

We will send a response indicating the next steps in handling your report.
After the initial reply to your report, we will keep you informed of the
progress towards a fix and full announcement, and may ask for additional
information or guidance.

Please report security bugs in third-party modules directly to the person
or team maintaining the module.

Public notifications of vulnerabilities will be shared in community channels
such as Slack.
