# OnboardEU: Track-Selective Georeferencing for Railways – Sample Measurement Data

## Description

This dataset is intended to be used for track-selective railway vehicle positioning. It provides sensor data which was collected by a sensor unit on an in-service vehicle within the mFUND project OnboardEU. The data can be used for applying the Python open-source code published in this repository: [https://github.com/DLR-TS/railpos-onboardeu](https://github.com/DLR-TS/railpos-onboardeu).

For additional guidance, an example Jupyter Notebook is available at: [https://github.com/DLR-TS/railpos-onboardeu/blob/main/onboardeu/onboardeu_001_example.ipynb](https://github.com/DLR-TS/railpos-onboardeu/blob/main/onboardeu/onboardeu_001_example.ipynb).

## Content

The dataset contains the following files:

- `braunschweig_port_railway_network.gpkg`: A GeoPackage file of the railway network geometries.
- `onboardeu_001.h5`: An HDF5 file containing sensor data collected by a locomotive operating on the above railway network. The utilised sensor sources are GNSS (Global Navigation Satellite Systems) and IMU (Inertial Measurement Unit). Details of the data can be found in the metadata files (`metadata_gnss.toml` and `metadata_imu.toml`) or in the HDF5 file itself, where the metadata is attached to each dataset. The data is organised in journeys, which denote motions from standstill to standstill (without direction changes).
- `onboardeu_001_georef.h5`: A file containing the output of the algorithms applied to the input data (`onboardeu_001.h5`), i.e., track-selective position and motion information.

In addition, several visualisations are provided. The folders contain:

- `figures/figures_output`: Output velocity and projected path distances together with input (GNSS) speed and projected path distances, for each journey of the data.
- `figures/foliums_all_journeys`: The file `Georef_output_all_journeys_10_Hz.html` shows the output velocities and positions for all journeys on the map, at a reduced output frequency of 10 Hz. Journey data can be selected in the menu. The file `GNSS_input_all_journeys.html` shows the input GNSS speed and positions on the map. Data of each journey is selectable.
- `figures/foliums_per_journey`: The files `*_output_10_Hz.html` show the GNSS input data (speed, time, position) and the output of the positioning algorithm (velocity, position) of a given journey on the map. In addition, the selected path in the railway network is displayed. The files `*_paths.html` show all valid railway paths for the journey data found in the railway network, the best (and selected) railway path is illustrated in black.

## License

The license is specified in the `license.txt` file.
