[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.14191134.svg)](https://doi.org/10.5281/zenodo.14191134)

## Beyond the Limit: The estimated air pollution damages of overshooting the temperature target

**Beyond the Limit: The estimated air pollution damages of overshooting the temperature target**

Clàudia Rodés-Bachs<sup>1,2\*</sup>, Laurent Drouet<sup>2,3</sup>, Peter Rafaj<sup>4</sup>, Massimo Tavoni<sup>2,3,5</sup>, Lara Aleluia Reis<sup>2,3</sup>, 

<sup>1 </sup> Basque Center for Climate Change, Leioa, Spain

<sup>2 </sup> CMCC Foundation - Euro-Mediterraneo Center on Climate Change, Italy

<sup>3 </sup> RFF-CMCC European Institute on Economics and the Environment (EIEE), Italy

<sup>4 </sup> International Institute for Applied Systems Analysis (IIASA), 2361 Laxenburg, Austria

<sup>5 </sup> Politecnico di Milano, Milan, Italy

\* corresponding author:  claudia.rodes@bc3research.org

## Abstract
Exposure to outdoor air pollution results in millions of premature deaths and illnesses that are associated with substantial economic loss. According to the Global Burden of Disease, outdoor air pollution was responsible for 4.7 million deaths in 2021. Climate change mitigation policies could provide co-benefits by reducing air pollution. The Intergovernmental Panel on Climate Change AR6 report explores scenarios using an updated carbon budget approach —the net-zero pathways— designed to avoid temporary overshoot of the 1.5ºC temperature limit. We assess if net-zero pathways consistently improve air pollution outcomes using a global source-receptor air pollution model to estimate concentrations, health impacts, and economic damages. To analyze key uncertainties, we apply multiple relative risk functions and economic damage models. Our findings show that stringent climate policies, avoiding overshoot and keeping below 2ºC, offer substantial health and economic co-benefits, particularly for China and India, and avoid 207 thousand premature deaths and 2269 billion USD2020 in damages by 2030.


## Code reference
Available at Zenodo: [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.14191134.svg)](https://doi.org/10.5281/zenodo.14191134)


## Data
The global climate change mitigation scenario dataset analyzed in this study is available in Zenodo: [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5553976.svg)](https://doi.org/10.5281/zenodo.5553976)


## Reproduce the experiment
To reproduce the results and figures shown in Rodés-Bachs et al.,

1. Install `R` here - https://www.r-project.org/
2. Suggested: install `R studio` from here - https://www.rstudio.com/
3. Run the script called `plt_figures_paper.R` chunk by chunk to generate the figures.
4. Run the script called `si_main.R` to generate the SI figures.  

## Funding acknowledgment

<img src="./data/Flag_of_Europe.svg.png" width="126" height="85" align="left" alt="EU logo" />
This work was funded by the European Union’s Horizon Europe research and innovation program under the ENGAGE - Exploring National and Global Actions to reduce Greenhouse gas Emissions - project (821471),  AdJUST - Advancing the understanding of challenges, policy options and measures to achieve a JUST EU energy transition - project (101069880), and the GRINS - Growing Resilient, INclusive and Sustainable - project (PE00000018).
