# coding=utf-8
"""retired iso

Revision ID: 3dfa2e32c21e
Revises: 1df6c637eb6a
Create Date: 2014-11-12 11:07:33.311000

"""

# revision identifiers, used by Alembic.

revision = '3dfa2e32c21e'
down_revision = '1df6c637eb6a'

import datetime
import json

from alembic import op
import sqlalchemy as sa

from glottolog3.lib.util import glottocode

JSON_KEY = 'iso_retirement'


def upgrade():
    conn = op.get_bind()

    insert_lang = sa.text("INSERT INTO language "
        "(created, updated, active, version, polymorphic_type, jsondata, id, name) "
        "VALUES (now(), now(), true, 1, 'base', :jsondata, :id, :name) "
        "RETURNING (pk)", conn)
    insert_uoid = sa.text("INSERT INTO languoid "
        "(pk, level, status, child_family_count, child_language_count, child_dialect_count) "
        "VALUES (:pk, 'language', 'spurious retired', 0, 0, 0)", conn)

    select_iso = sa.text("SELECT pk FROM identifier "
        "WHERE name = :name AND type = 'iso639-3' AND lang = 'en'", conn)
    select_ident = sa.text("SELECT pk FROM identifier "
        "WHERE name = :name AND type = 'name' AND description = 'Glottolog' "
        "AND lang = 'en'", conn)
    insert_ident = sa.text("INSERT INTO identifier "
        "(created, updated, active, version, name, type, description, lang) "
        "VALUES (now(), now(), true, 1, :name, :type, :description, 'en') "
        "RETURNING (pk)", conn)
    insert_lang_ident = sa.text("INSERT INTO languageidentifier "
        "(created, updated, active, version, language_pk, identifier_pk) "
        "VALUES (now(), now(), true, 1, :language_pk, :identifier_pk)", conn)

    codes = {}
    for retired in CREATE:
        if select_iso.scalar(name=retired['iso']) is not None:
            continue
        pk = insert_lang.scalar(
            id=glottocode(retired['name'], conn, codes),
            name=retired['name'],
            jsondata=json.dumps({JSON_KEY: retired}))
        insert_uoid.execute(pk=pk)

        ipk = select_ident.scalar(name=retired['name'])
        if ipk is None:
            ipk = insert_ident.scalar(name=retired['name'],
                type='name', description='Glottolog')
        insert_lang_ident.execute(language_pk=pk, identifier_pk=ipk)

        ipk = insert_ident.scalar(name=retired['iso'],
            type='iso639-3', description=None)
        insert_lang_ident.execute(language_pk=pk, identifier_pk=ipk)
        

    select_pj = sa.text("SELECT l.pk, l.jsondata "
        "FROM language AS l JOIN languoid as ll on l.pk = ll.pk "
        "WHERE l.id = :id", conn)
    update_lang = sa.text("UPDATE language SET updated = now(), "
        "jsondata = :jsondata WHERE pk = :pk", conn)

    for retired in UPDATE:
        pk, jsondata = select_pj.execute(id=retired.pop('id')).first()
        jsondata = json.loads(jsondata)
        jsondata[JSON_KEY] = retired
        update_lang.execute(pk=pk, jsondata=json.dumps(jsondata))


def downgrade():
    pass


CREATE = [  # 107
    {'iso': 'aex', 'name': u'Amerax',
     'cr': u'2007-177', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into English [eng]',
     'comment': u'\u201cThere may be evidence that some distinct variety of English is in use by "Neo-muslims in prisons" (Gordon, 2005:298) but insufficient evidence to treat it as a separate language. It is presumably some variety of English with possible influences from Arabic. It may not in fact be "fully intelligible" with standard English but probably doesn\'t merit being separately identified as a language under ISO 639-3.\u201d'},
    {'iso': 'ahe', 'name': u'Ahe',
     'cr': u'2007-261', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Kendayan; Salako [knx]',
     'comment': u'\u201cAdelaar (1992 and 2002) confirms that Selako and Ahe are part of the Kendayan language chain and are mutually intelligible with each other along with several other Kendayan dialects. Collins (personal communication - email 2007), confirms that Ahe, Selako, and Kendayan are all fully intelligible with each other.\u201d '},
    {'iso': 'aiz', 'name': u'Aari',
     'cr': u'2007-040', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Aari [aiw] (new identifier) and Gayil [gyl]',
     'comment': u"\u201cSpeakers of Gayil have very little understanding of the southern variety of Aari, based on the results of comprehension testing conducted with recorded southern Aari texts. The current language development effort for southern Aari, including the translation of literature and a literacy program, does not include Gayil speakers even though Gayil has in the past been considered a dialect of Aari. The Gayil do not understand southern Aari literature and have requested separate language development. According to Gayil interviewees, from their point of view they have a separate ethnolinguistic identity from the southern Aari. The Gayil people's distinct ethnolinguistic identity is reinforced by the fact that they are geographically isolated from the southern Aari area and have little to do with the southern Aari people, dealing mostly with the Basketo people to the north.\u201d"},
    {'iso': 'akn', 'name': u'Amikoana',
     'cr': u'2007-003', 'effective': '2008-01-14', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'\u201cOriginal source and intensive research for this language group indicates that the language never existed or at best is no longer spoken.\u201d'},
    {'iso': 'amd', 'name': u'Amap\xe1 Creole',
     'cr': u'2006-124', 'effective': '2007-07-18', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'\u201c1. No bibliographical sources can be found to support the Ethnologue entry.\n2. No mention of this language is given in the Linguasphere Register.\n3. No mention of this language is given in the the SIL Brazil on-line list of languages.\n4. A recent and careful survey by SIL (including Dr. Jo-Anne Ferriera and Dr. Ian Robertson, both from the Caribbean and with many years of Creole studies, and Rev. Peter Samuel, one of the translators of the St. Lucia French Creole New Testament) failed to find any trace of them.\u201d\n'},
    {'iso': 'arf', 'name': u'Arafundi',
     'cr': u'2007-026', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into three languages: Andai [afd]; Nanubae [afk]; Tapei [afp]',
     'comment': u'\u201cAn SIL-PNG survey (Kassell, MacKenzie and Potter 2005) found the three proposed languages were distinct from each other, using both lexicostatistical and intelligibility testing. Average lexical similarity of the three speech varieties is between 39% and 58%, as measured with a 170-item standard word list. The accepted threshold for regarding speech varieties as dialects of a single language is 70% lexical similarity (SIL 1991); these scores are well below that threshold. Testing of intelligibility found that speakers of each variety had 13 - 56% comprehension of recorded texts in the other varieties. SIL guidelines give a recorded text test score of 75% as the lowest acceptable indicator of comprehension; again these scores are well below that threshold. The survey team concluded that Andai, Nanubae and Tapei should be considered three distinct languages.\u201d'},
    {'iso': 'atf', 'name': u'Atuence',
     'cr': u'2006-122', 'effective': '2007-08-10', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'1. The name is an old town name not associated with any language spoken there 2. The classification is highly unlikely for the region given\n3. The population figure is ludicrously way higher than Tibetan, also spoken there\n-- 590,000 Atuence (no date or source) vs 4,800 known Central Tibetans (2006) 4. All in all, the "guess is that the Atuence entry is probably based on some spurious information reported to Shafer (1966) and compiled by him in his collections.\u201d'},
    {'iso': 'auv', 'name': u'Auvergnat',
     'cr': None, 'effective': '2007-03-14', 'reason': 'merge',
     'remedy': u'Merge into Occitan (post 1500) [oci]',
     'comment': None},
    {'iso': 'azr', 'name': u'Adzera',
     'cr': u'2007-186', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into three languages: Adzera [adz] (new identifier), Sukurum [zsu] and Sarasira [zsa]',
     'comment': u'\u201cSarasira and Sukurum were formerly listed as dialects of Adzera. However, even though they are closer geographically to Adzera villages, historically and linguistically they are more closely related to the Mari and Wampur languages, and are thus in a different subfamily of the Upper Markham language family to Adzera. Susanne Holzknecht has documented the linguistic differences in: Holzknecht, Susanne. 1989. The Markham Languages of Papua New Guinea. Pacific Linguistics C-115. Canberra: Australian National University. Her work provides sufficient proof that these speech varieties are indeed separate languages that belong in the Mountain subgroup of Upper Markham languages, rather than being included as dialects of Adzera. Malcolm Ross also treats these three languages as distinct languages of the Upper Markham subfamily in his 1986 Ph.D. dissertation, later published as: Ross, Malcolm D. 1988. Proto Oceanic and the Austronesian languages of Western Melanesia. Pacific Linguistics C-98. Canberra: Australian National University.\u201d'},
    {'iso': 'bcx', 'name': u'Pamona',
     'cr': u'2007-199', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Pamona [pmf] (new identifier) and Batui [zbt]',
     'comment': u'\u201cIn 1908, the Dutch administrator O. E. Goedhart visited Batui. In a somewhat odd-seeming practice today, he named the people\u2019s speech the \u2018Baha language\u2019 after their negative term. In this he was partly in error, because the word for \u2018no\u2019 in Batui is actually mbaha\u2019. In 1914, the Dutch linguist N. Adriani further compounded the error by surmising that Baha must be a dialect of the nearby Pamona language. Adriani\'s basis was (a) geographical proximity, and (b) that the negative term "baha" superficially resembled "bare\'e" of the Pamona language.\nSadly, no one bothered to check things out further. Instead, as the years passed, the claim was repeated on language atlases and other writings about Sulawesi languages. People forgot about the shaky foundation upon which it had been built, and thus error had become "linguistic fact".\nIn 2006 we collected (in fact, became the first to collect) first-hand information on the Batui language, and discovered that Batui is not even closely related to Pamona at all, but shares its greatest affinities with the Saluan-Banggai languages to the east. Including Batui (or Baha) as a dialect of Pamona was nothing other than an egregious error.\u201d'},
    {'iso': 'bii', 'name': u'Bisu',
     'cr': u'2007-092', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Bisu [bzi] (new identifier) and Laomian [lwm]',
     'comment': u'\u201cLaomian is sometimes included in Bisu by Chinese linguists. Xu (2005:100) confirms this affiliation but notes that degrees of intelligibility vary between Thailand Bisu and Laomian speakers in different areas; in contrast, Xu reports that the related dialect Laopin shares ease of intelligibility with Bisu. Bradley (2002:106) recommends Laomian as a distinct language, and remarks (personal communication) that intelligibility between Bisu and Laomian is low in particular. Zhang (2004) also considers Laomian to be a distinct variety. Bradley recommends that Laopin (spoken by only 240 people in China) be considered a dialect of Thailand Bisu [bii] and Laomian be considered a distinct language [lwm]* closely related to Bisu [bii].\u201d'},
    {'iso': 'bke', 'name': u'Bengkulu',
     'cr': u'2007-179', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into [pse] Central Malay',
     'comment': u'\u201cCentral Malay is the proposed name for the language embracing the related Malay dialects of Pasemah, Lintang, Semendo, Ogan, Enim, Bengkulu, and Serawai Malay. Central Malay is the historic name for the languages found in the highlands of the Bukit Barisan mountains between South Sumatra, Lampung, and Bengkulu provinces. According to Adelaar quoting Voorheeve, the term Middle Malay is a poor translation of the Dutch name for these languages, Midden Maleisch, and properly translated should be Central Malay. (Adelaar 1992:4) Use of the name Central Malay will reflect these group of dialects long standing position of being related and sharing a common culture.\u201d'},
    {'iso': 'blu', 'name': u'Hmong Njua',
     'cr': u'2007-188', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into four languages: Hmong Njua [hnj] (new identifier); Chuanqiandian Cluster Miao [cqd]; Horned Miao [hrm]; Small Flowery Miao [sfm]',
     'comment': u"Hmong Njua [blu] should be retired, split into Chuanqiandian Cluster Miao, Small Flowery Miao, Horned Miao and Hmong Njua. Until now Hmong Njua [blu] as described in the Ethnologue 15th ed. was awkwardly forced to encompass a large number of Chuanqiandian Miao lects. The specific variety Hmong Njua (or Hmongb Nzhuab), appearing under country headings for Thailand, Vietnam, Laos and Myanmar and also spoken by many overseas Hmong around the world, is one member of the Chuanqiandian Cluster Miao group. Thus Hmong Njua has been used in two senses until now, denoting a broad category of several dozen Chuanqiandian lects, and in a much narrower sense, denoting one specific variety within that broad category. Because from now on it would be unclear in any given use of the identifier as to whether [blu] meant the old, overly broad Hmong Njua, or the new, more proper Hmong Njua, the identifier [blu] must be retired from use. The specific variety Hmong Njua should be given a new identifier to remove that ambiguity, and the broad category of Chuanqiandian lects should be split into four new entries.\nChinese linguists normally organize the broad category of Chuanqiandian lects, formerly represented in the Ethnologue by the lect best known overseas, Hmong Njua, into three or\nfour clusters of closely related lects. They call these three clusters \u5ddd\u9ed4\u6ec7\u65b9\u8a00\u5ddd\u9ed4\u6ec7\u6b21\u65b9 \u8a00\u7b2c\u4e00\u3001\u7b2c\u4e8c\u3001\u7b2c\u4e09\u3001\u7b2c\u56db\u4e2a\u571f\u8bed. In English these could be translated as the first, second,\nthird and fourth local dialects of the Chuanqiandian sub-dialect of the Chuanqiandian dialect of the Miao language.\nChinese linguists have arranged these multiple varieties in three or four groups based on closeness of genetic relationship, determined through analysis of extensive word lists, and on estimates of inherent intelligibility, gained through observations of ability to communicate across lects in the mother tongue.\nWhile the many lects within the Chuanqiandian Cluster Miao group (corresponding to the first local dialect described by Chinese linguists) do differ somewhat in phonology and lexicon, and their speakers have autonyms, clothing and customs distinct from other subgroups within the cluster, and while marriage tends to be within the same subgroup, there is fairly good inherent intelligibility at a functional level across lects within the cluster.\nSmall Flowery Miao or Gha-Mu, corresponding to the second local dialect described by Chinese linguists, is a distinct ethnolinguistic subgroup with its own clear identity. Through historical reconstruction Chinese linguists have determined that the Small Flowery Miao lect is closely related to other lects within the Chuanqiandian sub-dialect, and they state that there is partial intelligibility between this lect and Chuanqiandian Cluster Miao (the first local dialect).\nSinicized Miao or Hmong Sa, posited by at least one Chinese linguist (Li Yunbing) as a fourth local dialect of the Chuanqiandian sub-dialect, is also a distinct ethnolinguistic sub- group, and is phonologically more divergent from the Chuanqiandian Cluster Miao lects (the first local dialect) than Small Flowery Miao is from the Chuanqiandian Cluster Miao lects. There is marginal intelligibility between Sinicized Miao and either Chuanqiandian Cluster Miao lects or Small Flowery Miao. It is believed, however, that this is the same language that is already represented by the code [hmz] Hmong Shua, previously identified as only being used in Vietnam. Thus, this proposal recommends an expansion of the denotation of [hmz] Hmong Shua to incorporate this lect as spoken in China (cf change request 2007-132)\nHorned Miao, although it has been classified in several different ways by Chinese linguists, is also a distinct ethnolinguistic sub-group speaking a variety of Miao that is phonologically divergent from other lects in the Chuanqiandian sub-dialect and only partially intelligible with them.\nThe specific variety Hmong Njua (or Hmongb Nzhuab), spoken in China, Thailand, Vietnam, Laos, Myanmar and by many overseas Hmong around the world, is one member of the Chuanqiandian Cluster Miao group. A significant body of literature now exists in Hmong Njua in the RPA writing system used since the 1950's in Laos, Thailand and in western countries where overseas Hmong live. Speakers of the Hmong Njua lect, along with speakers of Hmong Daw, are probably the best-known members outside of China of this large over-arching ethnolinguistic group known as Miao or Hmong.\u201d"},
    {'iso': 'bnh', 'name': u'Banaw\xe1',
     'cr': u'2006-013', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merge into [jaa]',
     'comment': u'Jamamadi, Jarua\u0301ra, and Banawa are speech varieties of the same language.'},
    {'iso': 'boc', 'name': u'Bakung Kenyah',
     'cr': u'2007-245', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Mainstream Kenyah [xkl]',
     'comment': u'\u201cThe name Kenyah, Kelinyau, was proposed by Wurm and Hattori (1981) mainly based on what Soriente (2005:19) calls "superficial analysis focusing on geographic and administrative boundaries". Using the means of comparative linguistics methodology, it is possible to clarify the variations the Kenyah group. By investigating the shared innovation among the various Kenyah group, Soriente (2005) proposes that the names above- mentioned be used to incorporate all the other variants of another subgroup of Kenyah which further divided into four minor categories (which for the sake of simplicity here will be only referred to as "group 1-4". Group 1 language incorporates dialects of Lepo Tau, Lepo Bem, Uma Jalan, Uma Tukung, Lepo Jengan, Lepo Aga, Uma Ake, Lepo Ga, Lepo La\'ang, Sambup and Likan. Group 2 language incorporates the dialect of Lepo Ke\', and Lepo Kuda. Group 3 language incorporates dialect of Lepo Ma\'ut, Lepo Ndang, Badeng, and Lepo Jamok. Group 4 language incorporate dialects of Bakung and Lepo Teppu\'\u201d'},
    {'iso': 'bqe', 'name': u'Navarro-Labourdin Basque',
     'cr': u'2006-119', 'effective': '2007-08-10', 'reason': 'merge',
     'remedy': u'Merge into Basque [eus]',
     'comment': u'\u201cNavarro-Labourdin is just a dialect of Basque, and so is asserted by all speakers from the Low Navarrese and Labourdin regions from the first written records in 16th century to the present. Nobody identifies his or her language as "Navarro-Labourdin". All their putative speakers uniformly self-identify as Basque speakers. The term "Navarro-Labourdin" refers to a written variety of Basque used in the French part of the Basque Country in the first part of the 20th century. The name was coined by Pierre Lafitte (1944) before the Basque Academy had developed a standard variety for the language. In his book, Lafitte crucially refers to "literary Navarro-Labourdin" as a specific Basque variety, used by some Basque writers from the regions of Labourd and Low Navarre, in the French Basque Country, not as a different language from Basque. From 1964 there is a standard Basque ("euskara batua" or unified Basque), which is the language taught in most schools, including those in the French Basque Country, and used in the media and official documents of the Basque Country.\u201d'},
    {'iso': 'bsd', 'name': u'Sarawak Bisaya',
     'cr': u'2007-206', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Bisaya, Brunei [bsb]',
     'comment': u'\u201cBisaya in Brunei and Sarawak is the same cross-border language.\nWe are also proposing to retire the designations Tutong 1 and Tutong 2, as researchers have used these terms with conflicting designations. The language in the Dusunic group (formerly Tutong 1) should be called Brunei Bisaya, which includes as dialects Sarawak Bisaya and Tutong 1/Southern Bisaya.\u201d'},
    {'iso': 'bsz', 'name': u'Souletin Basque',
     'cr': u'2006-118', 'effective': '2007-08-10', 'reason': 'merge',
     'remedy': u'Merge into Basque [eus]',
     'comment': u'\u201cSouletin is just a dialect of Basque, and so is asserted by all speakers from the Soule region from the first written records in 17th century to the present. Nobody identifies his or her language as "Souletin". All their putative speakers uniformly self-identify as Basque speakers. From 1964 there is a standard Basque ("euskara batua" or unified Basque), which is the language taught in most schools, including those in the French Basque Country, and used in the media and official documents of the Basque Country.\u201d'},
    {'iso': 'bvs', 'name': u'Belgian Sign Language',
     'cr': u'2006-001', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into Langue des signes de Belgique Francophone [sfb], and Vlaamse Gebarentaal [vgt]',
     'comment': u'There are clear distinctions in the sociolinguistic identies of the two linguistic communities which parallel the larger sociological and cultural distinctions between the Flanders (northern) and Walloon (sourthern) regions of Belgium. The actual linguistic differences are apparently less clear, yet the trend within the Deaf communities in these two regions is clearly toward establishing separate linguistic identities for the signed languages of the northern and southern parts of Belgium. For example:\n"In the past the term Belgian Sign Language was commonly used, because one believed there were more resemblances between the two sign languages used in Flanders and Wallonia than between those used in Flanders and the Netherlands. Also, the first sign language research in Belgium was carried out by Flemish and Walloon researchers together. In their publications they always mentioned Belgian Sign Language. Deaf people themselves spoke of signs or sign language without really specifying which one. A few years ago, the name changed. Because of the lack of sufficient linguistic evidence that would enable us to speak of two completely different sign languages, the compromise Flemish Belgian Sign Language was chosen to refer to the variant used in Flanders. However, because of the split of NAVEKADOS (the former Belgian Deaf Association) into a Flemish and a Walloon organization, reduced contact between the Flemish and Walloon Deaf and the different processes of standardization, Deaf people got more and more dissatisfied with the term Flemish Belgian and wanted to change it into Flemish. FEVLADO [the Flemish Deaf association, http://www.fevlado.be/] also advocated this change at an Annual General Meeting in October 2000. This is why from that moment on the term Flemish Sign Language is used in all publications concerning the Flemish Deaf community and their mother tongue." [http://gebaren.ugent.be/information.php].\n"In short, up until about fifteen years ago, people were usually signing, talking, and writing about Belgian Sign Language. Now, many Deaf people feel intuitively that the signed language used in Flanders is very different from the one used in the Netherlands (even though the two hearing communities speak the same language, Dutch) but that it is closer to the signed language used in Wallonia (although the Walloon hearing community speaks French). Right now, not enough linguistic evidence has been collected to know whether the differences between Flanders and Wallonia are big enough to allow talk about two different signed languages. Hence, as a good Belgian compromise, the term Flemish Belgian Sign Language was used in recent years for the signed language variants used in Flanders. However, because of the split of the national Deaf federation into two regional federations, the fewer and fewer contacts among both organizations and their members, and the separate standardization processes, most Deaf people in Flanders prefer to talk about Flemish Sign Language. This term is also the term that was adopted by Fevlado at its last annual general meeting (AGM) in October 2000. At that AGM, the participants were asked to vote for either the term Flemish Sign Language or the term Flemish Belgian Sign Language. The first option was nearly unanimously elected. Even though this choice is obviously more politically than linguistically motivated, I want to respect the opinion of the Flemish Deaf Association and its members and will talk about Flemish Sign Language from now on... [Mieke Van Herreweghe, 2002. "Turn-Taking Mechanisms and Active Participation in Meetings with Deaf and Hearing Participants in Flanders", in Turn-Taking, Fingerspelling, and Contact in Signed Languages, Ceil Lucas, ed., available online at http://gupress.gallaudet.edu/excerpts/TTFCthree3.html]\nRegarding the situation in French-speaking Belgium (Wallonia and the major parts of Brussels), in the early 1980s, the term "Langue Franc\u0327aise Signe\u0301e" (Signed French Language) was used, then it changed into "Langue des Signes Belge" (Belgian Sign Language) or "Langue des Signes Franc\u0327aise de Belgique" (French Sign Language of Belgium). However, Deaf people have become quite unsatisfied with these terms and thus, another term was advocated. Since then, Langue des Signes Belge Francophone or Langue des Signes de Belgique Francophone has been used during formal meetings although most deaf people still refer their language as "sign language". There was never a compromise on which term to use. Therefore, sign language researchers hired to write a report on the feasibility of an official recognition of the sign language used in French-speaking Belgium chose the term "Langue des Signes de Belgique Francophone" and an abbreviation which reflected the close relationship between this sign language and French Sign Language : LSFB.\nAccording to Dr. Vermeerbergen, comprehension of LSFB by signers of VGT varies according to the person, the region from which the two signers are from, and the topic of conversation. For example, older Deaf from Flanders understand LSFB better than younger Deaf, who have had less contact with signers from Walloonia. This suggests that the comprehension is based on learned bidialectalism rather than inherent intelligibility. Those from central areas in Flanders understand LSBF better than those from peripheral areas, which is indication that the sign language situation in Belgium is in some respects a dialect chain which the Deaf communities in both regions have decided to break into two separate languages along political lines.\nThe Parliament of French-speaking Belgium recognised LSFB in a decree of October 2003, which acknowledges the existing internal variation and advocates allowing it to develop toward standardization along its own natural evolutionary path. The decree is available at http://www.fevlado.be/themas/gebarentaal/documenten/Decreet%20FBelg%20Gebarentaal.pdf. Official recognition of VGT by the government in Flanders was granted in April 2006 (http://www.fevlado.be/nieuws/nieuwsDetail.aspx?item=150). The proposed text of the decree is available at http://jsp.vlaamsparlement.be/docs/stukken/2005-2006/g729-2.pdf.'},
    {'iso': 'bwv', 'name': u'Bahau River Kenyah',
     'cr': u'2007-262', 'effective': '2008-01-14', 'reason': 'non-existent',
     'remedy': u"Any current use is likely either Mainstream Kenyah [xkl] or Uma' Lung [ulu] (new code element)",
     'comment': u'Kenyah, Bahau River is a vague name associated mainly to toponym or ethnonym of some Kenyah groups. The name was proposed by Wurm and Hattori (1981) mainly based on what Soriente (2005:19) calls "superficial analysis focusing on geographic and administrative boundaries". Using the means of comparative linguistics methodology, Soriente (2005) is able to re-classify the variants of Kenyah.\n[RA comment: This Kenyah language is being requested to be retired as "non-existent" because it is not clear to which of the two Kenyah languages (one existing, but expanded, and the other newly defined) the former geographically specified language would belong. See requests 2007-245 and 2007-246.]'},
    {'iso': 'bxt', 'name': u'Buxinhua',
     'cr': u'2007-009', 'effective': '2008-01-14', 'reason': 'duplicate',
     'remedy': u'Merge into Bit [bgk] as duplicate',
     'comment': u'\u201cAs best as I can tell, these refer to the same language from two different sources. The bgk information seems to have originally come from J-O Svantesson, whereas the Buxinhua information is originally from the Encyclopedic Dictionary of Chinese Linguistics. "Bit" and "Buxin(g)hua" appear to refer to the same small language in Yunnan province\'s Mengla county which Chinese linguists (e.g. Shearer & Sun 2002) classify as Khmuic. As bgk is linked to speakers in Laos, it seems simpler to retire bxt.\u201d'},
    {'iso': 'byu', 'name': u'Buyang',
     'cr': u'2007-012', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': "Split into three languages: E'ma Buyang [yzg]; Langnian Buyang [yln]; Baha Buyang [yha]",
     'comment': u"\u201cThese three varieties of Buyang are not mutually intelligible, and are significantly different in lexicon,\nLangnian - E'ma 78% similarity, yet not intelligible despite frequent contact. Langnian - Baha 50% lexical similarity\nE'ma - Baha 48% lexical similarity\u201d"},
    {'iso': 'ccx', 'name': u'Northern Zhuang',
     'cr': u'2007-027', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into ten languages: Guibian Zh [zgn]; Liujiang Zh [zlj]; Qiubei Zh [zqe]; Guibei Zh [zgb]; Youjiang Zh [zyj]; Central Hongshuihe Zh [zch]; Eastern Hongshuihe Zh [zeh]; Liuqian Zh [zlq]; Yongbei Zh [zyb]; Lianshan Zh [zln].',
     'comment': u'Speakers of each proposed separate language only have marginal understanding of the other languages. There is no central variety that speakers of the proposed languages understand.'},
    {'iso': 'ccy', 'name': u'Southern Zhuang',
     'cr': u'2006-128', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into five languages: Nong Zhuang [zhn];  Yang Zhuang [zyg]; Yongnan Zhuang [zyn]; Zuojiang Zhuang [zzj]; Dai Zhuang [zhd].',
     'comment': u'These five Southern Zhuang languages are not mutually intelligible with each other and have no common literature. They have been grouped into the same official nationality (Zhuang) since 1958 by the government (along with speakers of ccx, Northern Zhuang,\nand Buyang), but previously did not share a common ethnolinguistic identity. There is no central variety or reference dialect for all five either (most commonly some dialect of Chinese is used as lingua franca among speakers of different Southern Zhuang langauges).'},
    {'iso': 'cit', 'name': u'Chittagonian',
     'cr': u'2006-048', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into Rohingya [rhg], and Chittagonian (new identifier [ctg])',
     'comment': u"The Rohingya people claim to be indigenous to Rakhine State of Myanmar. They claim descent from Arab traders who settled on the coast well over 1,000 years ago and their local Muslim converts, and were the ruling class of the ancient Kingdom of Arakan which until the mid 18th century covered part of Bangladesh's Chittagong Division as well as Rakhine State. Proof of their long presence in Myanmar is found in the ruins of many ancient mosques in Rakhine State, some over 500 years old. The Myanmar government, however, claims that the Rohingya are recent immigrants from Bangladesh, and has suppressed their language and attempted to drive the entire population to Bangladesh whose government has not accepted them. The language is Indo-Aryan, with an admixture of Persian, Arabic and some Burmese vocabulary. Tonal distinctions exist, a feature of Burmese but not usual in Indo-Aryan languages. Rohingya is closely related to but distinct from Chittagonian, which is reported to be understood by most men but not by most women."},
    {'iso': 'cru', 'name': u'Car\xfatana',
     'cr': u'2007-006', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Baniwa  [bwi]',
     'comment': u'Recent research indicates that Caru\u0301tana is a dialect of Baniwa, not a separate language.'},
    {'iso': 'dat', 'name': u'Darang Deng',
     'cr': u'2007-021', 'effective': '2008-01-14', 'reason': 'duplicate',
     'remedy': u'Merge into Digaro Mishmi [mhu] as duplicate',
     'comment': u'It was discovered that the Ethnologue entries for India_Digaro Mishmi_mhu and China_Darang Deng_dat are referring to the same language. Darang Deng is an alternate name for mhu. Digaro and Taraon are alternate names for Darang Deng. The locations for each language are just across the India/China border from each other. they are both classified in the North Assam branch of the Sino-Tibetan language tree. It is proposed that the name Darang Deng be retained for China but assume the same language code as Digaro Mishmi, with India being the HUB country for the language.'},
    {'iso': 'dyk', 'name': u'Land Dayak',
     'cr': u'2007-254', 'effective': '2008-01-14', 'reason': 'non-existent',
     'remedy': u'Language family name with all constituent languages already represented',
     'comment': u'Land Dayak is a language family name (the current term is actually "Bidayuhic"), rather than a language name. Furthermore, all Bidayuhic (Land Dayak) geographical locations and populations are already accounted for by other Bidayuhic language entries. This entry duplicates geographies and populations, and should be retired.'},
    {'iso': 'eni', 'name': u'Enim',
     'cr': u'2007-179', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into [pse] Central Malay',
     'comment': u'\u201cCentral Malay is the proposed name for the language embracing the related Malay dialects of Pasemah, Lintang, Semendo, Ogan, Enim, Bengkulu, and Serawai Malay. Central Malay is the historic name for the languages found in the highlands of the Bukit Barisan mountains between South Sumatra, Lampung, and Bengkulu provinces. According to Adelaar quoting Voorheeve, the term Middle Malay is a poor translation of the Dutch name for these languages, Midden Maleisch, and properly translated should be Central Malay. (Adelaar 1992:4) Use of the name Central Malay will reflect these group of dialects long standing position of being related and sharing a common culture.\u201d'},
    {'iso': 'eur', 'name': u'Europanto',
     'cr': u'2008-087', 'effective': '2009-01-16', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'Existing litterature (see for example: http://www.europanto.be/gram.en.html) states very clearly that Europanto is not a Language name. So, there is no reason at all to maintain "eur" inside ISO 639-3\n\nCOMMENT BY PURODHA BLISSENBACH:\nPlease do not retire code eur as of request 2008-087.\nThere is quite some published materials using Europanto in Brussels\nnewspapers. Writing about it and quoting it in internet sites needs an\nappropriate language code.\nOtherwise speech synthesizers, search programs, indexing programs, and other will not be able to function properly since there would be no way to identify the language.\nSince at least for linguist publications (and some fun for general\npublic, certainly, too) referring to Europanto both as a concept and in the form of samples of text, is useful, we cannot do without a language code. Greetings. Purodha Blissenbach'},
    {'iso': 'fiz', 'name': u'Izere',
     'cr': u'2007-147', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Ganang [gne] and Izere [izr] (new identifier)',
     'comment': u'The phonology and noun-class system of Ganang have taken on features of Berom and it is, for all practical purposes, unintelligible to mainstream Izere-speakers.'},
    {'iso': 'flm', 'name': u'Falam Chin',
     'cr': u'2006-023', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into Ranglong [rnl], and Falam Chin (new identifier [cfm]).',
     'comment': u'"The term \u201cRanglong\u201d is listed in the Ethnologue as being part of Falam Chin language but BI considers it a language on its own merits and not a alternative name or dialect of the Falam Chin". from an e-mail dated Oct 2003 from Eric Elmer, Bibles International corresponding with New Life Computer Institute'},
    {'iso': 'fri', 'name': u'Western Frisian',
     'cr': None, 'effective': '2007-02-01', 'reason': 'change',
     'remedy': u'Change to [fry] to align with ISO 639-2',
     'comment': None},
    {'iso': 'gen', 'name': u'Geman Deng',
     'cr': u'2007-020', 'effective': '2008-01-14', 'reason': 'duplicate',
     'remedy': u'Merge into Miju-Mishmi [mxj] as duplicate',
     'comment': u'It was discovered that the Ethnologue entries for India_Miju Mishmi_mxj and China_Geman Deng_gen are referring to the same language. Gaman Deng is an alternate name for mxj. Kuman is an alternate name for Geman Deng and Kaman is an alternate name for Miju Mishmi. The locations for each language are just across the India/China border from each other. they are both classified in the North Assam branch of the Sino-Tibetan language tree. It is proposed that the name Geman Deng be retained for China (and Myanmar) but assume the same language code as Miju Mishmi, with India being the HUB country for the language.'},
    {'iso': 'ggh', 'name': u'Garreh-Ajuran',
     'cr': u'2007-172', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split between Borana [gax] and Somali [som]',
     'comment': u'Garreh-Ajuran is not a specific language, but rather a pair of closely allied ethnic groups. The Garreh people speak Borana as a first language and Somali as a second language while the Ajuran people are divided into two groups; those who speak Borana as a first language and those who speak Somali as a first language.'},
    {'iso': 'gsc', 'name': u'Gascon',
     'cr': None, 'effective': '2007-03-14', 'reason': 'merge',
     'remedy': u'Merge into Occitan (post 1500) [oci]',
     'comment': None},
    {'iso': 'itu', 'name': u'Itutang',
     'cr': u'2007-253', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Inapang [mzu]',
     'comment': u'Itutang is the name of one village within the Inapang language.'},
    {'iso': 'jap', 'name': u'Jaru\xe1ra',
     'cr': u'2006-013', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merge into [jaa]',
     'comment': u'Jamamadi, Jarua\u0301ra, and Banawa are speech varieties of the same language.'},
    {'iso': 'kds', 'name': u'Lahu Shi',
     'cr': u'2007-090', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Kucong [lkc] and Lahu Shi [lhi] (new identifier)',
     'comment': u'Kucong speakers are classified under the Lahu nationality in China but are, in most cases, separated from the primary Lahu population by significant distances and are often reported on distinctly in Chinese sources (cf. YJDZ 1983). Ethnologue 15 confuses Kucong with Lahu Shi, but Kucong speakers are not particularly affiliated with Lahu Shi (Yellow Lahu) any more than they are with Lahu Na (Black Lahu). Speakers applied for distinct nationality status in the early 1980\u2019s, but, instead, were classified under the Lahu nationality in 1989. Speakers in Vietnam belong to the Cosung Nationality. Bradley (2002:104) notes that Kucong is not mutually intelligible with Lahu.'},
    {'iso': 'knh', 'name': u'Kayan River Kenyah',
     'cr': u'2007-263', 'effective': '2008-01-14', 'reason': 'non-existent',
     'remedy': u'Any current use is most likely Mainstream Kenyah [xkl]',
     'comment': u'Kenyah, Kayan River is a vague name associated mainly to toponym or ethnonym of some Kenyah groups. The name was proposed by Wurm and Hattori (1981) mainly based on what Soriente (2005:19) calls "superficial analysis focusing on geographic and administrative boundaries". Using the means of comparative linguistics methodology, Soriente (2005) is able to re-classify the variants of Kenyah.\n[RA comment: This Kenyah language is being requested to be retired as "non-existent" because it is not clear to which of the two Kenyah languages (one existing, but expanded, and the other newly defined) the former geographically specified language would belong. See requests 2007-245 and 2007-246.]'},
    {'iso': 'kob', 'name': u'Kohoroxitari',
     'cr': u'2006-015', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merge into [xsu], Sanuma. Name now identified as a village name, not a language name.',
     'comment': u'The name Kohoroxitari is the name of a village of speakers of the Yanoma (or possibly the Xitari) dialect of Sanuma. It is a place name, rather than the name of a distinct (and mutually unintelligible) language variety. Kohoroxitari has been listed in the Ethnologue as "unclassified."'},
    {'iso': 'krg', 'name': u'North Korowai',
     'cr': u'2007-222', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Korowai [khe]',
     'comment': u'There is currently an SIL linguist working in the area who is finding out that North Korowai is intelligible with Korowai. Quoting him from an email: "We haven\'t done any dialect intelligibility testing yet, but lexical similarity is 90% and they seem to understand each other without trouble. During the Baseline Study we had a South Korowai speaker do the interpretation and when we asked North Korowai speakers if they had any questions about the purpose of our Baseline Study they replied that they had just heard the explanation in their own language, so they had no questions. And from their actions is was clear that they understood. I myself can understand North Korowai speakers, if they do not speak too fast. Their pronunciation is a bit different and I plan to look into that in the future. North and South have some differing vocabulary but seem to have no problem understanding each other. Grammar doesn\'t seem to be different."'},
    {'iso': 'krq', 'name': u'Krui',
     'cr': u'2007-142', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Lampung Api [ljp]',
     'comment': u'There are various lects belonging to the closely-related Lampung(ic) language family scattered throughout the Sumatran provinces of Lampung and South Sumatra. The term "Lampung" applies to the whole family (or the province); however the language family (formerly consisting of 9 Ethnologue entries) is best conceived as consisting of three closely-related languages: Lampung Api, Lampung Nyo and Komering (see Hanawalt et al. forthcoming for more details). This proposal gives details regarding the proposed language "Lampung Api". "Api" is a modifier of "Lampung" and refers to this language\'s distinctive term for \'what?\' (as does "Nyo").\nWalker (1975) was a lexicostatistical comparison of various Lampungic lects. In the conclusion he delineated a number of dialects, including "Krui", "Pubian", "Southern Pesisir", "Ranau" (subsumed under Krui), and "Sungkai" (subsumed under Pubian). He nowhere stated that these were distinct languages. Hanawalt (forthcoming) and Anderbeck (forthcoming) validate the earlier lexicostatistic division of Lampungic and demonstrate how the various subgroups of Lampung Api (recognized by Walker 1975 as "Lampung Pesisir") cohere lexically, phonologically and in terms of intelligibility and should not be considered distinct languages.'},
    {'iso': 'kxg', 'name': u'Katingan',
     'cr': u'2007-184', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Ngaju [nij]',
     'comment': u'Both these varieties [kxg] Katingan and [xah] Kahayan are major [nij] dialects (two of three major dialects), almost 100% intelligible with nij.'},
    {'iso': 'lms', 'name': u'Limousin',
     'cr': None, 'effective': '2007-03-14', 'reason': 'merge',
     'remedy': u'Merge into Occitan (post 1500) [oci]',
     'comment': None},
    {'iso': 'lmt', 'name': u'Lematang',
     'cr': u'2007-182', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Musi [mui]',
     'comment': u'The Musi river is the longest in Sumatra, and many speech varieties are spoken along its length. Musi and the other Malay varieties listed in 4a were listed in the 1981 Wurm and Hattori linguistic atlas as being Malay dialects, but were incorrectly interpreted in previous Ethnologue editions as distinct languages. Language surveys completed in 2006-2007 found comprehension between these Malay dialects, and a set of shared phonological innovations. The above "languages" should be listed as dialects of Musi.\nMUSI--language (internal structure) Musi group Palembang group\nMusi, Rawas, Pegagan Palembang, Lowland Malay\nIt was found that there was high reported comprehension between the speech varieties found along the coastal plain of South Sumatra and those centered around the city of Palembang, making a Palembang subgroup. The speech varieties of Downstream Lematang, Belide, and Penesak also had a high rate of reported comprehension, and form a Lowland Malay subgroup. The Palembang and the Lowland Malay subdialects together form the Palembang Malay subgroup of the Musi language. The other subgroup in the Musi language is the Musi subgroup, which is comprised of the Musi, Pegagan, and Rawas dialects. The Musi and Pegagan speech varieties share phonological innovations. Rawas has one of the phonological innovations, as well as some of its own. There is high reported comprehension between the Musi and Rawas and a high percentage of shared lexical items. The culture, phonological innovations, and reported comprehension in the Musi river basin dialect chain provide a reasonable basis for grouping these dialects of Malay (as ) as a distinct language. Moreover, the cultural and linguistic differences, distinct phonological innovations, along with lower reported comprehension between isolects of the Musi language and those of Central Malay (Pasemah, Semendo, Enim, etc.) argue against subsuming them all under "South Sumatran Malay".'},
    {'iso': 'lnc', 'name': u'Languedocien',
     'cr': None, 'effective': '2007-03-14', 'reason': 'merge',
     'remedy': u'Merge into Occitan (post 1500) [oci]',
     'comment': None},
    {'iso': 'lnt', 'name': u'Lintang',
     'cr': u'2007-179', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into [pse] Central Malay',
     'comment': u'\u201cCentral Malay is the proposed name for the language embracing the related Malay dialects of Pasemah, Lintang, Semendo, Ogan, Enim, Bengkulu, and Serawai Malay. Central Malay is the historic name for the languages found in the highlands of the Bukit Barisan mountains between South Sumatra, Lampung, and Bengkulu provinces. According to Adelaar quoting Voorheeve, the term Middle Malay is a poor translation of the Dutch name for these languages, Midden Maleisch, and properly translated should be Central Malay. (Adelaar 1992:4) Use of the name Central Malay will reflect these group of dialects long standing position of being related and sharing a common culture.\u201d'},
    {'iso': 'lod', 'name': u'Berawan',
     'cr': u'2007-200', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into three languages: West Berawan [zbw], Central Berawan [zbc], and East Berawan [zbe]',
     'comment': u"Juergen Burkhardt's preliminary historical-comparative analysis confirms Blust\u2019s (1974) classfication, which claims:\nBerawan (a separate group of languages) \nWest-Berawan (= Berawan Long Terawan) \nCentral-East Berawan\n- Central Berawan (Batu Belah & Long Teru) \n- East Berawan (Long Jegan)"},
    {'iso': 'mbg', 'name': u'Northern Nambiku\xe1ra',
     'cr': u'2007-017', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into six languages: Alapmunte [apv]; Lakond\xc3\xaa [lkd]; Latund\xc3\xaa [ltn]; Mamaind\xc3\xa9 [wmd]; Tawand\xc3\xaa [xtw]; Yalakalore [xyl]',
     'comment': u'Northern Nambikaura is a language cluster, not an individual language. The speech varieties listed as dialects of Northern Nambikuara [mbg] have been determined to be several separate but closely related languages / language dialect groups. Northern Nambikuara [mbg] should be changed from a language name to a part of the classification of the Nambiquaran languages.\nFor the classification of Nambiquaran languages, there should now be a distinction made between a Northern cluster and a Southern cluster. Currently there is only a distinction between two language groups Northern Nambikuara [mbg] and Southern Nambikaura [nab]. They are both listed in the Ethnologue as "Class: Nambiquaran". I am recommending that the Northern Nambikuara [mbg] language be split into potentially 6 separate languages / language dialect groups and that these 6 will receive new ISO language identity codes and should be classified as "Class: Nambiquaran, Northern". The Southern Nambikuara [nab] language should then be classified as "Class: Nambiquaran, Southern". The [nab] language has several dialects listed. These may be split into separate languages / language dialect groups at a later time. More research is needed before this can be done.\nIntelligibilty testing and interviews indicate that the dialects listed for this language, Northern Nambikuara [mbg], are actually separate languages / language dialect groups. These finding are also supported by ethnololinguistic identity as speakers of these separate languages do not view themselves as a single ethnic group, but rather as at least 8 separate ethnic groups with at least 6 separate languages being spoken by these 8 ethnic groups.'},
    {'iso': 'mdo', 'name': u'Southwest Gbaya',
     'cr': u'2007-187', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Southwest Gbaya [gso] (new identifier) and Gbaya-Mbodomo [gmm]',
     'comment': u'The survey mentioned below found intelligibility too low for the two varieties to be considered as one language.\nA Survey Report on the Usability of TWO GBAYA TRANSLATIONS among the Gbaya- Mbodomo People of East Cameroon, by Edward TONG, April 2005, SIL Cameroon'},
    {'iso': 'mhv', 'name': u'Arakanese',
     'cr': u'2007-189', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Marma [rmz] and Rakhine [rki]',
     'comment': u'Based on word lists recently elicited, lexical similarity percentages between Marma and Rakhine are 62-68%. Intelligibility testing was also done by playing a Rakhine story among Marma mother tongue speakers in two Marma villages. The average scores in the two villages were 73% and 53%, indicating insufficient inherent intelligibility. Also, during the course of survey fieldwork, the term "Arakanese" was not mentioned by either the Marma or the Rakhine. Rather, the Marma refer to themselves as Marma, and the Rakhine refer to themselves as Rakhine.'},
    {'iso': 'miv', 'name': u'Mimi',
     'cr': u'2007-191', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Amdang [amj]',
     'comment': u'During a sociolinguistic survey in November 2004 we visited the people group known in Chad as Mimi. They call themselves Amdang and their language Amdangti. There was no evidence of other Mimi populations and other Mimi dialects. The population figure of both Mimi and Amdang as recorded in the Ethnologue 15th ed. is roughly 40,000, but these appear to be the same 40,000. I suggest collapsing the entries for amj and miv into amj, thus calling the Mimi language of Chad "Amdang".'},
    {'iso': 'mly', 'name': u'Malay (individual language)',
     'cr': u'2007-183', 'effective': '2008-02-18', 'reason': 'split',
     'remedy': 'Split into four languages: Standard Malay [zsm], Haji [hji], Papuan Malay [pmy] and Malay (individual language) [zlm]',
     'comment': u'Malay as described in the Ethnologue 15th ed. currently has several dialects listed under Sumatra, many of which are in other areas of Indonesia besides Sumatra, and of which eighteen are already listed as separate languages or dialects of other separate languages, or should be listed on their own as separate languages. Other country listings for Malay have similar issues. After clarifying those, however, there remains a need to specify Standard Malay (along with various local/vernacular Malay dialects and sociolects, e.g., Terengganu and Trade Malay)\nAji, or more properly, Haji, is proposed as a new language; see proposal for Haji (Aji) for more detail.\nPapuan Malay should be recognized as a separate language; see proposal for more detail\nThese steps will remove double listing of a speech variety as both a stand alone language in one listing, a dialect of a language in another listing, and a dialect of Malay in another listing, and also recognize the languages that warrant separate treatment. Goal-one listing for each speech variety.\nThe following elaborates on the clarifications regarding the Malaysian and Indonesian "Dialects" sections of the current Ethnologue entry for Malay [Malay]:\nFirst, there should be a listing of "Dialects" not only for Sumatra but also Kalimantan. Jakarta, another name for existing separate code element Betawi [bew] The following are currently listed under Sumatra for Malay [mly] but are actually spoken in Kalimantan and should be considered not a part of either Standard Malay or Local Malay: - Borneo (Sintang), and Kota-Waringin, both dialects of Malayic Dayak [xdy]\n- Labu (Lebu, Labu Basap), exists in the Ethnologue as Basap [bdb]\n- Balikpapan is represented in the Ethnologue as Banjar [bjn] - Bakumpai is a separate code element [bkr].\n(moving onto dialects outside Kalimantan):\n- Makassarese or Makasar Malay exists as a separate code element [mfp].\n- Manadonese (Menadonese) exists as a separate code element [xmm].\n- Mulak, another name for existing separate code element Kaur [vkk]\n- Bangka is the proposed expanded value for existing code element [mfb] (currently Lom) - Larantuka (Ende Malay) has been proposed as a separate code element. (cf. 2007-197) - Peranakan exists as a separate code element [pea]\n- Basa Kupang (Kupang) exists as a separate code element [mkn]\n- Belide, actually a dialect of Musi (cf 2007-182)\n- Daya, actually a dialect of Lampung Api (cf 2007-142); Lengkayap, another name for Daya\n- Aji is another name for Haji [hji] (proposed new code element)\n- Papuan Malay (Irianese) has been proposed to be a new code element [pmy].\nThere are also a few problems with the Malaysia "Dialects": Kedah, already an existing separate code element, Kedah Malay [meo]. Pasir Malay may refer to an area in East Kalimantan currently mapped as Banjar [bjn] rather than any dialect in Malaysia.\nThailand Malay probably refers to the separate code element Pattani Malay [mfa].\nWith this analysis, there remains a number of "local" or "vernacular" Malay language varieties that are not well differentiated from each other, as well as a number of language varieties for which further research is required to clarify their level of differentiation from more mainstream dialects. The following Sumatran dialects should be considered in this group: Tamiang, Deli, Riau mainland, Lubu, Akit, Sakai, Riau islands, coastal Jambi, and Belitung. Though not well defined, this should be considered a separate code element from Standard Malay.\n(Local) Malay currently listed under Sumatra but actually spoken in Kalimantan are: Sambas, Kota-Waringin, Sukadana, Ritok (Siantan, Pontianak), Sampit, West Borneo Coast Malay. This list of dialects would be better expressed as Sambas, Pontianak and Ketapang.\n(Local) Malay dialects in Peninsular Malaysia (mostly following Collins 1989) include but may not be limited to: coastal Terengganu, inland Terengganu, Kelantan (evidently mutually intelligible with Patani Malay), Pahang, Southeast Island, Orang Hulu, Orang Kuala, Jugra-Muar-Melaka-Johor. This list deliberately does not repeat the misleading dialect labels based on state boundaries. It also does not include the Malay varieties currently listed as separate Ethnologue entries, although some of these may be better understood also as Local Malay dialects: Kedah, Negeri Sembilan, Jakun, Orang Kanaq, Orang Seletar and Temuan.\n(Local) Malay dialects in Eastern Malaysia and Brunei include Sarawak, and one or more local Malay dialects are spoken in Brunei alongside the national Standard Malay variety.\nWhat remains is Standard Malay more narrowly specified (not including the above language varieties), also to be a new code element. Standard Malay (Bahasa Malaysia), the national language of Malaysia, differs substantially, particularly on the morphosyntactic level, from any described local Malay dialect.\n[RA comment: The clarification of "Malay (individual language)" must of necessity reference the Ethnologue entry for this language (Standard Malay). The current Ethnologue entry involves a large number of language varieties that already are or should be (on linguistic grounds) recognized as separate languages, along with numerous varieties that are more correctly recognized as being with the scope of other existing language code elements. Two new language code elements are being proposed as part of this refining of Standard Malay and separation of Local Malay from it. Because of this past confusion regarding what "Malay (Individual language)" should denote, and a clear narrowing of the desired denotation to be Standard Malay, the existing Malay [mly] code element must be retired.]'},
    {'iso': 'mob', 'name': u'Moinba',
     'cr': u'2006-034', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into five languages: Chug [cvg]; Lish [lsh];  Kalaktang Monpa [kkf]; Tawang Monpa [twm]; Sartang [onp]',
     'comment': u'Monpa (or Moinba) is a cover term meaning "man of the lower country" and is used to refer to several ethnically related peoples which may not be related linguistically. Andvik states "The Monpa label is unfortunate, in that it separates languages which should be grouped together, while joining under a common name languages which should not be grouped together." Other publications (listed below) have indicated high variation in language among the Monpa groups we had previously listed under Moinba [mob].\nSurvey in 2005 has helped us sort out the various groups. The highest lexical similarity percentage among these 5 varieties are Chug with Lish - 62%. Informal comprehension testing indicated that Chug speakers had difficulty fully understanding a Lish story. The next highest similarity is Kalaktang with Tshangla_tsj - 62 \u2013 71%. Kalaktang speakers averaged 55% intelligibility of a Tshangla RTT with high standard deviation. Lish & Chug with Tawang and Kalaktang -15-21% LXS, Kalaktang with Tawang - 26-28% LXS. The closest language to Sartang is Sherdukpen with lexical similarity 49% to 60%. Sartang is less than 32% similar to the other 4 Monpa languages. Although I personally doubt the accuracy of the LXS numbers, they do indicate a great deal of variation which confirms similar statements by published sources.'},
    {'iso': 'mqd', 'name': u'Madang',
     'cr': u'2007-245', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Mainstream Kenyah [xkl]',
     'comment': u'\u201cThe name Kenyah, Kelinyau, was proposed by Wurm and Hattori (1981) mainly based on what Soriente (2005:19) calls "superficial analysis focusing on geographic and administrative boundaries". Using the means of comparative linguistics methodology, it is possible to clarify the variations the Kenyah group. By investigating the shared innovation among the various Kenyah group, Soriente (2005) proposes that the names above- mentioned be used to incorporate all the other variants of another subgroup of Kenyah which further divided into four minor categories (which for the sake of simplicity here will be only referred to as "group 1-4". Group 1 language incorporates dialects of Lepo Tau, Lepo Bem, Uma Jalan, Uma Tukung, Lepo Jengan, Lepo Aga, Uma Ake, Lepo Ga, Lepo La\'ang, Sambup and Likan. Group 2 language incorporates the dialect of Lepo Ke\', and Lepo Kuda. Group 3 language incorporates dialect of Lepo Ma\'ut, Lepo Ndang, Badeng, and Lepo Jamok. Group 4 language incorporate dialects of Bakung and Lepo Teppu\'\u201d'},
    {'iso': 'muw', 'name': u'Mundari',
     'cr': u'2007-065', 'effective': '2008-02-18', 'reason': 'split',
     'remedy': 'Split into Munda [unx] and Mundari [unr] (new identifier)',
     'comment': u'Munda is regarded as a separate language from Mundari by numerous published sources. Munda and Mundari are enumerated separately on the national census, thus indicating a separate ethnolinguisic identity.'},
    {'iso': 'mzf', 'name': u'Aiku',
     'cr': u'2006-057', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into four languages: Ambrak [aag]; Yangum Dey [yde]; Yangum Gel [ygl]; Yangum Mon [ymo]',
     'comment': u'The four groups speak related but distinct languages, with communication between the groups in Tok Pisin rather than one or more of the languages, indicating that inherent intelligibility is low.'},
    {'iso': 'nhj', 'name': u'Tlalitzlipa Nahuatl',
     'cr': u'2006-101', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merge into [nhi]',
     'comment': u'The linguist along with her co-translators visited the area and found that they speak a mutually intelligible dialect with nhi (Tenango Nahuatl, proposed name change to Zacatla\u0301n-Ahuacatla\u0301n-Tepetzintla Nahuatl).'},
    {'iso': 'nhs', 'name': u'Southeastern Puebla Nahuatl',
     'cr': u'2006-089', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into Sierra Negra Nahuatl [nsu] and Southeastern Puebla Nahuatl [npl]',
     'comment': u'75% intelligibility between the two speech groups'},
    {'iso': 'nky', 'name': u'Khiamniungan Naga',
     'cr': u'2007-252', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into three languages: Khiamniungan Naga [kix] (new identifier); Para Naga [pzn]; Makuri Naga [jmn]',
     'comment': u'Makuri Naga and Para Naga share very low lexical similarity with Khiamniungan Naga. Inherent intelligibility should therefore be low. Ethnolinguistic identity is separate between these three groups (Makuri and Para each show signs of strong language vitality), and there is no known common literature. Also, there is not any known intermediate variety that would be intelligible to any pair of these three language groups.'},
    {'iso': 'nxj', 'name': u'Nyadu',
     'cr': u'2007-255', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u"Merge into Benyadu' [byd]",
     'comment': u"Collins (personal communication - interview, 2004) is confident that Nyadu is the same language as Benyadu'."},
    {'iso': 'occ', 'name': u'Occidental',
     'cr': u'2006-090', 'effective': '2007-07-18', 'reason': 'duplicate',
     'remedy': u'Merge into Interlingue [ile] as Duplicate',
     'comment': u'Interlingue is the later name (currently in use) for this language, created by Edgar de Wahl. The [ile] identifier is in ISO 639-2 (as well as ISO 639-3). Occidental should be added as another name associated with [ile].'},
    {'iso': 'ogn', 'name': u'Ogan',
     'cr': u'2007-179', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into [pse] Central Malay',
     'comment': u'\u201cCentral Malay is the proposed name for the language embracing the related Malay dialects of Pasemah, Lintang, Semendo, Ogan, Enim, Bengkulu, and Serawai Malay. Central Malay is the historic name for the languages found in the highlands of the Bukit Barisan mountains between South Sumatra, Lampung, and Bengkulu provinces. According to Adelaar quoting Voorheeve, the term Middle Malay is a poor translation of the Dutch name for these languages, Midden Maleisch, and properly translated should be Central Malay. (Adelaar 1992:4) Use of the name Central Malay will reflect these group of dialects long standing position of being related and sharing a common culture.\u201d'},
    {'iso': 'ope', 'name': u'Old Persian',
     'cr': None, 'effective': '2008-04-18', 'reason': 'duplicate',
     'remedy': u'Merge into Old Persian (ca. 600-400 B.C.) [peo] as duplicate',
     'comment': None},
    {'iso': 'ork', 'name': u'Orokaiva',
     'cr': u'2007-190', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Orokaiva [okv] (new identifier), Aeka [aez] and Hunjara-Kaina Ke [hkk]',
     'comment': u'Orokaiva and Hunjara-Kaina Ke are only 67% lexically similar. Hunjara-Kaina Ke speakers see themselves as speaking a different language from Orokaiva. Many Hunjara-Kaina Ke speakers reported that they understand very little Orokaiva. Aeka is 72% lexically similar to Orokaiva. However, Aeka speakers consider their language as different from Orokaiva. They reported very low comprehension of Orokaiva and scripture extensibility testing also showed low comprehension of Orokaiva.'},
    {'iso': 'paj', 'name': u'Ipeka-Tapuia',
     'cr': u'2007-004', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Curripaco [kpc]',
     'comment': u'Ipeka-Tapuia [paj] is a dialect / clan of Curripaco [kpc].'},
    {'iso': 'pec', 'name': u'Southern Pesisir',
     'cr': u'2007-142', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Lampung Api [ljp]',
     'comment': u'There are various lects belonging to the closely-related Lampung(ic) language family scattered throughout the Sumatran provinces of Lampung and South Sumatra. The term "Lampung" applies to the whole family (or the province); however the language family (formerly consisting of 9 Ethnologue entries) is best conceived as consisting of three closely-related languages: Lampung Api, Lampung Nyo and Komering (see Hanawalt et al. forthcoming for more details). This proposal gives details regarding the proposed language "Lampung Api". "Api" is a modifier of "Lampung" and refers to this language\'s distinctive term for \'what?\' (as does "Nyo").\nWalker (1975) was a lexicostatistical comparison of various Lampungic lects. In the conclusion he delineated a number of dialects, including "Krui", "Pubian", "Southern Pesisir", "Ranau" (subsumed under Krui), and "Sungkai" (subsumed under Pubian). He nowhere stated that these were distinct languages. Hanawalt (forthcoming) and Anderbeck (forthcoming) validate the earlier lexicostatistic division of Lampungic and demonstrate how the various subgroups of Lampung Api (recognized by Walker 1975 as "Lampung Pesisir") cohere lexically, phonologically and in terms of intelligibility and should not be considered distinct languages.'},
    {'iso': 'pen', 'name': u'Penesak',
     'cr': u'2007-182', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Musi [mui]',
     'comment': u'The Musi river is the longest in Sumatra, and many speech varieties are spoken along its length. Musi and the other Malay varieties listed in 4a were listed in the 1981 Wurm and Hattori linguistic atlas as being Malay dialects, but were incorrectly interpreted in previous Ethnologue editions as distinct languages. Language surveys completed in 2006-2007 found comprehension between these Malay dialects, and a set of shared phonological innovations. The above "languages" should be listed as dialects of Musi.\nMUSI--language (internal structure) Musi group Palembang group\nMusi, Rawas, Pegagan Palembang, Lowland Malay\nIt was found that there was high reported comprehension between the speech varieties found along the coastal plain of South Sumatra and those centered around the city of Palembang, making a Palembang subgroup. The speech varieties of Downstream Lematang, Belide, and Penesak also had a high rate of reported comprehension, and form a Lowland Malay subgroup. The Palembang and the Lowland Malay subdialects together form the Palembang Malay subgroup of the Musi language. The other subgroup in the Musi language is the Musi subgroup, which is comprised of the Musi, Pegagan, and Rawas dialects. The Musi and Pegagan speech varieties share phonological innovations. Rawas has one of the phonological innovations, as well as some of its own. There is high reported comprehension between the Musi and Rawas and a high percentage of shared lexical items. The culture, phonological innovations, and reported comprehension in the Musi river basin dialect chain provide a reasonable basis for grouping these dialects of Malay (as ) as a distinct language. Moreover, the cultural and linguistic differences, distinct phonological innovations, along with lower reported comprehension between isolects of the Musi language and those of Central Malay (Pasemah, Semendo, Enim, etc.) argue against subsuming them all under "South Sumatran Malay".'},
    {'iso': 'plm', 'name': u'Palembang',
     'cr': u'2007-182', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Musi [mui]',
     'comment': u'The Musi river is the longest in Sumatra, and many speech varieties are spoken along its length. Musi and the other Malay varieties listed in 4a were listed in the 1981 Wurm and Hattori linguistic atlas as being Malay dialects, but were incorrectly interpreted in previous Ethnologue editions as distinct languages. Language surveys completed in 2006-2007 found comprehension between these Malay dialects, and a set of shared phonological innovations. The above "languages" should be listed as dialects of Musi.\nMUSI--language (internal structure) Musi group Palembang group\nMusi, Rawas, Pegagan Palembang, Lowland Malay\nIt was found that there was high reported comprehension between the speech varieties found along the coastal plain of South Sumatra and those centered around the city of Palembang, making a Palembang subgroup. The speech varieties of Downstream Lematang, Belide, and Penesak also had a high rate of reported comprehension, and form a Lowland Malay subgroup. The Palembang and the Lowland Malay subdialects together form the Palembang Malay subgroup of the Musi language. The other subgroup in the Musi language is the Musi subgroup, which is comprised of the Musi, Pegagan, and Rawas dialects. The Musi and Pegagan speech varieties share phonological innovations. Rawas has one of the phonological innovations, as well as some of its own. There is high reported comprehension between the Musi and Rawas and a high percentage of shared lexical items. The culture, phonological innovations, and reported comprehension in the Musi river basin dialect chain provide a reasonable basis for grouping these dialects of Malay (as ) as a distinct language. Moreover, the cultural and linguistic differences, distinct phonological innovations, along with lower reported comprehension between isolects of the Musi language and those of Central Malay (Pasemah, Semendo, Enim, etc.) argue against subsuming them all under "South Sumatran Malay".'},
    {'iso': 'poj', 'name': u'Lower Pokomo',
     'cr': u'2007-170', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Kipfokomo (Pokomo) [pkb]',
     'comment': u'The current name Pokomo does not reflect the language name according to the speech community. They say that their language name is Kipfokomo The "Upper" distinction is no longer needed, as this proposal also recommends the merging of Lower Pokomo [poj] with Upper Pokomo to have a single code element encompassing all of Kipfokomo, nee "Pokomo".\nThe current distinction between Upper Pokomo and Lower Pokomo is not so much a matter of linguistic intelligibility as it is of other distinctions. On linguistic grounds (including use of literature), these should be considered one language.'},
    {'iso': 'prv', 'name': u'Proven\xe7al',
     'cr': None, 'effective': '2007-03-14', 'reason': 'merge',
     'remedy': u'Merge into Occitan (post 1500) [oci]',
     'comment': None},
    {'iso': 'pun', 'name': u'Pubian',
     'cr': u'2007-142', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Lampung Api [ljp]',
     'comment': u'There are various lects belonging to the closely-related Lampung(ic) language family scattered throughout the Sumatran provinces of Lampung and South Sumatra. The term "Lampung" applies to the whole family (or the province); however the language family (formerly consisting of 9 Ethnologue entries) is best conceived as consisting of three closely-related languages: Lampung Api, Lampung Nyo and Komering (see Hanawalt et al. forthcoming for more details). This proposal gives details regarding the proposed language "Lampung Api". "Api" is a modifier of "Lampung" and refers to this language\'s distinctive term for \'what?\' (as does "Nyo").\nWalker (1975) was a lexicostatistical comparison of various Lampungic lects. In the conclusion he delineated a number of dialects, including "Krui", "Pubian", "Southern Pesisir", "Ranau" (subsumed under Krui), and "Sungkai" (subsumed under Pubian). He nowhere stated that these were distinct languages. Hanawalt (forthcoming) and Anderbeck (forthcoming) validate the earlier lexicostatistic division of Lampungic and demonstrate how the various subgroups of Lampung Api (recognized by Walker 1975 as "Lampung Pesisir") cohere lexically, phonologically and in terms of intelligibility and should not be considered distinct languages.'},
    {'iso': 'rae', 'name': u'Ranau',
     'cr': u'2007-142', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Lampung Api [ljp]',
     'comment': u'There are various lects belonging to the closely-related Lampung(ic) language family scattered throughout the Sumatran provinces of Lampung and South Sumatra. The term "Lampung" applies to the whole family (or the province); however the language family (formerly consisting of 9 Ethnologue entries) is best conceived as consisting of three closely-related languages: Lampung Api, Lampung Nyo and Komering (see Hanawalt et al. forthcoming for more details). This proposal gives details regarding the proposed language "Lampung Api". "Api" is a modifier of "Lampung" and refers to this language\'s distinctive term for \'what?\' (as does "Nyo").\nWalker (1975) was a lexicostatistical comparison of various Lampungic lects. In the conclusion he delineated a number of dialects, including "Krui", "Pubian", "Southern Pesisir", "Ranau" (subsumed under Krui), and "Sungkai" (subsumed under Pubian). He nowhere stated that these were distinct languages. Hanawalt (forthcoming) and Anderbeck (forthcoming) validate the earlier lexicostatistic division of Lampungic and demonstrate how the various subgroups of Lampung Api (recognized by Walker 1975 as "Lampung Pesisir") cohere lexically, phonologically and in terms of intelligibility and should not be considered distinct languages.'},
    {'iso': 'rjb', 'name': u'Rajbanshi',
     'cr': u'2007-008', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Kamta (India) / Rangpuri (Bangladesh) [rkt] and Rajbanshi (Nepal) [rjs]',
     'comment': u'What has formerly been listed as Rajbanshi_rjb in Nepal, India and Bangladesh can more accurately be represented by using 3 different names and 2 different iso codes. Survey revealed 62-69% intelligibility of Nepal Rajbanshi by speakers of Rajbanshi in West Bengal, India. What is spoken in India is intelligible with the variety in Bangladesh and can share an iso code but it is proposed to give them separate main names.'},
    {'iso': 'rws', 'name': u'Rawas',
     'cr': u'2007-182', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Musi [mui]',
     'comment': u'The Musi river is the longest in Sumatra, and many speech varieties are spoken along its length. Musi and the other Malay varieties listed in 4a were listed in the 1981 Wurm and Hattori linguistic atlas as being Malay dialects, but were incorrectly interpreted in previous Ethnologue editions as distinct languages. Language surveys completed in 2006-2007 found comprehension between these Malay dialects, and a set of shared phonological innovations. The above "languages" should be listed as dialects of Musi.\nMUSI--language (internal structure) Musi group Palembang group\nMusi, Rawas, Pegagan Palembang, Lowland Malay\nIt was found that there was high reported comprehension between the speech varieties found along the coastal plain of South Sumatra and those centered around the city of Palembang, making a Palembang subgroup. The speech varieties of Downstream Lematang, Belide, and Penesak also had a high rate of reported comprehension, and form a Lowland Malay subgroup. The Palembang and the Lowland Malay subdialects together form the Palembang Malay subgroup of the Musi language. The other subgroup in the Musi language is the Musi subgroup, which is comprised of the Musi, Pegagan, and Rawas dialects. The Musi and Pegagan speech varieties share phonological innovations. Rawas has one of the phonological innovations, as well as some of its own. There is high reported comprehension between the Musi and Rawas and a high percentage of shared lexical items. The culture, phonological innovations, and reported comprehension in the Musi river basin dialect chain provide a reasonable basis for grouping these dialects of Malay (as ) as a distinct language. Moreover, the cultural and linguistic differences, distinct phonological innovations, along with lower reported comprehension between isolects of the Musi language and those of Central Malay (Pasemah, Semendo, Enim, etc.) argue against subsuming them all under "South Sumatran Malay".'},
    {'iso': 'sdd', 'name': u'Semendo',
     'cr': u'2007-179', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into [pse] Central Malay',
     'comment': u'\u201cCentral Malay is the proposed name for the language embracing the related Malay dialects of Pasemah, Lintang, Semendo, Ogan, Enim, Bengkulu, and Serawai Malay. Central Malay is the historic name for the languages found in the highlands of the Bukit Barisan mountains between South Sumatra, Lampung, and Bengkulu provinces. According to Adelaar quoting Voorheeve, the term Middle Malay is a poor translation of the Dutch name for these languages, Midden Maleisch, and properly translated should be Central Malay. (Adelaar 1992:4) Use of the name Central Malay will reflect these group of dialects long standing position of being related and sharing a common culture.\u201d'},
    {'iso': 'sdi', 'name': u'Sindang Kelingi',
     'cr': u'2007-196', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Col [liw]',
     'comment': u'Col (pronounced \'chole\' or \'chool\') is the name the speakers of this variety of Malayic use for themselves in the areas surveyed, with the exception of the Col speakers from Lembak Delapan, a small pocket of Col speakers near Bengkulu City. The other regions where Col is spoken were not familiar with the term Lembak, but had heard of the term Saling and Sindang Kelingi. The general term used by this group for its language and by neighboring language groups is "Col", their word for "there isn\'t" or "none". If Col is not used, we recommend using the name "Sindang" as this is the name used in the government\'s linguistic literature on the language and is placed in front of the name of the dialect of Col under consideration, i.e. Sindang Kelingi, Sindang Beliti...The term Lembak should be changed to an alternate name or dropped as the majority of the Col population has not heard of this term and for those living in or near to South Sumatra, it brings to mind the Musi dialect Belide.'},
    {'iso': 'skl', 'name': u'Selako',
     'cr': u'2007-261', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Kendayan; Salako [knx]',
     'comment': u'\u201cAdelaar (1992 and 2002) confirms that Selako and Ahe are part of the Kendayan language chain and are mutually intelligible with each other along with several other Kendayan dialects. Collins (personal communication - email 2007), confirms that Ahe, Selako, and Kendayan are all fully intelligible with each other.\u201d\n(glg500503)'},
    {'iso': 'slb', 'name': u'Kahumamahon Saluan',
     'cr': u'2007-118', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Saluan [loe]',
     'comment': u'Whilst in the past two "Saluan" languages have been recognized, there have been at most only two reasons for doing so, and in neither case was the reason linguistic:\n(a) the Kahumamahon people in Simpang village were regarded by the Indonesian government as an exotic/isolated/primitive people (Indonesian: "suku terasing")\n(b) NTM mission was proceeding with a New Testament translation in Simpang village, while concurrently the Indonesian Bible Society was proceeding with a translation in Saluan as spoken in coastal areas.\nA linguistic basis for such a division, however, has never been made clear, and in fact no one has even known where to draw the border between these two supposed languages.\nIn 2001, I requested and obtained a 488-item word list of "Kahumamahon Saluan" from Robert Brown, then living in Simpang village and who knew the language well. A comparison of this word list with four other "Coastal Saluan" word lists which we had in hand suggested then that these were just one language. In 2006, an Indonesian colleague and I travelled the breadth of the Saluan area and collected seven additional word lists so that we could fully appraise the dialect situation. Whilst the isolect spoken in Simpang village is indeed divergent, all word lists scored above 80% in lexical similarity. Furthermore, "Kahomamahon" speakers themselves consider their language to be nothing other than a dialect of Saluan.\nWe are currently writng up the results of our research in a paper titled "An Initial Appreciation of the Dialect Situation in Saluan (Sulawesi, Indonesia)" (by David Mead and Edy Pasanda). Based on evidence from lexicostatistics, historical sound change and sociolinguistic interviews, we suggest that one Saluan language be recognized, which has three dialects:\nSaluan\n- Loinang dialect comprising three subdialects:\n= Lingketeng subdialect \n= Baloa\' subdialect \n= Kohumama\'on subdialect (<-- note corrected spelling)\n- Luwuk dialect \n- Kintom-Pagimana-Boalemo dialect\n\nTo this we can add:\n\nNo good cover term for the Kintom-Pagimana-Boalemo dialect emerged during the course of our visit, and perhaps each could also be considered its own subdialect.\nThe Loinang and Luwuk dialects are linked by the historical merger of word final *-n and *-l > *n, but the Luwuk and Kintom-Pagimana-Boalemo dialects are linked by higher lexical similarity.\nThe Luwuk dialect is spoken along the coast in the southeastern part of the Saluan language area, the Loinang dialect was formerly spoken in the interior, and the Kintom- Pagimana-Boalemo dialect elsewhere (on the coast). However, migrations of Saluan people from the interior to the coast over the past century has resulted in considerable dialect mixture in some coastal areas.'},
    {'iso': 'srj', 'name': u'Serawai',
     'cr': u'2007-179', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into [pse] Central Malay',
     'comment': u'\u201cCentral Malay is the proposed name for the language embracing the related Malay dialects of Pasemah, Lintang, Semendo, Ogan, Enim, Bengkulu, and Serawai Malay. Central Malay is the historic name for the languages found in the highlands of the Bukit Barisan mountains between South Sumatra, Lampung, and Bengkulu provinces. According to Adelaar quoting Voorheeve, the term Middle Malay is a poor translation of the Dutch name for these languages, Midden Maleisch, and properly translated should be Central Malay. (Adelaar 1992:4) Use of the name Central Malay will reflect these group of dialects long standing position of being related and sharing a common culture.\u201d'},
    {'iso': 'suf', 'name': u'Tarpia',
     'cr': u'2007-231', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Tarpia [tpf] (new identifier) and Kaptiau [kbi]',
     'comment': u'During the SIL survey in the area, the survey team gathered wordlists in each village that was thought to be Tarpia speaking (village of Tarpia and village of Kaptiau). When these word lists were compared, the results show that the lexical similarity between these two languages is low enough that these two varieties would not be intelligible (only 37% apparent lexical similarity). In addition, each of these villages reported that the other villages speaks a completely different language, which indicates that the people in these people perceive the other village to be of a different ethnolinguistic identity.'},
    {'iso': 'suh', 'name': u'Suba',
     'cr': u'2007-031', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Suba [sxb] (Kenya) and Suba-Simbita [ssc] (Tanzania)',
     'comment': u'A sociolinguistic survey of the Suba peoples of Tarime District, Mara Region, Tanzania, was carried out by the SIL Tanzania Language Assessment Team in January and February 2006. This survey also included a short stay on Mfangano Island in Kenya, which is the heartland of the Kenyan Suba people and their language. During this time a 300-word wordlist was elicited in the Kenyan variety of Suba, and a 3-minute story was digitally recorded. The team then returned to Tanzania and spent 2 weeks researching the Tanzanian varieties spoken by the Suba and Simbiti peoples. In a total of 6 research locations wordlists were elicited and groups of people were invited to listen to the story elicited in Kenyan Suba. Almost without exception the Tanzanian Suba and Simbiti peoples had a great deal of difficulty understanding the Kenyan Suba, and all reported that it was more difficult to understand than the nearby Kuria and Zanaki languages. The comparison of wordlists similarly showed that the Kenyan Suba variety and the Tanzanian Suba and Simbiti varieties are distinct languages.\nTherefore the Language Assessment Team concluded that the Suba and Simbiti varieties hitherto considered to be part of the same language as that spoken by the Suba in Kenya, do in fact constitute a distinct language.'},
    {'iso': 'suu', 'name': u'Sungkai',
     'cr': u'2007-142', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Lampung Api [ljp]',
     'comment': u'There are various lects belonging to the closely-related Lampung(ic) language family scattered throughout the Sumatran provinces of Lampung and South Sumatra. The term "Lampung" applies to the whole family (or the province); however the language family (formerly consisting of 9 Ethnologue entries) is best conceived as consisting of three closely-related languages: Lampung Api, Lampung Nyo and Komering (see Hanawalt et al. forthcoming for more details). This proposal gives details regarding the proposed language "Lampung Api". "Api" is a modifier of "Lampung" and refers to this language\'s distinctive term for \'what?\' (as does "Nyo").\nWalker (1975) was a lexicostatistical comparison of various Lampungic lects. In the conclusion he delineated a number of dialects, including "Krui", "Pubian", "Southern Pesisir", "Ranau" (subsumed under Krui), and "Sungkai" (subsumed under Pubian). He nowhere stated that these were distinct languages. Hanawalt (forthcoming) and Anderbeck (forthcoming) validate the earlier lexicostatistic division of Lampungic and demonstrate how the various subgroups of Lampung Api (recognized by Walker 1975 as "Lampung Pesisir") cohere lexically, phonologically and in terms of intelligibility and should not be considered distinct languages.'},
    {'iso': 'szk', 'name': u'Sizaki',
     'cr': u'2007-033', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Ikizu [ikz]',
     'comment': u'Ikizu and Sizaki share 95% lexical similarity and the same phonological innovations. Perceived intelligibility is very high. Ikizu and Sizaki speakers consider themselves separate ethnic groups with the same ancestral history speaking basically the same language. During group interviews, Sizaki speakers said that only when older people speak can one hear some differences.'},
    {'iso': 'tle', 'name': u'Southern Marakwet',
     'cr': u'2007-162', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'All existing uses should probably be Markweeta [enb]',
     'comment': u'There is no evidence to support the existence of Talai as the name of a distinct language. Talai is the name of a region. In the Ethnologue 15th ed., Talai has been closely associated with Markweeta, ne\u0301e Endo: "\'Marakwet\' is a cover term for Talai and Endo." Thus it is appropriate to map any existing usage of the code element for Talai to Markweeta, which now refers to the whole language area and its dialects (whereas "Endo" referred only to the northern dialect area)'},
    {'iso': 'tmx', 'name': u'Tomyang',
     'cr': u'2006-109', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merge into Yamphu [ybi]',
     'comment': u'There is 82% lexical similarity between Tomyang and Yamphu. The original Ethnologue entry for Tomyang was created before this data became available. A news article in a local newspaper stated that a new language, Tomyang, had been discovered by Nepali linguists. Further information revealed that the only Tomyang data collected was a Swadish 100 words list. And out of those, 21% are Nepali loan words. Also the wordlist was collected outside the area in which it is spoken and was, therefore, not compared to Yamphu, which is the main language in that area. It is proposed to list Tomyang as a dialect of Yamphu until more information could confirm it is a separate language.'},
    {'iso': 'tnj', 'name': u'Tanjong',
     'cr': u'2007-235', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Kanowit [kxn]',
     'comment': u'Chou cites percentage of lexical similarity between Kanowit and Tanjung as 82%.'},
    {'iso': 'tot', 'name': u'Patla-Chicontla Totonac',
     'cr': u'2006-085', 'effective': '2007-07-18', 'reason': 'split',
     'remedy': 'Split into Upper Necaxa Totonac [tku] and Tecpatl\xc3\xa1n Totonac [tcw]',
     'comment': u'Upper Necaxa Totonac and Tecpatla\u0301n Totonac do not seem to be naively mutually intelligible, although many speakers of one have enough experience with the other that in practice they can communicate. However, Upper Necaxa as spoken in Patla, Chicontla, San Pedro Tlalontongo, and Cacahuatla\u0301n is distinguished by (and recognized as a dialect in the region according to) a number of sound changes including the neutralization of a contrast between the voiceless lateral affricate and the voiceless lateral fricative.Tecpatla\u0301n Totonac has also undergone a shift of /w/ to /b/ (a sound not found at all in Upper Necaxa). There are a great many lexical distinctions that set Tecpatla\u0301n apart from the others.\nTecpatla\u0301n Totonac does, however, share one important sound change with the Upper Necaxa variety, the lenition of *q to a glottal stop and the concomittant collapse of historical fricative-q clusters to ejective fricatives. The shift is not quote complete in Tecpatla\u0301n, however, which retains /q/ in at least some lexical items. Tecpatla\u0301n and Upper Necaxa also share a shift in the grammatical paradigms so that many n-final verbs are treated as consonant-final stems for the purposes of perfective aspectual inflection (departing from the more common Totonacan pattern). These changes set Tecpatla\u0301n apart from Zihuateutla Totonac.'},
    {'iso': 'ttx', 'name': u'Tutong 1',
     'cr': u'2007-206', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Bisaya, Brunei [bsb]',
     'comment': u'Bisaya in Brunei and Sarawak is the same cross-border language.\nWe are also proposing to retire the designations Tutong 1 and Tutong 2, as researchers have used these terms with conflicting designations. The language in the Dusunic group (formerly Tutong 1) should be called Brunei Bisaya, which includes as dialects Sarawak Bisaya and Tutong 1/Southern Bisaya.'},
    {'iso': 'ubm', 'name': u'Upper Baram Kenyah',
     'cr': u'2007-265', 'effective': '2008-01-14', 'reason': 'non-existent',
     'remedy': u"Any current use is likely either Mainstream Kenyah [xkl] or Uma' Lung [ulu] (new code element)",
     'comment': u'Kenyah, Upper Baram is a vague name associated mainly to toponym or ethnonym of some Kenyah groups. The name was proposed by Wurm and Hattori (1981) mainly based on what Soriente (2005:19) calls "superficial analysis focusing on geographic and administrative boundaries". Using the means of comparative linguistics methodology, Soriente (2005) is able to re-classify the variants of Kenyah.\n[RA comment: This Kenyah language is being requested to be retired as "non-existent" because it is not clear to which of the two Kenyah languages (one existing, but expanded, and the other newly defined) the former geographically specified language would belong. See requests 2007-245 and 2007-246.]'},
    {'iso': 'vky', 'name': u'Kayu Agung',
     'cr': u'2007-195', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Komering [kge]',
     'comment': u'There are various lects belonging to the closely-related Lampung(ic) language family scattered throughout the Sumatran provinces of Lampung and South Sumatra. The term "Lampung" applies to the whole family (or the province); however the language family (formerly consisting of 9 Ethnologue entries) is best conceived as consisting of three closely-related languages: Lampung Api, Lampung Nyo and Komering (see Hanawalt et al. forthcoming for more details). The northernmost area of this family follows the Komering river. Phonologically it is quite similar to Lampung Api but in terms of lexicon and ethnolinguistic identity (as well as exposure which leads to familiarity) it is quite distinct. The Komering area furthest downstream is the city of Kayu Agung. There are not one but two speech varieties in Kayu Agung, one just called "Kayu Agung" and one called "Kayu Agung Asli" or "native Kayu Agung". The latter consists of one village within the city. Oral tradition has it that the numerically dominant "Kayu Agung" is actually from somewhere in Lampung, and there are well-known but minor differences between the two in terms of lexicon and phonology, with no disruption of intelligibility. The two lects also share a high degree of linguistic coherence and intelligibility with Komering varieties further upstream and should not be termed different languages.'},
    {'iso': 'vmo', 'name': u'Muko-Muko',
     'cr': u'2007-181', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Minangkabau [min]',
     'comment': u'Language surveys completed in 2007 identified Muko-Muko as a dialect of Minangkabau, with a shared ethnolinguistic identity, shared culture, and shared comprehension. The neighboring variety, Pekal [pel], was reportedly incomprehensible.\nMuko-Muko shares the same phonological innovations as the Minangkabau dialects to the immediate north of it. The survey respondents stated they identified themselves as being part of the Minangkabau linguistic grouping and can understand more central dialects of Minangkabau. Muko-Muko was listed as a dialect of Minangkabau in Wurm and Hattori (1981) but the Ethnologue has it as a distinct language. The Wurm and Hattori map for southern Sumatra has Muko-Muko delineated with a dashed line inside the Minangkabau solid line, showing a dialect. The WIST survey of 2007 confirmed the ethnolinguistic identity of the Muko-Muko as being part of the Minangkabau grouping. The Pekal, also shown in the Wurm and Hattori atlas as a dialect of Minangkabau, did not have this same self identity, but identified themselves more with the Malayic varieties to the south of Bengkulu. Southern Sumatra survey report forthcoming.'},
    {'iso': 'xah', 'name': u'Kahayan',
     'cr': u'2007-184', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Ngaju [nij]',
     'comment': u'Both these varieties [kxg] Katingan and [xah] Kahayan are major [nij] dialects (two of three major dialects), almost 100% intelligible with nij.'},
    {'iso': 'xkm', 'name': u'Mahakam Kenyah',
     'cr': u'2007-264', 'effective': '2008-01-14', 'reason': 'non-existent',
     'remedy': u"Any current use is likely either Mainstream Kenyah [xkl] or Uma' Lung [ulu] (new code element)",
     'comment': u'Kenyah, Mahakam is a vague name associated mainly to toponym or ethnonym of some Kenyah groups. The name was proposed by Wurm and Hattori (1981) mainly based on what Soriente (2005:19) calls "superficial analysis focusing on geographic and administrative boundaries". Using the means of comparative linguistics methodology, Soriente (2005) is able to re-classify the variants of Kenyah.\n[RA comment: This Kenyah language is being requested to be retired as "non-existent" because it is not clear to which of the two Kenyah languages (one existing, but expanded, and the other newly defined) the former geographically specified language would belong. See requests 2007-245 and 2007-246.]'},
    {'iso': 'xsk', 'name': u'Sakan',
     'cr': None, 'effective': '2008-10-23', 'reason': 'duplicate',
     'remedy': u'Merge with Khotanese [kho] as duplicate',
     'comment': None},
    {'iso': 'xst', 'name': u"Silt'e",
     'cr': u'2007-114', 'effective': '2008-02-28', 'reason': 'split',
     'remedy': "Split into Wolane [wle] and Silt'e [stv] (new identifier)",
     'comment': u'The Wolane language area is separated from the Silte area, being some 30-40 kms away from each other. It is true that there is inherent intelligibility to some degree, but the Wolane strongly feel like being ethnically separate from the Silte. The Wolane feel like belonging to the Gurage people, with whom they are direct neighbors and have close links with. On administrative level, the Wolane did not want to be part of the Silte Zone, but of the Gurage zone.\nThe Wolane speech variety does not have its own writing system, as opposed to Silte where an orthography was adopted some 10 years ago. In the Silte area, the Medium of Instruction (MoI) is Silte, but the Wolane use Amharic.\nIn terms of religion, the vast majority of Silte are Muslims, whereas this is only true for part of the Wolane, quite a percentage of them are following Ethiopian orthodox Christianity.'},
    {'iso': 'xuf', 'name': u'Kunfal',
     'cr': u'2007-044', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Awngi [awn]',
     'comment': u'The language code element for Kunfal [xuf] should be retired, and Kunfal should be merged with Awngi [awn]. Kunfal has been shown to be a dialect of Awngi, according to the results of two survey trips undertaken by Andreas Joswig, Hussein Mohammed and Ryan Boone in 2005 (to be published). Comprehension testing results and interview data regarding language attitude and identity all support this conclusion. Speakers of the Kunfal variety can understand Awngi texts with no problem and identify it as their own language.'},
    {'iso': 'yib', 'name': u'Yinglish',
     'cr': u'2006-044', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merged into English [eng]; entirely intelligible with English.',
     'comment': u'\u201cI do not believe that there exists evidence justifying the treatment of Yinglish as a separate language from English, rather than a dialect with Yiddish-derived vocabulary and occasional aberrant Yiddish-derived syntax. The differences between English and Yinglish are simply not comparable to the differences between German and Yiddish or Spanish and Ladino. In fact, Yinglish fits smoothly into the English dialect continuum. Yinglish is readily understood by speakers of plain English, provided the lexical items are explained, and even some of them have now entered the lexicon of colloquial American English, as your mavin Joshua Fishman notes. If there are enough unusual items, as in Yeshiva English, the speech may be unintelligible to the uninstructed listener, but no more so than the technical talk of pilots, doctors, or computer programmers. (Some borrowed words have un-English phonologies, but so do "Bach" and "oeuvre" as pronounced by many English speakers.) Furthermore, U.S. and U.K. Yinglish are about as different as U.S. and U.K. English, though segregating the first two into a separate language would lead us to expect that they would stand together as against non-Jewish dialects of English.  Orthographically (which is relevant to the sociolinguistics), Yinglish is invariably written in Latin script using mostly English conventions, quite unlike the various Jewish languages, which are mostly written in Hebrew script using their own conventions. Finally, the Ethnologue claim that Yinglish is "a second language only" is misleading. It is not a *second* language which some English-speakers also command; it is for the most part the particular way in which those English-speakers speak their first language, English (There are some Yinglish-speakers whose first Request for Change to ISO 639-3 Language Code, page 2\nlanguage is not English, of course.) Furthermore, the number and variety of Yinglish features in a particular speaker\'s speech (or writing) is under direct control: one can use more or fewer of them as appropriate. I\'ve used only one in this letter. (On a separate note, the term "Ameridish", listed in the Ethnologue as a synonym for Yinglish, wasn\'t originally meant to be: it was coined by Rosten to refer to Eastern Yiddish as spoken in the United States, with English lexical influences. He occasionally lost track of his own distinction, defining "opstairsiker/keh" as Yinglish and "donstairsiker/keh" as Ameridish for upstairs and downstairs neighbor respectively; both terms can be seen as either. But then again, Samuel Johnson defined "windward" and "leeward" the same way!)'},
    {'iso': 'yio', 'name': u'Dayao Yi',
     'cr': u'2007-073', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Lipo [lpo]',
     'comment': u'The distinctions between these two varieties has been a matter of some confusion for decades. This is primarily due to the fact that [yio] speakers are officially classified under the Yi nationality and [lpo] speakers are officially classified under the Lisu nationality. Numerous complex geographic, sociolinguistic, cultural and historical factors are behind this distinction--none of which seem to be directly related to the inter-intelligibility and/or in- group identity of the Lipo speakers themselves. Bradley has engaged in extensive research on Lipo dialects as part of his larger research focus on Central Ngwi varieties in general. Based on his own on-site survey work, he has observed the two to be mutually intelligible dialects of the same language and closely aligned ethnically in spite of an otherwise highly ramified sociolinguistic situation linked to various group-external factors.'},
    {'iso': 'ymj', 'name': u'Muji Yi',
     'cr': u'2007-120', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into five languages: Muji, Southern [ymc], Mojii [ymi], Qila Muji [ymq], Northern Muji [ymx], and Muzi [ymz]',
     'comment': u'This split is proposed based on findings from formal linguistic survey work on the Phula languages of Yunnan Province, China, carried out from 2005-2006. Eight of the 40 villages visited during this research period were closely affiliated ethnolinguistically with ISO code [ymj]. Research components explored lexicon, identity, contact and intelligibility, and the results point to five synchronically distinct languages originally subsumed under [ymj]. Communication and transportation have traditionally been limited between these varieties, though they are all closely related phylogenetically. The most vital and prototypical Muji variety, Southern Muji, also has the largest number of speakers. Rationale for identifying the other four languages as distinct from [ymj] is given below.\n[ymx] or Northern Muji speakers yeilded a mean score of .60 on a recorded text test from [ymc] with a high standard deviation of 24 suggesting that a mobile demographic has learned intelligibility with [ymj]. Anecdotal and perceptual information from [ymx] and [ymc] speakers alike confirms a distinction between the two, and speakers report significant learning time (longer than two months) being required in order to communicate in their respective Muji lects. A similar situation is reported between [ymx] and [ymz].\nThe smaller [ymi] and [ymq] (Moji and Qila Muji) varieties have apparently been separated from Muji proper for centuries and evidence numerous unique lexical and phonological characteristics as a result of independent change and language contact with other varieties. Lexical similarity in core vocabulary between these two and the other Muji varieties is lower than 60%--sufficiently low to posit the presence of mutually unintelligible synchronic languages without resorting to formal intelligibility testing. Although [ymq] shares a\nmarginal 60% core lexical similarity with [ymc], a [ymc] recorded text test played for [ymq] speakers yeilded a mean score of only .38 with a low standard deviation.\n[ymz] or Muzi speakers also scored low on the [ymc] recorded text test (.50) , and [ymx] speakers report that a bride who married out from their area to a [ymz] village required six months to one year before she was able to function in the [ymz] variety.'},
    {'iso': 'ypl', 'name': u'Pula Yi',
     'cr': u'2007-121', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into three languages: Phola [ypg], Phala [ypa] and Alo Phola [ypo]',
     'comment': u'Based on recent linguistic survey findings with research components exploring identity, contact and intelligibility, we recommend that [ypl] should be split into three closely related, but synchronically distinct languages. Speaker perceptions and recorded text test scores both point to low intelligibility between Phola [ypg] and Phala [ypa]*. Undirectional intelligibility from Phala to Phola is apparent in middle-aged to elderly speakers, but younger speakers who have had less contact are unable to converse in Phala or Phola and must resort to Chinese. Based on the views of in-group and out-group members alike, ethnic identity and material culture also confirm this distinction.\nThe proposed language [ypo], or Alo Phola, is reported by Phola speakers to be an unintelligible dialect of Phola spoken in a village in central Yuanjiang County. The village is surrounded by Dai villages, and Phola speakers say the language sounds like a mix of Phola, Chinese and Dai. Speakers from the two varieties reportedly must resort to Chinese in order to communicate.'},
    {'iso': 'ypw', 'name': u'Puwa Yi',
     'cr': u'2007-122', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into three languages: Hlepho Phowa [yhl], Labo Phowa [ypb], and Ani Phowa [ypn]',
     'comment': u'Phowa speakers are classified under the Yi nationality officially and are affiliated with the Phula ethnic group historically. Although all varieties of Phowa are closely related, a complex dialect continuum has developed within Phowa which features numerous transitional varieties--not all of which are mutually intelligible (cf. Pelkey forthcoming 2008). The three extremes of this dialect continuum feature varieties which are unintelligible to the majority of the remaining Phowa speaking population, and speakers in these three regions are also offset from each other by three corresponding embedded ethnic identities--each unique: Ani, Labo, and Hlepho. These three distinct identities are recognized by ingroup and outgroup Phowa speakers alike and find expression not only in autonyms but also in material culture as is sometimes reported in Chinese sources such as KYSZ (1996).'},
    {'iso': 'yuu', 'name': u'Yugh',
     'cr': u'2013-031', 'effective': '2014-02-03', 'reason': 'duplicate',
     'remedy': u'Yugh [yuu] is a duplicate of Yug [yug]',
     'comment': u'[yuu] Yugh (Yug) and [yug] Yug (Sym-Ket) are the same language.\nI suggest retiring code [yuu] because [yug] is easier to remember, but if [yuu] is older it might be better to retain it instead. The fact that Ethnologue has an entry for [yuu] but not for [yug] might be reason to retain [yuu], though perhaps they could move their article to [yug].\nIn order to complete the change request, the form \u201cRequest for New Language Code Element in ISO 639-3\u201d (file name \u201cISO639-3_NewCodeRequestForm.doc\u201d or \u201cISO639- 3_NewCodeRequestForm.rtf\u201d) must also be submitted for each new identifier that is to be created. That step can be deferred until this form has been processed by the ISO 639-3 registrar, provided that sufficient information on the rationale is given in (b) above.\nIn the case of a minority language that has been considered in some contexts to be a dialect of a major language, yet is divergent enough to be unintelligible to speakers of the standard variety of the major language, it may be more beneficial for the users of the ISO 639-3 and 639-2 code sets to create a new code element for the divergent language variety without splitting the existing code element of the major language. The ISO 639-3 Registration Authority may make this determination when considering a request involving a major language and a highly distinct \u201cdialect.\u201d If such a course is followed, the rationale for the decision will be published in a comment by the Registration Authority on approval of the requested addition for the divergent variety.'},
    {'iso': 'ywm', 'name': u'Wumeng Yi',
     'cr': u'2007-037', 'effective': '2008-01-14', 'reason': 'merge',
     'remedy': u'Merge into Wusa Yi [ywu], renamed Wumeng Nasu (cf. 2007-038)',
     'comment': u'Wumeng and Wusa have long been recognized as distinct varieties of Nasu, but Wumeng is spoken primarily in Guizhou Province with some speakers also living in Yunnan Province (thus matching the [ywu] profile), and Wusa is spoken only in Guizhou Province (thus matching the [yig] profile). The Ethnologue profile associated with [ywm], however, claims that the language is spoken only in Yunnan. The confusion, then, can likely be traced back to a lack of understanding regarding a single variety spoken on both sides of a provincial line. Thus, [ywm] should be merged into [ywu], the [ywu] reference name should be changed to reflect the Wumeng distinction, and the [yig] reference name should be changed to reflect the Wusa distinction (cf. the related [ywu] and [yig] reference name change applications).'},
    {'iso': 'yym', 'name': u'Yuanjiang-Mojiang Yi',
     'cr': u'2007-086', 'effective': '2008-01-14', 'reason': 'split',
     'remedy': 'Split into Southern Nisu [nsd] and Southwestern Nisu [nsv]',
     'comment': u'Southern and Southwestern Nisu were originally grouped together and referred to as Yuanjiang-Mojiang Nisu. However, the lack of mutual intelligibility between these two varieties suggests instead that they should be split into two distinct languages. During 2006, Ken Chan (also with EAG) and Cathryn Yang carried out a dialect survey of Nisu, in which they tested Northern and Southern Nisu speakers if they could understand a Southwestern Nisu RTT. Only one Northern Nisu data point could adequately comprehend (RTT score avg. 80%); all the other N and S Nisu points failed to adequately comprehend SW Nisu (scores below 80%, often 50 or 60%). Also, they tested SW Nisu speakers on how well\nthey could understand N and S Nisu varieties. The SW Nisu speakers were unable to adequately comprehend any of the other Nisu varieties. SW Nisu is linguistically very closely related to both N and S Nisu, but the speakers moved away from the Northern Nisu area several generations ago to the southwest. Because of the lack of mutual intelligibility with other Nisu languages, Chan and Yang concluded that SW Nisu was a related but divergent Nisu language.Northern Nisu refers to [yiv], currently named Eshan-Xinping Yi (name change requested).'},
    {'iso': 'ztc', 'name': u'Lachirioag Zapotec',
     'cr': u'2006-027', 'effective': '2007-07-18', 'reason': 'merge',
     'remedy': u'Merge into Yatee Zapotec [zty]',
     'comment': u'Zapotec, Lachirioag is now considered a dialect of Zapotec, Yatee.'}
]


UPDATE = [  # 123
    {'id': u'aari1240', 'iso': 'aay', 'name': u'Aariya',
     'cr': u'2008-001', 'effective': '2009-01-16', 'reason': 'non-existent',
     'remedy': None,
     'comment': u"\u201cThe only reference for this language is \n\nHugoniot, Richard.1970. A bibliographical Index of the Lesser Known Languages and Dialects of India and Nepal. Waxhaw: Summer Institute of Linguistics. \n\nHugoniot's source was [Madhya Pradesh Dept. of Tribal Welfare, The Tribes of Madhya Pradesh, Bhopal 1964.] Aariya was listed as a Scheduled Tribe at that time but not listed in the more recent Anthropological Society of India research on peoples of India edited by K.S. Singh. Surveyors in the area in 2004 found nobody who had even heard of this language.\u201d"},
    {'id': u'achi1258', 'iso': 'acc', 'name': u'Cubulco Ach\xed',
     'cr': u'2008-048', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Achi [acr]',
     'comment': u'\u201cThe name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name.\u201d'},
    {'id': u'ayic1234', 'iso': 'ayx', 'name': u'Ayi (China)',
     'cr': u'2010-020', 'effective': '2011-05-18', 'reason': 'duplicate',
     'remedy': u'Merge into Anong [nun] as duplicate',
     'comment': u'Apparently due to an error in reading Chinese linguistic sources (probably the Encyclopedic Dictionary of Chinese Linguistics) years ago, the name of a Nungish language spoken by some members of the Nu nationality group in China was mistakenly\nread as \u963f\u4f9d ("Ayi" in Pinyin Romanization) rather than \u963f\u4fac ("Anong") , and this was\nsubmitted to Ethnologue as "Ayi." Nu nationality intellectuals have confirmed that there are four languages spoken by members of this nationality group: Drung (which will probably need to be split into Drung and Anung/Along), Nusu, Rourou and Anong. There is no record of any language named "Ayi" spoken by members of the Nu nationality in Chinese literature or in the knowledge of local Nu intellectuals and therefore we conclude this is an\nerror due to the similar appearance of the characters \u4fac (nong) and \u4f9d (yi).'},
    {'id': u'tune1241', 'iso': 'baz', 'name': u'Tunen',
     'cr': u'2011-080', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split Tunen [baz]  into Tunen [tvu] and Nyokon [nvo]',
     'comment': u"\u201cEarly linguistic survey of the area highlighted many distinguishing features of the Nyokon language (Richardson 1957:28-31). Lexicostatistical studies have shown that the linguistic similarity between the two speech varieties (Tunen and Nyokon) is so low that there is no possibility of inherent understanding. Mous and Breedveld show that the percentage of similar lexical items between the two languages is as low as 36% (1986:184). A previous study by Schadeberg and Voorhoeve gave a figure of approximately 50% (1977:24). Both studies show that Tunen is more closely related to Nomaande (Mandi) ([lem]) than to Nyokon. Field notes from D. Barreteau reveal that the class system of Nyokon does not align with Tunen, each containing classes and gender pairs that do not occur in the other. This data confirms the early (and still accepted) classification of Nyokon as a separate\nlanguage labeled A.45 in Guthrie's system (1971, Maho 2003:641). Nyokon (niny\u01e4'\u01e4) has also been given the language number code 514 in the Administrative Atlas of the National Languages of Cameroon (Breton and Fohtung 1991: 39). Mous, in his studies of Tunen, specifically presents Nyokon as a related language and not a dialect (2003:283). Guthrie\nand Tucker (1956:29) write, \u201cAlthough Ny\u01e4'\u0303 \u01e4\u0303 is closely related to Bano\u0328n there can be no question of intercomprehension.\u201d\u201d"},
    {'id': u'buga1251', 'iso': 'bgh', 'name': u'Bogan',
     'cr': u'2006-050', 'effective': '2007-07-18', 'reason': 'duplicate',
     'remedy': u'Merge into Bugan [bbh] as duplicate',
     'comment': u'\u201cApparently these two ISO codes were created as information on this language came from two different sources under two slightly different names, and it was not noticed that they\nwere referring to the same variety. (The exact autonym [p\u025955k\u0251\u0324n33] cannot be precisely phoneticized using Chinese characters or English spelling conventions.)\u201d'},
    {'id': u'sout3125', 'iso': 'bjq', 'name': u'Southern Betsimisaraka Malagasy',
     'cr': u'2010-035', 'effective': '2011-05-18', 'reason': 'split',
     'remedy': 'split into Southern Betsimisaraka [bzc] and Tesaka Malagasy [tkg]',
     'comment': u'The Tesaka have never been part of the Antanosy or Betsimisaraka in any way whatsoever- it was a glitsch of our map and of the ISO process that they ended up erroneously as an alternate name for the Betsimisaraka.in the Ethnologue.\nThe Atesaka are a large people group with a very definite separate identity and language. The Atesaka tend to migrate all over the island in search of work, but always keep that group identity. When an Atesaka dies outside the Tesaka area, the body is transported back to the ancestral land. When preparing the ground for the Tesaka translation of Luke, we had to visit with the "kings" of the "telo troky" (=three stomachs) and with the fourth who claims to have a valid claim to royalty. The Tesaka language is roughly between 70% and 80% similar to Official Malagasy, 76% with Tanosy; 78% with Betsimisaraka. The Tesaka distinguish themselves very definitely from the Merina and from those around them.'},
    {'id': u'fina1242', 'iso': 'bkb', 'name': u'Finallig',
     'cr': u'2009-073', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'Split into Eastern Bontok [ebk] and Southern Bontok [obk]',
     'comment': u'\u201cThe present reference name used with [bkb], Finallig, is erroneous; that name should be used to refer only to the dialect spoken in the community of Barlig, Mountain Province, the Philippines, and cannot appropriately be used to refer to the language of other closely related dialects of Eastern Bontok that are spoken in the Barlig municipality, such as Kenachakran (spoken in Kadaklan), or Linias (spoken in Lias), who would never label their language variety as Finallig (see Fukuda 1997:11, 1980), or to the distinctively different Southern Bontok varieties.\nCurrently this code element (as described in the Ethnologue) has three "alternate names": Eastern Bontoc, Kadaklan-Barlig Bontoc, and Southern Bontoc. The term "Kadaklan- Barlig" appears nowhere in the literature, although Kadaklan and Barlig do so separately (see Fukuda 1997:11, 1980, etc.). The term Southern Bontoc was proposed by Busenitz (1973) in an unpublished SIL survey.\nAlthough Eastern Bontok is closely related to Southern Bontok (that is the dialects spoken in the communities of Can-eo, Talubin and Bayyo) , each has a markedly different phonology from the others., e.g., the pre-vocalic variants of /b/ and /d/, which are voiceless (and fricativized) in Central and Eastern languages are voiced in Southwestern Bontok, and the aspirated voiceless variant of /g/ found in Central and Eastern languages is lost, i.e., /g/ has no prevocalic variant at all. Eastern Bontok dialects of both Barlig and Kadaklan have a unique palatalized, voiceless, fricativized variant of /b/ and /d/ before /a/, written _fia_ (hence _Fiallig_, the local pronunciation of Barlig) and _cha_, respectively, which is not found in the Southern dialects. The reflex of *schwa in Southern Bontok is schwa, as in the Central Bontok dialects, whereas in the Eastern dialects it has fallen together with a back vowel /u/ (sometimes also represented as o). Southern dialects also have developed an /o/ vowel, but from a completely different source than the Eastern dialects (see Kikusawa and Reid 2003 for the developments in the Talubin dialect that is known as Tinoveng).\n\nThere are a wide range of both morphological and syntactic features that distinguish Eastern and Southern dialects, discussed in Kikusawa and Reid (2003). The Southern dialects of Talubin and Bayyo are strongly influenced also from their proximity to the neighboring languages to the south, the various dialects of Ifugao. These communities are located on the main road between Bontoc town and the Ifugao municipality of Banaue.\nAlthough Talubin and Bayyo are listed as dialects of Eastern Bontok based on an unpublished SIL survey by Busenitz in 1973 (cited by Fukuda 1997:11, Busenitz called all Eastern dialects Southern), my own research shows that the varieties are distinct enough in phonology, morphology, syntax and lexicon to be considered separate languages.\nApart from the linguistic differences between the two groups of dialects, speakers of the Eastern Bontok varieties have rejected the label Southern Bontok, since historically they have been enemies (especially of the Can-eo people), and even today have vivid memories of headhunting exploits of one group against the other.\nThe reference name "Bontok, Eastern" matches the proposed macrolanguage name "Bontok", and correctly positions them geographically in the Eastern area of Mountain Province. The communalects of Kadaklan and Barlig are referred to as Eastern Bontoc in several publications (Fukuda 1980, 1981, 1992,1997, and Pang 1998.)\u201d'},
    {'id': u'beti1250', 'iso': 'btb', 'name': u'Beti (Cameroon)',
     'cr': u'2009-032', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'Beti is a group name, not an individual language name. Member languages are Bebele [beb], Bebil [bxp], Bulu [bum], Eton [eto], Ewondo [ewo], Fang [fan], and Mengisa [mct], all of which already have their own code elements.',
     'comment': u'\u201cBeti is actually a group name, not a language name. Language group members are Bebele [beb], Bebil [bxp], Bulu [bum], Eton [eto], Ewondo [ewo], Fang [fan], and Mengisa [mct], all of which already have their own code elements.\n\nIn the 15th edition of Ethnologue it states that Beti "[c]onsists of a set of \'languages\' (Bebele, Bebil, Bulu, Eton, Ewondo, Fang, Mengisa) which are partially intelligible but ethnically distinct." In Maho 2003, Beti is not listed as a language in the A.70 group of Bantu languages.\u201d'},
    {'id': u'kaqc1271', 'iso': 'cbm', 'name': u'Yepocapa Southwestern Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'chau1262', 'iso': 'ccq', 'name': u'Chaungtha',
     'cr': u'2011-043', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'merged into Rakhine [rki]',
     'comment': u'Both Chaungtha and Yangbye refer to similar varieties within the Rakhine (rki) language. The speakers of these dialects identify themselves as "Rakhine". Wordlists collected on Yangbye island and in Kyauktaw Township share at least 94% lexical similarity with the prestige variety of Rakhine spoken in Sittwe Town.'},
    {'id': u'chum1264', 'iso': 'chs', 'name': u'Chumash',
     'cr': u'2008-030', 'effective': '2009-01-16', 'reason': 'split',
     'remedy': 'Chumash is actually a family name, not a language name. Language family members already have code elements: Barbare\xc3\xb1o [boi], Cruze\xc3\xb1o [crz], Inese\xc3\xb1o [inz], Obispe\xc3\xb1o [obi], Purisime\xc3\xb1o [puy], and Venture\xc3\xb1o [veo]',
     'comment': u'Chumash is actually a family name, not a language name. Language family members are Barbaren\u0303o [boi], Cruzen\u0303o [crz], Inesen\u0303o [inz], Obispen\u0303o [obi], Purisimen\u0303o [puy], and Venturen\u0303o [veo].\n\nIn the 13th edition of Ethnologue and in older linguistic literature on Native America "Chumash" was listed by itself as a single language. Since the middle of the 20th century, however, it has been recognized that Chumash was a family of six mutually unintelligible languages. In the 14th edition of Ethnologue, the six constituent languages were added, but the entry "Chumash" was not deleted, resulting in the retention of "Chumash" as a constituent of itself. All specialist literature on the languages of California list 6 languages as constituents of the Chumash language family.'},
    {'id': u'chor1275', 'iso': 'cjr', 'name': u'Chorotega',
     'cr': u'2009-035', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'Merge with Mangue [mom]',
     'comment': u'There was no separate Chorotega language. The Chorotega Indians were speakers of Mangue, which is the name proposed in a separate request to be used for the extinct language identified by [mom], currently called Monimbo.\n[RA comment: see change request 2009-034]'},
    {'id': u'khum1250', 'iso': 'cka', 'name': u'Khumi Awa Chin',
     'cr': u'2011-037', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'merged into Mro-Khimi Chin [cmr]',
     'comment': u'The 1931 Census of Burma report contains an appendix about the \u201cAwa Khami\u201d, \u201cAhraing Khami\u201d, and \u201cMro\u201d. Clan lists as well as some vocabulary items are included and make it easier to identify which groups were being referred to.\nThe Awa Khami and Ahraing Khami vocabulary items from the 1931 Census are very similar to each other and match with wordlists collected from the group today known as Mro-Khimi.\nThe Mro-Khimi today recognize two broad sub-groupings, Wakung (\u201cdownstream\u201d) and Areung (\u201cupstream\u201d). The speech variety spoken by the vast majority of people is known as Wakung. \u2018Wa\u2019 is a Rakhine/Burmese word meaning \u201cmouth of a stream\u201d. \u2018Kung\u2019 is a Mro-Khimi word also meaning \u201cmouth of a stream\u2019. This \u201cAwa Khami\u201d clan lists from the 1931 Census match with the current Wakung clans, making identification clear.\nThe Areung sub-group includes multiple speech varieties, including Hrengna and Xata. This sub- group matches with the Ahraing Khami in the 1931 Census.\nThe Wakung and Areung groups consider themselves to belong to one common overall group, Mro- Khimi, and speak similar speech varieties. Thus, they are grouped together here under one ISO entry.\nRegarding the name for the group, there is currently some disagreement. While most of the group uses the name Mro-Khimi, those living in Buthidaung Township use the name Khimi. The majority group has chosen to include Mro in their name to distinguish themselves from the Khumi, who live in Paletwa Township, Chin State. However, the group living in Buthidaung Township does not have contact with the Khumi. Instead, they distinguish themselves from the Mru who live nearby by not including \u201cMro\u201d in their name. Both groups agree, however, that they do not want to be called \u201cChin\u201d.\nFor the ISO entry, we have chosen to use the name chosen by the majority with a note about the situation in Buthidaung Township.\nIn the 1931 Census, the vocabulary lists of "Mro" match with wordlists from the group today known as Mru (mro), not Mro-Khimi. This group lives in Bangladesh and Myanmar and speaks a very divergent speech variety from the Mro-Khimi. They are known by a variety of other names including Mrung, Mrusa, Dak, Launghu, and Taung \u201cmountain\u201d Mru.\nMru (mro) is already represented by a distinct ISO entry, and the current Mro (cmr) entry has up until now been used to refer to the Mro-Khimi. Thus, for clarity, it would be better to merge the Chin, Khumi Awa (cka) and Chin, Mro (cmr) entries and change the name to Mro-Khimi.'},
    {'id': u'kaqc1275', 'iso': 'ckc', 'name': u'Northern Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1272', 'iso': 'ckd', 'name': u'South Central Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1273', 'iso': 'cke', 'name': u'Eastern Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1274', 'iso': 'ckf', 'name': u'Southern Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1276', 'iso': 'cki', 'name': u'Santa Mar\xeda De Jes\xfas Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1278', 'iso': 'ckj', 'name': u'Santo Domingo Xenacoj Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1277', 'iso': 'ckk', 'name': u'Acatenango Southwestern Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'kaqc1279', 'iso': 'ckw', 'name': u'Western Cakchiquel',
     'cr': u'2008-053', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Kaqchikel [cak]',
     'comment': u'The \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019\n'},
    {'id': u'chim1250', 'iso': 'cmk', 'name': u'Chimakum',
     'cr': u'2009-033', 'effective': '2010-01-18', 'reason': 'duplicate',
     'remedy': u'Merge with Chemakum [xch] as duplicate',
     'comment': u'"Chimakum" is just an alternate spelling for Chemakum, which is the more common spelling in the linguistic literature. However, since it has been listed with this spelling in the Ethnologue, it is probably appropriate to include this alternate spelling in the standard.'},
    {'id': u'chuj1251', 'iso': 'cnm', 'name': u'Ixtat\xe1n Chuj',
     'cr': u'2008-050', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Chuj [cac]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.'},
    {'id': u'chol1285', 'iso': 'cti', 'name': u'Tila Chol',
     'cr': u'2008-049', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Chol [ctu]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.'},
    {'id': u'kich1264', 'iso': 'cun', 'name': u'Cun\xe9n Quich\xe9',
     'cr': u'2008-054', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with K'iche' [quc]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.\n[RA comment: the name form Quiche\u0301 in Spanish spelling will also be retained for historical reference with regard to the standard.]'},
    {'id': u'dann1241', 'iso': 'daf', 'name': u'Dan',
     'cr': u'2012-083', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Dan [dnj] and Kla-Dan [lda]',
     'comment': u'Kla-Dan is different enough from the Dan to make mutual intelligibility marginal; the percentage of cognates in Swadesh\'s 100-wordlist between Kla-Dan and different Dan dialects varies between 88 and 90%. Kla-Dan and Dan have no common literature; Kla- Dan speakers have an ethnolinguistic identity of their own, separate from the rest of Dan.\nDan and Kla-Dan can still be regarded as closely related languages, their speakers are aware of their common origin. Kla-Dan speakers do not accept their common identity with "Yakuba", the term commonly used in Co\u0302te d\'Ivoire for the other Dan speakers, but they agree that they belong to the Dan community.\nFurther explanation from email:\nAbout Dan and Kla-Dan: well... I see the point. For me, 90% of Swadesh\'s 100-word list is about the limit of inellegibility. In the Mande families, there are lots of varieties which are considered as separate languages although they have 95 to 98% of cognates in the 100- wordlist with other ones! If we take the 80% range as the limit, I\'m afraid, many European languages will loose their status of languages...\nIt is true that when a 100-wordlis is collected badly, or based on unreliable and incomplete data, or do not take account of established regular correspondences, the rate is normally lower than in the contrary case. For example, in Ronald Long\'s dissertation (1971) "A comparative study of the Northern Mande languages" (which is still regarded by many as the main reference in the field), the rates are systematically lower than in my analysis (2009). Here are some examples:\nLong 1971 Susu-Maninka 27-36%\nMandinka-Maninka 79-83%\nMau-Maninka 74-93%\nVai-Maninka 53-62%\netc. - this tendency is valid for every pair of languages without exception! Therefore, if I want to justify the necessity to split one language into two, I can simply take Long\'s data (instead of mine), and the critics will be convinced. Isn\'t it absurd?'},
    {'id': u'nisi1239', 'iso': 'dap', 'name': u'Nisi (India)',
     'cr': u'2011-132', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Nyishi [njz] and Tagin [tgj]',
     'comment': u'A research work was done in 2001 by Annie Susan Samuel, Marshall Joshua, Mathews John among the people group of Arunachal Pradesh. They mentioned that they speak their own language Tagin along with other neighbouring languages like Hindi, Assamese, ect.\nTagin & Sulung tribes of Arunachal: A sociolinguistic survey, NLCI 2007 says that Tagin and Nisi are two different languages. Nisi language shows 54-60% of lexical similarity with T agin.\nThe LUAV Questionnaire finding is Tagin is used widely in almost all of the important domains, and the mother tongue speakers of Tagin have a very good, positive attitude toward it. Tagins would like to see their language developed.'},
    {'id': u'dhan1267', 'iso': 'dha', 'name': u'Dhanwar (India)',
     'cr': u'2010-010', 'effective': '2011-05-18', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'1. The only language speaker count is the1961 Census . Later, in the 1991 Census has the Dhanwar speaking Marathi in Maharashtra, and Hindi in Madhya Pradesh [Chhattisgarh?]\n2. Lewis\u2019 (2009) estimate is the 1981 Census ethnic population. It is not the L1 speaker population.\n3. The Joshua Project (2002) mentioned the Dhanwar speaker population but the latest version (Joshua Project 2009) reported that they speak Marathi.\n4. Singh (1993:87), Vaisanav (2004:6) reported that the Dhanwar speak Chhattisgarhi and Marathi. But with other groups they speak Chhattisgarhi, Hindi and Marathi. The other source mentioned that the Dhanwar people themselves reported that they speak Chhattisgarhi and Marathi (India in Focus 2004).\n5. From an informal interview with a person who works in Chhattisgarh, the Dhanwar speak Chhattisgarhi and Marathi as their first language.\n6. As early as 1916 when Russell (2006:488) was first published, the Dhanwar did not speak a language of their own, but rather spoke Chhattisgarhi and Hindi.'},
    {'id': u'djiw1239', 'iso': 'djl', 'name': u'Djiwarli',
     'cr': u'2012-074', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Djiwarli [dze] and Thiin [iin]',
     'comment': u'Dr. Bowern (p.c.), Peter Austin (http://coombs.anu.edu.au/WWWVLPages/AborigPages/LANG/WA/4_4_15.htm, Austin, Peter. 1983. Classification of Southern Pilbara Languages.), and Alan Dench (Dench, Alan. 1995. Pacific Linguistics, 71. University of California) all support Thiin\'s existence as separate from Djiwarli.\nTogether Djiwarli and Thiin form a subgroup "Kanyara-Mantharta" languages under Pama- Nyungan, South-West, Coastal Ngayarda.\nWe believe that Dr. Bowern\'s research and expertise on languages of Australia, as well as the support of the sources listed below are sufficient to define this as a distinct language.'},
    {'id': u'kolu1247', 'iso': 'dkl', 'name': u'Kolum So Dogon',
     'cr': u'2010-018', 'effective': '2011-05-18', 'reason': 'split',
     'remedy': 'split into Ampari Dogon [aqd] and Mombo Dogon [dmb]',
     'comment': u'In my 2004 Dogon survey report I wrote: "According to the elders of the Mombo speaking village Bandiougou, Ampari-kora speakers could understand them, but not vice-versa. One explanation might be inherent intelligibility, since Calame-Griaule listed both Mombo and Ampari-kora (she called it A\u0303mba\u014bge) as subvarieties of Edye\u014bge do\u0303. However, since the Ampari-kora speakers that the elders spoke about came yearly to Bandiougou to observe a rite, this might also be learned comprehension."\nIn 2009 I analysed the following Dogon wordlists in Wordsurv 6.0.2: Miambo de Makou, Mombo de Bandiougou, Mombo K\u0254lu S\u0254, Mombo de Kori-Kori, Mombo Pignari, Nyambalee\u014bge de Ficko, Mombo (Blench\'s Ambaleenge) de Kema, and Ampari de Pahandaga, Ampari de Pa, Ampari de Danga, Ampari de Baboye. Raw scores between Mombo varieties range from 71-88%. Raw scores between Ampari varieties range from 70- 88%. Raw scores between Mombo and Ampari varieties range from 40-53%. Total number of items compared range from 64 to 180.\n"...Mombo and Ampari are separate non-intercomprehensible varieties, which, however, are genetically much closer to each other than to any other Dogon language." (correspondence with Prokhorov 12-19-2009)'},
    {'id': u'dark1243', 'iso': 'drh', 'name': u'Darkhat',
     'cr': u'2009-020', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'Merge with Halh Mongolian [khk]',
     'comment': u'Darkhat is in reality a dialect or regional accent variation of Mongolian Halh (Darkhad or Darhad is often used for transcription of its standard form in Halh; Darkhat is the preferred older, traditional orthography.) When Darkhad speakers converse with Halh speakers from other regions they understand each other fully without difficulty. They consider their language to be Halh.'},
    {'id': u'darw1234', 'iso': 'drw', 'name': u'Darwazi',
     'cr': u'2009-028', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'merge with [prs] Dari',
     'comment': u'Lexical similiarity of Dari and Darwazi is between 86% and 90%. Comprehension testing of Eastern Farsi (Dari) showed that Dari is highly intelligible for the Darwazi people. The Darwazi call their area Darwaz but not their speech variety. No one ever mentioned a language called Darwazi as his mother tongue. The Darwazi themselves explain that they speak Dari, acknowledging that their dialect is slightly different.'},
    {'id': u'walo1239', 'iso': 'dwl', 'name': u'Walo Kumbe Dogon',
     'cr': u'2011-070', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Dogon, Bankan Tey (Walo) [dbw]  and Dogon, Ben Tey (Beni) [dbt]',
     'comment': u'marginal intelligibility without common literature'},
    {'id': u'elpa1240', 'iso': 'elp', 'name': u'Elpaputih',
     'cr': u'2011-181', 'effective': '2012-02-03', 'reason': 'non-existent',
     'remedy': u'Lack of information may have cause Elpaputih to be considered different from [amq] (Amahai) and [plh] (Paulohi)',
     'comment': u"Since Voeglin & Voeglin 1977 was written, there have been two major surveys done of the area of Seram where the Elpaputih language supposedly exists. Collins conducted his survey from 1977 to 1979 and published his results 1982 in Oceanic Linguistics. Taguchi and other SIL linguists conducted survey in the same general area from 1985-1988 and published their results in Workpapers in Indonesian Languages and Cultures in 1989. Neither of the surveys report any language by the name of Elpaputih. There are two languages on the Elpaputih Bay which may have been included in the Elpaputih language amq (Amahai), plh (Paulohi). These two languages are now nearly extinct. It seems probable that the lack of information caused Voeglin & Voeglin to erroneously suggest that Elpaputih was it's own language. I would suggest that with the new information from Collins and Taguchi, the Elpaputih language be removed from the Ethnologue."},
    {'id': u'emil1242', 'iso': 'eml', 'name': u'Emiliano-Romagnolo',
     'cr': u'2008-040', 'effective': '2009-01-16', 'reason': 'split',
     'remedy': 'Split into Emilian [egl] and Romagnol [rgn]',
     'comment': u'The name Emilia-Romagna can be very confusing. I would like to explain why I think the term Emilia-Romagna is misleading when referring to regional culture which includes aspects such as language, customs, and cuisine, and should only be referred to for geopolitical reasons.\nTwo ISO 639 codes, one for Emilia and one for Romagna would be much clearer when referring to the cultural aspects of both regions.\nThe sole reason why this code exists is because in 1948 with the inception of the Italian Constitution, the Region of Emilia-Romagna was created. This name never previously existed in Italian history. Emilia and Romagna had been two different regions of Italy in the past.\nFrom 1815 to 1866 two historical regions of Italy, Lombardia and Veneto, were merged to create the Lombardian-Venetian Kingdom. Nevertheless, nobody referred to Milan nor Venice as Lombardian-Venetian cities, Milan still remained a Lombardian city , and Venice remained a Venetian city. The same holds true for Emilia-Romagna. Bologna is an Emilian city while Ravenna is a Romagnol city. The term \u201cEmiliano-Romagnolo\u201d makes sense only if looking at the political region of Italy called \u201cEmilia-Romagna\u201d.\nMoreover, there is Emilian cuisine and Romagnol cuisine. There isn\u2019t an Emilia-Romagnian cuisine in Italy. The \u201cRomagnol Riviera\u201d, and not the \u201cEmilia-Romagna Riviera\u201d, is the famous tourist area along the Northern Adriatic Sea.\nThere is an Emilian dialect and a Romagnol dialect. There isn\u2019t such a thing as an Emilian- Romagnolo dialect. A counter-factual example: if in 1948 two regions had been created, Emilia and Romagna, no one could have ever imagined the existence of an Emilia- Romagnol language!\nNowadays, Italy is seeing a revival of dialects, after a period over the last 40 years when regional dialects couldn\'t be spoken on national TV or radio. Many cultural institutes were established to keep dialects alive in both Emilia and Romagna. For example, in Romagna the Istituto F. Schurr was founded in 1996 and it\'s still involved with the conservation of Romagna\'s dialect as an important part of the region\u2019s heritage.\nHere is a brief history of the \u201cEmilia\u201d and \u201cRomagna\u201d names. Before 1948 there weren\'t geopolitical regions in Italy. There were about 90 provinces, and Emilia and Romagna were two clearly distinctive regions. Before the unification of Italy in 1861, one could find on a map only the name Romagna, or \u201cRomagne\u201d, the Italian plural of Romagna. The name Emilia, instead, did not appear. Instead of Emilia one could find the \u201cdukedom of Ferrara\u201d, the \u201cdukedom of Modena and Reggio\u201d, and other dukedoms. Historically and culturally, Emilia and Romagna were formed many centuries before the creation of this geopolitical region. People from these regions have the feeling of being "Romagnol" or "Emilian". It is very evident to anyone who is from either of these two regions. I know, for example, that I\'m Romagnol, an inhabitant of Romagna, as well as any Bolognese citizen knows she/he\'s Emilian.\nAllow me to present some points of consideration:\n1) Let\'s pretend that Emilians are 90% of population of Emilia-Romagna and Romagnols are only the 10%. So one could think that Romagnols could be considered just an appendix of the Region.\nReply: There are 1 million Romagnols in a region of 4 million people.\nPrinciple Romagnol towns include Ravenna, with a population of 150,000 people, Rimini, with 135,000, Forli\u0300, with 115,000, and Cesena with 95,000.\n2) Some may consider definitive evidence of the existence of Emilian-Romagnol language as having an Italo-Emilian-Romagnol dictionary.\nReply: There has never been such a dictionary. We have dictionaries of Romagnolo- Italiano and Bolognese-Italiano, or Modenese-Italiano (Modenese is the dialect of Modena, the second biggest town of Emilia).\n3) Could the definitive evidence of the existence of Emilian-Romagnol language be the mutual intelligibility?\nNo, because there is not mutual intelligibility. There are certain features in the Romagnol dialect which differ greatly from the Emilian dialect; for they can be classified as two distinct dialects. These dialectical differences are very evident to a linguist.\nAn example: atonic vocalism.\nSome words that in Latin were trisyllabic or quadrisyllabic (where the \'u\' final is atonic) are reduced in Romagnol to monosyllable. The atonic syllable is cut off.\nLatin GENUCULU becomes in Romagnol ZNO\u0300C Latin TEPIDU becomes in Romagnol TEVVD Latin OCULU becomes in Romagnol O\u0300C\nLatin FRIGIDU becomes in Romagnol FRE\u0301DD\n(Italian: ginocchio (Italian: tiepido) (Italian: occhio) (Italian: freddo)\nThis didn\'t happen in Emilia: that\'s why an Emilian speaker is not used to hearing words with atonic vowels removed. Emilians don\'t understand Romagnol. On the contrary, every Romagnol \u201cfeels\u201d Emilian dialects as very similar to Italian (because Italian is full of vowels).\n4) Emilian and Romagnol do not share a common literature. Romagnol literature begins in the late XVI century with Pvlon matt. There is critical edition of the poem in English, translated by British linguist Douglas Bartlett Gregor. This is the card of the book:\nMad Nap ("Pvlon Matt"): An anonymous Romagnol poem of the sixteenth century translated into English verse and Italian prose, and annotated / D. B. Gregor. - Cambridge : The Oleander Press, c1976. - 237 p.\nPvlon Matt was reviewed also by Friedrich Schu\u0308rr (1888-1980), an eminent linguist who first acknowledged Romagnol as a romance language.'},
    {'id': u'emok1238', 'iso': 'emo', 'name': u'Emok',
     'cr': u'2013-012', 'effective': '2014-02-03', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'Susnik\'s widespread hypothesis has been disproved: she proposed that the Toba of Puerto Casado constitute a mixed ethnic group, of "Toba [Qom] groups who blended with the Maskoy, forming the new Emok-Toba ethnic identity. The first generation was bilingual, but the Toba language later became established as the \'language of men\'" (Susnik 1989: 144), and supposedly went on to form "a \'Maskoyized\' proletariat in the tannin factories" of Puerto Casado (ibid.). Our research leaves no doubt that the indigenous population of the tannin ports on the River Paraguay is of purely Enlhet-Enenlhet descendency. In spite of the existence of communities such as Cerrito and El Padernal where people of Enlhet- Enenlhet and Qom descendency live together, bilingualism across the two language groups has not developed, and Guarani is the main language of intercommunication. That is, an Emok language (classified as extinct) in fact never existed. Emmo\'ok is not the name of a language; it means simply \'our neighbour\' in the languages of the Enlhet-Enenlhet family. This explains why we have found no instances of a supposed Emok language; nor of any evidence shown by Susnik, who made her hypothesis for its existence so widely known.'},
    {'id': u'gabu1248', 'iso': 'gav', 'name': u'Gabutamon',
     'cr': u'2009-044', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'Merge into Domung[dev]',
     'comment': u'People in Gabutamon village consider themselves Domung speakers, and people in all other Domung villages consider Gabutamon to be a Domung village. Gabutamon people reported understanding speakers from all Domung villages well, and speakers from all but two Domung villages reported understanding people from Gabutamon well. The two Domung villages that reported to not understand Gabutamon speakers well are from the opposite end of the Domung dialect chain. People from Gabutamon and other Domung villages are working together successfully on a Scripture translation project.\nReported data suggests that there is a dialect chain in the Domung area with Gabutamon at one end and Sibgou, Kian, Dirit and Maramung at the other. Each village had a different way of breaking the chain into dialects. Putting the different reported dialects together suggests the chain is as follows, starting from the Gabutamon end: Gabutamon; Maum and Kosit; Wakopop and Bobongat; Aunon; Ayengket; Sibgou, Kian, Dirit, Swantan and Maramung. This is shown in the attached map.\nLexical similarity percentages support the fact that Gabutamon village is part of the Domung dialect chain. The map shows that Gabutamon is as closely related to Domung villages as the other Domung villages are to each other. For example, Gabutamon and Kian, villages on the opposite ends of the Domung dialect chain, both share 70% or more lexical similarity with two central Domung villages (Bobongat and Ayengket).\nThe criteria used by the survey team (based on 1991 ILAC recommendations) to determine language boundaries is listed below.\n-At least 70% lexical similarity with a linguistically determined central dialect;\n-Either high reported comprehension of a central dialect or intelligibility of at least 75% of a central dialect\n-Shared ethnolinguistic identity with the central dialect\nVillages at both ends of the Domung dialect chain (Gabutamon and Kian) meet these criteria and should be included as part of the Domung language.\nSee map sketch on final page (http://www-01.sil.org/iso639-3/cr_files/2009-044.pdf).'},
    {'id': u'gara1261', 'iso': 'gbc', 'name': u'Garawa',
     'cr': u'2011-121', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Garrwa [wrk] and Wanyi [wny]',
     'comment': u'The languages were probably misanalyzed as dialects of a single language because, as Breen admits "Garrwa and Wanyi are superficially very similar" (2003: 426). He concludes an extensive comparison of the two languages by saying "The many correspondences in grammar, especially the pronoun inventories, confirm the conclusion that these languages are closely related, but at the same time the substantial differences in grammar suggest that they must be mutually unintelligible -- closely related languages rather than dialects of a language" (2003: 454).\nGarrwa and Wanyi have about 50% shared lexicon, either identical words or confirmed cognates. Nominal morphology is more or less similar but by far the most significant difference is the verbal system. Wanyi has no evidence of the clitic system that Garrwa uses to express TAM, and prefers a richer verb conjugation to express these instead. Belfrage (2003) corroborates these conclusions of Breen, and while he revises the verb analysis so that the two languages resemble each other even further, he maintains the assertion that the languages are distinct.\nPerhaps contributing to the confusion is the asymmetrical distribution of the two: they both occupy areas about the same size, but per Walsh (1981) Garrwa had "300+" speakers while Wanyi had a questionable "10?". Moreover, Walsh recognizes the dichotomy and goes so far as to list Garrwa and Wanyi as distinct subgroups within a larger family. As Breen (2003) explains, the situation is more complex than it seems on the surface. Garrwa in fact has two or three true dialects--Western Garrwa and Eastern Garrwa, the latter of which may or may not be distinguishable from another variety called Kunindirri (2003: 426).\nIn terms of higher-level organization, Austin mentions that "The two closely-related languages Garawa and Wanyi are spoken in an area immediately north of Wagay. In vocabulary and morphology they are very different from all the languages discussed above, and are classified as members of a distinct language family by O\'Grady et al" (1981: 327). Breen calls this family "Yanyi," explaining "I have used the name Yanyi (the word for \'language\' in these languages) for the group for a number of years... and propose this as a name for the group that makes no implications regarding its status and does not imply primacy for either language" (2003: 426).'},
    {'id': u'gugu1257', 'iso': 'ggm', 'name': u'Gugu Mini',
     'cr': u'2013-030', 'effective': '2014-02-03', 'reason': 'non-existent',
     'remedy': u'This name is a cover term for several related languages and is not an individual language.',
     'comment': u'\u201cGugu Mini\u201d is apparently a generic term meaning \u201cgood speech\u201d that is used for several languages in the Thaypan area. The original ISO-addition request noted this when they cited the AIATSIS entry, which is no. Y94 in their data base. There are word lists under the name \u201cGugu Mini\u201d that AIATSIS labels as \u201cpotential data\u201d, but no confirmed new language. (See \u201cstatus\u201d below.) The AIATSIS entry for Y94 "Gugu Mini" is as follows:\nAIATSIS Code: Y94\nAIATSIS reference name: Gugu Mini\nComment: According to Rigsby (2005:138), Gugu Mini is a language name whose reference is shifting, variable and wide-ranging and that it variably signifies languages situated on the mainland south of Flinders Island all the way south to Normanton. Sommer (2008 p.c.) says that Kuku Mini (Y94) literally means \u2018speech good\u2019 and in general it applies to languages/dialects of the Central Paman type.\nIt is not clear whether Gugu Mini refers to a group of related languages/dialects, or simply a group of both related and unrelated languages/dialects. If the former is the case, Gugu Mini can be treated as a cover term or a language name.\nIn this database, Gugu Mini is tentatively listed as a language name, and the location of this language on the map is based on Tindale (1974), who uses Kokomini (Y94) to refer to one specific tribe.'},
    {'id': u'aghu1254', 'iso': 'ggr', 'name': u'Aghu Tharnggalu',
     'cr': u'2012-138', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Aghu-Tharnggala [gtu], Gugu-Mini [ggm], and Ikarranggal [ikr]',
     'comment': u'Ethnologue currently lists "Ikarranggali" and "Kuku-Mini" as alternate names of Aghu Tharnggalu [ISO 639-3: ggr]. Australian language scholarship, however, points to the need to identify these as distinct languages.\nAUSTLANG classifies Aghu-Tharnggala and Ikarranggal as distinct languages in the Rarmul Pama subgroup. Oates also recognizes these as two separate languages (1975: 287, 292).\nAUSTLANG tentatively lists Gugu Mini, noting it is unclear if Gugu Mini refers to a specific language or is used as a broader cover term. Sommer says that Kuku Mini [AIATSIS Code Y94] literally means \u2018speech good\u2019 and is generally applied to languages and dialects of the Central Paman type (2008 p.c.). Gugu Mini and Aghu-Tharnggala are considered separate entities in Wurm (1972, 1994), Oates (1975), and Walsh (1981).\nDr. Claire Bowern identifies distinct locations for Aghu-Tharnggala and Gugu Mini in her map "Centroid Coordinates for Australian languages" (2011).'},
    {'id': u'gela1261', 'iso': 'gio', 'name': u'Gelao',
     'cr': u'2011-054', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': "split into Qau [gqu] and A'ou [aou] with some going to Green Gelao [gig], some to Red Gelao [gir], and some to White Gelao [giw]",
     'comment': u'Gelao languages, although grouped together into one ethnic group, are not mutually intelligible.'},
    {'id': u'gamo1244', 'iso': 'gmo', 'name': u'Gamo-Gofa-Dawro',
     'cr': u'2008-080', 'effective': '2009-01-16', 'reason': 'split',
     'remedy': 'Split into three languages: Gamo [gmv], Gofa [gof], and Dawro [dwr]',
     'comment': u'Seven years ago, Dawro was already considered to be separate from Gamo and Gofa. At that time, plans were made to begin a language development project in the Dawro language. In 2001, according to the Education Bureau of the Southern Nations, Nationalities and Peoples Regional State (SNNPR), both the Gamo-Gofa Zone and the Dawro Zone were developing their own education materials. Currently, Gamo and Gofa are also considered to be linguistically separate, each having their own language development project as of 2004.\nAll of the Central Ometo speech varieties are quite similar, but there are some definite divisions along ethnic lines. For example, Wolaytta is a Central Ometo speech variety closely related to Gamo, Gofa and Dawro. However, these three have such a strong separate identity that they are not able to have a common body of literature with Wolaytta (this was established even before Dawro was split from the other two). The grouping of Gamo, Gofa and Dawro is now no longer possible due to political and identity reasons, and at least according to lexicostatistics there is no more cause for them to be grouped with each other than there is for them to be grouped with Wolaytta. In one study, the lexical similarity between these three was less than or equal to their similarity with Wolaytta (Girard 2002). See also the lexicostatistical data quoted in the Ethnologue (Gordon 2005).'},
    {'id': u'horu1241', 'iso': 'hrr', 'name': u'Horuru',
     'cr': u'2011-086', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'Merged into the code for Yalahatan [jal]',
     'comment': u"The original criteria for including Horuru in the ethnologue as a separate language seem to be outweighed by the data that suggests that the name is Haruru and is simply a dialect of Yalahatan. Since the only reference for Horuru is Voegelin 1965 which is somewhat of a survey of several languages and the only note about Horuru is that it may be an alternate for another languoage or extinct, the original inclusion of Horuru seems to be a little weak. Yalahatan, which is spoken in only two villages (Yalahatan and Haruru), matches well with the classification of Horuru, both being in the Three Rivers linguistic grouping. The geographic location of Horuru is simply Central Maluku, Seram which is home to several languages, one of which isYalahatan. Since there's no language polygon, the location could be anywhere on the island of Seram, but nowhere else in Seram is there a village by the name Horuru or a tribe that goes by that name (based on the government statistic data from 2000). The closest to the name Horuru is the village Haruru which speaks a dialect of the Yalahatan language (Sakiyama 1999 and Beckley personal communication)."},
    {'id': u'huas1256', 'iso': 'hsf', 'name': u'Southeastern Huastec',
     'cr': u'2008-051', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Huastec [hus]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'huas1255', 'iso': 'hva', 'name': u'San Lu\xeds Potos\xed Huastec',
     'cr': u'2008-051', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Huastec [hus]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'ibil1238', 'iso': 'ibi', 'name': u'Ibilo',
     'cr': u'2011-153', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'Merged into language element [opa] Okpamheri',
     'comment': u'The change I am proposing is that Ibilo [ibi] be changed from being a language within [Edo- Esan-Ora, North Central, Edoid, Benue-Congo, Volta-Congo, Atlantic-Congo, Niger-Congo], and be moved to being a dialect of Okpamheri [opa], located within the Northwestern Edoid branch.\nI have found no publication which places Ibilo within this subclassification. Nor have I found any dialect called "Ibilo" in these languages. In talking to Prof. Ron Schaefer (Southern Illinois University Edwardsville), who has extensive first hand experience with Emai and other Edoid languages, he knows of no languages or dialects called Ibilo in North Central. He also says that Ibillo is the principal village in the Okpamheri cluster, which include about 20 or so villages.\nFurther, Ben Elugbe (University of Ibadan) has written extensively on comparitive Edoid.\nElugbe (1989a: 24) cites that he used the Ibilo dialect of Okpamheri in his comparative work, and Elugbe (1989b: 296) notes that the Ibilo dialect is spoken in Ibilo town, and is a dialect of Okpamheri. He further provides in (1989b: 296) the consonant inventory of Ibilo, showing it has breathy voiced consonants, and a lenis/nonlenis distinction. These are features of the Northwest branch. The Edo-Esan-Ora language group of North Central, within which Ibilo is classified by Ethnologue, do not contain these phonological features.\nAlso, your map 6 of Nigeria (found at http://www.ethnologue.com/show_map.asp?name=NG&seq=80) shows that the code for Ibilo on the map is 305. This places it in the Northwest area of Edoid languages, not the North Central.\nFinally, in a non-linguistics article, Oseni (1991: 224) notes Okpamheri people from a town "Ibillo".\nThese facts, I feel, warrant that its status as an independent language, with its own language code, be removed, unless there is some distinct evidence to classify it as a separate language from Okpamheri [opa].\nThere is the possiblity that evidence and documentation exists that Ibilo is its own language within the North Central branch, or that perhaps it is some dialect of a North Central branch language, which happens to be homophonous with a dialect of Okpamheri in the Northwest branch. If this is the case, I would be very interested to see which sources this information comes from.'},
    {'id': u'talu1239', 'iso': 'ilw', 'name': u'Talur',
     'cr': u'2012-151', 'effective': '2013-01-23', 'reason': 'merge',
     'remedy': u'Merged into Galolen [gal]',
     'comment': u'For East Timor, we noted previously that the Galolen Language Council told me they have a dialect spoken on the island of Wetar in SW Maluku in then village of Iliwaki. I have now compared my Galolen [gal] data with the Talur wordlist in Hinton (2000: Pacific Linguistics 503:105-129), which was taken in the village of Iliwaki, and his data are 95% lexically similar with my Galolen data. The forms that are the same are actually identical. The forms that are different (e.g. names for bamboo) could easily refer to different species. THEY ARE THE SAME LANGUAGE. Note that SIL member Bryan Hinton shows the Talur data quite divergent from the other Wetar lgs (he excludes it from the "Wetar cluster" (p.110-111). He lists "Galoleng" as an alternate name for Talur (p.113). He continues (p.113), "While in the Talur language area, I was told that the language was the same as the language spoken in East Timor in the region around Manututo. This roughly corresponds to the Galoli language area shown in the Wurm and Hattori (1981) map of Timor. Salzner (1960) even includes Galoli as a dialect of Wetar located in East Timor. Capell (1944) notes, \'.the language of Wetar is almost identical with that of the Galoli country in Timor.\' .. This Timor connection for the Talur language could explain why it is divergent from the language groups of the Wetar cluster. So basically, all sources are in convergence. Talur should be listed as a dialect of Galolen [gal], with the hub in East Timor.'},
    {'id': u'ixil1253', 'iso': 'ixi', 'name': u'Nebaj Ixil',
     'cr': u'2008-052', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Ixil [ixl]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'ixil1252', 'iso': 'ixj', 'name': u'Chajul Ixil',
     'cr': u'2008-052', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Ixil [ixl]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'izie1238', 'iso': 'izi', 'name': u'Izi-Ezaa-Ikwo-Mgbo',
     'cr': u'2012-078', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Izii [izz], Ezaa [eza], Ikwo [iqw], Mgbolizhia [gmz]',
     'comment': u'Although oral history says that these four groups have a common ancestor, over the course of time, they have drifted apart and become separate socially, culturally, politically, and linguistically.\nThese languages are not mutually intelligible. When speakers of one of these languages meet with speakers of another, they speak English or Igbo together rather than their own languages. The government, for the above reason, allowed each of these languages to be taught in the primary schools in their respective areas, each with its own distinct curriculum.\nEach of the four has a distinct social and cultural identity. The Ikwo have 8 days in their weekly calendar. The Ezaa have 4 days in their week. The Izii and the Mgbolizhia have 5 days in their week. Recognizing their distinct cultural identities, the government built separate cultural centers for each of the four groups. Each of the four groups has its own paramount traditional ruler. Each celebrates its own traditional festival separately at its respective ancestral home. The New Year Festival for each group is at a separate time between July and September. Each group celebrates the New Yam Festival separately, at different times.'},
    {'id': u'jaka1246', 'iso': 'jai', 'name': u'Western Jacalteco',
     'cr': u'2008-056', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with Popti' [jac]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names.\n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'jara1263', 'iso': 'jar', 'name': u'Jarawa (Nigeria)',
     'cr': u'2011-172', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'split into Gwak [jgk] and Bankal [jjr]',
     'comment': u'Intelligibility and lexical similarity between Bankal and Gwak are marginal.\nSpeakers of Gwak, Bankal, Duguri, Mbat, and Kantana all consider themselves to be one Jarawa people, descended from the same ancestors and speaking a common Jar language. There is no significant body of existing Jar literature.'},
    {'id': u'kado1242', 'iso': 'kdv', 'name': u'Kado',
     'cr': u'2011-002', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'split into Kadu [zkd] and Kanan [zkn]',
     'comment': u"Research conducted in 2008 showed that Kadu and Kanan speakers do not adequately understand each other's languages, and have to switch to Burmese in order to communicate with speakers from the other community. Kadu and Kanan people also have strong separate identities and have a desire to have separate literature. In addition, Myanmar's official list of ethnic groups lists Kadu and Kanan as separate language groups."},
    {'id': u'paku1238', 'iso': 'kpp', 'name': u'Paku Karen',
     'cr': u'2011-059', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Paku Karen [jkp] and Mobwa Karen [jkm]',
     'comment': u'The entry for Karen, Paku contained Mobwa as a dialect in the past. However, speakers of Mobwa report low inherent intelligibility with Paku. Based on low reported comprehension and separate identities, it seems that Mobwa should be considered a separate language from Paku. In addition, Mobwa is treated as a distinct variety from Paku in the linguistic literature.\nRegarding Mobwa being different from Paku and from Sgaw, there is an article by Shintani (2001) in which he did lexicostatistical analysis of various Karen varieties, including Sgaw, Paku, and Mobwa. He found 79% similarity between Mobwa and Paku and put them in separate groupings. He found 74% similarity between Mobwa and Sgaw and put them in separate groupings.\nThe Mobwa live among the Bwe, but have to switch to Sgaw or Burmese to communicate with them. They do not have much contact with Paku people, have low understanding of Paku, and have a distinct identity from the Paku.'},
    {'id': u'kenu1236', 'iso': 'kzh', 'name': u'Kenuzi-Dongola',
     'cr': u'2011-143', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Andaandi (Dongolawi) [dgl] and Kenzi (Mattoki) [xnz]',
     'comment': u"1- Both language communities claim different idntities, however all Nile Nubians, i.e Nobiin speakers, Dongolawi speakers and Kenzi speakers, claim inheriting the former Nubian identity, heritage and civilization.\n2- The two languages are claimed, beside other dialects, as dialects of the Old Nubian language, but the difference between the two is to the level that, they can't be claimed or considered as one\n3- There is medium intelligibility between the speakers of the two languages,\n4- No common literature neither written nor traditional. Written texts in each language are availble separately.\n5-No any written text claimed or known as Kenuzi-Dongola,\n6-Native scholars from each group did and continue doing researches every in their own language, without any claims in the other language , i.e Kenzi scholars do researches in Kenzi/Kenuzi -Self name Mattokki, without mentioning Dongolawi. The Dongolawi scholars do researches in Dongolawi - Self name Andaandi, without mentioning Kenzi. This fact, also implies that the two are divergent to the level that, no native scholar claims them as one. Ultimately there is no language known by the name Kenuzi-Dongola among Kenzi natives as well as among Dongolawi natives.\n7- Developing writing system for each language is progressing on its own, by native scholars of each"},
    {'id': u'leng1262', 'iso': 'leg', 'name': u'Lengua',
     'cr': u'2013-014', 'effective': '2014-02-03', 'reason': 'split',
     'remedy': 'Split into Enlhet [enl] and Enxet [enx]',
     'comment': u"The Enxet were first contacted in 1989 by Anglican missionaries from Concepcio\u0301n; the Enlhet in 1927 by Mennonite immigrants from Puerto Casado (today Puerto La Victoria). Both of these groups, of European origin, referred to the indigenous of the interior of the Chaco as 'Lengua', even before having met them. This coincidence of names has led to the two ethnic groups being considered as a single one. In view of the linguistic differences between them, it has been proposed that two dialects, Lengua Sur [Southern Lengua] and Lengua Norte [Northern Lengua] should be distinguished. This proposal, which is not based on linguistic criteria, has been put forward even in the most recent attempts at classification (Campbell & Grondona), without comparative research being carried out in the field (see the extensive bibliography in Fabre (2005/2012)). However, on the basis of their linguistic research into the six languages of the Enlhet-Enenlhet family, Unruh & Kalisch (2003) have proposed that they should be seen as two different languages, since the Enlhet and Enxet languages are not mutually intelligible, and clearly distinct ethnolinguistic identities exist. An indicator of this is the fact that there is a considerable number of people who are bilingual Enlhet-Enxet.\nAt the same time, it is not possible to understand one of the languages as a dialect of the other; that is, the existing code does not represent a 'major language'. From the perspective of the whole family, the Enlhet and Enxet languages are of equal standing in relation to each other and to the other languages of the family."},
    {'id': u'lama1290', 'iso': 'lmm', 'name': u'Lamam',
     'cr': u'2013-028', 'effective': '2014-02-03', 'reason': 'duplicate',
     'remedy': u'Lamam [lmm] is a duplicate of Romam [rmx]',
     'comment': u'There is no Lamam language in Cambodia. The Ethnologue improperly moved it to Vietnam, but there is already a Romam language in Vietnam. The Romam in Vietnam is confined to one village, numbering between 200-400 people in Le village, Mo Rai commune. Sa Thay district of Kon Tum province.'},
    {'id': u'meaa1237', 'iso': 'meg', 'name': u'Mea',
     'cr': u'2012-131', 'effective': '2013-01-23', 'reason': 'merge',
     'remedy': u'Merged into [cir] Tiri and named T\xeer\xee or M\xe9a',
     'comment': u"The proposed correction to the spelling of the Ti\u0302ri\u0302 name is based on better linguistic analysis and is now part of standard linguistic practice in New Caledonia, as exemplified in the sites Corpus de la Parole (a summary of languages spoken in countries associated with France, written by established linguists who have undertaken extensive work in the area) and the official Acade\u0301mie des langues Kanak site. They also contain further reference to more full linguistic works. The specific Corpus de la Parole site page relevant to this language is: http://corpusdelaparole.in2p3.fr/spip.php?article105\nSee below for amalgamation of Mea (correctly Me\u0301a) [meg] with [cir] as dialects of the same language..\nThe settled consensus of NC linguistic opinon, as reflected in the Corpus de la Parole site (cited above), Wurm & Hattori (1981) and Grace (1976) (bibliographic details below) is that Ti\u0302ri\u0302 and Me\u0301a are dialects of the one language. New Caledonian official statistics also gives a single number of speakers for both dialects as one.\nWhile the cover page of the Acade\u0301mie des langues Kanak site http://www.alk.gouv.nc/portal/page/portal/alk/langues lists Ti\u0302ri\u0302 and Me\u0301a separately when listing the various languages and main dialects spoken in different custom areas, this because its aim is to celebrate local linguistic diversity. It has only a single sub-page on the language (listed under 'Hamea'-re the name, see comments under form submitted for Me\u0301a).\nThe composite name Ti\u0302ri\u0302-Me\u0301a as used in the Corpus de la Parole site reflects New Caledonian lingistic practice for names of languages composed of two significant dialects (eg. Ne\u0302le\u0302mwa- Nixumwak [nee], Nume\u0300e\u0300-Kwe\u0301nyi\nI have no particular view as to which of the two ISO codes, or a new one, should be used."},
    {'id': u'omat1240', 'iso': 'mgx', 'name': u'Omati',
     'cr': u'2011-081', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Barikewa [jbk] and Mouwase [jmw]',
     'comment': u'Omati is the name of a village, and not the name of a language, so the name Omati should be replaced by the two new names: Mouwase and Barikewa. Although reports indicate that there is some mutual intelligibility between speakers of the Mouwase and Barikewa languages, speakers of these languages see themselves as having distinct linguistic identities. They recognize that both languages are part of the "Kaser" subgroup, but still identify Mouwase and Barikewa as separate varieties. Lexicostatistics confirms their status as separate languages, as there is only 38% lexical similarity between them.'},
    {'id': u'mask1241', 'iso': 'mhh', 'name': u'Maskoy Pidgin',
     'cr': u'2013-011', 'effective': '2014-02-03', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'There is no evidence to show that this language has ever existed. Different ethnic groups of the Enlhet-Enenlhet (or Maskoy) family certainly have lived together in the Puerto La Victoria area (just as in several other regions of the Chaco), but, as we observe in these contexts today (and as witnesses indicate regarding the Puerto La Victoria region in the past), no type of pidgin has developed. Either a dominant language has been used by all, or members of each group have used their own language and the others have developed the ability to understand it (a passive bi- or multilingualism). In addition, in areas of contact between Enlhet-Enenlhet languages, the ethnic groups of this family have quickly begun to speak Guarani with each other. In any case, today no Enlhet-Enenlhet language is spoken in the Puerto La Victoria region; ethnic groups belonging to the Enlhet-Enenlhet speak an adapted version of Paraguayan Guarani.'},
    {'id': u'mahe1238', 'iso': 'mja', 'name': u'Mahei',
     'cr': u'2010-030', 'effective': '2011-05-18', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'We can find no evidence of the existence of this language in Yunnan Province, China, from Chinese and foreign linguistic sources. The Ethnologue editor has tracked the origins of this Ethnologue entry back to a 1953 thesis by linguist Dave Thomas. This work is apparently merely repeating a ethnonym cited by a non-linguist foreigner in 1949. The original work does not claim this to be a unique language. Therefore in the absence of any additional data, it appears best to remove this ISO code and consider this name to not refer to any unique language.'},
    {'id': u'mala1431', 'iso': 'mld', 'name': u'Malakhel',
     'cr': u'2012-069', 'effective': '2013-01-23', 'reason': 'non-existent',
     'remedy': u'No evidence this exists.',
     'comment': u'We have not been able to find evidence that this language exists. As far as we can see, it is not mentioned in the professional linguistic literature. The website of Global Recordings Network contains an audio-recorded story said to be in the Malakhel language; however, I listened to it and identified the language in the audio recording to be Ormuri [oru].'},
    {'id': u'mams1234', 'iso': 'mms', 'name': u'Southern Mam',
     'cr': u'2008-055', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Mam [mam]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam\nEastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'mayk1239', 'iso': 'mnt', 'name': u'Maykulan',
     'cr': u'2012-007', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Mayi-Kulan [xyk], Mayi-Thakurti [xyt], Mayi-Yapi [xyj], and Wunumara [wnn]',
     'comment': u'It is our proposal that the entry currently listed as "Maykulan" (mnt) in Ethnologue 16 has a series of "alternate names" which actually represent a collection of languages under a Mayi group (currently Mayabic). These languages--Mayi-Kulan, Mayi-Thakurti, Mayi-Yapi, and Wunumara--will join the level of the existing Mayaguduna (xmy) and Ngawun (nxn).\nThere are multiple publications discussing the above-mentioned varieties as languages.\nPollock (2011) and Hinton & Hale (2004) clearly denote the Mayi-Yapi people as a separate people from their neighbors. Hinton & Hale illustrate this with a map of the region, a dotted line labeled "ethnographic boundary" dividing the Mayi-Yapi from the Mayi-Kutuna (2004: 21). Pollock lists various river catchments and local peoples, for example the Flinders River Catchment has listed under Indigenous peoples groups: Mayi-Yapi, Mayi- Kulan, Mayi-Thakurti, while other catchments have not all of these listed.\nBlair (2001) cites several examples from the languages, for example "jerry-jerry, the annual herb Ammannia multiflora of Queensland, is from Mayi-Yapi and Mayi-Kulan, spoken around the Cloncurry Riverand the Norman River, north Queensland" (141-2).\nAlpher (1991) in section 8.2 "Languages cited for etymological information" uses Mayi- Kulan and Mayi-Yapi languages as references.\nATSIDA has a database of language groups and peoples, listing the Mayi-Kulan, Mayi- Thakurti, Mayi-Yapi, and Wunumara peoples as separate entries. AusAnthrop also has separate entires for the peoples, under the names Maijabi, Mayi-Kulan, Mayi-Thakurti Wanamara.\nI cannot neglect to mention perhaps the best publication concerning these languages, Breen\'s "The Mayi Languages of the Queensland Gulf Country" which provides, among other evidence, a 656 "concept list" with translations in all the Mayi languages illustrating the similarities and differences (e.g. 5). The book also provides an overview of cultural differences between the different peoples and notes several phonological differences between the languages (e.g. 29).'},
    {'id': u'mamt1234', 'iso': 'mpf', 'name': u'Tajumulco Mam',
     'cr': u'2008-055', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Mam [mam]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam\nEastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'cata1284', 'iso': 'mst', 'name': u'Cataelano Mandaya',
     'cr': u'2009-068', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'merged with Mandaya [mry]',
     'comment': u'The present codes for Mandaya (mrt, mry, and mst) do not represent dialects of Mandaya but data collection points when Andrew Gallman was gathering data for his dissertation some 30 years ago. In reality it is all the same language with a purer Mandaya in the mountains and more of a mixed variety of Mandaya along the coast. All of it is Mandaya.'},
    {'id': u'taca1258', 'iso': 'mtz', 'name': u'Tacanec',
     'cr': u'2008-055', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Mam [mam]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam\nEastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'mamc1234', 'iso': 'mvc', 'name': u'Central Mam',
     'cr': u'2008-055', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Mam [mam]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam\nEastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'mamt1235', 'iso': 'mvj', 'name': u'Todos Santos Cuchumat\xe1n Mam',
     'cr': u'2008-055', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Mam [mam]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam\nEastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'mudb1240', 'iso': 'mwd', 'name': u'Mudbura',
     'cr': u'2012-073', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Karranga [xrq] and Mudburra [dmw]',
     'comment': u"Dr. Bowern supports the judgement by Patrick McConvell that treats Karranga as a separate language (see http://wold.livingsources.org/language/182).\nWe believe that Dr. Bowern's research and expertise on languages of Australia, as well as the support of the sources listed below are sufficient to define this as a distinct language."},
    {'id': u'fore1268', 'iso': 'myq', 'name': u'Forest Maninka',
     'cr': u'2012-082', 'effective': '2013-01-23', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'Forest Maninka is a phantom language. I\u2019m afraid, I\u2019m partly guilty of its emergence: many years ago, I invented this term as generic for the continuum Manya \u2013 Konya \u2013 Odienne Jula, and later on, someone reinterpreted it as a language of a lower level. In reality, no language of this name exists.'},
    {'id': u'sang1338', 'iso': 'myt', 'name': u'Sangab Mandaya',
     'cr': u'2009-068', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'merged with Mandaya [mry]',
     'comment': u'The present codes for Mandaya (mrt, mry, and mst) do not represent dialects of Mandaya but data collection points when Andrew Gallman was gathering data for his dissertation some 30 years ago. In reality it is all the same language with a purer Mandaya in the mountains and more of a mixed variety of Mandaya along the coast. All of it is Mandaya.'},
    {'id': u'ngur1261', 'iso': 'nbx', 'name': u'Ngura',
     'cr': u'2012-077', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Eastern Karnic [ekc], Garlali [gll], Punthamara [xpt], Wangkumara [xwk], and Badjiri [jbi]',
     'comment': u'There are 11 dialects listed under the existing Ngura nbx code. Dr. Bowern suggests they be understood as follows:\nDr. Bowern supports the theory proposed that "Wurm and Hattori (1981) list the dialects as separate languages", as cited in the ethnologue entry for Ngura, as far as these four listed varieties go. Dr. Bowern suggests that Punthamara, Garlali, Wangkumara, Badjiri, and Eastern Karnic be listed as separate languages under a Ngura macrolanguage with the existing nbx code (if the nbx code must be retired, please list all these under the Ngura sub-family 190-16 since nbx will effectively be redundant).\nThe remaining dialects under the existing nbx code--Bidjara, Mambangura, Mingbari, Ngurawarla, Yarumarra--should be listed as dialects of a new code, Eastern Karnic.\nNote Dhiraila and Karendala (Garandala) are NOT dialects in any sense, they should be listed as alternate names of Eastern Karnic.\nWe believe that Dr. Bowern\'s research and expertise on languages of Australia, as well as the support of the sources listed below are sufficient to define these as distinct languages.'},
    {'id': u'nyen1255', 'iso': 'nfg', 'name': u'Nyeng',
     'cr': u'2008-017', 'effective': '2009-01-26', 'reason': 'merge',
     'remedy': u'Merge into Ahwai [nfd]',
     'comment': u'The Ahwai people speak a single language on a functional level. The expansion of the [nfd] Ndun code element with the merging of [nfg] Nyeng , [nfk] Shakara into it necessitates using a name that identifies the whole group, rather than a single subgroup. \nWe propose this change based on the results of our language research, undertaken in March 2007 in the southeastern area of Kaduna State, Nigeria. These three related varieties were proved to be varieties of the same language rather than three separate languages. The users of each variety have inherent understanding of the other variety at a functional level. The Ahwai people, as all three groups commonly identify themselves, say they all speak the same language, but with \u201cdifferent intonation\u201d. Their claims of the similarity of and intelligibility between their three speech varieties are supported by the high lexical similarity between varieties (over 86%) and the similarity of their noun-class marking systems, based on the comparison of the 320-items wordlists. Also, although each Ahwai sub-group has a distinct ethnolinguistic identity, they are not antagonistic towards one another. Rather, they desire to cooperate in language development, and come together to preserve their common identity.'},
    {'id': u'shak1238', 'iso': 'nfk', 'name': u'Shakara',
     'cr': u'2008-017', 'effective': '2009-01-26', 'reason': 'merge',
     'remedy': u'Merge into Ahwai [nfd]',
     'comment': u'The Ahwai people speak a single language on a functional level. The expansion of the [nfd] Ndun code element with the merging of [nfg] Nyeng , [nfk] Shakara into it necessitates using a name that identifies the whole group, rather than a single subgroup. \nWe propose this change based on the results of our language research, undertaken in March 2007 in the southeastern area of Kaduna State, Nigeria. These three related varieties were proved to be varieties of the same language rather than three separate languages. The users of each variety have inherent understanding of the other variety at a functional level. The Ahwai people, as all three groups commonly identify themselves, say they all speak the same language, but with \u201cdifferent intonation\u201d. Their claims of the similarity of and intelligibility between their three speech varieties are supported by the high lexical similarity between varieties (over 86%) and the similarity of their noun-class marking systems, based on the comparison of the 320-items wordlists. Also, although each Ahwai sub-group has a distinct ethnolinguistic identity, they are not antagonistic towards one another. Rather, they desire to cooperate in language development, and come together to preserve their common identity.'},
    {'id': u'dura1245', 'iso': 'nln', 'name': u'Durango Nahuatl',
     'cr': u'2011-111', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Eastern Durango Nahuatl [azd] and Western Durango Nahuatl [azn]',
     'comment': u'Based on phonological, grammatical, and lexical differences (see attached documentation), there are two linguistic variants in this language which make it difficult to convert materials in one variant directly to the other. When speakers of the two variants try to communicate in their language, they have so much trouble understanding each other that they usually use Spanish instead. Furthermore, there are several words that appear to be the same in the two variants that show significant semantic shift. There is approximately 85% comprehension between the two variants, which makes the speakers think they should be able to communicate in their language, but in fact they usually find it impossible. This has been confirmed by linguistic and sociolinguistic studies (see bibliography).\nIn the cultural realm, the Eastern variant has conserved more of their traditional beliefs than has the Western variant, where only some very elderly speakers still know them. Another factor has been the invasion of the Eastern variant by migrating speakers of Southeastern Tepehuan (stp), causing cultural and linguistic changes. In the Western variant, there are fewer such influences, especially in the communities in Durango State (San Agustin de Buenaventura, Curachitos de Buenavista, San Diego, Tepetates II (Berenjenas), Alacranes and Tepalcates). Except for Tepalcates, all these communities still use the language in all aspects of daily life, probably because there are few other linguistic influences in their isolated area. They even use Nahuatl when they talk on their "walkie talkies." Thus this area can be considered the heart of the ethnic group, because there the language and culture are preserved.\nThere are, however, some trends toward moderization that threated their cultural identity.\nIn Nayarit State, the same Western variant is spoken in four places (Santa Cruz, La Laguna, Mesa de las Arpas, and El Duraznito). The language is more threatened there, since these four communities have fewer speakers and are surrounded by large communities of Cora and Huichol speakers. This has caused the loss of the language in some parts to the extent that symptoms of language death are evident. In the schools of these four communities, Nayarit State has created a program to promote the use of the language, including training teachers in the language and in positive attitudes toward it, but in the homes it is often not spoken by the children, although they still understand it. The older traditional authorities also favor the creation of materials to promote the use of the language.'},
    {'id': u'ngar1286', 'iso': 'nlr', 'name': u'Ngarla',
     'cr': u'2012-075', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Ngarla [nrk] and Yinhawangka [ywg]',
     'comment': u"Dr. Bowern judges the two languages Yinhawangka and Ngarla to be different. They are associated with different locations, as provided on the New Code Request form.\nWe believe that Dr. Bowern's research and expertise on languages of Australia, as well as the support of the sources listed below are sufficient to define this as a distinct language."},
    {'id': u'noot1239', 'iso': 'noo', 'name': u'Nootka',
     'cr': u'2010-033', 'effective': '2011-05-18', 'reason': 'split',
     'remedy': 'Split into [dtd] Ditidaht and [nuk] Nuu-chah-nulth',
     'comment': u"The Ditidaht Band is recognized by the Canadian government as a Band of the Nuu-chah- nulth Tribe, while the Pacheedaht are recognized as an independent First Nation. The Ditidaht language is recognized as an individual language by the First Peoples' Heritage, Language and Culture Council, which is a Crown Corporation, and appointed by the government of Bristish Columbia to oversee provincial funding for native language revitalization.\nThe name 'Ditidaht' is commonly used for the traditional language that is shared by the present-day Ditidaht and Pacheedaht, though only the Ditidaht also use the name as an ethnonym. The Ditidaht and Pacheedaht peoples have distinct ethnic identities from each other, as well as distinct ethnolinguistic identities from their most closely related neighbours, the Nuu-chah-nulth of Vancouver Island, and the Makah of the Olympic Peninsula."},
    {'id': u'palu1254', 'iso': 'pbz', 'name': u'Palu',
     'cr': u'2011-071', 'effective': '2012-02-03', 'reason': 'non-existent',
     'remedy': u'Delete Palu [pbz]',
     'comment': u'Nothing is known about this language; we have never heard of this language. There is no evidence that this language has ever existed.'},
    {'id': u'pana1292', 'iso': 'pcr', 'name': u'Panang',
     'cr': u'2012-029', 'effective': '2013-01-23', 'reason': 'merge',
     'remedy': u'merge into Amdo Tibetan [adx]',
     'comment': u'\u201cPanang\u201d (Tibetan sbra.nag \u2018black tent\u2019) is the name of a particular subgroup of Amdo Tibetans.\nDenwood (1999:30) identifies their language as belonging to the category of \u201cAmdo dialects with oral [onset consonant] clusters only\u201d. My own examination of the data in Kara (1984) leads me to the same conclusion: this is nothing more than a variety of Amdo Tibetan. Varieties of Amdo Tibetan have a high degree of mutual intelligibility; Sung and\nlHa.byams rGyal (2005: xviii) give a typical report: \u201c[T]he sub-dialects within the Amdo region display remarkable uniformity. Any two people from different places inside the Amdo region can usually communicate with little or no difficulty.\u201d\nThere is therefore no reason for \u201cPanang\u201d to have its own ISO-693-3 code.'},
    {'id': u'pong1252', 'iso': 'pgy', 'name': u'Pongyong',
     'cr': u'2011-164', 'effective': '2012-02-03', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'In short, the rationale for this proposed change is that no proper evidence has ever been presented for Pongyong\'s [pgy] existence as a unique language. As far as Nepali linguists can tell, this is a "ghost entry" in the ISO 639-3. \u201cPongyong\u201d is a Rai clan name (Van Driem 2001:623). It is unlikely to be a separate language from Saam [raq]. The existence of Pongyong as a unique language was originally based on a single questionnaire by the German survey published by Hansson (1988:20-21; 1991:76-77, 84-85), which is known for having sometimes made big claims based on almost no data (such as is the case with Pongyong). Due to such scanty data, Hansson himself hedged to say that Pongyong may be a part of Saam [raq] (Hansson 1988:20-21; Hansson 1991:61, 85). I have not yet found any Kirati language scholars that have heard of Pongyong suggested as a unique language (outside of Hansson\'s work) or of Pongyong claimed by anyone as their own language. There is also little documentation (albeit some) about Saam, so there does not seem to be enough evidence to merge these ISO code elements. It seems that the Pongyong code element should be eliminated from ISO 639-3 or at grouped together as a part of Saam [raq] if for some reason that is necessary. I think eliminating the [pgy] code element makes the most sense.'},
    {'id': u'poqo1257', 'iso': 'poa', 'name': u'Eastern Pokomam',
     'cr': u'2008-057', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Poqomam [poc]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names.\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'poqo1256', 'iso': 'pob', 'name': u'Western Pokomch\xed',
     'cr': u'2008-058', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with Poqomchi' [poh]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names.\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'poqo1255', 'iso': 'pou', 'name': u'Southern Pokomam',
     'cr': u'2008-057', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Poqomam [poc]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names.\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'papa1263', 'iso': 'ppv', 'name': u'Papav\xf4',
     'cr': u'2008-019', 'effective': '2009-01-16', 'reason': 'non-existent',
     'remedy': u'Any usage probably referred to one of: Amarakaeri [amr], Huachipaeri [hug], Kulina [cul], Amahuaca [amc], or Yawanawa [ywn]',
     'comment': u'This is a name that was used to refer to a group of several different uncontacted groups. It is no longer used to refer to this group because it is now known that there are four separate, now identified groups that fell under this label (see http://lucy.ukc.ac.uk/Sonja/RF/Ukpr/Report34.htm).\nThese groups are: Harakmbet--two languages, Amarakaeri [amr] and Huachipaeri [hug]; Kulina [cul]; Amahuaca [amc]; and Yawanawa [ywn]'},
    {'id': u'kich1267', 'iso': 'quj', 'name': u'Joyabaj Quich\xe9',
     'cr': u'2008-054', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with K'iche' [quc]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.\n[RA comment: the name form Quiche\u0301 in Spanish spelling will also be retained for historical reference with regard to the standard.]'},
    {'id': u'kich1266', 'iso': 'qut', 'name': u'West Central Quich\xe9',
     'cr': u'2008-054', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with K'iche' [quc]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.\n[RA comment: the name form Quiche\u0301 in Spanish spelling will also be retained for historical reference with regard to the standard.]'},
    {'id': u'kich1265', 'iso': 'quu', 'name': u'Eastern Quich\xe9',
     'cr': u'2008-054', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with K'iche' [quc]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.\n[RA comment: the name form Quiche\u0301 in Spanish spelling will also be retained for historical reference with regard to the standard.]'},
    {'id': u'kich1263', 'iso': 'qxi', 'name': u'San Andr\xe9s Quich\xe9',
     'cr': u'2008-054', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with K'iche' [quc]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. Please see section 4 for an elaboration of the languages according to family divisions and branches.\n[RA comment: the name form Quiche\u0301 in Spanish spelling will also be retained for historical reference with regard to the standard.]'},
    {'id': u'calo1235', 'iso': 'rmr', 'name': u'Cal\xf3',
     'cr': u'2009-031', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'split into Cal\xc3\xb3 [rmq] and Erromintxela [emx]',
     'comment': u'Erromintxela, "Basque Romany", is not mutually intelligible with Iberian Calo\u0301 because 1) the grammar of Erromintxela is entirely based on Basque rather than on Spanish or Portuguese and 2) the Romany component is based on Kalderash Romany rather than Calo\u0301. There is no context in which these languages may be considered parts of a whole.'},
    {'id': u'sana1281', 'iso': 'sap', 'name': u'Sanapan\xe1',
     'cr': u'2013-013', 'effective': '2014-02-03', 'reason': 'split',
     'remedy': 'Split into Sanapan\xc3\xa1 [spn] and Angait\xc3\xa9 [aqt]',
     'comment': u'Angaite\u0301 and Sanapana\u0301 are different on all of the above criteria. Indeed, the two languages are not mutually intelligible, and there is a clear ethnoliguistic distinction.\nThe existing code element does not represent a major language. The Sanapana\u0301 and Angaite\u0301 languages are of equal standing in relation to each other and to the other languages of the family. For example, comparing the differences between Angaite\u0301 and Sanapana\u0301 with those between Angaite\u0301 and Enxet, the classification of the two languages in a single code element is clearly arbitrary.'},
    {'id': u'sans1276', 'iso': 'sca', 'name': u'Sansu',
     'cr': u'2011-076', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'Sansu [sca] merged into Hlersu [hle]',
     'comment': u'Sansu is an alternate name for Hlersu. They are the same language group. The speakers of Sansu identify themselves as "Hlersu".'},
    {'id': u'sang1316', 'iso': 'sgl', 'name': u'Sanglechi-Ishkashimi',
     'cr': u'2009-029', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'split into Sanglechi [sgy] and Ishkashimi [isk]',
     'comment': u'The lexical similarity of Ishkashimi and Sanglechi is 70%. Comprehension testing showed that intelligibility between the two speech varieties is marginal, although the Sanglechi understand Ishkashimi slightly better than vice versa. No common writing system and no common literature exists for the two speech varieties since they are oral languages. The speakers of Ishkashimi and Sanglechi do not perceive themselves to speak the same language nor to have the same ethnolinguistic identity.'},
    {'id': u'mali1288', 'iso': 'sic', 'name': u'Malinguat',
     'cr': u'2008-022', 'effective': '2009-01-16', 'reason': 'split',
     'remedy': 'Split into Keak [keh] and Sos Kundi [sdk]',
     'comment': u'The two languages are not inherently intelligible; the speakers of Sos Kundi identify their language as different from Keak, similarly the speakers of Keak identify their language as different to Sos Kundi; the lexical similarity of the two languages is 68%; there is no common literature.'},
    {'id': u'natu1249', 'iso': 'stc', 'name': u'Santa Cruz',
     'cr': u'2008-070', 'effective': '2009-01-16', 'reason': 'split',
     'remedy': 'Split into Nat\xc3\xbcgu [ntu] and Nal\xc3\xb6go [nlz]',
     'comment': u'There are three related languages on the island of Santa Cruz and it is confusing to refer to only one (which is actually two if this application is accepted) of them as "Santa Cruz."\n* Speakers of both varieties have to learn the other one.\n* There is no common written literature; oral society with stories told in own variety.\n* They consider themselves to speak different languages for census purposes.\n\nThe linguistics literature refers to all three languages on the island of Santa Cruz as Santa Cruz languages, when speaking of the Reefs-Santa Cruz languages (RSC). But it also refers to Natu\u0308gu and Nalo\u0308go as "N. and S. Santa Cruz," and Nanggu (Nagu) with its own name. Therefore, Santa Cruz is better reserved as the genetic group containing all three of these languages.'},
    {'id': u'suri1269', 'iso': 'sul', 'name': u'Surigaonon',
     'cr': u'2009-087', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'Split into Tandaganon [tgn] and Surigaonon [sgd] (new identifier)',
     'comment': u'The Tandaganon language is distinct from Surigaonon and from other languages in northeastern Mindanao (Butuanon, Kamayo, Mamanwa, Manobo) and other Philippine languages. It was included in the Zorc dissertation/monograph on Bisayan languages, but overlooked by all other researchers afterwards (but will be included in the forthcoming Lobel dissertation, where it is treated a distinct language). Zorc\'s dissertation treats Tandaganon as coordinate with Surigaonon, as does the forthcoming Lobel dissertation. Native speakers of this language refer to it as "Tandaganon" or "Tagon-on" and not as Surigaonon. It is different enough from Surigaonon that Surigaonon speakers refer to it as "Kamayo" (which is the next language to the south of Tandaganon); On the other hand, it is different enough from Kamayo that Kamayo speakers refer to it as "Tandaganon", "Tagon- on", or "Surigaonon". Tandaganon speakers often have intelligibility of Surigaonon because Surigaonon speakers from northern Surigao del Sur often come to Tandag (the provincial capitol) in order to conduct business. Surigaonon speakers (and especially those from outside of Surigao del Sur province) have much less understanding of Tandaganon, and as previously stated, often mistakenly refer to it as "Kamayo", a language which is even more different from Surigaonon.'},
    {'id': u'sumo1243', 'iso': 'sum', 'name': u'Sumo-Mayangna',
     'cr': u'2009-037', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'Split into Mayangna [yan] and Ulwa [ulw]',
     'comment': u'I copy from Thomas Michael Green (see reference, page 10): "Ulwa is the southernmost surviving member of the Sumu language subfamily. It is not mutually intelligible with its northern Sumu neighbor, the Mayangna language, whose modern dialects are Panamahka and Tuahka of Nicaragua (see von Houwald 1980, Norwood 1987 and 1997) and Tawahka of Honduras (Benedicto and Hale 1998)".'},
    {'id': u'tang1348', 'iso': 'tgg', 'name': u'Tangga',
     'cr': u'2012-141', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Fanamaket [bjp], Niwer Mil [hrc], and Warwar Feni [hrw]',
     'comment': u'The Tangga language is said to be spoken in three different locations; the Tangga Islands, the Feni Islands, and mainland New Ireland, PNG. A 2005 survey conducted by SIL-PNG showed that the three varieties spoken in the three locations consider themselves distinct, though sharing a common history. Even though all three groups say there was a time when they all spoke the same language, now they no longer understand each other. (Please note the accompanying survey report is a draft.)\nThis is shown through a lexicostatistic comparison, where Fanamaket scores an average of 69 with Warwar Feni, highest is a 70, and an average of 69 with Niwer Mil, highest a 69 (see pages 16 and 17 of the accompanying survey report).\nThis is verified by the reported comprehension between the varieties. Speakers of Warwar Feni and Niwer Mil said that children understand very little or nothing of the Fanamaket variety, while speakers of Fanamaket said the same of the other two varieties. (19 and 20).\nThe lexicostatistic comparison between Warwar Feni and Niwer Mil showed an average score of 83, the highest being 84 (pages 16-17).\nThe reported comprehension between the varieties is stark. Respondents in two Niwer Mil villages reported that children can understand nothing of Warwar Feni, while respondents in the other two Niwer Mil villages reported that children can understand little of Warwar Feni. On the other side, respondents in three Warwar Feni villages reported that children can understand nothing of Niwer Mil while the other two villages reported children can understand only a little. (pages 19 and 20)\nWhen asked specifically about the acceptance of language development in the other varieties, each said they would refuse to use them. Each group wants language development in their own variety. (page 22)\n"People from the Tanga Islands, Feni Islands, and the three New Ireland villages perceive themselves to be speaking different languages. They recognise that the three languages are related and they report that they have a shared origin on New Ireland, but speakers of any one dialect do not think that the other two dialects sound good, they do not think that the other two dialects are very comprehensible, and they generally say they would not be willing to use literature in either of the other two dialects. People from each group would prefer to use literature in their own dialect. Even if Warwar Feni speakers could understand literature in the Niwer Mil dialect, they probably would not use Niwer Mil materials. Therefore, Niwer Mil and Warwar Feni speakers should not be grouped together to use the same literature.\nIn conclusion, for the purposes of language development, Niwer Mil, Warwar Feni, and Fanamaket can be considered different languages and should each have their own literature." (page 23)'},
    {'id': u'ting1253', 'iso': 'tie', 'name': u'Tingal',
     'cr': u'2010-011', 'effective': '2011-05-18', 'reason': 'merge',
     'remedy': u'merge into Tegali [ras]',
     'comment': u'1. The original classification of Tingal as a separate language was based on a misreading of the only published reference to it.\n2. A field check has established that Tingal is a dialect of Tegali [ras].\nThe Ethnologue entry for Tingal appears to be based solely on Tucker & Bryan, 1956, p.70, "The speech of Tingal or Kajakja is reported to be different from that of Tegali and Rashad; it is uncertain whether it belongs to the Tegali or Tagoi Cluster. Population 520". This in turn would seem to be quoting almost directly from Stevenson, 1956/7, p.103, "The dialect of Tingal or Kajakja (Kajaja) (520 TP) is orally reported to be \'different from Tegali and Rashad\' but it is uncertain whether it belongs to this cluster or to that of Tagoi." This does not establish Tingal as a language separate from Tegali [ras] and Tagoi [tag], and it was only based on hearsay.'},
    {'id': u'takp1246', 'iso': 'tkk', 'name': u'Takpa',
     'cr': u'2010-017', 'effective': '2011-05-18', 'reason': 'duplicate',
     'remedy': u'Merge into Tawang Monpa [twm] as duplicate',
     'comment': u'Ethnologue data on Takpa_tkk is slim - it is spoken in Tibet on the India border and is classified as Tibetan, Western, Ladakhi. Researching the bibliographical references given for the [tkk] entry (Shafer, Hale, Benedict, Voegelin), leads to the conclusion that this is an alternate name for [twm], for which there is already an entry in China.\nShafer\'s study was on "Dwags", which according to Michailovsky, is spoken in the areas of Tawang in Arunachal Pradesh,Tshona in Southern Tibet, and in neighboring parts of Bhutan. He classified it as East Bodish. The other three sources have no information other than a language called Takpa that has been classified as Bodish (Benedict) or a central dialect of Tibetan (Voegelin). Hale gives a comparison of the above classifications along with those of Roerich, who called it an eastern or southeastern dialect of Tibetan and Nishida, who called it a southeastern dialect of Tibetan.\nIt appears that the original data and language name of Dakpa, or Dwags, came from Hodgon (1853) which was then published and used in analysis by Shafer (1954). (See Michael Aris (1980) as quoted in Bielmeier (2004)): "The term Dag-pa .. is applied by the Bhutanese to a small group of pastoralists on the eastern border who are related to the Mon-pa people of the rTawang region ... Hodgson\'s informant in the mid-19th century was undoubtedly a native of the area."\nTakpa and Dwags are listed in Ethnologue as alternate names for Tawang Monpa [twm] in India.\nBurling (2003) says that Takpa (Dwags) is spoken in the very western tip of Arunachal, where it is referred to as \'Northern Monpa\'... also spoken in Tibet where it is known as \'cuona monpa\'.\nMichailovsky and Mazaudon (1994) states that: "The closest relative of the Bumthang group on which studies have been published is probably the Dakpa language spoken in the areas of Tawang in Arunachal Pradesh and Tshona (Cuona) in southern Tibet, and in neighboring parts of Bhutan.\nI can find no data in the Takpa [tkk] references in the Ethnologue to support its classification as Tibetan, Western, Ladakhi. On the contrary, Dakpa has been grouped with East Bodish by Shafer, Burling, van Driem and Michailovsky & Mazaudon. Cuona Monpa (which is the name in China for [twm]) is classified as East Bodish by Bradley. The [twm] entry in the Ethnologue is currently listed as Tibetan, Unclassified. I propose to assign to it the classification of Sino-Tibetan, Tibeto-Burman, Himalayish, Tibeto-Kanauri, Tibetic, Tibetan, Eastern.'},
    {'id': u'sout2892', 'iso': 'tlw', 'name': u'South Wemale',
     'cr': u'2011-083', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'Merged into North Wemale [weo]',
     'comment': u'Taguchi, who originally stated that they are differen langauges, recently sent me an e-mail stating the following "My survey report in 1996-7 concluded that the North and South Wemale should be identified as two different languages. However, after many years of interactions of Wemale community people I learned and can now conclude that they can communicate with each other without difficulty. So now we may want to say that Wemale have at least two main dialects: North and South Dialects."\nI recently returned from a survey of North Wemale and they said that they have no problem communicating with the Wemale on the south coast of Seram.'},
    {'id': u'toal1234', 'iso': 'tlz', 'name': u"Toala'",
     'cr': u'2008-026', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with Tae' [rob]",
     'comment': u'Grimes and Grimes (1987) Languages of South Sulawesi, proposed two languages to the east of the Toraja area: Toala\' and Rongkong. Even though the Grimeses\' own computations showed Toala\' and Rongkong to be 83% cognate, one consideration for not combining the languages was that Rongkong speakers themselves viewed their language as separate. However, a follow-up survey of the Toraja language area (Valkama 1987, WILC vol. 5) revealed dialect chaining which was more complex than the Grimeses\' initial survey had indicated, with no particular reason to demark the two languages. In their update to Languages of South Sulawesi, Tim Friberg and Tom Laskowske (1989, NUSA vol. 31) proposed that these two languages be combined and be renamed the Rongkong- Luwu\' language.\nIn 1988, Ian and Tanya Vail began living in the area, in order to investigate the situation in greater detail. After an extensive survey, which involved living in six different locations in Kabupaten Luwu, Vail concurred (Vail 1991) that the languages be combined, but suggested that the language be named Tae\' after the negative term which is used throughout the area (this term was also acceptable to speakers themselves as a language name). However, this term is neither definitive nor unambiguous, since tae\'is also the negative term in Sa\'dan Toraja (compare for example Van der Veen\'s 1940 Tae\' Woordenboek, which is a dictionary of Sa\'dan Toraja, not Rongkong-Luwu\').\nUnfortunately, these later suggestions were only halfway incorporated into the Ethnologue, which up through the 14th and 15th editions, had changed the name of Rongkong to Tae\' but maintained Toala\' as a separate language. The data listed under Tae\' (location, dialects, etc.) in the Ethnologue, 14th and 15th eds., partly assume that the languages were merged, and yet partly assume that the languages are separate.\nOne curiosity is where Chuck and Barbara Grimes even got the name Toala\'. They write on page 49, "There has been great diversity in the previous classification of Toala\'..." and so one might assume from the following discussion that Esser, Van der Veen, Salzner, Mills and the authors of the Peta Bahasa had all mentioned a Toala\' language, but this is not true. The term Toala\' is used only by Salzner, who listed it under his Makasar-Bugi group (see page 15), but never gave it a location on his Southern Sulawesi map (map no. 23). Since Salzner did not do any original research in Sulawesi, he must have picked up this term from someone else, but we could not track down this earlier source. Noorduyn calls Toala\' "an exceedingly inapt exonym ... meaning \'people of the forest\'" (1991:203). The preferred self-designation is Luwu\', and "there is little chance of confusion with the Luwu dialect of Bugis" (Friberg and Laskowske 1989:9).\nFollowing Vail (1991), there are four dialects of Tae\'. Major subdialects of Tae\' appear to be:\n- Northeast Luwu\' (= Bone-bone = Masamba) \n- Rongkong\n= Seko Lemo\n= Rongkong Atas\n= Rongkong Bawah (= Sabbang)\n- Bua\n- South Luwu\'\n= Bajo (=Palili\') \n= Bastem (=Toala\')\n\nHowever, integrating the dialect descriptions of Valkama (1987:125, 127), Friberg and Laskowske (1989:9) and Vail (1991:79) is not without its difficulties. In particular, Valkama writes as if Rongkong Bawah and Sabbang are separate subdialects, and places the latter within his North Luwu dialect. Valkama also uses the inelegant terms Northern South Luwu\' and Southern South Luwu\'. These terms are especially to be avoided since once Bua is removed from his Northern South Luwu\' (following Vail 1991), the split is more east- west rather than north-south. The Bastem and Bajo subdialects are named after kecamatans (subdistricts), but both are spoken more broadly than the respective kecamatan borders. Bastem is a mountain kecamatan which borders on the Toraja area. Finally, it is unclear from Ian Vail\'s report whether Bone-bone and Masamba are to be regarded as synonyms for Northeast Luwu\', or whether they should be regarded as separate, marginally different subdialects under Northeast Luwu\'. Kari Valkama took only one word list in this area, so it is impossible to resolve the issue by investigating Kari\'s primary data.'},
    {'id': u'tang1374', 'iso': 'tnf', 'name': u'Tangshewi',
     'cr': u'2009-027', 'effective': '2010-01-18', 'reason': 'merge',
     'remedy': u'merge with [prs] Dari',
     'comment': u'Lexical similiarity of Dari and Tangshewi is between 86% and 90%. Comprehension testing of Eastern Farsi (Dari) showed that Dari is highly intelligible for the Tangshewi people. The Tangshewi call the valley they live in Tangshew valley but not their speech variety. No one ever mentioned a language called Tangshewi as his mother tongue. The Tangshewi themselves explain that they speak Dari, acknowledging that their dialect is slightly different.'},
    {'id': u'tzel1255', 'iso': 'tzb', 'name': u'Bachaj\xf3n Tzeltal',
     'cr': u'2008-060', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Tzeltal [tzh]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'tzot1262', 'iso': 'tzc', 'name': u'Chamula Tzotzil',
     'cr': u'2008-061', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Tzotzil [tzo]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'tzot1263', 'iso': 'tze', 'name': u'Chenalh\xf3 Tzotzil',
     'cr': u'2008-061', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Tzotzil [tzo]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'tzot1260', 'iso': 'tzs', 'name': u'San Andr\xe9s Larrainzar Tzotzil',
     'cr': u'2008-061', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Tzotzil [tzo]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'tzut1249', 'iso': 'tzt', 'name': u'Western Tzutujil',
     'cr': u'2008-062', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u"Merge with Tz'utujil [tzj]",
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'tzot1261', 'iso': 'tzu', 'name': u'Huixt\xe1n Tzotzil',
     'cr': u'2008-061', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Tzotzil [tzo]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'tzot1264', 'iso': 'tzz', 'name': u'Zinacant\xe1n Tzotzil',
     'cr': u'2008-061', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Tzotzil [tzo]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names. \n\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'},
    {'id': u'woro1255', 'iso': 'unp', 'name': u'Worora',
     'cr': u'2011-091', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Worrorra [wro] and Unggumi [xgu].',
     'comment': u'Unggumi and Worrorra have been considered separate languages for some time now. In McGregor\'s 1988 Worrorran classification in his "Handbook of Kimberley Languages," he lists them both as separate languages. In 2009, McGregor and Alan Rumsey also list both Unggumi and Worrorra as independent languages within the Western Worrorran group (7).\nThe Australian Phylum classification by O\'Grady, Voegelin and Voegelin also treats Unggumi and Worrorra as separate languages (1966: 35). They explain that "the primary verbal distinction is between realis and irrealis in all languages in the Wororan family (except Worora, which distinguishes many moods and tenses)" (1966: 79). Presumably this further sets Worora apart from Unggumi.\nBoth languages are listed independently in AUSTLANG, with Unggumi given the AIATSIS code K14 and Worrorra given the separate code K17. AUSTLANG classifies them both within the Worrorric subgroup of the Worrorran family.\nDr. Bowern\'s documentation on Australian language locations also places the Unggumi and Worrorra languages in different areas, which one may see by consulting the following map:\nhttp://maps.google.com/maps?q=http://pantheon.yale.edu/~clb3/PamaNyungan/CCAL1.2.k mz\nWe believe that Dr. Bowern\'s research and expertise on languages of Australia, as well as the support of the sources listed below are sufficient to define Unggumi and Worrorra as languages distinct from one another.'},
    {'id': u'vatr1237', 'iso': 'vlr', 'name': u'Vatrata',
     'cr': u'2008-069', 'effective': '2009-01-16', 'reason': 'split',
     'remedy': "Split into Vera'a [vra] and Lemerig [lrz]",
     'comment': u'Vera\'a and Lemerig belong historically to two distinct language communities, even though Lemerig speakers now have generally adopted Vera\'a as their primary language. There is low intelligibility between Vera\'a and Lemerig.\n"Vatrata" is not, and never was, used by the local community. It was chosen by XIXth-c. missionaries based on another language (Mota). The speakers designate their village and language as Vera\'a (apostrophe = glottal stop). This is also the spelling which I have adopted in my scientific work, and which has been used by other scholars ever since. "Vatrata" is used by nobody else than Codrington (1885). As for "Vetrat", it is the name of the place & language, in the dominant language of Vanua Lava (Vure\u0308s [msn]).\nThe dialect names "Leon, Pak, Sasar" as listed in the Ethnologue form part of the distinct language called Lemerig.\nThere is no body of literature either in or on either of these languages, no other reason to keep the 2 languages under a single code.\nVera\'a should be considered the main language of the two, because it is viable and spoken by more speakers (about 300); Lemerig is dying out, with only 2 speakers.\nImportant note: the three dialects currently mentioned under "Vatrata", namely "Leon, Pak (Bek) and Sasar", correspond in fact to various ancient varieties of the language Lemerig. As far as I know, all these dialects became extinct during the last generation, except for Pak (or more precisely Pa\u0308k) which still has 2 speakers alive. Everybody insist that these three names, all corresponding to small mountain hamlets now deserted, should be placed under the umbrella term "LEMERIG" to designate the language.\nFinally, Vatrata has no internal dialect.'},
    {'id': u'waga1262', 'iso': 'wgw', 'name': u'Wagawaga',
     'cr': u'2009-045', 'effective': '2010-01-18', 'reason': 'split',
     'remedy': 'Split into Yaleba [ylb] and Wagawaga [wgb] (new identifier)',
     'comment': u"\u201cLexical similarity percentages between the two varieties are between sixty-six and seventy-six percent, depending on the dialect of Yaleba, of which there are three. Between the Soma'a dialect and Wagawaga, lexical similarity is 66%; between the Sileba dialect and Wagawaga it is 72%; between the Gamadoudou dialect and Wagawaga it is 76%. Furthermore, intelligibility testing between Yaleba and Wagawaga revealed that intelligibility between the two varieties is only marginal and they do not share a common ethnolinguistic identity.\u201d "},
    {'id': u'wint1259', 'iso': 'wit', 'name': u'Wintu',
     'cr': u'2012-144', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Wintu [wnw], Nomlaki [nol], and Patwin [pwi]',
     'comment': u"Modern scholars of Wintuan languages are in agreement that Wintu, Nomlaki and Patwin are three separate languages. The most thorough discussion of the language and dialect situation in all three of the Wintuan languages is in Whistler's (1980) dissertation (pp. 15\u2013 30, 46\u201353). Shepherd's (2005) book on Proto-Wintuan also distinguishes these three languages (see esp. pp. 1\u20134). Other more general works in agreement are: Golla (2011, 140\u2013147), Mithun (1999, 560\u2013563), and Campbell (1997, 128). The discussion in Golla (2011) of the dialect continuum between Wintu and Nomlaki should by no means rule out their being recognized as two distinct languages. Dialect continuums are not uncommon in geographically adjacent languages which are closely related. Authors of ethnographies, grammars, dictionaries and collections of texts are careful to distinguish the three groups both ethnographically and linguistically: cf. for Patwin, Kroeber (1932) and Whistler (1977, 1978); for Nomlaki, Goldschmidt (1951); and for Wintu, Shepherd (1989), Pitkin (1984, 1985), and Schlichter (1981)."},
    {'id': u'wira1260', 'iso': 'wiw', 'name': u'Wirangu',
     'cr': u'2011-133', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Wirangu [wgu] and Nauo [nwo]',
     'comment': u'Nauo, also known as Nawo, is a poorly attested, but clearly separate language from Wirangu (ISO 639-3: wiw). Ethnologue 16 currently lists "Nhawu" as an alternate name of Wirangu, but this name actually refers to this separate language Nauo. Hercus and Simpson investigated the little that is known about Nauo in their article "The Tragedy of Nauo," arguing that "the Nauo people were part of a chain of culturally related groups living on Eyre Peninsula and along the west coast, and that their language had elements in common with both Wirangu and Barngarla" (2001: 263).\nHercus and Simpson also argue that Wirangu is not a dialect of the Western Desert language, but is in fact a member of the Thura-Yura subgroup (2004). Hercus and Simpson systematically show that Nauo is a Thura-Yura language in their 2001 article, demonstrating that it has some qualities that are similar to Wirangu and others that are similar to Barnggarla (ISO 639-3: bjb). They explain that "phonotactically, it resembles Wirangu, rather than Barngarla, in allowing initial \'ty(i)\' , and \'i-u\' sequences. Three distinctive Nauo properties are the morphemes \'-yu\' and \'-lye\', and the final vowel of the second person singular, \'niino\'. Finally, Schu\u0308rmann\'s observation that Nauo was vowel-final is important: this links it with Barngarla and distinguishes it from Wirangu, Mirniny, and Kukata" (2001: 279).\nAs far back as 1966, O\'Grady, Voegelin and Voegelin included Nawu in their Yura subgroup (40). Wirangu was included in a separate subgroup called Nangga (1966: 40). More recently, Tryon has classified both Wirangu and what he calls Nawu as Thura-Yura languages (2007: 117).\nAUSTLANG follows both Hercus and Simpson 2001 and 2004 and places both Wirangu and Nauo in the Thura-Yura subgroup of the Pama-Nyungan family (2011).\nIt should also be noted that Hercus and Simpson 2004 identified two dialects of Wirangu, Modern Wirangu and Gawler Ranges Wirangu (181, 182-183).'},
    {'id': u'xian1249', 'iso': 'xia', 'name': u'Xiandao',
     'cr': u'2012-008', 'effective': '2013-01-23', 'reason': 'merge',
     'remedy': u'Merge into Achang [acn]',
     'comment': u'This is a subdialect of the Husa dialect of Achang. According to a native speaker of Husa Achang, it is very easily mutually intelligible with Husa Achang and its speakers only recently moved away from the Husa valley.\nXiandao is a subdialect of the Husa dialect of Achang and should be included in the element [acn].'},
    {'id': u'miar1236', 'iso': 'xmi', 'name': u'Miarr\xe3',
     'cr': u'2006-016', 'effective': '2007-07-18', 'reason': 'non-existent',
     'remedy': None,
     'comment': u'Language is unattested in linguistic research literature.'},
    {'id': u'yang1301', 'iso': 'ybd', 'name': u'Yangbye',
     'cr': u'2011-043', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'merged into Rakhine [rki]',
     'comment': u'Both Chaungtha and Yangbye refer to similar varieties within the Rakhine (rki) language. The speakers of these dialects identify themselves as "Rakhine". Wordlists collected on Yangbye island and in Kyauktaw Township share at least 94% lexical similarity with the prestige variety of Rakhine spoken in Sittwe Town.'},
    {'id': u'yend1240', 'iso': 'yen', 'name': u'Yendang',
     'cr': u'2011-150', 'effective': '2012-02-03', 'reason': 'split',
     'remedy': 'Split into Yendang [ynq] and Yotti [yot]',
     'comment': u'Yotti is listed as a dialect of Yendang. This was a mistake, as they are linguistically and socially distinct. In an interview in Mayo Lope in 2007, the Yotti individuals said that they have two origins: some clans come from Yoro (linking them with Mumuye [mzm]) and others from Bolki (linking them with Bacama [bcy]). They report than many are bilingual in Mumuye [mzm] and Yendang from an eariy age, but there are some Yotti (particularly the Nyagbala\u014b and Y\u025by\u026apte clans) who do not understand Yendang well.\nIntelligibility testing with children in Bonding (a Yotti village) showed very poor understanding of a text recorded in Kpankwai (a Yendang village).\nLexical similarity: 35% with Bali [bcn], 35% with Kpasham [pbn], 13% with Yendang [yen].\nPopulation: Yotti have about eight villages compared with many more than thirty Yendang villages.'},
    {'id': u'yiry1245', 'iso': 'yiy', 'name': u'Yir Yoront',
     'cr': u'2012-117', 'effective': '2013-01-23', 'reason': 'split',
     'remedy': 'Split into Yir Yoront [yyr] and Yirrk-Mel [yrm]',
     'comment': u'http://www-01.sil.org/iso639-3/cr_files/2012-117.pdf'},
    {'id': u'yamp1243', 'iso': 'yma', 'name': u'Yamphe',
     'cr': u'2011-152', 'effective': '2012-02-03', 'reason': 'merge',
     'remedy': u'Merged into Southern Lorung [lrr] and renamed Southern Yamphu.',
     'comment': u"1.) Linguistic/Ethnic Identity: The ethnic and linguistic identity of people in both groups (Yamphe [yma] and Southern Lorung [lrr]) is 'Yamphu.'\n2.) Attitudes: The varieties spoken in these areas, currently denoted at Yamphe [yma] and Southern Lorung [lrr], consider themselves similar to each other and linguistically different from Yamphu [ybi].\n3.) Wordlist data: Initial lexical similarity percentages for wordlists among the Yamphe [yma] Southern Lorung [lrr] varieties range between 83% and 86% similarity.\n4.) Terms of reference: Neither speakers nor scholars like or use the terms 'Yamphe' or 'Southern Lorung'. These terms were taken Hansson (1991), which is considered by most scholars to have made dubious choices for terms of reference in this region.\n5.) Linguistic evidence: Both Yamphe [yma] and Southern Lorung [lrr] are linguistically distinct from Yamphu [ybi]. The initial lexical similarity between Yamphe [yma] and Yamphu [ybi] is 67% and between Southern Lorung [lrr] and Yamphu [ybi] is 64%. Intelligibility testing (Recorded Text Tests) was conducted between Southern Lorung [lrr] and Yamphu [ybi] as well as between Yamphe [yma] and Yamphu [ybi]. The average score among Southern Lorung speakers on the Yamphu [ybi] story was 43% with a standard deviation of 14. The average score among Yamphe [yma] speakers on the Yamphu [ybi] story was 58% with a standard deviation of 21."},
    {'id': u'yosa1234', 'iso': 'yos', 'name': u'Yos',
     'cr': u'2012-035', 'effective': '2013-01-23', 'reason': 'merge',
     'remedy': u'Merge into Zo [zom].',
     'comment': u"Yos is the English plural form of the name 'Yo', which is just another pronunciation of 'Zo'. Yos/Yo is not a separate group or a separate language. It is the same as 'Zo'. No references to the 'Yos' exist apart from an obscure alleged reference in the 1983 Census of Myanmar. Yos [yos] should be retired from use, since it is equivalent to Zo [zom]."},
    {'id': u'maya1286', 'iso': 'yus', 'name': u'Chan Santa Cruz Maya',
     'cr': u'2008-063', 'effective': '2009-01-16', 'reason': 'merge',
     'remedy': u'Merge with Yucateco [yua]',
     'comment': u'The name is a dialect or dialect group name, and therefore incorrect for a language designation. It should be changed to the general language name. There is almost no disagreement among linguists about what the general language names for Mayan languages are. The majority of the Ethnologue/ISO names are, however, dialect names.\nThe \u201clanguages\u201d to be merged are in fact dialects or dialect groups within a single language. All historical linguists who work on Mayan agree on almost all of the actual languages in terms of identity (there is some disagreement about how the family is ramified), and agree that there are many fewer than are listed in Ethnologue or by ISO. The ISO codes taken from Ethnologue represent some of the dialects of different Mayan languages, but are not even a complete or accurate listing of dialects. At any rate, the distinctions they make need to be made at the level of dialect designations or codes, not language codes. If for some reason it is decided to maintain dialect distinctions in the codes for Mayan languages instead of merging the separate codes, then each language needs a separate general code to designate the language as a whole rather than one of its dialects. The languages about which there is still some discussion are: Achi (most linguists agree that it is a dialect (group) of K\u2019ichee\u2019, but speakers have chosen overwhelmingly to identify it as a separate language), Cholti\u2019 (separate extinct language or ancestral language?), Motozintlec and Tuzantec (dialects of Mocho\u2019 or separate languages?). The classification originally made by Terrence Kaufman and supported by the work of Lyle Campbell is that which is generally accepted, while the classification made by John Robertson is in agreement on most of the language names but disagrees on some of the family divisions. The list of currently accepted names of Mayan languages, arranged according to the family divisions and branches proposed by Kaufman, follows. I am using Mayan spelling for the Guatemalan languages, since there is general agreement among speakers of these languages to use these spellings. Language names are preceded by a hyphen.\nHuastecan division: -Huastec, -Chicomuceltec (extinct) Yucatecan division: -Yucatec Maya, -Lacandon, -Itzaj, -Mopan\nWestern division, Greater Tzeltalan branch, Cholan: -Ch\u2019olti\u2019 (ancestral form of Ch\u2019orti\u2019 or extinct lg?), -Ch\u2019orti\u2019, -Chol, -Chontal\nWestern division, Greater Tzeltalan branch, Tzeltalan: -Tzotzil, -Tzeltal Western division, Greater Q\u2019anjob\u2019alan branch, Chujean: -Tojolab\u2019al, -Chuj\nWestern division, Greater Q\u2019anjob\u2019alan branch, Q\u2019anjob\u2019alan Proper, Q\u2019anjob\u2019al complex: -Q\u2019anjob\u2019al, -Akateko, -Popti\u2019 (Jakalteko)\nWestern division, Greater Q\u2019anjob\u2019alan branch, Cotoque complex (2 languages or 2 dialects?): -Mocho\u2019 (Motozintleco, Tuzanteco)\nEastern division, Greater Mamean branch, Mamean Proper: -Teko, -Mam Eastern division, Greater Mamean branch, Ixilan: -Awakateko, -Ixil Eastern division, Greater K\u2019ichee\u2019an branch: -Uspanteko\nEastern division, Greater K\u2019ichee\u2019an branch, K\u2019ichee\u2019an Proper: -Sipakapense, -Sakapulteko, -K\u2019ichee\u2019, -Achi (also considered a dialect group within K\u2019ichee\u2019), -Tz\u2019utujiil, -Kaqchikel\nEastern division, Greater K\u2019ichee\u2019an branch, Poqom: -Poqomam, -Poqomchi\u2019 Eastern division, Greater K\u2019ichee\u2019an branch:-Q\u2019eqchi\u2019'}
]
