# coding=utf-8
"""update wals links

Revision ID: 105f1b1505b3
Revises: 1fd38a400cf6
Create Date: 2014-11-03 18:09:57.837000

"""

# revision identifiers, used by Alembic.

revision = '105f1b1505b3'
down_revision = '1fd38a400cf6'

import datetime

from alembic import op
import sqlalchemy as sa


def upgrade():
    conn = op.get_bind()

    conn.execute('CREATE TEMPORARY TABLE wals_glottocode( id TEXT, glottocode TEXT, PRIMARY KEY (id, glottocode))')
    conn.execute(sa.text('INSERT INTO wals_glottocode (id, glottocode) values (:id, :glottocode)'),
        [{'id': w, 'glottocode': g} for w, g in WALS_GLOTTOCODE])

    sa.text('DELETE FROM languageidentifier AS li '
        'WHERE EXISTS (SELECT 1 FROM language AS l, identifier AS i '
            'WHERE l.pk = li.language_pk AND i.pk = li.identifier_pk AND i.type = :type '
            'AND NOT EXISTS (SELECT 1 FROM wals_glottocode AS w '
                'WHERE w.glottocode = l.id AND w.id = i.name))',
        conn).execute(type='WALS')
    sa.text('DELETE FROM identifier AS i '
        'WHERE type = :type AND NOT EXISTS (SELECT 1 FROM wals_glottocode WHERE id=i.name)',
        conn).execute(type='WALS')
    sa.text('WITH ins AS (SELECT id AS wals FROM wals_glottocode AS w '
        'WHERE NOT EXISTS (SELECT 1 FROM identifier WHERE type = :type AND name = w.id)) '
        'INSERT INTO identifier '
        '(created, updated, active, version, name, type, lang) '
        'SELECT now(), now(), true, 1, ins.wals, :type, :lang FROM ins',
        conn).execute(type='WALS', lang='en')
    sa.text('WITH ins AS (SELECT '
            '(SELECT pk FROM language WHERE id = w.glottocode) AS language_pk, '
            '(SELECT pk FROM identifier WHERE type = :type AND name = w.id) AS identifier_pk '
        'FROM wals_glottocode AS w '
        'WHERE NOT EXISTS (SELECT 1 FROM language AS l '
            'JOIN languageidentifier AS li ON li.language_pk = l.pk '
            'JOIN identifier AS i ON li.identifier_pk = i.pk AND i.type = :type '
            'WHERE l.id = w.glottocode AND i.name = w.id)) '
        'INSERT INTO languageidentifier '
        '(created, updated, active, version, language_pk, identifier_pk) '
        'SELECT now(), now(), true, 1, ins.language_pk, ins.identifier_pk '
        'FROM ins',
        conn).execute(type='WALS')


def downgrade():
    pass


WALS_GLOTTOCODE = [  # 2677
    ('aar', 'aari1239'), ('aba', 'abau1245'), ('abb', 'chad1249'), ('abd', 'abid1235'), ('abe', 'nort3139'),
    ('abh', 'baha1259'), ('abi', 'abip1241'), ('abk', 'abkh1244'), ('abm', 'alab1237'), ('abn', 'arab1267'),
    ('abo', 'arbo1245'), ('abu', 'abun1252'), ('abv', 'abui1241'), ('abw', 'west2630'), ('abz', 'abaz1241'),
    ('ace', 'achi1257'), ('acg', 'acha1250'), ('ach', 'ache1246'), ('aci', 'quic1275'), ('acl', 'acol1236'),
    ('acm', 'achu1247'), ('acn', 'acha1249'), ('aco', 'west2632'), ('acu', 'achu1248'), ('ada', 'adam1238'),
    ('adg', 'adan1251'), ('adi', 'adio1239'), ('adk', 'ando1256'), ('adn', 'adny1235'), ('adt', 'adyg1241'),
    ('ady', 'adyg1241'), ('adz', 'adze1240'), ('aea', 'aleu1260'), ('aeg', 'egyp1253'), ('ael', 'liby1240'),
    ('afr', 'afri1274'), ('aga', 'agar1252'), ('agb', 'legb1242'), ('agc', 'cent2084'), ('agd', 'dupa1235'),
    ('agh', 'aghe1239'), ('agl', 'aghu1253'), ('agm', 'anga1287'), ('ago', 'ango1258'), ('agr', 'agua1253'),
    ('agt', 'leni1238'), ('agu', 'agua1252'), ('agw', 'alag1248'), ('aho', 'arap1274'), ('ahs', 'hass1238'),
    ('aht', 'ahte1237'), ('ahu', 'aghu1255'), ('aik', 'aika1237'), ('ain', 'ainu1240'), ('aiz', 'apro1235'),
    ('aja', 'ajas1235'), ('ajg', 'ajab1235'), ('aji', 'ajie1238'), ('aka', 'yaka1272'), ('akb', 'akab1249'),
    ('akc', 'akac1240'), ('akh', 'akha1245'), ('akk', 'akak1252'), ('akl', 'akla1241'), ('akm', 'marm1234'),
    ('akn', 'akan1250'), ('ako', 'cypr1248'), ('akr', 'arik1262'), ('akw', 'akaw1239'), ('ala', 'alam1246'),
    ('alb', 'gheg1238'), ('alb', 'tosk1239'), ('alc', 'alle1238'), ('ald', 'alla1248'), ('ale', 'aleu1260'),
    ('alg', 'algo1255'), ('alk', 'arop1243'), ('all', 'lala1268'), ('aln', 'alun1238'), ('als', 'alse1251'),
    ('alt', 'swis1247'), ('alu', 'alut1245'), ('alw', 'alaw1244'), ('alx', 'bata1292'), ('aly', 'alya1239'),
    ('ama', 'amar1272'), ('amb', 'ambu1247'), ('amc', 'amah1246'), ('amd', 'amdo1237'), ('ame', 'amel1241'),
    ('amh', 'amha1245'), ('ami', 'amis1246'), ('amk', 'amar1274'), ('aml', 'east2443'), ('amm', 'amap1240'),
    ('amn', 'aman1265'), ('amo', 'amoo1242'), ('amp', 'east2379'), ('amq', 'amba1265'), ('amr', 'moro1292'),
    ('ams', 'stan1318'), ('amt', 'amdo1237'), ('amu', 'yane1238'), ('amx', 'anam1248'), ('amz', 'guer1243'),
    ('ana', 'arao1248'), ('anc', 'ngas1240'), ('ane', 'anem1249'), ('ang', 'ango1254'), ('ani', 'anii1246'),
    ('anj', 'anei1239'), ('anl', 'nort3139'), ('ann', 'anin1240'), ('ano', 'nung1282'), ('ant', 'anga1290'),
    ('anu', 'anuf1239'), ('anx', 'andi1255'), ('any', 'anua1242'), ('ao', 'aona1235'), ('aoj', 'mufi1238'),
    ('apa', 'sout3123'), ('apc', 'mesc1238'), ('ape', 'safe1240'), ('api', 'apin1244'), ('apj', 'jica1244'),
    ('apk', 'apuc1241'), ('apl', 'apal1257'), ('apt', 'apat1240'), ('apu', 'apur1254'), ('apw', 'west2615'),
    ('ara', 'araw1276'), ('arb', 'arab1268'), ('arc', 'arch1244'), ('ard', 'aran1237'), ('arg', 'gulf1241'),
    ('arh', 'hija1235'), ('ari', 'arib1241'), ('arj', 'gulf1241'), ('ark', 'arak1252'), ('arl', 'nort3139'),
    ('arm', 'nucl1235'), ('arn', 'chad1249'), ('aro', 'aros1241'), ('arp', 'buki1249'), ('arq', 'meso1252'),
    ('arr', 'east2379'), ('arr', 'west2441'), ('ars', 'sana1295'), ('arv', 'sout3123'), ('arw', 'nucl1235'),
    ('arx', 'area1240'), ('arz', 'nucl1235'), ('ash', 'adyg1241'), ('asl', 'amer1248'), ('asm', 'tamn1235'),
    ('aso', 'sout2694'), ('ass', 'assa1263'), ('ast', 'astu1245'), ('asu', 'toca1235'), ('asy', 'nort3139'),
    ('ata', 'atay1247'), ('atb', 'aral1243'), ('atc', 'urip1239'), ('ath', 'athp1241'), ('ati', 'atik1240'),
    ('atk', 'atak1252'), ('atm', 'kunz1244'), ('atq', 'paci1278'), ('ats', 'atsu1245'), ('atu', 'tuni1259'),
    ('au', 'auuu1241'), ('aul', 'aulu1238'), ('aus', 'aust1271'), ('auy', 'awiy1238'), ('ava', 'avar1256'),
    ('avk', 'avik1243'), ('avo', 'avok1242'), ('avt', 'avat1244'), ('awa', 'awap1236'), ('awd', 'awad1243'),
    ('awe', 'west2441'), ('awi', 'aeky1238'), ('awk', 'pong1250'), ('awn', 'awng1244'), ('awp', 'awac1239'),
    ('awt', 'awtu1239'), ('awy', 'awyi1241'), ('axv', 'akhv1239'), ('ayi', 'anyi1245'), ('aym', 'nucl1667'),
    ('ayn', 'ainu1251'), ('ayr', 'ayor1240'), ('ayw', 'ayiw1239'), ('aze', 'nort2697'), ('aze', 'sout2697'),
    ('azi', 'sout2697'), ('baa', 'bara1377'), ('bab', 'veng1238'), ('bac', 'wadj1254'), ('bad', 'bade1248'),
    ('bae', 'bare1276'), ('baf', 'bafu1246'), ('bag', 'bagi1246'), ('bai', 'cent2004'), ('baj', 'indo1317'),
    ('bak', 'baka1272'), ('bal', 'bali1278'), ('bam', 'bamb1269'), ('ban', 'bana1305'), ('bao', 'bona1250'),
    ('baq', 'baur1253'), ('bar', 'bari1284'), ('bas', 'basa1284'), ('bat', 'bata1301'), ('bau', 'bauu1244'),
    ('baw', 'bawm1236'), ('bbf', 'nort2819'), ('bbf', 'sout2840'), ('bbl', 'dibo1245'), ('bbm', 'bamb1270'),
    ('bbu', 'bara1361'), ('bbw', 'gunw1252'), ('bca', 'band1339'), ('bch', 'tach1249'), ('bco', 'bell1243'),
    ('bdc', 'berb1259'), ('bdg', 'bada1257'), ('bdk', 'budu1248'), ('bdm', 'badi1246'), ('bdu', 'budu1250'),
    ('bdw', 'baha1258'), ('beb', 'bena1264'), ('bec', 'chit1275'), ('bee', 'beem1239'), ('beg', 'idaa1241'),
    ('bej', 'beja1238'), ('bel', 'belh1239'), ('bem', 'bemb1258'), ('ben', 'beng1280'), ('beo', 'beot1247'),
    ('ber', 'bert1248'), ('bet', 'dalo1238'), ('bez', 'bezh1248'), ('bfd', 'biaf1240'), ('bfi', 'bafi1243'),
    ('bga', 'beng1282'), ('bgg', 'bang1368'), ('bgi', 'bagr1243'), ('bgl', 'bugl1243'), ('bgm', 'bang1363'),
    ('bgn', 'bugu1246'), ('bgo', 'bong1285'), ('bgr', 'furu1242'), ('bgs', 'baga1272'), ('bgv', 'bagv1239'),
    ('bgz', 'bong1289'), ('bhi', 'bhil1251'), ('bhn', 'bahi1254'), ('bho', 'bhoj1244'), ('bhu', 'mund1320'),
    ('bia', 'bera1259'), ('bia', 'bila1255'), ('bid', 'bidi1241'), ('big', 'yulu1243'), ('bii', 'biri1256'),
    ('bik', 'biak1248'), ('bil', 'bilu1245'), ('bim', 'bima1247'), ('bin', 'bina1277'), ('bio', 'naii1241'),
    ('biq', 'boli1256'), ('biq', 'sara1326'), ('bir', 'bero1242'), ('bis', 'biss1248'), ('bit', 'biat1246'),
    ('biu', 'bisu1246'), ('bjs', 'sout2918'), ('bka', 'baka1274'), ('bkb', 'bett1235'), ('bkd', 'binu1244'),
    ('bki', 'baka1277'), ('bkl', 'cent2087'), ('bkn', 'orok1266'), ('bkr', 'bata1293'), ('bkt', 'brok1247'),
    ('bku', 'mokp1239'), ('bla', 'siks1238'), ('blc', 'east2304'), ('ble', 'baou1238'), ('blg', 'bala1310'),
    ('blj', 'kaci1244'), ('blk', 'bala1315'), ('bln', 'bili1260'), ('blq', 'nucl1695'), ('blr', 'bela1254'),
    ('blt', 'balt1258'), ('blu', 'luba1249'), ('blx', 'bilo1248'), ('bly', 'nija1241'), ('blz', 'bala1300'),
    ('bma', 'cent2194'), ('bmb', 'bimo1239'), ('bmn', 'bamu1253'), ('bmr', 'buru1306'), ('bmz', 'tumz1238'),
    ('bna', 'jama1261'), ('bnb', 'buna1275'), ('bnd', 'band1352'), ('bng', 'qaqe1238'), ('bni', 'bini1246'),
    ('bnj', 'band1339'), ('bnk', 'bank1256'), ('bnl', 'bang1339'), ('bnm', 'binu1245'), ('bnn', 'bann1247'),
    ('bno', 'waim1255'), ('bnq', 'beng1286'), ('bnr', 'ngar1235'), ('bnt', 'bant1286'), ('bnu', 'bula1255'),
    ('bnw', 'bani1255'), ('boa', 'kuni1265'), ('bob', 'bang1354'), ('bod', 'bodo1269'), ('boi', 'boik1241'),
    ('boj', 'damu1236'), ('bok', 'boko1266'), ('bol', 'boli1255'), ('bon', 'bong1291'), ('boq', 'damu1236'),
    ('bor', 'bora1263'), ('bos', 'bosn1245'), ('bou', 'taga1278'), ('boz', 'tiey1235'), ('bpa', 'bura1292'),
    ('bpb', 'bahn1262'), ('bqb', 'basq1248'), ('bqg', 'basq1248'), ('bqh', 'basq1248'), ('bqi', 'basq1248'),
    ('bql', 'basq1248'), ('bqn', 'basq1248'), ('bqo', 'basq1248'), ('bqr', 'basq1248'), ('bqs', 'basq1248'),
    ('bqz', 'basq1248'), ('bra', 'lave1249'), ('brb', 'baat1238'), ('brc', 'boru1252'), ('brd', 'bard1255'),
    ('bre', 'bret1244'), ('brf', 'tari1263'), ('brh', 'brah1256'), ('bri', 'brib1243'), ('brj', 'burj1242'),
    ('brk', 'beri1254'), ('brl', 'lowa1242'), ('brm', 'nucl1310'), ('brn', 'buru1320'), ('bro', 'torr1261'),
    ('brp', 'wara1302'), ('brr', 'boro1282'), ('brs', 'bara1380'), ('bru', 'east2332'), ('brw', 'west2397'),
    ('bry', 'baru1267'), ('brz', 'birr1240'), ('bse', 'cent2194'), ('bsh', 'bush1247'), ('bsi', 'siwi1239'),
    ('bsk', 'bash1264'), ('bsl', 'brit1235'), ('bsm', 'bisl1239'), ('bso', 'basq1250'), ('bsq', 'basq1248'),
    ('bsr', 'bass1258'), ('bth', 'bath1244'), ('bti', 'beto1236'), ('btk', 'cent2083'), ('bto', 'bata1289'),
    ('bua', 'bura1267'), ('bub', 'bube1242'), ('bud', 'budu1265'), ('bug', 'bugi1244'), ('bui', 'buli1255'),
    ('buj', 'kwas1243'), ('buk', 'buku1249'), ('bul', 'bulg1262'), ('bum', 'tean1237'), ('bun', 'tere1278'),
    ('bur', 'buru1296'), ('bus', 'busa1253'), ('but', 'mong1330'), ('buu', 'buru1303'), ('buw', 'bulu1251'),
    ('buy', 'buli1254'), ('bvi', 'bali1280'), ('bwa', 'band1339'), ('bwc', 'west2560'), ('bxj', 'bayu1240'),
    ('bya', 'byan1241'), ('bys', 'bais1246'), ('byu', 'band1339'), ('bzi', 'bauz1241'), ('cab', 'cabe1245'),
    ('cac', 'cacu1241'), ('cad', 'cadd1256'), ('cah', 'cahu1264'), ('cai', 'suri1267'), ('cak', 'kaqc1274'),
    ('cam', 'cams1241'), ('can', 'cand1248'), ('cap', 'capa1241'), ('car', 'gali1262'), ('cas', 'cash1251'),
    ('cat', 'embe1260'), ('cav', 'cavi1250'), ('cax', 'asha1243'), ('cay', 'chac1249'), ('cba', 'barb1263'),
    ('cbo', 'chac1251'), ('cch', 'choc1279'), ('cck', 'chic1270'), ('ccm', 'coma1246'), ('cco', 'tutu1242'),
    ('ccp', 'coco1261'), ('cct', 'choc1276'), ('cde', 'maqu1238'), ('cea', 'swam1239'), ('ceb', 'cebu1242'),
    ('cec', 'chic1271'), ('cem', 'cemu1238'), ('cga', 'moch1256'), ('cha', 'cham1312'), ('chb', 'cham1313'),
    ('chc', 'chec1245'), ('chd', 'chau1259'), ('che', 'cher1273'), ('chg', 'chan1313'), ('chh', 'seba1251'),
    ('chi', 'chim1301'), ('chj', 'chuj1249'), ('chk', 'chuk1273'), ('chl', 'uppe1439'), ('chm', 'cham1309'),
    ('chn', 'chan1310'), ('cho', 'high1242'), ('chp', 'chip1261'), ('chq', 'quio1240'), ('chr', 'chra1242'),
    ('chs', 'siyi1240'), ('cht', 'nopa1235'), ('chu', 'niva1238'), ('chv', 'chuv1255'), ('chw', 'west2650'),
    ('chx', 'lowl1260'), ('chy', 'chay1248'), ('chz', 'minn1241'), ('cic', 'nyan1308'), ('cil', 'luba1249'),
    ('cin', 'ines1240'), ('cjo', 'chic1272'), ('ckh', 'chek1238'), ('ckl', 'chin1286'), ('ckr', 'cane1242'),
    ('ckr', 'krah1246'), ('cku', 'wasc1239'), ('cla', 'clal1241'), ('clc', 'cola1237'), ('cld', 'chal1275'),
    ('cle', 'leal1235'), ('cln', 'chil1275'), ('cln', 'chol1284'), ('cly', 'chul1246'), ('cma', 'chim1309'),
    ('cmc', 'come1251'), ('cme', 'east2563'), ('cmh', 'utes1238'), ('cmk', 'chim1310'), ('cml', 'caml1239'),
    ('cmn', 'coma1245'), ('cmr', 'mara1382'), ('cmx', 'como1259'), ('cmy', 'taba1266'), ('cnl', 'cane1242'),
    ('cnm', 'kana1291'), ('cnt', 'yuec1235'), ('coa', 'coah1252'), ('coc', 'coca1259'), ('coe', 'coeu1236'),
    ('cof', 'cofa1242'), ('cog', 'cogu1240'), ('coi', 'chor1273'), ('col', 'chol1281'), ('com', 'maor1244'),
    ('coo', 'coos1249'), ('cop', 'copt1239'), ('cor', 'elna1235'), ('cos', 'nort2969'), ('cos', 'sout2986'),
    ('cpa', 'ashe1273'), ('cpl', 'pala1351'), ('cpn', 'chep1245'), ('cpw', 'chip1241'), ('cpy', 'chip1262'),
    ('cqt', 'chiq1248'), ('cre', 'plai1258'), ('crg', 'east2555'), ('crh', 'chru1239'), ('cri', 'crim1257'),
    ('crj', 'cari1279'), ('crk', 'cree1270'), ('crl', 'caro1242'), ('crn', 'corn1251'), ('cro', 'crow1244'),
    ('crp', 'cara1272'), ('crq', 'carr1249'), ('crt', 'chor1274'), ('csc', 'soch1239'), ('csf', 'usil1237'),
    ('csh', 'cash1254'), ('csk', 'jola1262'), ('csl', 'chin1283'), ('cso', 'west2644'), ('ctc', 'cuic1234'),
    ('cte', 'tepe1279'), ('cti', 'tedi1235'), ('ctl', 'stan1289'), ('ctm', 'chit1248'), ('ctt', 'tata1258'),
    ('ctw', 'cata1286'), ('cua', 'cuaa1241'), ('cub', 'cube1242'), ('cuc', 'timo1237'), ('cui', 'cuib1242'),
    ('cul', 'culi1244'), ('cum', 'chum1261'), ('cup', 'cupe1243'), ('cur', 'curr1243'), ('cut', 'cuit1236'),
    ('cuu', 'chuu1238'), ('cvc', 'chav1241'), ('cve', 'chua1250'), ('cwe', 'colu1241'), ('cya', 'west2644'),
    ('cyg', 'cayu1261'), ('cyn', 'chey1247'), ('cyv', 'cayu1262'), ('cze', 'czec1258'), ('daa', 'daak1235'),
    ('dab', 'maza1304'), ('dab', 'nucl1683'), ('dad', 'dadi1250'), ('dag', 'daga1275'), ('dah', 'daha1245'),
    ('dak', 'dako1258'), ('dam', 'mala1522'), ('dan', 'dann1241'), ('dar', 'dara1250'), ('dat', 'dato1239'),
    ('daw', 'daww1239'), ('day', 'dayy1236'), ('dbd', 'tait1250'), ('dbr', 'dutc1256'), ('dbw', 'dann1241'),
    ('dca', 'casi1235'), ('dda', 'dhuw1249'), ('ddf', 'darf1239'), ('ddj', 'godi1239'), ('dds', 'donn1238'),
    ('def', 'defa1248'), ('deg', 'dege1246'), ('den', 'deni1241'), ('der', 'dera1245'), ('des', 'desa1247'),
    ('det', 'shua1254'), ('deu', 'deor1238'), ('dga', 'sout2789'), ('dgb', 'dagb1246'), ('dge', 'germ1281'),
    ('dgi', 'indo1311'), ('dgo', 'dong1290'), ('dgr', 'daur1238'), ('dgx', 'dege1248'), ('dha', 'daas1238'),
    ('dhb', 'baya1257'), ('dhi', 'dhiv1236'), ('dhl', 'dhal1245'), ('dhm', 'dhim1246'), ('dhr', 'dhar1247'),
    ('dhu', 'dhur1239'), ('dhw', 'thur1254'), ('did', 'didi1258'), ('die', 'kumi1248'), ('dig', 'diga1241'),
    ('dim', 'dime1235'), ('din', 'nort2815'), ('dio', 'jola1263'), ('diy', 'dier1241'), ('diz', 'dizi1235'),
    ('dja', 'dyaa1242'), ('dji', 'djin1251'), ('djm', 'djam1256'), ('djn', 'djin1253'), ('djp', 'dhuw1249'),
    ('djr', 'jaru1254'), ('dli', 'dutc1256'), ('dlm', 'dera1245'), ('dma', 'duma1253'), ('dmi', 'dumi1241'),
    ('dmk', 'doma1260'), ('dms', 'dima1251'), ('dng', 'ding1239'), ('dni', 'lowe1415'), ('dnw', 'dang1274'),
    ('dob', 'dobe1238'), ('dok', 'ngom1268'), ('dol', 'dolg1241'), ('dom', 'doma1258'), ('don', 'nort2735'),
    ('don', 'sout2741'), ('dou', 'dout1240'), ('doy', 'doya1240'), ('dre', 'dehu1237'), ('drg', 'darg1241'),
    ('dri', 'dari1249'), ('drm', 'darm1243'), ('dsh', 'dani1285'), ('dts', 'toro1252'), ('dua', 'dual1243'),
    ('dug', 'gaww1239'), ('duk', 'huns1239'), ('dul', 'drun1238'), ('dum', 'vani1248'), ('dun', 'duna1248'),
    ('dut', 'dutc1256'), ('duz', 'zeeu1238'), ('dyi', 'dyir1250'), ('dym', 'djim1235'), ('dyu', 'dyul1238'),
    ('ebi', 'ebir1243'), ('edo', 'edol1239'), ('efi', 'efik1245'), ('ega', 'egaa1242'), ('egn', 'enge1239'),
    ('eip', 'eipo1242'), ('eja', 'ejag1239'), ('eka', 'ekar1243'), ('eko', 'koti1238'), ('els', 'else1239'),
    ('emb', 'nort2972'), ('emc', 'embe1262'), ('eme', 'emer1243'), ('eml', 'emba1238'), ('emm', 'amii1238'),
    ('ena', 'enga1252'), ('ene', 'enet1250'), ('eng', 'stan1293'), ('eno', 'engg1245'), ('eny', 'enya1247'),
    ('epe', 'epen1239'), ('erk', 'sout2856'), ('err', 'siee1239'), ('ese', 'esee1248'), ('esm', 'atac1235'),
    ('ess', 'esse1238'), ('est', 'esto1258'), ('ets', 'yekh1238'), ('eud', 'opat1246'), ('eve', 'even1259'),
    ('evn', 'even1260'), ('ewa', 'ewee1241'), ('ewe', 'ewee1241'), ('ewo', 'ewon1239'), ('eya', 'eyak1241'),
    ('far', 'faro1244'), ('fas', 'fasu1242'), ('fbf', 'west2454'), ('fea', 'east2288'), ('fef', 'fefe1239'),
    ('fgo', 'adam1253'), ('fgu', 'pula1262'), ('fij', 'fiji1243'), ('fin', 'finn1318'), ('fio', 'koon1244'),
    ('fiw', 'west2519'), ('fli', 'west2454'), ('fma', 'pula1263'), ('fni', 'nige1253'), ('fno', 'nort2626'),
    ('foe', 'foii1241'), ('fon', 'fonn1241'), ('for', 'fore1270'), ('fox', 'mesk1242'), ('fqs', 'fass1245'),
    ('frd', 'ford1242'), ('fre', 'stan1290'), ('fri', 'east2288'), ('frw', 'west2354'), ('fsl', 'finn1310'),
    ('fua', 'adam1253'), ('fue', 'east2447'), ('ful', 'fuln1247'), ('fum', 'maas1239'), ('fur', 'furr1244'),
    ('fus', 'pula1263'), ('fut', 'futu1245'), ('fuz', 'mind1253'), ('fye', 'fyam1238'), ('ga', 'gaaa1244'),
    ('gaa', 'gaga1251'), ('gad', 'gade1242'), ('gae', 'scot1245'), ('gag', 'gaga1249'), ('gah', 'alek1238'),
    ('gal', 'damu1236'), ('gam', 'gamo1244'), ('gan', 'apuc1241'), ('gap', 'gapa1238'), ('gar', 'garo1247'),
    ('gau', 'bava1246'), ('gav', 'gavi1246'), ('gay', 'gayo1244'), ('gba', 'bava1246'), ('gbb', 'gbay1287'),
    ('gbc', 'uppe1455'), ('gbe', 'swis1247'), ('gbk', 'nort2775'), ('gbl', 'stan1295'), ('gcy', 'mode1248'),
    ('gdb', 'bodo1267'), ('gdf', 'gudu1252'), ('gdi', 'godi1239'), ('gdk', 'pott1240'), ('gdl', 'guad1242'),
    ('gdr', 'gida1247'), ('gds', 'gads1258'), ('gel', 'gela1263'), ('geo', 'nucl1302'), ('ger', 'stan1295'),
    ('gfr', 'guia1246'), ('ggd', 'guga1239'), ('ggu', 'gure1255'), ('gha', 'stan1295'), ('ghb', 'guah1255'),
    ('gho', 'ghot1243'), ('ghr', 'gahr1239'), ('gid', 'band1339'), ('gil', 'gila1241'), ('gim', 'benc1235'),
    ('gir', 'gula1265'), ('git', 'gitx1241'), ('giz', 'maro1246'), ('gji', 'guri1247'), ('gjj', 'guaj1255'),
    ('gku', 'puel1244'), ('gla', 'gela1261'), ('glc', 'gali1258'), ('gll', 'gale1259'), ('gln', 'goli1247'),
    ('glp', 'dhan1270'), ('gma', 'stan1295'), ('gmb', 'guam1248'), ('gml', 'gami1243'), ('gmt', 'guma1253'),
    ('gmw', 'guma1254'), ('gmz', 'gumu1244'), ('gna', 'guan1268'), ('gnb', 'kunb1251'), ('gnd', 'gaan1243'),
    ('gnn', 'kwin1241'), ('gno', 'guan1269'), ('gny', 'guny1241'), ('goa', 'wayu1243'), ('god', 'ghod1238'),
    ('goe', 'goem1240'), ('gog', 'gogo1265'), ('goj', 'guja1253'), ('gok', 'goka1239'), ('gol', 'gola1255'),
    ('gon', 'nort2702'), ('gon', 'sout2711'), ('goo', 'goon1238'), ('gor', 'goro1270'), ('gos', 'swis1247'),
    ('gpz', 'swis1247'), ('grb', 'barc1235'), ('gre', 'kala1399'), ('grf', 'gari1256'), ('grg', 'gura1252'),
    ('grj', 'huar1255'), ('grk', 'mode1248'), ('grm', 'gour1243'), ('grn', 'fare1241'), ('gro', 'guro1248'),
    ('grp', 'kols1241'), ('grr', 'gara1261'), ('grs', 'garu1246'), ('grt', 'goro1259'), ('grw', 'kala1399'),
    ('gsl', 'gree1271'), ('gso', 'kala1399'), ('gtg', 'swis1247'), ('gth', 'stan1295'), ('gti', 'stan1295'),
    ('gto', 'guat1253'), ('gua', 'para1311'), ('gud', 'gude1246'), ('gue', 'guer1240'), ('guf', 'gupa1247'),
    ('gug', 'koka1244'), ('guh', 'guhu1244'), ('guj', 'guja1252'), ('gul', 'gula1269'), ('gum', 'kumb1268'),
    ('gun', 'nugu1242'), ('guq', 'cari1279'), ('gur', 'guru1261'), ('gus', 'gusi1247'), ('gut', 'gour1243'),
    ('guu', 'gugu1255'), ('guw', 'gunn1250'), ('gvi', 'bava1246'), ('gwa', 'gbag1258'), ('gwa', 'gbar1246'),
    ('gwe', 'west2356'), ('gwo', 'tyap1238'), ('gyb', 'guay1257'), ('gyc', 'jiar1239'), ('gzu', 'swis1247'),
    ('had', 'hadz1240'), ('hai', 'haid1248'), ('hak', 'hakk1236'), ('hal', 'hali1244'), ('ham', 'hamt1247'),
    ('han', 'hani1248'), ('har', 'haru1245'), ('hat', 'hata1243'), ('hau', 'haus1257'), ('hav', 'hava1248'),
    ('haw', 'hawa1245'), ('hay', 'wayu1241'), ('hba', 'hebr1245'), ('hcr', 'hait1244'), ('hdi', 'hdii1240'),
    ('heb', 'hebr1245'), ('heh', 'hehe1240'), ('hei', 'heil1246'), ('hem', 'hemb1242'), ('her', 'here1253'),
    ('hhu', 'hang1263'), ('hia', 'cari1279'), ('hid', 'hida1246'), ('hil', 'hili1240'), ('hin', 'hind1269'),
    ('hix', 'hixk1239'), ('hks', 'hong1241'), ('hlb', 'halb1244'), ('hli', 'halk1245'), ('hln', 'hala1252'),
    ('hlp', 'hava1248'), ('hlu', 'halk1245'), ('hma', 'hmar1241'), ('hmb', 'huam1247'), ('hmd', 'hmon1333'),
    ('hmi', 'mini1256'), ('hmo', 'huam1250'), ('hmr', 'hame1242'), ('hmu', 'nupo1240'), ('hna', 'mina1276'),
    ('hnd', 'hund1239'), ('hnk', 'hinu1240'), ('hnn', 'hanu1241'), ('hno', 'nort2938'), ('ho', 'hooo1248'),
    ('hoa', 'hoav1238'), ('hok', 'minn1241'), ('hol', 'holo1240'), ('hop', 'hopi1249'), ('hpd', 'hupd1244'),
    ('hre', 'hree1244'), ('hrr', 'hara1271'), ('hrs', 'hars1241'), ('hsl', 'hais1244'), ('htc', 'huas1256'),
    ('htt', 'mini1256'), ('hua', 'yaga1260'), ('huc', 'huaa1248'), ('hui', 'huic1243'), ('hum', 'muru1274'),
    ('hun', 'hung1274'), ('hup', 'hupa1239'), ('hve', 'sanm1287'), ('hwc', 'hawa1247'), ('hwr', 'gura1251'),
    ('hya', 'haya1250'), ('hyo', 'asho1236'), ('hzb', 'hunz1247'), ('iaa', 'iaai1238'), ('iat', 'iatm1242'),
    ('iau', 'iauu1242'), ('iba', 'iban1264'), ('ibi', 'ibib1240'), ('ibn', 'iban1267'), ('ice', 'icel1247'),
    ('ics', 'icel1236'), ('idn', 'idun1242'), ('ido', 'idom1241'), ('idu', 'idum1241'), ('ifi', 'ital1282'),
    ('ifm', 'teke1274'), ('ifu', 'bata1298'), ('iga', 'inga1252'), ('igb', 'nucl1417'), ('ige', 'iged1239'),
    ('ign', 'igna1246'), ('igs', 'gaam1241'), ('iha', 'ihaa1241'), ('iir', 'papu1250'), ('ijo', 'izon1238'),
    ('ik', 'ikkk1242'), ('ika', 'arhu1242'), ('ila', 'ilaa1246'), ('ill', 'miam1252'), ('ilo', 'ilok1237'),
    ('imo', 'imon1245'), ('ina', 'suab1238'), ('ind', 'indo1316'), ('ing', 'ingu1240'), ('inj', 'indo1316'),
    ('inn', 'yand1253'), ('inr', 'west2618'), ('ins', 'east2534'), ('inu', 'nort2943'), ('ipi', 'indi1237'),
    ('ipk', 'paki1242'), ('iql', 'east2534'), ('iqu', 'iqui1243'), ('ird', 'iris1253'), ('iri', 'iris1253'),
    ('irm', 'iris1253'), ('irq', 'iraq1241'), ('irr', 'irar1238'), ('irs', 'iris1235'), ('irx', 'iran1263'),
    ('isa', 'kris1246'), ('ise', 'isek1239'), ('ish', 'sang1316'), ('isi', 'isir1237'), ('isl', 'inte1259'),
    ('isn', 'isna1241'), ('iso', 'isok1239'), ('iss', 'isra1236'), ('ita', 'ital1282'), ('itb', 'emil1242'),
    ('ite', 'itel1242'), ('itg', 'ligu1248'), ('itn', 'neap1235'), ('ito', 'iton1250'), ('itu', 'piem1238'),
    ('itw', 'itaw1240'), ('itz', 'itza1241'), ('iva', 'ivat1242'), ('ivs', 'ivat1242'), ('iwa', 'iwai1244'),
    ('iwm', 'iwam1256'), ('ixc', 'ixca1245'), ('ixi', 'ixil1250'), ('izh', 'ingr1248'), ('izi', 'izie1238'),
    ('jab', 'yabe1254'), ('jad', 'tibe1272'), ('jah', 'jeha1242'), ('jak', 'jaka1246'), ('jak', 'popt1235'),
    ('jam', 'djam1255'), ('jaq', 'jaqa1244'), ('jar', 'jara1263'), ('jav', 'java1254'), ('jbt', 'djeo1235'),
    ('jcr', 'jama1262'), ('jeb', 'jebe1250'), ('jeh', 'jehh1245'), ('jel', 'jeri1242'), ('jem', 'jeme1245'),
    ('jia', 'jiar1239'), ('jib', 'sheh1240'), ('jin', 'jino1236'), ('jiv', 'shua1257'), ('jlu', 'luwo1239'),
    ('jmm', 'jama1261'), ('jmo', 'jurm1239'), ('jms', 'jams1239'), ('jng', 'kach1280'), ('jom', 'talo1250'),
    ('jpn', 'nucl1643'), ('jpr', 'japr1238'), ('jrn', 'juru1256'), ('jrw', 'jara1245'), ('jug', 'tase1235'),
    ('juh', 'juho1239'), ('juk', 'juku1254'), ('jum', 'juma1249'), ('jun', 'juan1238'), ('jur', 'jurc1239'),
    ('jva', 'kara1500'), ('jwr', 'jama1261'), ('kaa', 'karo1305'), ('kab', 'kaba1278'), ('kac', 'kach1279'),
    ('kad', 'katc1249'), ('kae', 'kaki1249'), ('kag', 'kome1238'), ('kai', 'kaia1245'), ('kaj', 'kaur1271'),
    ('kak', 'kama1370'), ('kal', 'kala1373'), ('kam', 'kamb1299'), ('kan', 'khan1278'), ('kao', 'kara1487'),
    ('kap', 'kela1255'), ('kaq', 'kaur1267'), ('kar', 'kara1482'), ('kas', 'kash1277'), ('kat', 'kate1253'),
    ('kau', 'kaul1240'), ('kaw', 'kaiw1246'), ('kay', 'kaya1319'), ('kaz', 'kaza1248'), ('kba', 'kamb1297'),
    ('kbi', 'inpu1234'), ('kbl', 'kaby1243'), ('kbo', 'apma1241'), ('kbr', 'bara1370'), ('kbt', 'kaba1276'),
    ('kbu', 'kane1243'), ('kbw', 'bwek1238'), ('kby', 'kabi1261'), ('kch', 'koyr1240'), ('kda', 'kond1295'),
    ('kdg', 'kari1317'), ('kdw', 'kadi1248'), ('kdz', 'coas1294'), ('kea', 'qanj1241'), ('ked', 'keda1252'),
    ('kef', 'kafa1242'), ('kei', 'keii1239'), ('kek', 'kekc1242'), ('kel', 'kele1258'), ('kem', 'qima1242'),
    ('ken', 'keng1240'), ('keo', 'keoo1238'), ('ker', 'kera1255'), ('ket', 'kett1243'), ('kew', 'kewa1250'),
    ('kfe', 'koro1298'), ('kfy', 'kirg1245'), ('kga', 'nucl1379'), ('kgi', 'wame1240'), ('kgl', 'umbu1258'),
    ('kgm', 'kago1247'), ('kgr', 'kagu1239'), ('kgt', 'west2618'), ('kgu', 'kalk1246'), ('kgy', 'kyer1238'),
    ('kgz', 'kirg1245'), ('kha', 'halh1238'), ('khd', 'kham1282'), ('khg', 'khal1275'), ('khi', 'khin1240'),
    ('khk', 'khak1248'), ('khl', 'turk1303'), ('khm', 'cent1989'), ('khn', 'khun1259'), ('kho', 'nama1264'),
    ('khr', 'khar1287'), ('khs', 'khas1269'), ('khu', 'khum1248'), ('khv', 'khva1239'), ('khw', 'khow1242'),
    ('kic', 'kick1244'), ('kie', 'kire1240'), ('kij', 'kitj1240'), ('kik', 'kiku1240'), ('kil', 'luba1250'),
    ('kim', 'kima1246'), ('kin', 'kiny1244'), ('kio', 'kiow1266'), ('kiq', 'kalm1243'), ('kir', 'cerm1238'),
    ('kis', 'kiss1245'), ('kit', 'kits1249'), ('kiu', 'kuii1253'), ('kiw', 'nort2930'), ('kiw', 'sout2949'),
    ('kje', 'kore1283'), ('kji', 'nort2641'), ('kjn', 'kunj1245'), ('kjo', 'coas1295'), ('kjr', 'koor1239'),
    ('kkb', 'konk1269'), ('kkl', 'beng1239'), ('kkn', 'konk1267'), ('kko', 'kura1250'), ('kkp', 'kara1467'),
    ('kkq', 'kuik1246'), ('kkr', 'kiri1256'), ('kkt', 'koko1269'), ('kku', 'kork1243'), ('kkv', 'lusi1240'),
    ('kkw', 'kara1289'), ('kky', 'kank1243'), ('kkz', 'kukn1238'), ('kla', 'klao1243'), ('klb', 'huba1236'),
    ('klg', 'kulu1253'), ('klh', 'kala1372'), ('kli', 'ledo1238'), ('klk', 'kuoo1238'), ('kll', 'kalu1248'),
    ('klm', 'klam1254'), ('kln', 'wers1238'), ('klp', 'kala1400'), ('klq', 'kala1397'), ('klr', 'shah1254'),
    ('kls', 'kali1308'), ('klt', 'kela1258'), ('klv', 'kili1267'), ('klw', 'kili1268'), ('kly', 'kala1377'),
    ('klz', 'kala1384'), ('kma', 'kama1373'), ('kmb', 'ndei1235'), ('kmh', 'gama1251'), ('kmi', 'kami1256'),
    ('kmj', 'kara1483'), ('kmk', 'kalm1243'), ('kmn', 'kuma1280'), ('kmo', 'moun1252'), ('kmp', 'kuni1267'),
    ('kmr', 'kamo1255'), ('kms', 'kama1351'), ('kmt', 'kemt1242'), ('kmu', 'khmu1256'), ('kmw', 'kamu1258'),
    ('kmz', 'kama1367'), ('kna', 'kari1311'), ('knb', 'badi1247'), ('knc', 'kuku1280'), ('knd', 'nucl1305'),
    ('kng', 'kain1272'), ('kni', 'konn1242'), ('knk', 'dera1248'), ('knm', 'kuna1268'), ('knn', 'kinn1249'),
    ('kno', 'kano1245'), ('knp', 'ngka1235'), ('knq', 'krio1252'), ('knr', 'cent2050'), ('knu', 'rapo1238'),
    ('knw', 'nort2951'), ('knz', 'kham1282'), ('koa', 'koas1236'), ('kob', 'kobo1249'), ('kod', 'koda1255'),
    ('koe', 'kweg1241'), ('koh', 'kohu1244'), ('koi', 'gras1249'), ('kok', 'kokb1239'), ('kol', 'kola1242'),
    ('kom', 'komo1258'), ('kon', 'koon1244'), ('koo', 'kola1285'), ('kop', 'komi1269'), ('kor', 'kore1280'),
    ('kos', 'kosr1238'), ('kot', 'kota1263'), ('kou', 'komc1235'), ('kow', 'winy1241'), ('koy', 'koya1251'),
    ('kpa', 'kpan1246'), ('kpe', 'libe1247'), ('kpm', 'pamp1243'), ('kpn', 'kapi1249'), ('kpo', 'ikpo1238'),
    ('kpw', 'east2341'), ('kqq', 'kren1239'), ('kra', 'kara1486'), ('krb', 'gilb1244'), ('krc', 'kara1465'),
    ('krd', 'nort2641'), ('kre', 'gbay1288'), ('krf', 'kora1294'), ('krg', 'shon1251'), ('krh', 'krah1246'),
    ('kri', 'kari1255'), ('krj', 'kara1476'), ('krk', 'karo1304'), ('krl', 'kare1335'), ('krm', 'kara1464'),
    ('krn', 'kora1292'), ('kro', 'kron1241'), ('krq', 'kere1280'), ('krr', 'kair1263'), ('krt', 'kara1474'),
    ('krw', 'koro1312'), ('kry', 'kory1246'), ('krz', 'kryt1240'), ('ksa', 'east1472'), ('kse', 'koyr1242'),
    ('ksg', 'sgaw1245'), ('ksh', 'kash1280'), ('ksi', 'puoc1238'), ('ksl', 'keny1241'), ('ksm', 'kase1253'),
    ('ksn', 'suoy1242'), ('ksp', 'kimm1246'), ('ksr', 'kisa1266'), ('kss', 'sout2778'), ('ksu', 'kash1274'),
    ('kta', 'koit1244'), ('ktb', 'kitu1246'), ('ktc', 'katc1249'), ('kte', 'kete1252'), ('kth', 'gwic1235'),
    ('kti', 'yong1280'), ('ktk', 'afad1236'), ('ktl', 'katl1237'), ('ktn', 'kete1254'), ('kto', 'kato1244'),
    ('ktp', 'mala1479'), ('ktt', 'kott1239'), ('ktu', 'nucl1297'), ('kty', 'khan1273'), ('ktz', 'kati1270'),
    ('kug', 'mand1415'), ('kui', 'kuii1252'), ('kuk', 'bari1284'), ('kul', 'gamo1244'), ('kum', 'kuma1273'),
    ('kun', 'bord1248'), ('kuo', 'kuot1243'), ('kuq', 'kumy1244'), ('kur', 'kuru1302'), ('kus', 'kusu1250'),
    ('kut', 'kute1249'), ('kuu', 'kuuk1238'), ('kuv', 'kuvi1243'), ('kuy', 'teng1267'), ('kuz', 'mati1250'),
    ('kwa', 'kwai1243'), ('kwb', 'nucl1595'), ('kwe', 'west2635'), ('kwk', 'kwak1269'), ('kwm', 'kwaa1269'),
    ('kwn', 'kwan1273'), ('kwo', 'kwom1262'), ('kwr', 'kwam1252'), ('kws', 'kawa1283'), ('kwt', 'nucl1593'),
    ('kwy', 'sans1272'), ('kwz', 'kwaz1243'), ('kxo', 'kxoe1243'), ('kya', 'kuku1273'), ('kyg', 'keny1279'),
    ('kyk', 'kyak1244'), ('kyl', 'east2342'), ('kym', 'nort2690'), ('kyn', 'koyu1237'), ('kyo', 'kany1247'),
    ('kyp', 'kaya1330'), ('kyq', 'noot1239'), ('kyr', 'kark1258'), ('kyt', 'kayt1238'), ('kyz', 'kaya1329'),
    ('kzh', 'nort2735'), ('kzy', 'komi1268'), ('laa', 'laal1242'), ('lab', 'labu1248'), ('lac', 'laca1243'),
    ('lad', 'lada1244'), ('laf', 'lafo1243'), ('lag', 'lagw1237'), ('lah', 'lahu1253'), ('lai', 'haka1240'),
    ('lak', 'lakk1252'), ('lal', 'xish1235'), ('lam', 'peve1243'), ('lan', 'lang1324'), ('lao', 'laoo1244'),
    ('lar', 'lara1258'), ('lat', 'latv1249'), ('lau', 'lauu1247'), ('lav', 'lavu1241'), ('laz', 'lazz1240'),
    ('lbu', 'lund1266'), ('lch', 'lach1248'), ('lcr', 'guad1242'), ('lcr', 'sain1246'), ('lda', 'gand1255'),
    ('ldn', 'ladi1250'), ('ldo', 'orok1266'), ('ldu', 'lend1245'), ('leb', 'ngel1238'), ('lec', 'leco1242'),
    ('leg', 'lega1249'), ('leg', 'lega1250'), ('lel', 'lele1276'), ('len', 'lena1238'), ('lep', 'lepc1244'),
    ('les', 'lese1243'), ('let', 'leti1246'), ('lew', 'lewo1242'), ('lez', 'lezg1247'), ('lga', 'onto1237'),
    ('lge', 'nort2627'), ('lgi', 'lang1320'), ('lgp', 'port1277'), ('lgt', 'logo1259'), ('lgu', 'long1395'),
    ('lha', 'laha1250'), ('lho', 'lhom1239'), ('lic', 'hlai1239'), ('lii', 'ital1275'), ('lil', 'lill1248'),
    ('lim', 'limb1266'), ('lin', 'ling1263'), ('lis', 'lisu1250'), ('lit', 'lith1251'), ('liv', 'livv1244'),
    ('lje', 'lauj1238'), ('lkk', 'lakk1238'), ('lkt', 'lako1247'), ('lla', 'lamu1254'), ('llm', 'lele1264'),
    ('lma', 'loma1260'), ('lmb', 'lamb1271'), ('lmg', 'lama1288'), ('lmh', 'lama1277'), ('lml', 'nucl1327'),
    ('lmn', 'lamb1269'), ('lmp', 'lamp1243'), ('lmu', 'lame1260'), ('lnd', 'band1344'), ('lng', 'leng1262'),
    ('lnj', 'leni1238'), ('lno', 'ladi1251'), ('lns', 'lamn1239'), ('lnw', 'lonw1238'), ('lob', 'lobi1245'),
    ('lok', 'loko1255'), ('lon', 'loni1238'), ('lot', 'loth1237'), ('lou', 'louu1245'), ('lov', 'lave1248'),
    ('loz', 'lozi1239'), ('lrd', 'lard1243'), ('lrk', 'lari1255'), ('lsa', 'arge1236'), ('lsb', 'braz1236'),
    ('lse', 'span1263'), ('lsf', 'fren1243'), ('lsq', 'queb1245'), ('lu', 'luuu1242'), ('lua', 'niel1243'),
    ('luc', 'luch1239'), ('lud', 'lund1271'), ('lug', 'lugb1240'), ('lui', 'luis1253'), ('lul', 'lule1238'),
    ('lum', 'stra1244'), ('lun', 'tase1235'), ('luo', 'luok1236'), ('lur', 'nort2645'), ('lus', 'lush1252'),
    ('luv', 'luva1239'), ('lux', 'luxe1241'), ('luy', 'saam1283'), ('lye', 'lyel1241'), ('ma', 'made1252'),
    ('maa', 'masa1300'), ('mab', 'maba1277'), ('mac', 'macu1259'), ('mad', 'madi1260'), ('mae', 'maee1241'),
    ('mag', 'east2352'), ('mah', 'west2392'), ('mai', 'mait1250'), ('maj', 'maja1242'), ('mak', 'maka1318'),
    ('mal', 'plat1254'), ('mam', 'mamc1234'), ('man', 'mann1248'), ('mao', 'maor1246'), ('map', 'mapu1245'),
    ('mar', 'mari1440'), ('mas', 'masa1322'), ('mau', 'maun1240'), ('mav', 'mari1435'), ('maw', 'west2500'),
    ('max', 'maxa1247'), ('may', 'maib1239'), ('maz', 'maza1293'), ('mba', 'mbaa1245'), ('mbb', 'mbab1239'),
    ('mbe', 'mber1257'), ('mbg', 'mbug1240'), ('mbi', 'bamb1266'), ('mbl', 'mbol1247'), ('mbm', 'mbum1254'),
    ('mbo', 'nucl1458'), ('mbr', 'mbar1260'), ('mbt', 'mang1394'), ('mbu', 'mana1298'), ('mby', 'mbay1241'),
    ('mbz', 'mbee1250'), ('mca', 'maca1260'), ('mcc', 'moch1259'), ('mcd', 'mace1250'), ('mce', 'beli1260'),
    ('mcf', 'mich1243'), ('mcg', 'maca1259'), ('mch', 'mach1267'), ('mcn', 'macu1260'), ('mco', 'coat1238'),
    ('mcr', 'mori1278'), ('mcs', 'cent2140'), ('mcv', 'moco1246'), ('mda', 'mada1293'), ('mdb', 'mudb1240'),
    ('mde', 'mend1266'), ('mdg', 'mund1325'), ('mdk', 'mand1436'), ('mdl', 'madn1237'), ('mdn', 'mand1446'),
    ('mdo', 'gbay1281'), ('mdr', 'nucl1460'), ('mds', 'mala1481'), ('mdu', 'mund1326'), ('mdw', 'mbos1242'),
    ('mdz', 'mada1282'), ('mea', 'meya1236'), ('meb', 'beta1252'), ('mee', 'meen1242'), ('meh', 'mehr1241'),
    ('mei', 'mani1292'), ('mek', 'saki1248'), ('mel', 'cent2101'), ('mem', 'mane1266'), ('men', 'meno1252'),
    ('mer', 'meri1244'), ('mey', 'meny1245'), ('mga', 'ndun1249'), ('mgd', 'mong1342'), ('mge', 'east2333'),
    ('mgg', 'tuuu1240'), ('mgh', 'maga1260'), ('mgi', 'mail1248'), ('mgk', 'mung1266'), ('mgl', 'ming1252'),
    ('mgn', 'magu1243'), ('mgo', 'mong1338'), ('mgq', 'mang1398'), ('mgu', 'musg1254'), ('mhc', 'mohe1244'),
    ('mhi', 'mara1378'), ('mhk', 'mehe1243'), ('mhl', 'misi1242'), ('mhm', 'besi1244'), ('mhu', 'mbal1255'),
    ('mic', 'mikm1235'), ('mid', 'mido1240'), ('mie', 'iumi1238'), ('mig', 'miga1249'), ('mii', 'tama1331'),
    ('mij', 'miju1243'), ('mik', 'karb1241'), ('mil', 'damu1236'), ('min', 'mina1268'), ('mir', 'miri1266'),
    ('mis', 'misk1235'), ('mit', 'mitu1240'), ('miy', 'miya1266'), ('miz', 'lush1249'), ('mja', 'jami1235'),
    ('mjc', 'sanj1281'), ('mjk', 'mand1419'), ('mka', 'maho1249'), ('mkb', 'coas1301'), ('mkd', 'mako1251'),
    ('mke', 'meke1243'), ('mkg', 'mand1436'), ('mki', 'mika1239'), ('mkj', 'maka1316'), ('mkl', 'makl1246'),
    ('mkn', 'mank1251'), ('mko', 'muku1242'), ('mkq', 'ngem1255'), ('mkr', 'arua1260'), ('mks', 'maka1311'),
    ('mku', 'mara1386'), ('mkw', 'maku1246'), ('mkz', 'maka1304'), ('mla', 'came1252'), ('mla', 'nige1255'),
    ('mlc', 'mala1533'), ('mle', 'male1284'), ('mlg', 'wand1278'), ('mli', 'mali1284'), ('mlk', 'mull1237'),
    ('mll', 'mola1238'), ('mlm', 'mlab1235'), ('mlt', 'malt1254'), ('mlu', 'male1289'), ('mly', 'stan1306'),
    ('mma', 'nucl1706'), ('mmb', 'mbul1263'), ('mme', 'east2328'), ('mmi', 'mamb1294'), ('mmn', 'mama1275'),
    ('mmo', 'moks1248'), ('mmp', 'mamp1244'), ('mms', 'mama1276'), ('mmu', 'nege1240'), ('mmv', 'mamv1243'),
    ('mmw', 'mamb1296'), ('mmz', 'mams1234'), ('mna', 'muna1247'), ('mnc', 'manc1252'), ('mnd', 'mand1415'),
    ('mne', 'nort2952'), ('mng', 'mang1405'), ('mni', 'moni1261'), ('mnj', 'mart1256'), ('mnk', 'east2426'),
    ('mnm', 'mana1295'), ('mno', 'mono1275'), ('mnr', 'mand1442'), ('mns', 'mans1258'), ('mnt', 'ment1249'),
    ('mnu', 'kimm1245'), ('mnv', 'mina1269'), ('mnx', 'manx1243'), ('mny', 'marg1253'), ('mnz', 'monz1249'),
    ('moa', 'mono1273'), ('moc', 'shek1244'), ('moe', 'erzy1239'), ('mof', 'mofu1248'), ('mog', 'mogh1245'),
    ('moh', 'moha1258'), ('moj', 'moha1256'), ('mok', 'moki1238'), ('mol', 'roma1327'), ('mom', 'nucl1452'),
    ('mon', 'monn1252'), ('moo', 'moss1236'), ('mop', 'mopa1243'), ('mor', 'morm1235'), ('mos', 'mose1249'),
    ('mot', 'siwa1245'), ('mou', 'moru1253'), ('mov', 'movi1243'), ('mpa', 'murr1258'), ('mpo', 'myen1241'),
    ('mpr', 'maip1246'), ('mpt', 'mian1256'), ('mpu', 'mpur1239'), ('mpy', 'mapo1246'), ('mqc', 'guad1242'),
    ('mqf', 'momu1241'), ('mra', 'mara1385'), ('mrc', 'rong1264'), ('mrd', 'nucl1622'), ('mrg', 'marg1265'),
    ('mrh', 'mari1424'), ('mri', 'moro1289'), ('mrj', 'ngad1258'), ('mrk', 'muri1260'), ('mrl', 'murl1244'),
    ('mrn', 'mara1404'), ('mro', 'moro1285'), ('mrq', 'nort2845'), ('mrq', 'sout2866'), ('mrr', 'mari1419'),
    ('mrs', 'nucl1594'), ('mrt', 'mart1255'), ('mru', 'maru1249'), ('mrw', 'muru1266'), ('msc', 'chib1270'),
    ('mse', 'muns1251'), ('msg', 'misi1242'), ('msh', 'mars1254'), ('msk', 'ngil1242'), ('msl', 'nucl1440'),
    ('msm', 'muso1238'), ('msn', 'mais1250'), ('msq', 'halk1245'), ('mss', 'sout2985'), ('msy', 'west2418'),
    ('mta', 'buka1257'), ('mtb', 'matu1259'), ('mtg', 'mont1268'), ('mth', 'tlah1239'), ('mti', 'bari1297'),
    ('mtk', 'matu1261'), ('mtl', 'matt1238'), ('mto', 'kuma1274'), ('mtp', 'toto1305'), ('mts', 'mati1255'),
    ('mtt', 'wamp1249'), ('mtu', 'motu1246'), ('mua', 'makh1264'), ('mud', 'mund1327'), ('mug', 'barg1252'),
    ('muh', 'seba1251'), ('mui', 'muin1242'), ('mul', 'mula1253'), ('mum', 'nucl1240'), ('mun', 'mund1320'),
    ('muo', 'muon1246'), ('mup', 'mwag1236'), ('mur', 'murs1242'), ('mus', 'muss1246'), ('mut', 'sout2986'),
    ('muu', 'mund1330'), ('muy', 'muyu1244'), ('mwa', 'mart1256'), ('mwb', 'west2555'), ('mwc', 'mawc1242'),
    ('mwe', 'mwer1248'), ('mwl', 'lake1258'), ('mwn', 'nort2968'), ('mwo', 'motl1237'), ('mwp', 'plai1259'),
    ('mxa', 'atat1238'), ('mxc', 'sanm1295'), ('mxe', 'mele1250'), ('mxg', 'sanm1295'), ('mxj', 'pino1237'),
    ('mxl', 'alac1244'), ('mxm', 'sanm1295'), ('mxo', 'ocot1243'), ('mxp', 'peno1244'), ('mxs', 'sila1250'),
    ('mxt', 'ayut1236'), ('mxu', 'chay1249'), ('mxy', 'yoso1239'), ('mxz', 'coat1241'), ('mya', 'maya1282'),
    ('myg', 'mayo1261'), ('myi', 'mang1381'), ('myk', 'mala1479'), ('mym', 'mala1464'), ('myn', 'maan1238'),
    ('myo', 'mayo1264'), ('myr', 'mats1244'), ('myy', 'mayk1239'), ('mzc', 'chiq1250'), ('mzh', 'huau1238'),
    ('mzn', 'maza1291'), ('naa', 'chal1275'), ('nab', 'naba1256'), ('nad', 'nade1244'), ('naf', 'nafa1258'),
    ('nag', 'yale1246'), ('nah', 'niha1238'), ('nai', 'nana1257'), ('naj', 'lish1245'), ('nak', 'naka1262'),
    ('nal', 'nali1244'), ('nam', 'nami1256'), ('nan', 'nand1266'), ('nap', 'lish1246'), ('nar', 'nara1262'),
    ('nas', 'naas1242'), ('nat', 'natc1249'), ('nau', 'naur1243'), ('nav', 'nava1243'), ('nax', 'naxi1245'),
    ('nbb', 'bign1238'), ('nbd', 'kenu1236'), ('nbe', 'ngom1268'), ('nbh', 'ghul1238'), ('nbk', 'natu1249'),
    ('nbm', 'ngba1284'), ('nbo', 'nyam1277'), ('nbr', 'ngab1239'), ('nca', 'carn1240'), ('ncm', 'ntch1242'),
    ('ndb', 'sout2808'), ('nde', 'nand1264'), ('ndg', 'ndog1248'), ('ndi', 'nort2774'), ('ndi', 'sout2784'),
    ('ndj', 'djee1236'), ('ndo', 'ndon1254'), ('ndr', 'fiji1243'), ('ndt', 'ndut1239'), ('ndu', 'ndum1239'),
    ('ndy', 'ndyu1242'), ('ned', 'dutc1253'), ('neg', 'negi1245'), ('neh', 'neha1247'), ('nel', 'kuma1276'),
    ('nen', 'nene1249'), ('nep', 'nepa1252'), ('nev', 'toho1245'), ('new', 'newa1246'), ('ney', 'neyo1238'),
    ('nez', 'nezp1238'), ('nga', 'ngan1291'), ('ngb', 'ngba1285'), ('ngd', 'ngad1261'), ('nge', 'ngem1255'),
    ('ngg', 'nang1259'), ('ngi', 'wang1291'), ('ngj', 'ngad1258'), ('ngk', 'nang1259'), ('ngl', 'ngal1293'),
    ('ngm', 'ngam1268'), ('ngn', 'ngan1295'), ('ngo', 'ngon1269'), ('ngr', 'narr1259'), ('ngt', 'tang1336'),
    ('ngu', 'nort2836'), ('ngw', 'ngaw1240'), ('ngy', 'ngar1235'), ('ngz', 'ngiz1242'), ('nha', 'nhan1238'),
    ('nhc', 'cent2132'), ('nhh', 'huas1257'), ('nhm', 'mich1245'), ('nhn', 'nort2957'), ('nhp', 'poch1244'),
    ('nht', 'tete1251'), ('nhx', 'guer1241'), ('nia', 'nias1242'), ('nic', 'cent1990'), ('nif', 'niua1240'),
    ('nih', 'japa1238'), ('nim', 'nucl1633'), ('nin', 'ning1273'), ('nis', 'nisi1239'), ('nit', 'noot1239'),
    ('niu', 'niue1239'), ('niv', 'gily1242'), ('nju', 'nyun1247'), ('nkb', 'ngal1292'), ('nke', 'nkem1242'),
    ('nkk', 'naka1260'), ('nkn', 'nkon1245'), ('nko', 'chig1238'), ('nkr', 'nuku1260'), ('nkt', 'nyah1250'),
    ('nku', 'kenu1236'), ('nlr', 'ngar1286'), ('nlu', 'ngar1287'), ('nly', 'nyam1271'), ('nma', 'maon1238'),
    ('nmb', 'sout2994'), ('nmd', 'samo1303'), ('nmi', 'isth1242'), ('nmm', 'mana1288'), ('nnc', 'cent1990'),
    ('nnd', 'nend1239'), ('nne', 'neng1238'), ('nng', 'nyan1304'), ('nnk', 'nank1250'), ('nnm', 'tuva1244'),
    ('nnn', 'nort2784'), ('nnt', 'nant1249'), ('nob', 'nobi1240'), ('noc', 'noct1238'), ('nog', 'noga1249'),
    ('nok', 'noga1249'), ('nom', 'noma1263'), ('non', 'noon1243'), ('noo', 'noon1242'), ('nor', 'norw1259'),
    ('npa', 'isth1241'), ('nph', 'narp1239'), ('npi', 'nige1257'), ('npn', 'naga1394'), ('npu', 'napu1241'),
    ('nrg', 'nane1238'), ('nrm', 'naro1251'), ('nro', 'naro1249'), ('nse', 'nsen1242'), ('nsg', 'nisg1240'),
    ('nsk', 'nask1242'), ('nsn', 'nise1244'), ('nsy', 'assy1241'), ('nsz', 'high1278'), ('nte', 'norw1255'),
    ('nti', 'ngit1239'), ('ntj', 'ngaa1240'), ('ntn', 'nate1242'), ('nto', 'ntom1248'), ('ntu', 'nene1249'),
    ('nua', 'nuau1240'), ('nub', 'nubi1253'), ('nue', 'nuer1246'), ('nug', 'nung1290'), ('nuk', 'nuka1242'),
    ('nun', 'nung1283'), ('nup', 'nupe1254'), ('nus', 'nusu1239'), ('nuu', 'noot1239'), ('nvs', 'gily1242'),
    ('nwd', 'newa1246'), ('nya', 'nyaw1247'), ('nyg', 'nyan1313'), ('nyh', 'nyih1240'), ('nyi', 'amas1236'),
    ('nyk', 'tukp1239'), ('nyl', 'nyal1254'), ('nym', 'nyam1276'), ('nyn', 'nyig1240'), ('nyr', 'nyan1301'),
    ('nyu', 'nyul1247'), ('nza', 'nzak1247'), ('nze', 'zeme1240'), ('nzs', 'newz1236'), ('obg', 'ogbr1243'),
    ('obk', 'obok1239'), ('obo', 'obol1243'), ('oca', 'ocai1244'), ('occ', 'occi1239'), ('ocu', 'atzi1235'),
    ('ogb', 'ogbi1239'), ('oi', 'oyyy1238'), ('oir', 'kalm1243'), ('oix', 'ixte1237'), ('oji', 'east2542'),
    ('ojm', 'chip1241'), ('ojs', 'seve1240'), ('oka', 'okan1243'), ('oko', 'adiv1239'), ('oks', 'oksa1245'),
    ('oku', 'okuu1243'), ('olm', 'ngaj1237'), ('olo', 'oloo1241'), ('olu', 'olut1240'), ('oma', 'omag1248'),
    ('omh', 'omah1247'), ('omi', 'omie1241'), ('ond', 'onei1249'), ('one', 'molm1235'), ('ong', 'onge1236'),
    ('onn', 'onon1246'), ('ono', 'onoo1246'), ('ood', 'toho1245'), ('ora', 'emai1241'), ('orb', 'bora1271'),
    ('orc', 'oroc1248'), ('ord', 'peri1253'), ('ore', 'orej1242'), ('orh', 'east2652'), ('ori', 'tega1236'),
    ('ork', 'orok1265'), ('orl', 'orok1267'), ('orm', 'ormu1247'), ('oro', 'orok1269'), ('orw', 'waat1238'),
    ('ory', 'orya1242'), ('osa', 'osag1243'), ('osm', 'quer1236'), ('oss', 'osse1243'), ('otm', 'mezq1235'),
    ('oto', 'iowa1245'), ('otr', 'otor1240'), ('ots', 'east2556'), ('owc', 'west2721'), ('owi', 'owin1240'),
    ('oya', 'nucl1284'), ('paa', 'paaa1242'), ('pac', 'paco1243'), ('pad', 'pado1242'), ('pae', 'paez1247'),
    ('pag', 'pagu1249'), ('pai', 'paiw1248'), ('pak', 'paka1251'), ('pal', 'pala1344'), ('pam', 'cent2145'),
    ('pan', 'panj1256'), ('pap', 'papi1253'), ('par', 'pari1256'), ('pat', 'pate1247'), ('pau', 'paum1247'),
    ('paw', 'pawa1255'), ('pba', 'pima1248'), ('pcm', 'poqo1253'), ('pdp', 'folo1238'), ('pec', 'pech1241'),
    ('pem', 'pemo1248'), ('pen', 'peng1244'), ('per', 'pero1241'), ('pga', 'pila1245'), ('pgl', 'ping1243'),
    ('phl', 'pwon1235'), ('pia', 'piar1243'), ('pil', 'pile1238'), ('pin', 'pint1250'), ('pip', 'pipi1250'),
    ('pir', 'yine1238'), ('pis', 'asue1235'), ('pit', 'pitj1243'), ('pkm', 'poco1241'), ('pkn', 'darl1243'),
    ('pkt', 'poko1263'), ('pla', 'play1240'), ('plb', 'pola1255'), ('plg', 'nucl1291'), ('plh', 'paul1238'),
    ('plk', 'pali1279'), ('plp', 'ngaj1237'), ('plr', 'palo1243'), ('pmc', 'cent2138'), ('pme', 'east2545'),
    ('pmn', 'nort2966'), ('pms', 'paam1238'), ('pna', 'pamo1252'), ('png', 'pang1287'), ('pnn', 'pang1290'),
    ('pno', 'nort2954'), ('pnr', 'enap1235'), ('pnu', 'youn1235'), ('pnx', 'pana1307'), ('pny', 'pany1241'),
    ('poa', 'fwai1237'), ('poc', 'poqo1257'), ('pod', 'park1239'), ('pog', 'pogo1243'), ('poh', 'pohn1238'),
    ('pok', 'rawo1244'), ('pol', 'poli1260'), ('pop', 'mezo1235'), ('por', 'port1283'), ('pot', 'pota1247'),
    ('pow', 'powh1243'), ('ppc', 'piap1246'), ('ppi', 'pitt1247'), ('pra', 'pras1239'), ('prc', 'pare1272'),
    ('prd', 'duru1236'), ('pre', 'asut1235'), ('prh', 'pira1253'), ('pri', 'prin1242'), ('prk', 'puri1258'),
    ('pro', 'occi1239'), ('prs', 'west2369'), ('prt', 'pira1254'), ('psh', 'cent1973'), ('psj', 'sanj1285'),
    ('psl', 'plai1235'), ('psm', 'male1292'), ('pso', 'sout2982'), ('psv', 'coyo1236'), ('psw', 'port1285'),
    ('pta', 'dumb1241'), ('pte', 'pait1244'), ('ptp', 'patp1243'), ('ptt', 'patt1248'), ('ptw', 'wint1259'),
    ('pui', 'puin1248'), ('puk', 'para1301'), ('pul', 'pulu1242'), ('pum', 'pumi1242'), ('pun', 'wadj1254'),
    ('puq', 'puqu1242'), ('pur', 'pure1242'), ('put', 'utes1238'), ('pwn', 'pawn1254'), ('qaf', 'afar1241'),
    ('qan', 'chiq1249'), ('qaw', 'qawa1238'), ('qay', 'ayac1239'), ('qbo', 'boli1262'), ('qca', 'caja1238'),
    ('qch', 'kich1262'), ('qco', 'sout2991'), ('qcu', 'cusc1236'), ('qec', 'chim1302'), ('qhu', 'huam1248'),
    ('qia', 'qian1264'), ('qim', 'imba1240'), ('qta', 'nort2980'), ('que', 'quec1382'), ('qui', 'quil1240'),
    ('qum', 'sipa1247'), ('rad', 'rade1240'), ('rag', 'hano1246'), ('ral', 'ralt1242'), ('ram', 'rama1270'),
    ('rao', 'raoo1244'), ('rap', 'rapa1244'), ('ras', 'tega1236'), ('rav', 'balk1252'), ('raw', 'rawa1265'),
    ('rbg', 'sint1235'), ('rbu', 'balk1252'), ('rej', 'reja1240'), ('rem', 'bond1245'), ('ren', 'rend1243'),
    ('res', 'resi1247'), ('ret', 'tani1257'), ('rga', 'rong1268'), ('rgc', 'jiar1239'), ('rgn', 'nort2994'),
    ('ria', 'rian1263'), ('rik', 'rikb1245'), ('rim', 'nyat1246'), ('rit', 'rita1239'), ('rji', 'raji1240'),
    ('rka', 'vlax1238'), ('rlo', 'vlax1238'), ('rmb', 'remb1249'), ('rmc', 'roma1326'), ('rnd', 'rund1242'),
    ('rng', 'reng1252'), ('rnn', 'renn1242'), ('rnr', 'balt1257'), ('rny', 'nyan1307'), ('rom', 'roma1327'),
    ('ron', 'ronn1241'), ('ror', 'waim1251'), ('rot', 'rotu1241'), ('rov', 'rovi1238'), ('rpa', 'tibe1272'),
    ('rru', 'nyor1246'), ('rsc', 'roma1326'), ('rsh', 'shug1248'), ('rsl', 'russ1255'), ('rsm', 'roma1326'),
    ('rsu', 'roma1326'), ('rti', 'term1237'), ('rtk', 'roto1249'), ('ruk', 'ruka1240'), ('rum', 'rumu1243'),
    ('run', 'rung1258'), ('rus', 'russ1263'), ('rut', 'rutu1240'), ('rwa', 'rawa1267'), ('rwe', 'wels1246'),
    ('ryu', 'cent2126'), ('saa', 'saaa1240'), ('sab', 'saba1265'), ('sae', 'saek1240'), ('sah', 'sahu1245'),
    ('sak', 'saka1289'), ('sal', 'sali1253'), ('sam', 'samo1305'), ('san', 'sang1328'), ('sao', 'saho1246'),
    ('sap', 'sapu1248'), ('sar', 'kapr1245'), ('sav', 'savi1242'), ('saw', 'sabu1255'), ('say', 'sayu1241'),
    ('sba', 'sali1298'), ('sbg', 'bala1311'), ('sch', 'stra1244'), ('scr', 'sout1528'), ('scs', 'sout2674'),
    ('sdh', 'sind1272'), ('sdw', 'sand1273'), ('sea', 'sout2859'), ('seb', 'kups1238'), ('sec', 'seco1241'),
    ('sed', 'seda1262'), ('see', 'taro1264'), ('sel', 'onaa1245'), ('sem', 'sumi1235'), ('sen', 'nucl1396'),
    ('ser', 'seri1257'), ('ses', 'sout2807'), ('sey', 'sese1246'), ('sgb', 'mani1235'), ('sge', 'song1303'),
    ('sgl', 'seng1278'), ('sgr', 'sang1336'), ('sgs', 'stra1244'), ('sgu', 'sang1333'), ('sha', 'shan1277'),
    ('shb', 'shab1252'), ('shd', 'sher1257'), ('she', 'sher1255'), ('shg', 'tibe1272'), ('shh', 'shar1245'),
    ('shi', 'nina1238'), ('shk', 'ship1254'), ('shl', 'shil1265'), ('shm', 'sham1280'), ('shn', 'shon1251'),
    ('sho', 'shos1248'), ('shp', 'nort1527'), ('shr', 'shor1247'), ('shs', 'shas1239'), ('sht', 'shat1244'),
    ('shu', 'shus1248'), ('shw', 'shaw1249'), ('shy', 'east2337'), ('sia', 'sian1257'), ('sid', 'sida1246'),
    ('sik', 'sika1262'), ('sil', 'dars1235'), ('sim', 'sime1241'), ('sin', 'sion1247'), ('sio', 'sioo1240'),
    ('sir', 'siar1238'), ('sis', 'baba1268'), ('siu', 'sius1254'), ('ski', 'kild1236'), ('skk', 'sikk1242'),
    ('skl', 'siku1242'), ('skm', 'suku1261'), ('skn', 'guah1255'), ('sko', 'nucl1634'), ('skp', 'selk1253'),
    ('skr', 'sika1263'), ('sku', 'suku1259'), ('skw', 'shek1243'), ('sla', 'slav1253'), ('slb', 'sali1295'),
    ('sle', 'samb1305'), ('slg', 'sulu1241'), ('slo', 'slov1268'), ('slp', 'sele1250'), ('slr', 'sala1264'),
    ('slv', 'sout2959'), ('sly', 'sela1260'), ('smd', 'sema1269'), ('sme', 'siam1242'), ('smj', 'sema1266'),
    ('sml', 'seme1247'), ('smn', 'cree1270'), ('smp', 'shom1245'), ('smt', 'umat1237'), ('sna', 'shin1264'),
    ('snc', 'sene1264'), ('snd', 'ceba1235'), ('sng', 'sina1266'), ('snh', 'sinh1246'), ('snm', 'sanu1240'),
    ('snn', 'soni1259'), ('sno', 'nort2671'), ('snt', 'nucl1632'), ('so', 'sooo1256'), ('sob', 'sobe1238'),
    ('sod', 'kist1241'), ('sol', 'even1259'), ('som', 'soma1255'), ('son', 'sons1242'), ('soo', 'stra1244'),
    ('soq', 'soqo1240'), ('sor', 'sora1254'), ('sou', 'uppe1395'), ('spa', 'stan1288'), ('spc', 'stan1288'),
    ('spi', 'tibe1272'), ('spo', 'spok1245'), ('sps', 'sout2965'), ('squ', 'squa1248'), ('sra', 'sran1240'),
    ('srb', 'sorb1249'), ('src', 'sars1236'), ('srd', 'camp1261'), ('sre', 'koho1244'), ('sri', 'siri1274'),
    ('srl', 'lowe1385'), ('srm', 'sara1340'), ('srn', 'siri1273'), ('sro', 'siro1249'), ('srr', 'serr1255'),
    ('sru', 'sela1259'), ('sry', 'sira1267'), ('ssa', 'west2465'), ('ssh', 'boro1277'), ('ssl', 'kore1273'),
    ('sss', 'stra1244'), ('sst', 'stra1244'), ('sta', 'dong1285'), ('sti', 'stie1250'), ('stl', 'sant1410'),
    ('stn', 'pedi1238'), ('sto', 'ston1242'), ('sub', 'subi1246'), ('sud', 'sude1239'), ('sue', 'suen1241'),
    ('sug', 'assa1269'), ('sui', 'suii1243'), ('suk', 'suki1245'), ('sul', 'sulk1246'), ('sum', 'sumo1243'),
    ('sun', 'sund1252'), ('sup', 'supy1237'), ('sur', 'surs1246'), ('sus', 'susu1250'), ('sva', 'svan1243'),
    ('svc', 'kash1274'), ('svk', 'slov1269'), ('svs', 'savo1255'), ('svt', 'swed1236'), ('swa', 'swah1253'),
    ('swe', 'swed1254'), ('swi', 'sawa1247'), ('swr', 'shos1248'), ('swt', 'swat1243'), ('swv', 'swed1254'),
    ('syg', 'west2402'), ('syu', 'salt1242'), ('tab', 'east2440'), ('tac', 'taca1256'), ('taf', 'sapo1253'),
    ('tag', 'taga1270'), ('tah', 'tahi1242'), ('tai', 'taha1241'), ('taj', 'taji1245'), ('tak', 'taki1248'),
    ('tal', 'tali1258'), ('tam', 'east2346'), ('tam', 'east2347'), ('tan', 'nucl1696'), ('tao', 'tara1313'),
    ('tap', 'taia1239'), ('taq', 'minn1241'), ('tar', 'tari1256'), ('tas', 'tach1250'), ('tat', 'tata1257'),
    ('tau', 'tauy1241'), ('taw', 'tawa1275'), ('tay', 'tayo1238'), ('taz', 'taly1247'), ('tba', 'sina1271'),
    ('tbb', 'tuba1278'), ('tbe', 'tigr1270'), ('tbl', 'tabl1243'), ('tbo', 'tbol1240'), ('tbr', 'taba1263'),
    ('tbs', 'taba1259'), ('tbt', 'toba1266'), ('tbu', 'tebu1238'), ('tbw', 'taab1238'), ('tbx', 'seke1240'),
    ('tce', 'cent2131'), ('tda', 'toda1252'), ('tdi', 'tibe1272'), ('tdr', 'tibe1272'), ('tec', 'tekt1235'),
    ('tee', 'hueh1236'), ('teh', 'tehu1242'), ('tel', 'telu1262'), ('tem', 'temm1241'), ('ten', 'tenn1246'),
    ('teo', 'teop1238'), ('tep', 'tlac1235'), ('ter', 'tera1251'), ('tes', 'teso1249'), ('tet', 'tete1250'),
    ('tew', 'tewa1260'), ('tex', 'khor1269'), ('tga', 'tang1348'), ('tgb', 'tagb1258'), ('tgh', 'taha1241'),
    ('tgk', 'tiga1245'), ('tgl', 'tsha1245'), ('tgn', 'tugu1245'), ('tgo', 'tsog1243'), ('tgp', 'sawi1256'),
    ('tgr', 'tigr1270'), ('tgw', 'west2538'), ('tha', 'thai1261'), ('thd', 'thad1238'), ('thk', 'thak1245'),
    ('thn', 'than1259'), ('tho', 'thom1243'), ('thp', 'thay1248'), ('ths', 'thai1240'), ('tht', 'tehi1237'),
    ('thu', 'thul1246'), ('thw', 'thao1240'), ('thy', 'thay1249'), ('tia', 'tima1241'), ('tib', 'tibe1272'),
    ('tic', 'ticu1245'), ('tid', 'tido1248'), ('tif', 'tifa1245'), ('tig', 'tigr1271'), ('tik', 'tika1246'),
    ('til', 'till1254'), ('tim', 'timu1262'), ('tin', 'tiri1258'), ('tir', 'trio1238'), ('tis', 'tibe1272'),
    ('tiv', 'tivv1240'), ('tiw', 'tiwi1244'), ('tja', 'kumi1248'), ('tke', 'toke1240'), ('tki', 'tuki1240'),
    ('tkl', 'take1257'), ('tkm', 'turk1304'), ('tks', 'teke1280'), ('tla', 'kuan1248'), ('tlb', 'noga1249'),
    ('tld', 'tala1285'), ('tlf', 'tele1256'), ('tli', 'tlin1245'), ('tll', 'taul1251'), ('tlo', 'tobe1252'),
    ('tlp', 'acat1239'), ('tls', 'taly1247'), ('tma', 'tama1331'), ('tmc', 'timu1245'), ('tmg', 'tama1336'),
    ('tmi', 'tata1255'), ('tmk', 'tuma1260'), ('tml', 'tami1289'), ('tmm', 'malo1243'), ('tmn', 'nucl1339'),
    ('tmo', 'tibe1272'), ('tmp', 'tamp1252'), ('tmr', 'temi1246'), ('tmu', 'musl1236'), ('tna', 'turk1308'),
    ('tnb', 'ango1257'), ('tnc', 'tana1290'), ('tnd', 'tind1238'), ('tne', 'timn1235'), ('tng', 'tong1325'),
    ('tni', 'tina1246'), ('tnj', 'tana1289'), ('tnk', 'tung1290'), ('tnl', 'lowe1425'), ('tnn', 'tune1241'),
    ('tno', 'tond1251'), ('tns', 'sout2869'), ('tnt', 'tont1239'), ('tny', 'west2466'), ('toa', 'toar1246'),
    ('tob', 'toba1269'), ('tod', 'stod1241'), ('tof', 'kara1462'), ('toj', 'tojo1241'), ('tok', 'taro1263'),
    ('tol', 'toll1241'), ('ton', 'tonk1249'), ('toq', 'toab1237'), ('tor', 'rata1244'), ('tos', 'high1243'),
    ('tot', 'yecu1235'), ('tou', 'tusi1238'), ('tow', 'sout2797'), ('toz', 'tong1318'), ('tpa', 'papa1238'),
    ('tpc', 'tepe1278'), ('tpi', 'tokp1240'), ('tpn', 'nort2959'), ('tpr', 'tupu1244'), ('tps', 'sout2976'),
    ('tpt', 'tapi1253'), ('trb', 'teri1250'), ('trc', 'chic1273'), ('trd', 'tora1261'), ('trg', 'tewa1260'),
    ('tri', 'copa1237'), ('trm', 'suri1267'), ('trn', 'tere1279'), ('trr', 'nort2920'), ('trt', 'tern1247'),
    ('tru', 'trum1247'), ('trw', 'torw1241'), ('try', 'tiru1241'), ('tsa', 'tsak1249'), ('tse', 'uabm1237'),
    ('tsf', 'colo1256'), ('tsg', 'taus1251'), ('tsh', 'pana1305'), ('tsi', 'nucl1649'), ('tsj', 'tewa1260'),
    ('tsk', 'tama1365'), ('tsl', 'tanz1238'), ('tsn', 'tson1249'), ('tso', 'tsou1248'), ('tsp', 'tami1289'),
    ('tsr', 'taus1253'), ('tst', 'tsat1238'), ('tsw', 'tswa1253'), ('tsz', 'dido1241'), ('ttb', 'tata1255'),
    ('ttd', 'tetu1245'), ('tte', 'tute1247'), ('ttn', 'tetu1245'), ('tts', 'take1255'), ('ttu', 'bats1242'),
    ('tty', 'tatu1247'), ('tua', 'tuam1242'), ('tub', 'tuba1279'), ('tuc', 'tuca1252'), ('tug', 'taha1241'),
    ('tui', 'turk1288'), ('tuk', 'tuka1247'), ('tul', 'tulu1258'), ('tum', 'tuml1238'), ('tun', 'tuni1252'),
    ('tur', 'nucl1301'), ('tus', 'tusc1257'), ('tut', 'nort2941'), ('tuv', 'tuvi1240'), ('tuy', 'tuyu1244'),
    ('tvl', 'tuva1244'), ('tvo', 'tata1255'), ('tvt', 'tuts1235'), ('twa', 'twan1247'), ('twe', 'lowl1265'),
    ('twn', 'nort1550'), ('tws', 'sout2961'), ('twx', 'khor1269'), ('txj', 'xico1235'), ('tye', 'tyar1236'),
    ('tza', 'tzel1254'), ('tzb', 'tzel1255'), ('tze', 'tzel1253'), ('tzi', 'taiw1241'), ('tzo', 'tzot1262'),
    ('tzs', 'tzot1260'), ('tzt', 'tzel1254'), ('tzu', 'cakc1244'), ('tzz', 'tzot1264'), ('uby', 'ubyk1235'),
    ('udh', 'udih1248'), ('udi', 'udii1243'), ('udm', 'udmu1245'), ('ugs', 'ugan1238'), ('uhi', 'urad1239'),
    ('ukr', 'ukra1253'), ('uku', 'uppe1438'), ('ulc', 'ulch1241'), ('uld', 'wuzl1236'), ('uli', 'ulit1238'),
    ('uma', 'umaa1242'), ('umb', 'umbu1257'), ('ump', 'umpi1239'), ('umu', 'cari1279'), ('una', 'unaa1239'),
    ('ung', 'ngar1284'), ('unm', 'unam1242'), ('ura', 'urav1235'), ('urd', 'urdu1245'), ('urh', 'urho1239'),
    ('uri', 'urim1252'), ('urk', 'urub1250'), ('url', 'urak1238'), ('urm', 'urum1249'), ('urn', 'urar1246'),
    ('urt', 'urat1244'), ('uru', 'uruu1244'), ('usa', 'usan1239'), ('usl', 'urub1243'), ('usr', 'usar1243'),
    ('ute', 'utes1238'), ('uyg', 'uigh1240'), ('uzb', 'uzbe1247'), ('uzn', 'nort2690'), ('vaf', 'vafs1240'),
    ('vag', 'vagl1239'), ('vai', 'vaii1241'), ('vas', 'vasa1239'), ('vat', 'lako1244'), ('ved', 'vedd1240'),
    ('ven', 'vend1245'), ('vep', 'veps1250'), ('vie', 'viet1252'), ('vif', 'vili1238'), ('vka', 'kari1304'),
    ('vla', 'vlaa1235'), ('vnm', 'vinm1237'), ('vot', 'voti1245'), ('wag', 'wage1238'), ('wah', 'wahg1249'),
    ('wai', 'waiw1244'), ('wak', 'wakh1245'), ('wal', 'valm1241'), ('wam', 'wamb1258'), ('wan', 'ngur1261'),
    ('wao', 'waor1240'), ('wap', 'wapp1239'), ('war', 'wari1268'), ('was', 'wash1253'), ('wat', 'waja1257'),
    ('wau', 'woun1238'), ('way', 'waya1270'), ('wbn', 'wamb1259'), ('wbt', 'wanm1242'), ('wch', 'wich1264'),
    ('wec', 'wels1247'), ('wed', 'weda1241'), ('wel', 'wels1247'), ('wer', 'weri1253'), ('wet', 'luan1263'),
    ('wgg', 'wang1290'), ('wgl', 'waig1243'), ('wgu', 'waru1264'), ('wic', 'wich1260'), ('wik', 'yoku1256'),
    ('win', 'wint1259'), ('wir', 'wira1260'), ('wiy', 'wiyo1248'), ('wkw', 'waka1274'), ('wlf', 'nucl1347'),
    ('wll', 'wall1257'), ('wlm', 'walm1241'), ('wlo', 'woli1241'), ('wlw', 'warl1256'), ('wly', 'wola1242'),
    ('wma', 'west2600'), ('wme', 'wamb1257'), ('wmn', 'weme1239'), ('wmu', 'wikm1247'), ('wn', 'wikn1245'),
    ('wna', 'wann1242'), ('wnb', 'hoch1243'), ('wnt', 'want1252'), ('wob', 'weno1238'), ('wog', 'woga1249'),
    ('woi', 'kama1365'), ('wol', 'wole1240'), ('wom', 'womo1238'), ('wor', 'woro1255'), ('wps', 'wapi1253'),
    ('wra', 'wara1303'), ('wrb', 'warr1257'), ('wrd', 'ward1246'), ('wrg', 'warr1255'), ('wrk', 'guar1293'),
    ('wrl', 'warl1254'), ('wrm', 'ware1253'), ('wrn', 'wand1263'), ('wrp', 'waro1242'), ('wrs', 'wari1266'),
    ('wru', 'waru1265'), ('wrw', 'warr1258'), ('wry', 'wara1290'), ('wsk', 'wask1241'), ('wth', 'wath1238'),
    ('wtm', 'wata1253'), ('wuc', 'wuch1236'), ('wur', 'waur1244'), ('wwa', 'waam1244'), ('wwr', 'woiw1237'),
    ('wwy', 'wara1300'), ('wya', 'wyan1247'), ('wyn', 'waya1269'), ('xam', 'xamm1241'), ('xar', 'xara1244'),
    ('xas', 'xaas1235'), ('xav', 'xava1240'), ('xbi', 'komb1272'), ('xer', 'xere1240'), ('xho', 'xhos1239'),
    ('xia', 'minn1241'), ('xns', 'kana1283'), ('xok', 'xokl1240'), ('xoo', 'xooo1239'), ('xsm', 'kase1253'),
    ('xun', 'kung1261'), ('yag', 'yagu1244'), ('yah', 'yama1264'), ('yak', 'yaka1269'), ('yal', 'kosa1249'),
    ('yam', 'yami1256'), ('yan', 'yana1271'), ('yao', 'yaoo1241'), ('yap', 'yape1248'), ('yaq', 'yaqu1251'),
    ('yar', 'yare1248'), ('yav', 'hava1248'), ('yaw', 'nucl1454'), ('yay', 'bouy1240'), ('yaz', 'yazg1240'),
    ('yba', 'yamb1251'), ('ybi', 'yamp1242'), ('ych', 'cent2127'), ('ycn', 'yucu1253'), ('yct', 'yuca1254'),
    ('ydb', 'east2295'), ('ydd', 'yidd1255'), ('ydl', 'east2295'), ('yei', 'yeii1239'), ('yel', 'yele1255'),
    ('yem', 'yemb1246'), ('yes', 'yess1239'), ('yey', 'yeyi1239'), ('ygd', 'diii1241'), ('ygn', 'yagn1238'),
    ('ygr', 'yaga1260'), ('yi', 'sich1238'), ('yid', 'yidi1250'), ('yil', 'yill1241'), ('yim', 'yima1243'),
    ('yin', 'yind1247'), ('yir', 'yiry1245'), ('yki', 'yuki1243'), ('ykm', 'yako1252'), ('ykn', 'yaka1277'),
    ('yko', 'sout2750'), ('ykp', 'yukp1241'), ('ykt', 'yaku1245'), ('ylb', 'mart1256'), ('yli', 'angg1239'),
    ('ylm', 'yelm1242'), ('ylr', 'yala1262'), ('ylt', 'east2295'), ('ymd', 'yamd1240'), ('ymi', 'yami1254'),
    ('yms', 'yems1235'), ('yna', 'nauk1242'), ('yng', 'ying1247'), ('ynk', 'yank1247'), ('ynm', 'yano1262'),
    ('yns', 'yans1239'), ('yny', 'yany1243'), ('yok', 'yoku1256'), ('yor', 'yoru1245'), ('ypk', 'cent2127'),
    ('yqy', 'yaqa1246'), ('yrc', 'yura1255'), ('yrm', 'yuru1243'), ('yrr', 'pume1238'), ('yrt', 'yuru1263'),
    ('ysi', 'sire1246'), ('ysl', 'cent2128'), ('yta', 'noga1249'), ('ytu', 'nort2745'), ('yuc', 'yuch1247'),
    ('yug', 'yugh1239'), ('yuk', 'gang1267'), ('yul', 'yulu1243'), ('yun', 'cent2127'), ('yur', 'yuro1248'),
    ('yus', 'cent2128'), ('yuw', 'gami1243'), ('ywl', 'yoku1256'), ('ywr', 'yawu1244'), ('yyg', 'yayg1236'),
    ('yyo', 'yort1237'), ('yzv', 'komi1268'), ('zag', 'zagh1240'), ('zai', 'isth1244'), ('zaj', 'sier1250'),
    ('zam', 'mixt1426'), ('zan', 'zand1248'), ('zap', 'mitl1236'), ('zaq', 'sant1451'), ('zar', 'zarm1239'),
    ('zay', 'zays1235'), ('zaz', 'diml1238'), ('zch', 'chim1300'), ('zen', 'zena1248'), ('zfl', 'fran1266'),
    ('zha', 'jang1254'), ('zhn', 'guib1245'), ('zim', 'zima1244'), ('zno', 'zulu1248'), ('zpi', 'sout3005'),
    ('zpr', 'zapa1253'), ('zqc', 'copa1236'), ('zqo', 'copa1236'), ('zqr', 'rayo1235'), ('zqs', 'high1276'),
    ('zso', 'zulu1248'), ('zsq', 'sanj1284'), ('zte', 'texm1235'), ('zul', 'zulu1248'), ('zun', 'zuni1245'),
    ('zya', 'yatz1235'), ('zzo', 'zoog1238')
]
