# coding=utf-8
"""source jsondata relicts

Revision ID: d262a0299e2
Revises: 4256d27f1cde
Create Date: 2014-10-23 16:18:10.189000

"""

# revision identifiers, used by Alembic.

revision = 'd262a0299e2'
down_revision = '4256d27f1cde'

import datetime
import json

from alembic import op
import sqlalchemy as sa


def upgrade():
    conn = op.get_bind()
    select_pj = sa.text('SELECT pk, jsondata FROM source WHERE pk IN :pks', conn)
    update_source = sa.text('UPDATE source SET updated = now(), '
        'jsondata = :jsondata WHERE pk = :pk', conn)
    for key in sorted(KEY_PKS):
        pks = KEY_PKS[key]
        for pk, jsondata in select_pj.execute(pks=pks):
            jsondata = json.loads(jsondata)
            if key in jsondata:
                del jsondata[key]
                update_source.execute(pk=pk, jsondata=json.dumps(jsondata))


def downgrade():
    pass


KEY_PKS = {
    'university': (  # 4
        7586, 55019, 92377, 98585
    ),
    'numnote': (  # 4
        55278, 70595, 77027, 118128
    ),
    'zurichcode': (  # 608
        176517, 176536, 176538, 176541, 176542, 176546, 176547, 176549, 176552, 176557,
        176564, 176568, 176577, 176578, 176581, 176586, 176590, 176595, 176597, 176609,
        176611, 176622, 176627, 176634, 176636, 176640, 176653, 176659, 176681, 176682,
        176684, 176702, 176707, 176718, 176724, 176733, 176738, 176740, 176768, 176769,
        176792, 176795, 176825, 176828, 176832, 176848, 176865, 176872, 176875, 176888,
        176890, 176895, 176896, 176908, 176912, 176917, 176922, 176923, 176934, 176937,
        176938, 176942, 176944, 176945, 176949, 176950, 176954, 176959, 176967, 176971,
        176977, 176980, 176981, 176982, 176983, 176991, 176994, 176995, 176996, 176997,
        176998, 176999, 177001, 177003, 177006, 177008, 177009, 177011, 177012, 177013,
        177019, 177020, 177026, 177027, 177029, 177030, 177032, 177037, 177039, 177044,
        177045, 177047, 177050, 177055, 177058, 177059, 177062, 177066, 177073, 177078,
        177079, 177088, 177091, 177096, 177117, 177174, 177238, 177260, 177268, 177278,
        177279, 177357, 177425, 177431, 177445, 177456, 177477, 177483, 177487, 177511,
        177514, 177540, 177545, 177560, 177565, 177606, 177607, 177613, 177619, 177630,
        177675, 177699, 177700, 177715, 177723, 177741, 177747, 177769, 177777, 177786,
        177799, 177803, 177814, 177818, 177827, 177832, 177837, 177896, 177934, 177955,
        177958, 177960, 177995, 177996, 177999, 178040, 178117, 178131, 178158, 178172,
        178177, 178187, 178222, 178264, 178265, 178272, 178275, 178297, 178306, 178313,
        178326, 178328, 178331, 178332, 178340, 178343, 178346, 178357, 178358, 178360,
        178365, 178368, 178370, 178373, 178384, 178388, 178410, 178415, 178425, 178549,
        178556, 178570, 178581, 178583, 178587, 178592, 178595, 178611, 178617, 178643,
        178656, 178660, 178662, 178666, 178675, 178683, 178694, 178702, 178716, 178720,
        178725, 178734, 178736, 178745, 178758, 178759, 178760, 178764, 178766, 178777,
        178780, 178806, 178811, 178828, 178844, 178857, 178858, 178862, 178887, 178905,
        178924, 178928, 178936, 178941, 178968, 178975, 178980, 179009, 179011, 179020,
        179021, 179035, 179039, 179048, 179092, 179098, 179100, 179101, 179104, 179120,
        179153, 179170, 179190, 179196, 179204, 179221, 179235, 179236, 179241, 179243,
        179257, 179258, 179262, 179268, 179269, 179281, 179285, 179290, 179291, 179309,
        179332, 179338, 179350, 179362, 179363, 179369, 179376, 179382, 179383, 179399,
        179404, 179412, 179452, 179465, 179472, 179476, 179480, 179483, 179487, 179507,
        179539, 179540, 179547, 179572, 179585, 179588, 179589, 179590, 179592, 179617,
        179675, 179680, 179681, 179682, 179812, 179815, 179817, 179819, 179824, 179827,
        179829, 179884, 179950, 179955, 180018, 180021, 180022, 180025, 180026, 180027,
        180048, 180049, 180052, 180059, 180162, 180164, 180166, 180167, 180174, 180176,
        180179, 180184, 180221, 180232, 180257, 180283, 180293, 180308, 180310, 180313,
        180315, 180325, 180326, 180333, 180344, 180406, 180442, 180446, 180451, 180457,
        180464, 180474, 180475, 180524, 180574, 180584, 180593, 180599, 180630, 180634,
        180652, 180681, 180699, 180709, 180713, 180746, 180766, 180813, 180826, 180827,
        180838, 180844, 180902, 180940, 180950, 180967, 180981, 180985, 180998, 180999,
        181012, 181013, 181014, 181015, 181019, 181021, 181022, 181040, 181082, 181171,
        181190, 181206, 181304, 181311, 181312, 181315, 181316, 181365, 181388, 181396,
        181400, 181408, 181432, 181437, 181452, 181456, 181478, 181479, 181480, 181482,
        181488, 181495, 181511, 181512, 181529, 181543, 181564, 181569, 181591, 181657,
        181672, 181677, 181678, 181679, 181680, 181683, 181685, 181708, 181751, 181776,
        181798, 181815, 181828, 181920, 181928, 181940, 181948, 181950, 181995, 181998,
        182027, 182042, 182057, 182092, 182116, 182122, 182127, 182130, 182135, 182136,
        182138, 182167, 182283, 182324, 182332, 182363, 182387, 182397, 182448, 182471,
        182492, 182494, 182495, 182496, 182502, 182507, 182534, 182538, 182628, 182643,
        182655, 182656, 182721, 182783, 182784, 182862, 182874, 182925, 182984, 182990,
        182995, 183033, 183064, 183092, 183093, 183100, 183106, 183155, 183156, 183157,
        183177, 183179, 183184, 183224, 183280, 183282, 183309, 183456, 183458, 183462,
        183500, 183531, 183582, 183585, 183589, 183591, 183618, 183619, 183627, 183680,
        183706, 183718, 183755, 183777, 183826, 183853, 183864, 183868, 183871, 183872,
        183907, 183910, 184016, 184020, 184074, 184087, 184125, 184140, 184146, 184161,
        184179, 184192, 184217, 184222, 184224, 184290, 184303, 184330, 184353, 184355,
        184398, 184420, 184510, 184516, 184519, 184520, 184528, 184548, 184574, 184584,
        184641, 184643, 184645, 184665, 184677, 184678, 184692, 184701, 184705, 184710,
        184716, 184719, 184724, 184767, 184784, 184787, 184791, 184793, 184833, 184835,
        184844, 184846, 184851, 184852, 184859, 184863, 184881, 184898, 184902, 184930,
        184944, 184960, 184962, 185043, 185047, 185058, 185061, 185124, 185144, 185160,
        185172, 185173, 185187, 185196, 185203, 185207, 185214, 185216
    )
}
