# coding=utf-8
"""fix country-language relations

Revision ID: 56d1bff8c07d
Revises: 99e196d9ea4
Create Date: 2014-04-02 12:37:19.494067

"""

# revision identifiers, used by Alembic.
revision = '56d1bff8c07d'
down_revision = '99e196d9ea4'

import datetime

from alembic import op
import sqlalchemy as sa
from clld.db.migration import Connection

from glottolog3.models import Languoid, Country, Languoidcountry


ADD = {"roh": ["AT", "IT"], "sck": ["BD"], "ale": ["RU"], "rof": ["KE"], "mnh": ["CF"], "mnk": ["GN"], "bvk": ["MY"], "llb": ["MW"], "alt": ["KZ", "MN", "CN"], "mnc": ["RU"], "als": ["MK"], "lko": ["UG"], "mwp": ["AU"], "ron": ["BG"], "aug": ["TG"], "isu": ["NG"], "mwk": ["GN"], "mwn": ["MW"], "mwl": ["ES"], "kcd": ["PG"], "fax": ["PT"], "mpa": ["MW"], "kck": ["ZA"], "fai": ["ID"], "pta": ["BR"], "fur": ["AT"], "pbt": ["TM"], "jhi": ["TH"], "bxr": ["MN"], "bxu": ["RU", "MN"], "bxk": ["UG"], "bxm": ["RU", "CN"], "pbc": ["BR"], "ojc": ["US"], "flr": ["BI"], "tem": ["GN"], "nbe": ["MM"], "sug": ["ID"], "kus": ["TG"], "suj": ["BI"], "rou": ["SD"], "kun": ["SD"], "ycn": ["BR", "PE"], "zro": ["PE"], "kuf": ["VN"], "nep": ["BD", "CN"], "mef": ["IN"], "lef": ["TG"], "men": ["GN"], "mev": ["CI"], "tdd": ["VN"], "box": ["ML"], "plg": ["PY"], "fwe": ["ZM", "BW"], "drt": ["DE"], "drh": ["RU"], "sjo": ["KZ"], "aka": ["TG"], "dre": ["CN"], "uzn": ["AF"], "vif": ["AO"], "spy": ["UG"], "brv": ["LA"], "sgt": ["IN"], "brl": ["ZW"], "bwi": ["CO"], "brd": ["CN"], "apd": ["TD", "CF"], "uzs": ["TJ", "UZ"], "ayn": ["SA"], "ayh": ["SA"], "twd": ["DE"], "two": ["ZA"], "ayc": ["CL"], "lwh": ["CN"], "lwa": ["AO"], "msc": ["SL"], "ven": ["BW"], "kgc": ["VN"], "kgd": ["VN"], "kgk": ["PY"], "tnv": ["IN"], "deq": ["CD"], "klo": ["CM"], "deu": ["NL"], "fli": ["CM"], "cag": ["BO"], "gqr": ["CF"], "hhr": ["GW"], "kyi": ["BN"], "spp": ["BF", "CI"], "lrc": ["IQ"], "dzo": ["CN"], "spa": ["GY", "BR", "HT", "PT"], "kyu": ["TH"], "csk": ["GW"], "gcf": ["BL", "MF"], "nyr": ["ZM", "TZ"], "nyw": ["LA"], "nyu": ["MW", "ZW"], "gcr": ["BR"], "nyn": ["RW", "TZ"], "nya": ["TZ"], "afr": ["MZ"], "sne": ["ID"], "bkc": ["CG", "CF"], "snj": ["CD"], "bkx": ["ID"], "aoz": ["TL"], "kxx": ["CD"], "eng": ["GT", "GG", "IM", "BR", "JE", "CU"], "mjh": ["MW"], "gha": ["DZ"], "fao": ["FO"], "ttz": ["CN"], "vmk": ["MW"], "kbl": ["NE"], "wut": ["ID"], "tts": ["KH", "LA"], "ttq": ["BF"], "ita": ["AT"], "ttj": ["CD"], "ffm": ["BF", "NE", "MR"], "vmr": ["MW"], "tsn": ["ZM"], "tsl": ["LA"], "jie": ["CM"], "jia": ["TD"], "jim": ["NG"], "jiv": ["PE"], "byo": ["VN", "LA"], "ceg": ["BO", "BR"], "dag": ["TG"], "mxx": ["GN"], "cmn": ["MM", "KP"], "nod": ["MM"], "kkw": ["GA"], "dav": ["TZ"], "kkh": ["LA"], "das": ["LR"], "now": ["UG", "RW"], "nor": ["FI", "SE", "RU"], "nos": ["VN"], "kpz": ["KE"], "did": ["UG"], "nfu": ["NG"], "pan": ["PK"], "shy": ["TN"], "ifm": ["CD"], "kpl": ["CF"], "oun": ["NA"], "pby": ["ID"], "dga": ["BF"], "izh": ["EE"], "sms": ["NO"], "gob": ["VE"], "smn": ["NO"], "dgh": ["CM"], "gos": ["DE"], "bwp": ["PG"], "sbs": ["ZW"], "sbz": ["TD", "SD"], "asa": ["KE"], "asg": ["BJ"], "bwe": ["TH"], "orh": ["RU"], "quh": ["CL"], "log": ["SD"], "aiy": ["CD"], "cax": ["BR"], "wlv": ["PY"], "mve": ["IN"], "wln": ["FR", "LU"], "yua": ["GT"], "yue": ["HK", "MO"], "kfy": ["NP"], "lom": ["GN"], "kfk": ["CN"], "koj": ["TD"], "toq": ["UG", "KE"], "toi": ["NA"], "jei": ["PG"], "kot": ["NG"], "tod": ["LR"], "pnx": ["VN"], "lot": ["UG"], "ncp": ["NG"], "huh": ["AR"], "pnt": ["BG", "MK"], "hut": ["CN"], "pne": ["BN"], "huz": ["GE"], "beh": ["TG"], "stg": ["LA"], "sef": ["ML", "BF"], "dta": ["KZ"], "kts": ["PG"], "stt": ["KH"], "ktj": ["LR"], "kte": ["CN"], "rad": ["KH"], "prb": ["LA"], "saf": ["CI"], "acd": ["TG"], "raw": ["CN"], "anv": ["NG"], "nqg": ["NG"], "prs": ["TM", "TJ"], "nqk": ["TG"], "pry": ["LA"], "prx": ["PK"], "gkp": ["LR"], "wca": ["VE"], "efi": ["CM"], "zos": ["GT"], "tyj": ["LA"], "sfw": ["CI"], "kah": ["SD"], "kap": ["GE"], "tyz": ["CN"], "pye": ["LR"], "tpe": ["IN"], "mrz": ["PG"], "ckh": ["IN"], "bzd": ["PA"], "tha": ["MM", "KH"], "bza": ["SL"], "axk": ["CM"], "tke": ["MW"], "nld": ["GF", "GY"], "abo": ["CM"], "oci": ["AD"], "kss": ["GN"], "ngc": ["CF"], "ngl": ["MW"], "hux": ["CO"], "bfo": ["GH"], "mgg": ["CG"], "kxm": ["KH"], "sss": ["VN"], "gec": ["CI"], "hig": ["CM"], "sse": ["MY"], "kxq": ["PG"], "ssb": ["ID"], "eme": ["BR"], "shr": ["RW", "BI"], "shv": ["YE"], "gbo": ["CI"], "shz": ["BF", "CI"], "gbm": ["CN"], "emk": ["ML", "CI"], "aec": ["SD"], "aeb": ["DZ"], "shg": ["ZW"], "shl": ["BD"], "ktv": ["LA"], "btu": ["CM"], "arq": ["TN", "MA"], "ars": ["LB", "YE", "TR", "AE", "IL"], "ses": ["NE"], "seq": ["ML", "CI"], "ary": ["DZ"], "nut": ["CN"], "nuu": ["CF"], "sey": ["CO"], "rmc": ["HU"], "lno": ["UG"], "seb": ["ML"], "arg": ["FR"], "sen": ["ML"], "rmn": ["SK"], "seh": ["MW"], "dln": ["BD"], "lua": ["AO"], "luc": ["SD"], "wof": ["SN"], "muk": ["CN"], "tur": ["SY", "AM", "AL"], "ikx": ["KE"], "tuv": ["UG", "SD"], "jod": ["GN", "ML"], "fgr": ["CF", "SD"], "gwe": ["KE"], "han": ["BI"], "vun": ["KE"], "pdt": ["PY", "MX", "BZ"], "kjm": ["CN"], "coa": ["CC", "CX"], "kjz": ["CN"], "tgr": ["VN"], "por": ["GF", "BO", "CO", "AR", "PE"], "tge": ["CN"], "kwy": ["CG"], "tgk": ["CN", "AF"], "gxx": ["LR"], "swk": ["MZ"], "kzi": ["BN"], "swe": ["AX"], "dug": ["TZ"], "frr": ["DK"], "xal": ["KZ"], "yae": ["CO"], "duu": ["MM"], "gaz": ["SD"], "hmz": ["CN"], "mcg": ["CO"], "hmv": ["CN"], "gal": ["ID"], "nrr": ["CN"], "gae": ["CO"], "pig": ["BR"], "slx": ["AO"], "fuq": ["ML", "TD", "NG"], "slt": ["CN"], "iyo": ["NG"], "aim": ["NP"], "mlq": ["GN", "MR"], "fub": ["ET", "ER"], "gng": ["GH"], "hka": ["KE"], "sld": ["GH"], "fuh": ["ML", "NG"], "mql": ["TG"], "pzn": ["IN"], "ava": ["GE"], "pap": ["BL", "AN"], "ewo": ["GA", "GQ"], "zga": ["MW"], "fkv": ["FI", "RU"], "kiz": ["MW"], "nih": ["MW"], "kix": ["MM"], "syi": ["CM"], "dgi": ["GH"], "dgo": ["PK"], "nix": ["UG"], "niy": ["UG"], "kin": ["TZ"], "phr": ["IN"], "mzh": ["BO", "PY"], "mzk": ["CM"], "kno": ["GN"], "gsw": ["IT"], "thw": ["CN"], "thv": ["ML"], "twl": ["ZW"], "ccj": ["SN"], "thf": ["BT"], "ccg": ["CM"], "knu": ["CI"], "thc": ["LA"], "gso": ["CM"], "mfa": ["MY"], "xem": ["MY"], "ldi": ["CD"], "mfq": ["GH"], "gdf": ["CM"], "gdi": ["CM"], "wec": ["LR"], "rgr": ["CO"], "kkf": ["BT"], "gmn": ["NG"], "gmm": ["CF"], "hay": ["UG"], "adb": ["ID"], "haq": ["BI"], "cuk": ["CO"], "fvr": ["CF"], "adh": ["KE"], "bim": ["TG"], "mow": ["CD"], "amf": ["KE"], "biz": ["CG"], "biv": ["BF"], "pst": ["AF"], "bpd": ["CD"], "zlm": ["TH"], "kqo": ["CI"], "mhb": ["CG"], "mhc": ["GT"], "wbf": ["ML"], "mht": ["CO"], "wbm": ["MM"], "kdj": ["KE", "SD"], "kdg": ["ZM"], "nzy": ["CF"], "tvs": ["TZ"], "kdz": ["NG"], "njx": ["AO"], "kmb": ["CD"], "gva": ["BR"], "pes": ["AF"], "fod": ["TG"], "ddo": ["GE"], "ddn": ["NE"], "tmf": ["BR"], "kmp": ["NG"], "mcu": ["NG"], "tmm": ["LA"], "dde": ["CD"], "run": ["CD"], "plr": ["BF"], "nmq": ["NA", "ZM"], "tdg": ["CN"], "fra": ["GG", "JE"], "cgg": ["RW", "CD"], "rue": ["RO", "PL"], "nmf": ["MM"], "nmn": ["ZA"], "rus": ["KP"], "krz": ["PG"], "dzg": ["LY", "SD"], "ndn": ["CM"], "srk": ["ID"], "krv": ["LA"], "dzl": ["CN", "IN"], "krt": ["TD"], "acq": ["SA"], "acw": ["YE"], "act": ["DE"], "krc": ["GE"], "aao": ["MA", "LY"], "ahl": ["GH"], "bjt": ["GW"], "sou": ["MM", "MY"], "usi": ["MM", "IN"], "gir": ["CN"], "lon": ["MZ"], "xpe": ["GN"], "gix": ["CF"], "hed": ["CM"], "mku": ["CI"], "loq": ["CG"], "heb": ["SY", "JO", "LB"], "buz": ["CM"], "pww": ["MM"], "rjs": ["IN"], "sdr": ["IN"], "mgs": ["MW"], "bus": ["BJ"], "sdz": ["DE"], "bul": ["MK"], "bum": ["GA", "GQ"], "pwo": ["TH"], "sdj": ["AO", "CD"], "azj": ["IR", "TR"], "ciw": ["CA"], "myx": ["KE"], "sxb": ["UG"], "nnj": ["SD"], "cbj": ["NG"], "khq": ["MR"], "nnb": ["UG"], "mrq": ["PF"], "myk": ["BF"], "inh": ["GE"], "khm": ["TH"], "nnw": ["GH"], "khg": ["MM", "IN"], "kqs": ["LR"], "yon": ["ID"], "tiz": ["VN"], "tir": ["SD"], "xkz": ["CN"], "tii": ["CG"], "kqk": ["TG"], "gro": ["BT"], "xkv": ["ZA"], "sqq": ["KH"], "dos": ["CI"], "kvx": ["IN"], "bcb": ["GW"], "sva": ["RU"], "ajp": ["SA"], "bcz": ["GW"], "nku": ["BF"]}
REMOVE = {"aln": ["CZ", "SI", "US"], "pkp": ["NZ", "AU"], "dar": ["KG", "UZ", "TR", "TM"], "wuu": ["US"], "mnp": ["SG"], "tkl": ["AS", "NZ", "US"], "cdo": ["MY", "BN", "US", "TH", "SG", "ID"], "sco": ["IE"], "kbd": ["JO", "SY", "DE", "US"], "aju": ["CA", "FR", "IL"], "tth": ["US"], "tkr": ["UZ"], "nld": ["FR", "CA", "ZA", "US", "AW", "ID"], "mfv": ["FR"], "ttt": ["RU"], "mfy": ["BR"], "cje": ["FR", "US"], "als": ["BE", "HR", "EG", "DE", "TR", "US", "UA", "SE"], "mng": ["US"], "smo": ["TO", "NZ", "FJ", "US"], "cuu": ["TH"], "mwp": ["PG"], "mww": ["FR", "US"], "ron": ["RU", "KG", "UZ", "HR", "CA", "US", "CZ", "TM", "AU", "IL", "FI", "KZ", "AZ", "TJ", "MZ"], "ell": ["FR", "DJ", "DE", "HU", "JO", "BS", "RU", "PY", "TN", "PL", "LY", "AE", "AM", "CA", "CG", "ZA", "CD", "CZ", "GE", "AU", "AT", "US", "GB", "MW", "SL", "KZ", "SE", "MZ"], "skr": ["GB"], "cld": ["BE", "LB", "CA", "DE", "US", "AU", "NL", "SE"], "hrv": ["CL", "CA", "DE", "US", "SK", "CZ"], "ady": ["FR", "NL", "IQ", "EG", "DE", "MK", "AU", "US"], "gla": ["CA", "AU", "US"], "jam": ["CA", "US", "JM", "GB", "CR"], "vec": ["HR", "SI", "IT"], "fij": ["NZ", "NR", "US", "VU"], "pcc": ["FR", "US"], "ymm": ["US", "SD"], "hau": ["DE", "CG", "CF", "TG", "GH", "ER", "SD"], "eus": ["CR", "PH", "AU", "MX", "US"], "kmr": ["BE", "FR", "DK", "DE", "BH", "FI", "RU", "LB", "NO", "CH", "GR", "AF", "CA", "IT", "GE", "AU", "AT", "NL", "KG", "US", "KZ", "SE", "GB"], "amh": ["EG", "IL", "US", "SE"], "lzz": ["BE", "FR", "DE", "US"], "ium": ["BE", "FR", "CH", "DK", "US", "NZ"], "ceb": ["US"], "pbt": ["AE", "GB"], "mos": ["SN", "BJ"], "por": ["BE", "BM", "DE", "JM", "CH", "CV", "TL", "LU", "GW", "ZM", "VC", "CN", "AG", "CA", "CG", "ZA", "AO", "GB", "IN", "ID", "OM", "US", "ST", "MW", "SN", "MZ"], "dan": ["AE", "NO", "CA", "US", "GL", "SE"], "nog": ["UZ"], "wol": ["FR"], "mgm": ["AU"], "hak": ["SR", "BN", "ZA", "US", "ID", "MU", "GF", "NZ", "PA", "PF", "GB", "TH", "SG", "MY", "CA"], "mgp": ["BT"], "fan": ["ST"], "fao": ["DK", "US"], "taj": ["BT", "MM"], "lez": ["KG", "UZ", "TR", "TM"], "mlf": ["US"], "vls": ["CA", "US"], "niu": ["CK", "TO", "NZ", "US"], "hil": ["US"], "hin": ["ZM", "AE", "KE", "CA", "DE", "YE", "ZA", "US", "NZ", "BW", "GB", "DJ", "PH", "SG", "UG", "BZ"], "hye": ["FR", "BG", "HU", "JO", "HN", "PS", "LB", "EE", "TM", "TJ", "RO", "CA", "GR", "RU", "IQ", "EG", "CY", "IL", "IN", "KG", "UZ", "US", "KZ", "UA"], "pbu": ["CA", "AE", "GB", "US"], "cmn": ["ZM", "SG", "BN", "KH", "US", "ID", "MU", "GB", "TH", "PH", "LY", "MY", "CA", "MZ"], "mah": ["NR", "US"], "shu": ["CF"], "evn": ["US"], "zlm": ["MM", "CA", "AE", "US"], "guj": ["ZM", "OM", "TZ", "KE", "CA", "ZA", "US", "MU", "RE", "MW", "BW", "GB", "FJ", "ZW", "SG", "UG", "MZ"], "knc": ["ER"], "yor": ["TG", "GB", "US", "SL"], "aeb": ["BE", "FR", "DE"], "pan": ["AE", "KE", "MY", "CA", "US", "MU", "GB", "FJ", "SG", "LY"], "zdj": ["RE", "MG"], "shi": ["FR"], "lbe": ["KG", "UZ", "TR", "TM", "TJ"], "bam": ["BF", "GM", "MR"], "tru": ["BE", "CA", "DE", "US", "AR", "AU", "BR", "NL", "SE"], "bak": ["KG", "UZ", "TM", "TJ"], "bah": ["US"], "arq": ["BE", "FR", "DE", "EG", "PM"], "ars": ["CA", "US"], "tel": ["AE", "MY", "CA", "BH", "ZA", "US", "MU", "FJ", "SG"], "rmt": ["RU", "AF", "IQ", "IR", "TR", "UZ", "IN", "LY", "SD"], "ary": ["BE", "FR", "NL", "EG", "DE", "GB", "GI", "LY"], "nut": ["CA", "AU", "US"], "brh": ["TM"], "mfe": ["MG", "FR", "GB"], "snd": ["OM", "CA", "US", "GB", "PH", "SG"], "mdd": ["US"], "dmm": ["SL"], "rmc": ["CZ", "PL", "US"], "lao": ["FR", "AU", "CA", "US"], "apc": ["PR", "DO", "AG", "GF", "ML", "EG", "JM", "CY", "AR", "SR", "TT", "BZ"], "pam": ["US"], "rmn": ["MD", "FR", "IR", "GR", "DE", "TR", "IT", "US", "UA"], "slv": ["CA", "AR", "AU", "US", "RS"], "arn": ["US"], "gom": ["AE", "KE"], "yka": ["MY"], "est": ["CA", "US", "AU", "GB", "FI", "SE"], "eng": ["BB", "BN", "JP", "JM", "BW", "WS", "BS", "RW", "TK", "GU", "GR", "BH", "GD", "GM", "GH", "PR", "PW", "PG", "PK", "PH", "PM", "ZM", "EC", "ET", "ZW", "ER", "MG", "MH", "MU", "MT", "MW", "MP", "MS", "UG", "MY", "VU", "AW", "FI", "FJ", "FM", "NO", "NA", "NG", "NZ", "NP", "NR", "NU", "CH", "CN", "CM", "CL", "SZ", "KE", "KI", "KH", "KN", "KR", "SO", "SL", "SC", "SB", "SA", "SG", "DM", "DK", "DE", "LB", "LC", "TT", "LK", "TO", "LS", "TC", "LY", "VC", "AE", "AD", "AG", "VG", "AI", "VI", "IT", "AS", "IL", "IO", "IN", "TZ", "MZ"], "ajp": ["PR", "EG", "AR", "LY"], "blt": ["FR", "AU", "US"], "abk": ["UA"], "azb": ["SY", "JO", "US"], "pes": ["FR", "DK", "DE", "BH", "NL", "TJ", "AT", "AE", "GR", "CA", "OM", "AU", "GB", "IN", "ES", "SY", "UZ", "US", "QA", "SA", "SE", "IL"], "fod": ["GH"], "abq": ["DE"], "kum": ["TR"], "abs": ["NL", "US"], "bdq": ["US"], "apd": ["SA"], "bho": ["MU"], "gvr": ["BT"], "fub": ["US"], "lld": ["US"], "dsb": ["US"], "ort": ["US"], "nep": ["BN", "US"], "hsb": ["US"], "plt": ["RE", "KM", "US"], "tdn": ["US"], "khf": ["US"], "cha": ["US"], "mkd": ["HR", "CA", "US", "SI"], "tur": ["BE", "FR", "BA", "DE", "HN", "FI", "DK", "RU", "NL", "RS", "TJ", "AT", "RO", "CA", "CH", "AE", "EG", "AU", "IL", "KG", "UZ", "SV", "US", "KZ", "UA", "SE", "GB"], "slk": ["ME", "HR", "CA", "RO", "US"], "hsn": ["US"], "fra": ["WF", "BF", "DJ", "BI", "BJ", "DZ", "YT", "PR", "RW", "LB", "CM", "NC", "NE", "TN", "RE", "PF", "TG", "TD", "LY", "CI", "AE", "GQ", "GP", "VI", "CG", "ZA", "CF", "VU", "GA", "IN", "GN", "CD", "PH", "HT", "MG", "MA", "ML", "IL", "KH", "KM", "MU", "MQ", "SN", "MR", "SC", "SA", "MZ", "GB", "AT"], "kea": ["FR", "NL", "PT", "DE", "IT", "US", "LU", "SN", "ES", "MZ"], "tdd": ["FR", "CH"], "uum": ["GR"], "tuk": ["RU", "SY", "KG", "DE", "US", "KZ"], "chk": ["GU", "US"], "kiu": ["FR", "CH", "NL", "DK", "DE", "AT", "SE", "GB"], "jdt": ["RU", "IL"], "rus": ["BG", "UY", "GR", "HR", "RS", "CA", "DE", "AM", "US", "SK", "CZ", "TJ", "IL", "AZ", "MZ"], "rup": ["RO", "BA"], "rue": ["CZ", "EE", "RS", "HR"], "mey": ["LY"], "crh": ["KG", "RU", "TR", "US"], "asm": ["US"], "ayh": ["KE", "ER"], "kjb": ["US"], "xuu": ["ZA"], "cos": ["PR", "UY", "VE", "CA", "BO", "US", "CU"], "acf": ["FR", "LC", "GY", "GD"], "ilo": ["US"], "wls": ["FJ", "NC", "VU"], "gle": ["CA", "US", "BR"], "bgn": ["TJ"], "diq": ["DE"], "coa": ["AU"], "jav": ["SG", "NL", "US"], "acq": ["DJ", "KE", "EG", "SO", "GB", "LY"], "acw": ["ER"], "syl": ["MY", "CA", "IT", "US", "AU", "GB", "SG"], "wlo": ["MY"], "krc": ["KG", "UZ", "AM", "US"], "wlc": ["RE", "MG"], "bod": ["TW", "CH", "US", "NO"], "tab": ["TM", "UZ"], "zul": ["MW"], "oss": ["UZ", "DE", "TM", "TJ", "KZ", "UA"], "uzn": ["RU", "TR", "US", "AU", "IL", "UA"], "bap": ["BT"], "kfr": ["MW", "TZ", "KE"], "jra": ["US"], "vie": ["RU", "FR", "NC", "NL", "MQ", "KH", "NO", "TW", "CA", "DE", "CI", "US", "CZ", "AU", "GB", "TH", "FI", "PH", "VU", "SN"], "brv": ["US"], "lmo": ["US"], "som": ["OM", "AE", "CA", "YE", "IT", "GB", "FI", "SA", "SE"], "pol": ["AZ", "AE", "RS", "HR", "CA", "US", "HU", "LV", "EE", "AU", "AT", "KZ", "FI", "RO", "IL"], "sot": ["SZ", "BW"], "pht": ["US"], "sov": ["MP"], "tgk": ["RU", "IR", "UA", "TM", "KZ"], "bre": ["US"], "rkh": ["NZ"], "brb": ["FR", "US"], "tgl": ["GU", "AE", "CA", "US", "GB", "SA", "LY"], "swh": ["OM", "AE", "CA", "US", "ZA", "YT", "LY"], "dng": ["RU", "TM"], "chv": ["KG", "UZ"], "che": ["SY", "KG", "UZ", "DE", "TR", "JO"], "twh": ["FR"], "swb": ["RE", "MG", "SZ"], "swe": ["EE", "CA", "AE", "US"], "ukr": ["KG", "RS", "HR", "CA", "PY", "AM", "GE", "CZ", "UZ", "LV", "EE", "LT", "TM", "TJ", "US", "BR", "KZ", "AZ", "AR"], "frs": ["CA", "US"], "ton": ["CA", "NZ", "US", "AS", "AU", "VU", "FJ", "NU"], "rhg": ["SA", "MY"], "heb": ["CA", "DE", "US", "PA", "AU", "GB"], "afb": ["EG"], "xal": ["TW", "DE", "KG", "US"], "rcf": ["MG", "KM"], "gil": ["TV", "FJ", "NR", "VU", "US"], "arz": ["SY", "AE", "IQ", "YE", "JO", "KW", "SA"], "hat": ["PR", "GP", "CA", "US", "GF", "BS", "KY", "TC"], "ita": ["BE", "BA", "DE", "BR", "PR", "PY", "LI", "TN", "LU", "PH", "RO", "CA", "LY", "AE", "CL", "EG", "ZA", "AR", "AU", "IL", "ER", "UY", "US", "MT", "SO", "SA", "GB"], "dks": ["CA"], "gaz": ["EG"], "gyn": ["US"], "hun": ["RU", "CA", "US", "CZ", "AU", "IL"], "wni": ["RE", "MG"], "pnt": ["RU", "CA", "US", "GE", "KZ", "AZ"], "bul": ["RU", "HR", "CA", "US", "HU", "SK", "CZ", "IL", "LY"], "gag": ["RU", "KZ"], "udi": ["TM"], "kos": ["NR", "US"], "cym": ["CA", "AR", "US"], "kjg": ["FR", "US"], "azj": ["KG", "UZ", "EE", "TM", "KZ", "UA"], "kor": ["BN", "DE", "BH", "BR", "BZ", "PY", "NZ", "PA", "TJ", "TH", "PH", "TM", "LY", "GU", "JP", "CA", "AS", "AU", "KG", "UZ", "SR", "MN", "US", "MP", "MR", "KZ", "SA", "SG", "MZ"], "ben": ["AE", "CA", "US", "MW", "GB", "SA", "SG"], "bel": ["MD", "KG", "UZ", "EE", "CA", "US", "TM", "TJ", "KZ", "AZ"], "tvl": ["KI", "FJ", "NZ", "NR"], "kpm": ["US"], "fin": ["CA", "US"], "aao": ["EG", "US"], "aiq": ["TJ"], "deu": ["BA", "HR", "BO", "BR", "FI", "PR", "RU", "NA", "PY", "TJ", "PH", "AE", "CL", "EE", "CA", "ZA", "EC", "AR", "AU", "IL", "KG", "MD", "UY", "UZ", "US", "KZ", "UA", "MZ"], "cat": ["DO", "CH", "CO", "VE", "CL", "DE", "US", "AR", "BE", "UY", "BR", "DZ", "MX", "CU"], "fuf": ["GM"], "klu": ["GH", "US", "NG"], "fud": ["NC"], "fue": ["TG"], "aii": ["BE", "FR", "CH", "LB", "GR", "RU", "GE", "CA", "DE", "AM", "IT", "CY", "NZ", "AU", "AT", "BR", "NL", "US", "AZ", "SE", "GB"], "mlt": ["CA", "IT", "US", "TN", "AU", "GB", "LY"], "ltz": ["US"], "sqt": ["AE"], "inh": ["UZ"], "ble": ["GM"], "hrx": ["AR", "UY", "PY", "CL"], "cab": ["US"], "tat": ["MD", "KG", "UZ", "AF", "TR", "US", "TM", "TJ"], "bhh": ["IL", "US"], "rad": ["US"], "pdt": ["CA"], "taq": ["DZ"], "uig": ["TW", "DE", "TR", "US", "AU", "AF", "TJ", "SA"], "jpn": ["DO", "DE", "BR", "FM", "BZ", "PW", "TW", "PY", "NZ", "PA", "TH", "PH", "GU", "AE", "CA", "AS", "AR", "AU", "GB", "MN", "US", "MP", "SG", "MX"], "myv": ["KG", "UZ", "AM", "TM"], "avl": ["SY", "JO"], "mya": ["MY", "US"], "khk": ["TW", "KG", "US"], "rar": ["NZ", "PF", "US"], "khm": ["FR", "CA", "CN", "US"], "rap": ["PF", "US"], "spa": ["BE", "CH", "GQ", "NO", "AI", "VI", "TT", "DE", "KY", "JM", "AU", "IL", "AW", "FI", "PH", "CA", "SE"], "rif": ["BE", "FR", "DE", "NL"], "tam": ["MU", "AE", "MY", "CA", "DE", "BH", "ZA", "US", "QA", "RE", "GB", "TH", "NL", "FJ", "SG"], "lyn": ["BW"], "khc": ["SG"], "tzm": ["FR"], "ava": ["KZ"], "lbo": ["US"], "mhs": ["NL"], "pap": ["PR", "VI", "NL", "US"], "bgp": ["IN"], "lif": ["BT"], "pau": ["GU", "US"], "oaa": ["JP"], "cjm": ["US"], "tah": ["NZ", "NC", "VU"], "kan": ["CA", "US"], "cja": ["FR", "YE", "US", "AU", "SA", "MY", "ID", "LY"], "nan": ["MY", "BN", "KH", "US", "TH", "PH", "SG", "ID"], "srp": ["RU", "CH", "AE", "GR", "ZM", "CA", "TR", "US", "CZ", "AU", "UA", "SE", "LY"], "tir": ["CA", "DE", "IL"], "csb": ["CA"], "lit": ["KG", "UZ", "EE", "CA", "US", "AR", "AU", "GB", "BR", "KZ", "UY", "TJ", "TM", "SE"], "efi": ["US"], "idb": ["AU", "IN"], "rmy": ["FR", "BG", "BR", "RU", "NL", "PT", "NO", "RO", "PL", "CO", "GR", "CL", "CA", "AL", "AR", "GB", "ES", "MD", "US", "UA", "MX", "SE"], "kdr": ["UA"], "pnb": ["CA", "AE", "GB", "US", "AF"], "pag": ["US"], "nya": ["BW"], "sin": ["AE", "CA", "US", "MV", "TH", "SG", "LY"], "afr": ["SZ", "CA", "NZ", "US", "MW", "AU", "LS"], "kac": ["US"], "kab": ["BE", "FR"], "kaa": ["RU"], "mar": ["MU", "CA", "IL", "US"], "lbn": ["US"], "sna": ["MW"], "lad": ["PR", "US", "IL"], "kir": ["RU", "TR", "US"], "isl": ["CA", "US"], "snk": ["CI"], "xsr": ["BT", "KR", "US"], "kal": ["DK"], "kas": ["GB", "US"], "kvr": ["BH"], "mad": ["SG"], "tyz": ["FR", "US"], "kat": ["KG", "UZ", "US", "TM", "TJ", "KZ", "UA"], "kaz": ["DE", "TR", "US", "UA"], "lav": ["VE", "CA", "DE", "US", "NZ", "AU", "GB", "BR", "UA", "SE"], "mal": ["AE", "MY", "CA", "BH", "US", "QA", "IL", "FJ", "SG", "GB"], "tyr": ["TH", "US"], "bsc": ["GM"], "urd": ["DE", "BH", "BW", "FJ", "MU", "NO", "TH", "NP", "ZM", "AE", "CA", "ZA", "GY", "GB", "OM", "US", "QA", "MW", "SA"], "acx": ["TZ", "DJ", "KE"], "knj": ["US"], "bug": ["MY"], "knf": ["GM"], "yue": ["NL", "MY", "BN", "NR", "ZA", "US", "MU", "NZ", "PA", "HN", "GB", "TH", "CR", "AU", "PH", "SG", "ID", "CA"], "hnj": ["GF", "FR", "AU", "CA", "US"], "mrq": ["FM"], "lhi": ["US"], "bcc": ["AE"], "cpx": ["MY", "SG"], "bze": ["NG"], "mri": ["US"], "ces": ["BG", "RS", "HR", "CA", "US", "IL", "RO", "UA"], "tha": ["AE", "CA", "SG", "US"]}


def upgrade():
    conn = Connection(op.get_bind())

    for hid, countries in REMOVE.items():
        l = conn.pk(Languoid, hid, attr='hid')
        for country in set(countries):
            c = conn.pk(Country, country)
            assert conn.first(Languoidcountry, country_pk=c, languoid_pk=l)
            conn.delete(Languoidcountry, country_pk=c, languoid_pk=l)

    for hid, countries in ADD.items():
        l = conn.pk(Languoid, hid, attr='hid')
        for c in set(countries):
            c = conn.pk(Country, c)
            conn.insert(Languoidcountry, country_pk=c, languoid_pk=l)


def downgrade():
    pass
