# coding=utf-8
"""add legacyref table

Revision ID: 4b89d69d005c
Revises: 378601404825
Create Date: 2014-12-05 11:16:01.392000

"""

# revision identifiers, used by Alembic.
revision = '4b89d69d005c'
down_revision = '378601404825'

import datetime

from alembic import op
import sqlalchemy as sa

from clld.db.meta import JSONEncodedDict


def upgrade():
    op.create_table('legacyref',
        sa.Column('pk', sa.Integer, primary_key=True, doc='primary key'),
        sa.Column('created', sa.DateTime(timezone=True), default=sa.func.now()),
        sa.Column('updated', sa.DateTime(timezone=True),
            default=sa.func.now(), onupdate=sa.func.now()),
        sa.Column('active', sa.Boolean, default=True),
        sa.Column('jsondata', JSONEncodedDict),
        sa.Column('id', sa.String, unique=True))

    insert_row = sa.text('INSERT INTO legacyref (pk, created, updated, active, id) '
        'VALUES (:pk, now(), now(), true, :id)')

    for id in IDS:
        op.execute(insert_row.bindparams(pk=id, id=id))


def downgrade():
    op.drop_table('legacyref')


IDS = [  # 6440
    11, 22, 28, 29, 32, 37, 43, 44, 45, 48,
    49, 51, 53, 56, 61, 63, 70, 73, 74, 76,
    79, 83, 91, 96, 103, 108, 109, 110, 112, 127,
    129, 130, 131, 140, 141, 148, 152, 160, 164, 174,
    175, 178, 181, 193, 212, 213, 214, 220, 226, 229,
    234, 238, 239, 244, 247, 251, 254, 256, 259, 263,
    268, 276, 277, 295, 298, 300, 301, 303, 312, 315,
    329, 332, 333, 334, 339, 341, 343, 344, 348, 351,
    353, 357, 359, 364, 375, 379, 394, 399, 402, 410,
    416, 420, 423, 427, 428, 444, 448, 457, 461, 467,
    468, 471, 483, 492, 494, 496, 507, 518, 523, 529,
    530, 532, 538, 543, 547, 548, 559, 561, 564, 570,
    576, 581, 583, 585, 588, 589, 593, 613, 621, 626,
    628, 634, 636, 637, 640, 645, 647, 651, 656, 657,
    659, 660, 663, 665, 667, 674, 676, 677, 678, 682,
    685, 688, 693, 694, 695, 707, 712, 715, 718, 720,
    723, 724, 731, 738, 739, 740, 750, 751, 754, 756,
    762, 763, 766, 768, 769, 774, 779, 786, 790, 795,
    804, 805, 806, 814, 818, 822, 824, 825, 826, 834,
    835, 836, 850, 854, 855, 857, 862, 871, 873, 875,
    877, 878, 895, 901, 904, 906, 912, 913, 914, 917,
    919, 921, 925, 926, 928, 931, 935, 940, 942, 943,
    948, 955, 957, 961, 965, 971, 982, 988, 992, 1001,
    1013, 1019, 1022, 1023, 1031, 1034, 1037, 1038, 1051, 1064,
    1067, 1069, 1071, 1072, 1074, 1075, 1078, 1084, 1086, 1091,
    1106, 1110, 1115, 1120, 1122, 1124, 1129, 1132, 1133, 1151,
    1160, 1168, 1169, 1170, 1181, 1194, 1195, 1198, 1199, 1207,
    1219, 1222, 1225, 1226, 1229, 1230, 1235, 1243, 1247, 1249,
    1255, 1263, 1264, 1274, 1277, 1288, 1295, 1296, 1301, 1303,
    1304, 1307, 1308, 1313, 1316, 1324, 1325, 1327, 1330, 1331,
    1335, 1347, 1354, 1359, 1360, 1371, 1376, 1378, 1380, 1381,
    1383, 1384, 1386, 1387, 1395, 1401, 1407, 1408, 1418, 1420,
    1424, 1425, 1430, 1433, 1446, 1448, 1452, 1454, 1457, 1459,
    1462, 1473, 1477, 1484, 1486, 1489, 1493, 1494, 1501, 1503,
    1506, 1508, 1509, 1512, 1513, 1515, 1518, 1519, 1523, 1525,
    1526, 1532, 1534, 1535, 1549, 1552, 1560, 1565, 1571, 1576,
    1580, 1582, 1588, 1596, 1607, 1608, 1609, 1610, 1612, 1614,
    1625, 1627, 1636, 1637, 1651, 1652, 1658, 1661, 1673, 1674,
    1681, 1682, 1695, 1701, 1706, 1709, 1710, 1712, 1713, 1714,
    1716, 1717, 1719, 1725, 1728, 1729, 1730, 1732, 1742, 1744,
    1745, 1751, 1756, 1758, 1770, 1777, 1787, 1789, 1790, 1796,
    1797, 1801, 1806, 1822, 1827, 1830, 1840, 1849, 1852, 1855,
    1859, 1862, 1863, 1865, 1872, 1873, 1874, 1876, 1890, 1895,
    1898, 1902, 1903, 1904, 1917, 1922, 1924, 1930, 1931, 1936,
    1939, 1940, 1947, 1955, 1958, 1959, 1961, 1962, 1964, 1965,
    1967, 1968, 1975, 1979, 1983, 1985, 1986, 1989, 1993, 1994,
    1995, 1998, 2001, 2005, 2006, 2009, 2011, 2017, 2023, 2026,
    2028, 2036, 2043, 2048, 2054, 2059, 2061, 2070, 2079, 2081,
    2087, 2089, 2098, 2116, 2118, 2124, 2131, 2138, 2142, 2151,
    2152, 2153, 2163, 2170, 2179, 2183, 2184, 2188, 2193, 2195,
    2201, 2202, 2209, 2210, 2212, 2217, 2218, 2221, 2223, 2226,
    2228, 2232, 2235, 2236, 2245, 2248, 2251, 2261, 2264, 2265,
    2267, 2271, 2272, 2277, 2284, 2288, 2289, 2292, 2295, 2296,
    2298, 2308, 2310, 2315, 2322, 2324, 2325, 2328, 2331, 2337,
    2343, 2344, 2356, 2370, 2375, 2376, 2381, 2384, 2386, 2387,
    2389, 2391, 2402, 2404, 2407, 2408, 2410, 2411, 2415, 2416,
    2417, 2419, 2421, 2425, 2434, 2435, 2440, 2451, 2454, 2470,
    2476, 2482, 2486, 2489, 2490, 2493, 2500, 2503, 2505, 2506,
    2513, 2514, 2519, 2531, 2532, 2535, 2538, 2557, 2561, 2569,
    2570, 2571, 2572, 2578, 2583, 2590, 2595, 2596, 2597, 2600,
    2602, 2605, 2610, 2612, 2620, 2629, 2630, 2632, 2633, 2635,
    2645, 2653, 2659, 2669, 2673, 2677, 2681, 2683, 2685, 2692,
    2703, 2706, 2709, 2711, 2718, 2723, 2724, 2725, 2731, 2734,
    2742, 2743, 2746, 2748, 2753, 2757, 2761, 2766, 2771, 2774,
    2781, 2786, 2794, 2795, 2798, 2799, 2800, 2804, 2807, 2809,
    2819, 2832, 2839, 2843, 2850, 2851, 2854, 2855, 2858, 2865,
    2882, 2885, 2888, 2890, 2891, 2898, 2903, 2905, 2909, 2921,
    2925, 2935, 2936, 2943, 2944, 2945, 2950, 2955, 2970, 2971,
    2972, 2977, 2981, 2982, 2983, 2988, 2989, 2998, 2999, 3003,
    3004, 3008, 3013, 3015, 3017, 3019, 3032, 3036, 3037, 3040,
    3041, 3042, 3054, 3055, 3062, 3063, 3065, 3068, 3070, 3071,
    3077, 3080, 3083, 3087, 3102, 3109, 3119, 3135, 3136, 3137,
    3140, 3144, 3150, 3155, 3158, 3159, 3161, 3162, 3163, 3166,
    3170, 3173, 3174, 3176, 3180, 3184, 3186, 3187, 3195, 3196,
    3206, 3207, 3211, 3212, 3219, 3221, 3229, 3233, 3234, 3243,
    3249, 3252, 3256, 3266, 3267, 3269, 3271, 3276, 3281, 3290,
    3298, 3302, 3304, 3305, 3310, 3312, 3314, 3324, 3333, 3335,
    3338, 3347, 3348, 3349, 3351, 3355, 3364, 3365, 3367, 3370,
    3372, 3375, 3376, 3384, 3410, 3420, 3422, 3424, 3454, 3458,
    3464, 3466, 3484, 3486, 3491, 3492, 3496, 3497, 3499, 3501,
    3506, 3508, 3513, 3519, 3520, 3521, 3522, 3523, 3530, 3532,
    3536, 3537, 3544, 3545, 3552, 3553, 3557, 3558, 3560, 3561,
    3562, 3564, 3569, 3571, 3580, 3582, 3585, 3587, 3588, 3589,
    3591, 3594, 3606, 3607, 3611, 3617, 3619, 3620, 3624, 3640,
    3650, 3658, 3671, 3672, 3679, 3683, 3691, 3695, 3699, 3707,
    3710, 3711, 3714, 3715, 3719, 3728, 3729, 3734, 3736, 3737,
    3738, 3751, 3752, 3760, 3763, 3767, 3771, 3779, 3782, 3785,
    3792, 3798, 3802, 3804, 3808, 3809, 3815, 3820, 3825, 3839,
    3847, 3848, 3849, 3860, 3862, 3866, 3869, 3872, 3875, 3876,
    3877, 3881, 3883, 3895, 3901, 3909, 3910, 3912, 3914, 3916,
    3918, 3921, 3922, 3923, 3925, 3928, 3929, 3930, 3934, 3936,
    3941, 3942, 3944, 3953, 3960, 3964, 3972, 3981, 3987, 3993,
    3998, 3999, 4005, 4007, 4012, 4022, 4032, 4034, 4038, 4040,
    4045, 4047, 4048, 4055, 4057, 4065, 4067, 4070, 4086, 4091,
    4092, 4099, 4100, 4115, 4120, 4123, 4124, 4133, 4136, 4144,
    4145, 4147, 4148, 4151, 4152, 4153, 4162, 4177, 4179, 4183,
    4185, 4186, 4188, 4193, 4195, 4199, 4200, 4205, 4206, 4207,
    4211, 4217, 4221, 4233, 4241, 4244, 4247, 4252, 4256, 4264,
    4267, 4270, 4272, 4274, 4275, 4278, 4285, 4294, 4301, 4303,
    4307, 4311, 4313, 4319, 4324, 4327, 4330, 4331, 4334, 4338,
    4341, 4344, 4351, 4358, 4362, 4366, 4369, 4373, 4375, 4379,
    4381, 4385, 4386, 4387, 4388, 4392, 4397, 4398, 4400, 4401,
    4406, 4408, 4409, 4410, 4411, 4421, 4425, 4426, 4436, 4448,
    4454, 4458, 4460, 4462, 4463, 4464, 4466, 4473, 4478, 4485,
    4490, 4499, 4506, 4507, 4509, 4514, 4516, 4519, 4521, 4529,
    4537, 4538, 4539, 4544, 4550, 4553, 4557, 4558, 4559, 4564,
    4567, 4572, 4574, 4575, 4576, 4583, 4585, 4593, 4597, 4606,
    4610, 4617, 4624, 4627, 4628, 4629, 4634, 4635, 4637, 4638,
    4643, 4647, 4652, 4658, 4659, 4660, 4662, 4671, 4683, 4695,
    4696, 4698, 4699, 4702, 4711, 4712, 4713, 4720, 4725, 4726,
    4735, 4737, 4740, 4747, 4750, 4752, 4754, 4771, 4775, 4789,
    4792, 4802, 4804, 4817, 4826, 4834, 4835, 4840, 4845, 4850,
    4858, 4860, 4864, 4866, 4875, 4883, 4887, 4891, 4901, 4902,
    4903, 4904, 4906, 4930, 4932, 4935, 4938, 4947, 4958, 4964,
    4965, 4969, 4970, 4973, 4976, 4977, 4980, 4985, 4991, 4995,
    5001, 5009, 5012, 5013, 5016, 5019, 5025, 5026, 5031, 5032,
    5036, 5038, 5050, 5053, 5054, 5068, 5072, 5078, 5080, 5081,
    5082, 5091, 5092, 5095, 5100, 5101, 5105, 5109, 5110, 5113,
    5114, 5116, 5117, 5122, 5128, 5129, 5132, 5136, 5140, 5146,
    5151, 5153, 5154, 5155, 5156, 5157, 5160, 5161, 5164, 5166,
    5171, 5173, 5178, 5182, 5190, 5196, 5202, 5207, 5209, 5210,
    5211, 5212, 5221, 5226, 5230, 5236, 5237, 5243, 5244, 5245,
    5248, 5250, 5256, 5260, 5264, 5270, 5275, 5276, 5279, 5281,
    5282, 5289, 5290, 5291, 5294, 5297, 5302, 5303, 5315, 5318,
    5324, 5325, 5328, 5329, 5333, 5334, 5338, 5340, 5341, 5344,
    5349, 5360, 5365, 5370, 5375, 5378, 5381, 5387, 5389, 5397,
    5400, 5404, 5409, 5416, 5418, 5419, 5429, 5436, 5443, 5444,
    5445, 5449, 5450, 5451, 5453, 5460, 5466, 5467, 5469, 5474,
    5475, 5479, 5484, 5485, 5487, 5488, 5489, 5491, 5497, 5499,
    5500, 5502, 5505, 5509, 5510, 5512, 5513, 5514, 5515, 5518,
    5519, 5523, 5527, 5529, 5530, 5544, 5557, 5559, 5560, 5562,
    5563, 5565, 5569, 5575, 5577, 5578, 5580, 5588, 5589, 5591,
    5597, 5598, 5600, 5609, 5610, 5612, 5615, 5617, 5629, 5630,
    5636, 5639, 5641, 5643, 5646, 5647, 5650, 5656, 5658, 5664,
    5665, 5672, 5674, 5676, 5677, 5678, 5679, 5680, 5681, 5684,
    5687, 5688, 5689, 5693, 5700, 5702, 5706, 5714, 5722, 5724,
    5730, 5732, 5734, 5737, 5740, 5744, 5746, 5749, 5754, 5755,
    5756, 5764, 5769, 5775, 5778, 5780, 5792, 5800, 5804, 5805,
    5807, 5811, 5816, 5820, 5824, 5829, 5830, 5834, 5835, 5837,
    5862, 5863, 5866, 5870, 5871, 5873, 5878, 5887, 5889, 5891,
    5893, 5894, 5895, 5901, 5905, 5910, 5911, 5912, 5914, 5915,
    5916, 5917, 5919, 5921, 5923, 5927, 5937, 5941, 5942, 5943,
    5956, 5957, 5959, 5962, 5963, 5966, 5967, 5969, 5970, 5979,
    5981, 5988, 5991, 5997, 6003, 6017, 6020, 6023, 6025, 6028,
    6036, 6039, 6040, 6045, 6047, 6051, 6055, 6060, 6062, 6065,
    6071, 6081, 6082, 6083, 6096, 6098, 6099, 6102, 6105, 6109,
    6112, 6119, 6123, 6125, 6126, 6131, 6137, 6139, 6145, 6147,
    6148, 6149, 6151, 6152, 6157, 6158, 6160, 6170, 6175, 6176,
    6182, 6188, 6190, 6192, 6196, 6197, 6201, 6205, 6208, 6210,
    6211, 6214, 6220, 6223, 6227, 6241, 6242, 6246, 6249, 6252,
    6254, 6258, 6265, 6271, 6279, 6283, 6292, 6296, 6298, 6299,
    6305, 6306, 6308, 6310, 6320, 6323, 6326, 6329, 6332, 6337,
    6338, 6339, 6355, 6363, 6364, 6378, 6381, 6382, 6386, 6389,
    6392, 6406, 6410, 6413, 6414, 6416, 6417, 6420, 6431, 6434,
    6437, 6445, 6450, 6456, 6457, 6466, 6479, 6489, 6491, 6496,
    6497, 6499, 6502, 6503, 6510, 6515, 6519, 6520, 6526, 6527,
    6533, 6535, 6540, 6544, 6550, 6554, 6555, 6570, 6578, 6581,
    6589, 6593, 6594, 6606, 6607, 6613, 6617, 6625, 6630, 6632,
    6633, 6637, 6647, 6650, 6656, 6657, 6658, 6659, 6664, 6667,
    6670, 6673, 6680, 6682, 6687, 6701, 6717, 6718, 6724, 6728,
    6729, 6731, 6732, 6733, 6735, 6736, 6746, 6749, 6753, 6754,
    6767, 6774, 6775, 6781, 6786, 6790, 6792, 6794, 6795, 6797,
    6801, 6802, 6810, 6819, 6823, 6824, 6828, 6831, 6833, 6835,
    6837, 6845, 6847, 6848, 6851, 6854, 6858, 6866, 6883, 6884,
    6885, 6888, 6895, 6897, 6903, 6904, 6906, 6908, 6917, 6919,
    6923, 6926, 6928, 6938, 6944, 6949, 6952, 6957, 6958, 6960,
    6966, 6970, 6975, 6976, 6983, 6993, 7005, 7011, 7013, 7015,
    7022, 7030, 7032, 7033, 7034, 7037, 7043, 7051, 7056, 7060,
    7061, 7072, 7081, 7089, 7092, 7093, 7104, 7108, 7119, 7120,
    7131, 7133, 7135, 7137, 7138, 7142, 7144, 7159, 7162, 7169,
    7171, 7173, 7177, 7180, 7183, 7185, 7186, 7187, 7188, 7197,
    7198, 7209, 7221, 7223, 7224, 7225, 7230, 7268, 7271, 7347,
    7356, 7412, 7446, 7463, 7517, 7530, 7543, 7586, 7790, 7842,
    7864, 7868, 8273, 8523, 9016, 9041, 9096, 9126, 9172, 9187,
    9204, 9205, 9314, 9542, 9678, 9846, 10088, 10094, 10241, 10293,
    10484, 10610, 10614, 10678, 10754, 11084, 11151, 11169, 11233, 11284,
    11359, 11548, 11550, 11692, 11895, 11947, 11963, 12002, 12085, 12158,
    12181, 12295, 12484, 12705, 12743, 12775, 13165, 13183, 13260, 13376,
    13462, 13492, 13711, 13760, 13832, 13853, 13905, 13907, 14126, 14134,
    14199, 14202, 14227, 14319, 14539, 14578, 14670, 14784, 14842, 14860,
    14876, 14964, 15031, 15355, 15577, 15654, 15738, 15908, 16039, 16040,
    16098, 16273, 16297, 16452, 16453, 16592, 16633, 16904, 16965, 17079,
    17182, 17243, 17333, 17401, 17446, 17564, 17569, 17850, 17948, 18032,
    18079, 18248, 18523, 18800, 18801, 18887, 18959, 19209, 19381, 19606,
    19702, 19714, 19750, 19804, 19944, 20281, 20399, 20425, 20618, 20723,
    20793, 20868, 20889, 21082, 21093, 21361, 21365, 21366, 21521, 21545,
    21671, 21725, 21772, 21837, 21924, 21945, 21996, 22227, 22276, 22371,
    22492, 22525, 22570, 22689, 22782, 22932, 23101, 23231, 23335, 23360,
    23374, 23577, 23583, 23684, 23786, 23830, 23997, 24027, 24251, 24257,
    24307, 24339, 24581, 25253, 25413, 25547, 26149, 26310, 26316, 26741,
    26886, 27410, 27427, 27492, 27777, 27795, 27883, 27926, 27964, 28008,
    28046, 28327, 28865, 28890, 28968, 29006, 29102, 29337, 29448, 29544,
    29557, 29805, 29829, 29886, 29943, 30227, 30266, 30351, 30880, 31195,
    31265, 31268, 31442, 31506, 31787, 32010, 32198, 32521, 32551, 32569,
    32613, 32661, 32792, 32820, 32826, 33408, 33510, 33619, 33657, 33729,
    33896, 34112, 34154, 34253, 34513, 34854, 34981, 35091, 35328, 35336,
    35615, 35686, 35721, 35751, 35827, 35890, 36062, 36549, 36668, 36920,
    37011, 37074, 37208, 37271, 37343, 37549, 37550, 37551, 37686, 37687,
    37808, 37838, 37952, 37966, 38036, 38105, 38132, 38372, 38556, 38729,
    38807, 38816, 38830, 38987, 39262, 39432, 39895, 39962, 40122, 40176,
    40266, 40520, 40641, 40753, 40943, 41159, 41657, 41668, 41680, 41749,
    41805, 41981, 42105, 42140, 42143, 42348, 42418, 42577, 42627, 42744,
    42951, 43033, 43121, 43215, 43674, 43745, 43766, 43770, 43886, 43907,
    44068, 44139, 44170, 44543, 44923, 44964, 45182, 45261, 45307, 45320,
    45685, 45900, 45963, 46019, 46078, 46268, 46546, 46555, 46839, 47429,
    47482, 47516, 47518, 47813, 48040, 48043, 48062, 48630, 48679, 48747,
    48748, 49084, 49112, 49138, 49201, 49342, 49358, 49385, 49411, 49767,
    49808, 49862, 49876, 49886, 49935, 50062, 50497, 50728, 50913, 51028,
    51075, 51251, 51539, 51595, 51636, 51709, 51720, 51997, 52088, 52148,
    52342, 52403, 52404, 52530, 52573, 52722, 52789, 53075, 53514, 53551,
    53563, 53601, 53643, 53732, 53767, 53829, 53899, 54197, 54218, 54473,
    54800, 55019, 55278, 55471, 55584, 55819, 55822, 55869, 56096, 56308,
    56405, 56609, 56621, 56655, 56817, 56926, 57142, 57177, 57231, 57565,
    57581, 57637, 57673, 57754, 58104, 58198, 58272, 58359, 58426, 58558,
    58582, 58638, 58750, 58934, 58986, 59247, 59284, 59379, 59383, 59449,
    59485, 59492, 59578, 59620, 59924, 60089, 60187, 60194, 60251, 60298,
    60337, 60362, 60365, 60464, 60524, 60544, 60754, 60794, 60873, 60974,
    61046, 61247, 61288, 61297, 61344, 61426, 61428, 61514, 61677, 61925,
    62044, 62590, 62710, 63091, 63145, 63197, 63218, 63300, 63322, 63373,
    63458, 63471, 63637, 63790, 63846, 63999, 64306, 64309, 64425, 64479,
    64546, 64678, 64721, 64785, 64845, 64846, 64963, 65220, 65221, 65245,
    65267, 65299, 65386, 65545, 65757, 65760, 65801, 65884, 65965, 66043,
    66349, 66405, 66501, 66561, 66618, 66773, 66820, 66941, 67344, 67362,
    67376, 67457, 67621, 67725, 67830, 67831, 67923, 67936, 67960, 68005,
    68085, 68086, 68095, 68195, 68217, 68414, 68508, 68733, 68734, 69135,
    69267, 69285, 69329, 69413, 69891, 70001, 70094, 70146, 70260, 70279,
    70595, 70602, 71183, 71198, 71720, 71721, 71768, 71808, 71831, 71998,
    72129, 72257, 72415, 72476, 72535, 72605, 72644, 72785, 72821, 72930,
    72978, 72979, 73046, 73144, 73267, 73272, 73292, 73338, 73370, 73453,
    73464, 73571, 73761, 73842, 74146, 74172, 74426, 74457, 74623, 74965,
    75048, 75136, 75149, 75213, 75216, 75268, 75378, 75423, 75435, 75525,
    75561, 75616, 75678, 75773, 75782, 75869, 76112, 76120, 76190, 76319,
    76426, 76560, 76568, 76682, 76707, 76819, 76929, 77013, 77027, 77137,
    77384, 77601, 77612, 77617, 77633, 77735, 77770, 77813, 77951, 77969,
    78041, 78572, 78815, 78835, 78884, 78903, 78932, 79018, 79019, 79434,
    79502, 79563, 79935, 79970, 80184, 80265, 80266, 80427, 80428, 80436,
    80446, 80458, 80560, 80737, 80778, 80846, 80951, 80979, 81002, 81042,
    81083, 81250, 81477, 81772, 81950, 82125, 82165, 82298, 82387, 82499,
    82504, 82582, 82647, 82686, 82869, 82912, 82984, 83184, 83190, 83245,
    83405, 83458, 83581, 83830, 83857, 83882, 84149, 84313, 84532, 84535,
    84536, 84622, 84651, 84758, 84897, 84906, 85518, 85534, 85612, 85733,
    85800, 85859, 86283, 86420, 86584, 86683, 86712, 86809, 86828, 86921,
    86957, 87118, 87173, 87317, 87499, 87537, 87705, 87994, 88001, 88030,
    88303, 88371, 88472, 88518, 88581, 88661, 89156, 89203, 89204, 89406,
    89501, 89731, 89755, 90115, 90258, 90272, 90312, 90466, 90495, 90725,
    90855, 90877, 91040, 91123, 91138, 91178, 91202, 91248, 91347, 91365,
    91532, 91642, 91643, 91644, 91649, 91970, 92101, 92167, 92361, 92377,
    92444, 92481, 92691, 92788, 93080, 93220, 93419, 93648, 93670, 93933,
    93967, 94088, 94162, 94184, 94534, 94544, 94579, 94633, 94762, 94803,
    94852, 95008, 95468, 95522, 95544, 95570, 95867, 95956, 95978, 96052,
    96650, 97029, 97303, 97320, 97402, 97507, 97564, 97640, 98034, 98104,
    98125, 98132, 98158, 98366, 98437, 98559, 98585, 98631, 98811, 98857,
    98917, 98918, 98933, 99143, 99210, 99280, 99282, 99294, 99422, 99538,
    99616, 99637, 99667, 99850, 99898, 99950, 100148, 100484, 100649, 100778,
    101022, 101146, 101506, 101888, 101904, 101912, 101980, 102206, 102495, 102799,
    102808, 102958, 103141, 103252, 103267, 103284, 103643, 103649, 103770, 103811,
    103900, 104260, 104328, 104397, 104400, 104421, 104433, 104492, 104544, 104545,
    104546, 104552, 104828, 104831, 104834, 104922, 104976, 105202, 105286, 105337,
    105382, 105467, 105469, 105470, 105843, 105881, 106077, 106237, 106414, 106656,
    106745, 106751, 106775, 106845, 107099, 107265, 107477, 107502, 107548, 107838,
    107878, 108082, 108228, 108486, 108566, 108576, 108644, 108768, 108771, 108989,
    109021, 109023, 109106, 109153, 109268, 109392, 109659, 109855, 109912, 109988,
    110032, 110073, 110108, 110155, 110164, 110334, 110469, 110490, 110535, 110623,
    110729, 110751, 110772, 110798, 110953, 111250, 111251, 111397, 111456, 111554,
    111571, 111636, 112023, 112026, 112257, 112481, 112634, 112762, 112784, 112916,
    113093, 113480, 113646, 113802, 113880, 114003, 114315, 114765, 114817, 114824,
    115128, 115376, 115592, 115632, 115724, 115860, 116089, 116156, 116226, 116366,
    116479, 116523, 116663, 116682, 116812, 116819, 116841, 116884, 116906, 117173,
    117383, 117665, 118083, 118120, 118128, 118185, 118279, 118344, 118943, 118969,
    118993, 119021, 119044, 119048, 119105, 119207, 119522, 119531, 119623, 119644,
    119830, 119958, 120065, 120216, 120220, 120298, 120302, 120311, 120690, 120790,
    121106, 121221, 121638, 121700, 121747, 121749, 121764, 121790, 121885, 121904,
    121937, 122035, 122303, 122305, 122488, 122766, 123115, 123136, 123227, 123237,
    123305, 123473, 123576, 123726, 123805, 123808, 123893, 123947, 124196, 124374,
    124417, 124553, 124606, 124626, 124901, 124912, 124955, 125048, 125082, 125089,
    125400, 125403, 125453, 125502, 125530, 125695, 125895, 125947, 126285, 126388,
    126482, 126793, 126947, 126949, 127014, 127029, 127035, 127038, 127138, 127245,
    127283, 127338, 127461, 127649, 127825, 128377, 128431, 128535, 128626, 128654,
    128667, 128848, 128854, 128993, 129135, 129184, 129189, 129336, 129601, 129644,
    129876, 130072, 130102, 130214, 130220, 130422, 130423, 130540, 130686, 130759,
    130782, 130829, 130929, 131125, 131218, 131357, 131415, 131508, 131606, 131708,
    131825, 131834, 132170, 132308, 132537, 132695, 132746, 132899, 133072, 133508,
    134005, 134012, 134042, 134168, 134419, 134519, 134760, 134938, 135058, 135220,
    135252, 135402, 135447, 135531, 135601, 135603, 135725, 135756, 135793, 135889,
    135973, 136018, 136076, 136294, 136453, 136737, 136793, 136795, 136834, 136848,
    136869, 136870, 136911, 137115, 137179, 137245, 137360, 137397, 137453, 137454,
    137457, 137679, 137683, 137730, 137795, 137905, 138009, 138065, 138094, 138133,
    138205, 138258, 138302, 138396, 138535, 138687, 138716, 138864, 138939, 139013,
    139660, 139683, 139784, 139837, 139838, 139909, 139915, 139956, 140037, 140102,
    140126, 140149, 140317, 140341, 140344, 140538, 140573, 140632, 140650, 140672,
    140688, 140997, 141063, 141103, 141184, 141244, 141283, 141425, 141440, 141686,
    141723, 141724, 141725, 141894, 141921, 142022, 142088, 142108, 142109, 142169,
    142330, 142341, 142429, 142474, 142593, 142769, 143036, 143272, 143409, 143543,
    143809, 143955, 144023, 144171, 144239, 144266, 144382, 144408, 144449, 144507,
    144516, 144570, 144687, 145018, 145040, 145126, 145386, 145422, 145459, 145532,
    145607, 145701, 145796, 146264, 146265, 146594, 146797, 146814, 147356, 147426,
    147713, 147918, 148016, 148160, 148174, 148352, 148666, 148811, 149286, 149458,
    149500, 149553, 149801, 149964, 150030, 150042, 150380, 150483, 150565, 150579,
    150876, 150992, 151122, 151123, 151168, 151297, 151375, 151400, 151515, 151730,
    151882, 151884, 151976, 151998, 152147, 152559, 152787, 153096, 153324, 153390,
    153591, 153731, 153780, 153849, 153947, 154120, 154128, 154168, 154195, 154248,
    154279, 154447, 154505, 154590, 154640, 154701, 154737, 154824, 154889, 154986,
    155034, 155074, 155138, 155297, 155460, 155480, 155617, 155809, 155887, 155892,
    155989, 156076, 156098, 156302, 156314, 156324, 156328, 156351, 156370, 156378,
    156382, 156383, 156425, 156498, 156513, 156645, 156683, 156739, 157092, 157097,
    157283, 157398, 157431, 157591, 157595, 157856, 157893, 157936, 157973, 157990,
    158218, 158668, 158710, 158738, 158757, 158846, 158865, 159115, 159323, 159407,
    159480, 159508, 159510, 159646, 159765, 159819, 159873, 159874, 160024, 160719,
    160936, 161045, 161054, 161056, 161181, 161276, 161332, 161858, 162240, 162261,
    162342, 162406, 162750, 162803, 162910, 163269, 163272, 163367, 163460, 163627,
    163632, 163880, 163979, 164142, 164177, 164193, 164312, 164628, 164690, 164695,
    164812, 164814, 164819, 164824, 164825, 164833, 164842, 164853, 164861, 164871,
    164876, 164878, 164881, 164882, 164883, 164884, 164885, 164887, 164888, 164893,
    164903, 164914, 164925, 164927, 164930, 164933, 164936, 164946, 164957, 164965,
    164966, 164968, 164971, 164977, 164979, 164980, 165012, 165023, 165034, 165045,
    165056, 165067, 165075, 165077, 165079, 165080, 165096, 165101, 165102, 165120,
    165143, 165147, 165148, 165219, 165240, 165265, 165275, 165278, 165314, 165315,
    165326, 165337, 165342, 165343, 165344, 165345, 165346, 165347, 165348, 165349,
    165350, 165351, 165352, 165359, 165392, 165403, 165407, 165410, 165417, 165418,
    165419, 165420, 165421, 165422, 165423, 165424, 165425, 165426, 165427, 165428,
    165429, 165430, 165431, 165432, 165433, 165434, 165435, 165436, 165437, 165438,
    165439, 165440, 165441, 165442, 165443, 165444, 165445, 165446, 165447, 165448,
    165449, 165450, 165451, 165452, 165453, 165457, 165469, 165473, 165484, 165496,
    165506, 165513, 165516, 165518, 165529, 165539, 165540, 165550, 165551, 165562,
    165573, 165583, 165594, 165597, 165608, 165619, 165630, 165632, 165633, 165641,
    165652, 165657, 165663, 165674, 165685, 165696, 165699, 165700, 165701, 165702,
    165708, 165712, 165719, 165730, 165741, 165752, 165762, 165773, 165784, 165787,
    165788, 165795, 165805, 165809, 165814, 165817, 165824, 165828, 165831, 165839,
    165850, 165853, 165855, 165861, 165869, 165872, 165874, 165875, 165883, 165892,
    165894, 165896, 165898, 165905, 165906, 165909, 165912, 165916, 165928, 165939,
    165950, 165961, 165971, 165981, 165983, 165986, 165991, 166002, 166003, 166004,
    166013, 166024, 166027, 166037, 166048, 166059, 166067, 166070, 166081, 166092,
    166103, 166109, 166110, 166114, 166118, 166125, 166148, 166157, 166158, 166168,
    166178, 166189, 166200, 166211, 166222, 166233, 166241, 166244, 166254, 166262,
    166273, 166275, 166283, 166294, 166305, 166314, 166316, 166317, 166324, 166327,
    166338, 166349, 166358, 166366, 166376, 166377, 166388, 166394, 166399, 166405,
    166410, 166421, 166432, 166443, 166454, 166466, 166477, 166488, 166499, 166510,
    166521, 166524, 166525, 166532, 166543, 166553, 166554, 166558, 166559, 166560,
    166565, 166577, 166588, 166589, 166598, 166599, 166600, 166610, 166621, 166632,
    166654, 166675, 166684, 166685, 166690, 166691, 166692, 166693, 166700, 166711,
    166722, 166733, 166735, 166736, 166737, 166738, 166739, 166740, 166744, 166755,
    166773, 166774, 166775, 166777, 166788, 166789, 166800, 166806, 166811, 166821,
    166822, 166823, 166824, 166825, 166826, 166827, 166828, 166829, 166830, 166831,
    166832, 166833, 166837, 166838, 166839, 166844, 166852, 166853, 166855, 166861,
    166864, 166865, 166866, 166867, 166876, 166877, 166878, 166880, 166881, 166883,
    166888, 166890, 166891, 166892, 166893, 166894, 166899, 166909, 166911, 166922,
    166929, 166930, 166933, 166936, 166944, 166955, 166966, 166977, 166988, 166999,
    167007, 167010, 167015, 167016, 167017, 167018, 167022, 167033, 167044, 167055,
    167066, 167077, 167088, 167099, 167110, 167121, 167130, 167133, 167144, 167155,
    167158, 167166, 167169, 167177, 167188, 167199, 167221, 167224, 167232, 167244,
    167255, 167266, 167277, 167288, 167321, 167339, 167343, 167354, 167355, 167366,
    167377, 167387, 167398, 167409, 167420, 167431, 167434, 167435, 167436, 167437,
    167439, 167442, 167444, 167453, 167465, 167476, 167487, 167498, 167509, 167520,
    167531, 167541, 167552, 167555, 167563, 167575, 167586, 167597, 167608, 167611,
    167619, 167628, 167630, 167641, 167692, 167694, 167699, 167702, 167713, 167789,
    167813, 167837, 167928, 167929, 167953, 167954, 167955, 167957, 167958, 167959,
    167960, 168069, 168125, 168173, 168212, 168233, 168236, 168280, 168281, 168282,
    168283, 168284, 168285, 168295, 168329, 168361, 168415, 168417, 168449, 168466,
    168489, 168503, 168581, 168635, 168646, 168675, 168676, 168678, 168679, 168680,
    168682, 168683, 168684, 168685, 168688, 168689, 168690, 168691, 168692, 168694,
    168695, 168696, 168698, 168729, 168758, 168783, 168785, 168787, 168789, 168790,
    168791, 168792, 168793, 168794, 168795, 168796, 168798, 168799, 168800, 168801,
    168802, 168805, 168814, 168815, 168816, 168817, 168820, 168821, 168822, 168823,
    168824, 168825, 168826, 168827, 168828, 168829, 168831, 168832, 168833, 168834,
    168835, 168836, 168837, 168838, 168839, 168840, 168842, 168843, 168844, 168845,
    168846, 168847, 168848, 168849, 168850, 168851, 168853, 168854, 168855, 168856,
    168857, 168858, 168859, 168860, 168861, 168863, 168864, 168865, 168866, 168867,
    168868, 168869, 168870, 168871, 168872, 168875, 168876, 168878, 168879, 168880,
    168881, 168892, 168893, 168894, 168897, 168898, 168901, 168906, 168907, 168908,
    168909, 168910, 168911, 168912, 168938, 168971, 168972, 168973, 168974, 168975,
    168976, 168977, 168978, 168979, 168980, 168981, 168983, 168984, 168992, 168998,
    168999, 169008, 169009, 169010, 169011, 169020, 169021, 169022, 169024, 169025,
    169027, 169028, 169046, 169081, 169122, 169123, 169125, 169127, 169128, 169130,
    169153, 169155, 169156, 169162, 169164, 169165, 169166, 169167, 169168, 169169,
    169170, 169171, 169172, 169173, 169175, 169176, 169177, 169183, 169184, 169186,
    169188, 169189, 169214, 169216, 169218, 169219, 169220, 169221, 169226, 169228,
    169229, 169237, 169239, 169244, 169245, 169249, 169250, 169252, 169266, 169272,
    169308, 169321, 169327, 169341, 169342, 169343, 169352, 169359, 169362, 169368,
    169369, 169370, 169371, 169372, 169373, 169374, 169375, 169376, 169377, 169378,
    169379, 169380, 169381, 169382, 169383, 169384, 169385, 169386, 169387, 169388,
    169389, 169390, 169391, 169394, 169397, 169398, 169401, 169411, 169419, 169437,
    169439, 169440, 169441, 169443, 169444, 169445, 169446, 169447, 169448, 169450,
    169451, 169452, 169453, 169454, 169455, 169456, 169457, 169458, 169459, 169461,
    169462, 169463, 169464, 169465, 169466, 169467, 169468, 169469, 169470, 169472,
    169473, 169474, 169475, 169476, 169477, 169478, 169479, 169480, 169481, 169483,
    169484, 169485, 169486, 169487, 169488, 169489, 169490, 169491, 169492, 169494,
    169495, 169496, 169497, 169517, 169524, 169525, 169526, 169527, 169529, 169530,
    169531, 169532, 169533, 169534, 169535, 169536, 169537, 169538, 169540, 169541,
    169542, 169543, 169544, 169545, 169546, 169547, 169548, 169549, 169551, 169552,
    169553, 169554, 169555, 169574, 169575, 169584, 169593, 169594, 169596, 169618,
    169629, 169631, 169632, 169633, 169634, 169635, 169636, 169637, 169638, 169639,
    169640, 169641, 169642, 169643, 169644, 169645, 169646, 169647, 169648, 169649,
    169650, 169651, 169652, 169653, 169654, 169655, 169656, 169657, 169658, 169659,
    169660, 169661, 169662, 169663, 169664, 169665, 169666, 169667, 169668, 169669,
    169670, 169671, 169672, 169673, 169674, 169675, 169676, 169677, 169678, 169680,
    169681, 169683, 169684, 169688, 169715, 169717, 169729, 169736, 169740, 169751,
    169752, 169755, 169762, 169773, 169784, 169785, 169792, 169793, 169794, 169795,
    169796, 169797, 169798, 169799, 169800, 169801, 169802, 169803, 169804, 169805,
    169806, 169807, 169808, 169809, 169810, 169811, 169812, 169813, 169814, 169815,
    169816, 169817, 169818, 169819, 169820, 169821, 169822, 169823, 169824, 169825,
    169826, 169827, 169829, 169830, 169831, 169832, 169833, 169834, 169835, 169836,
    169837, 169838, 169839, 169841, 169842, 169843, 169844, 169845, 169846, 169847,
    169848, 169849, 169850, 169852, 169853, 169854, 169855, 169856, 169857, 169858,
    169859, 169860, 169861, 169863, 169864, 169865, 169866, 169867, 169868, 169869,
    169870, 169871, 169872, 169875, 169912, 169944, 169963, 169979, 170013, 170024,
    170025, 170026, 170027, 170028, 170030, 170031, 170034, 170035, 170036, 170037,
    170038, 170039, 170040, 170041, 170081, 170082, 170083, 170084, 170085, 170086,
    170088, 170091, 170092, 170094, 170095, 170096, 170097, 170098, 170099, 170100,
    170101, 170102, 170103, 170105, 170106, 170107, 170108, 170109, 170110, 170119,
    170120, 170121, 170122, 170123, 170125, 170126, 170127, 170128, 170129, 170130,
    170131, 170132, 170133, 170134, 170136, 170144, 170145, 170147, 170148, 170149,
    170150, 170151, 170152, 170153, 170155, 170156, 170159, 170160, 170161, 170162,
    170163, 170164, 170165, 170166, 170167, 170168, 170174, 170175, 170179, 170192,
    170193, 170194, 170195, 170196, 170197, 170198, 170199, 170200, 170201, 170202,
    170203, 170204, 170205, 170206, 170207, 170208, 170209, 170211, 170212, 170213,
    170214, 170215, 170216, 170217, 170218, 170219, 170220, 170222, 170223, 170233,
    170235, 170306, 170320, 170321, 170322, 170323, 170329, 170331, 170373, 170376,
    170381, 170386, 170387, 170388, 170393, 170394, 170409, 170423, 170424, 170429,
    170431, 170437, 170438, 170452, 170454, 170455, 170456, 170457, 170458, 170459,
    170460, 170461, 170462, 170463, 170464, 170465, 170466, 170467, 170468, 170469,
    170470, 170471, 170472, 170473, 170474, 170476, 170477, 170479, 170480, 170481,
    170482, 170483, 170484, 170485, 170487, 170488, 170489, 170490, 170491, 170492,
    170493, 170494, 170495, 170496, 170498, 170499, 170500, 170501, 170502, 170503,
    170504, 170505, 170506, 170507, 170509, 170510, 170511, 170512, 170513, 170514,
    170515, 170516, 170517, 170518, 170520, 170521, 170522, 170523, 170524, 170525,
    170526, 170527, 170529, 170532, 170533, 170534, 170535, 170540, 170553, 170567,
    170589, 170593, 170604, 170605, 170607, 170608, 170609, 170610, 170611, 170613,
    170614, 170615, 170616, 170618, 170619, 170620, 170621, 170622, 170623, 170624,
    170625, 170626, 170627, 170629, 170630, 170631, 170635, 170637, 170638, 170640,
    170641, 170642, 170644, 170646, 170652, 170657, 170659, 170660, 170661, 170663,
    170664, 170665, 170666, 170667, 170668, 170669, 170670, 170671, 170672, 170674,
    170675, 170676, 170677, 170678, 170679, 170680, 170681, 170682, 170683, 170685,
    170686, 170687, 170688, 170689, 170690, 170691, 170692, 170693, 170694, 170696,
    170698, 170699, 170700, 170701, 170702, 170703, 170704, 170705, 170706, 170707,
    170708, 170709, 170710, 170711, 170712, 170713, 170714, 170715, 170716, 170718,
    170719, 170720, 170721, 170722, 170723, 170724, 170725, 170726, 170727, 170729,
    170730, 170731, 170732, 170733, 170734, 170735, 170736, 170737, 170738, 170740,
    170741, 170742, 170743, 170744, 170745, 170746, 170747, 170748, 170749, 170751,
    170752, 170753, 170754, 170755, 170756, 170757, 170758, 170759, 170760, 170762,
    170763, 170764, 170765, 170766, 170767, 170768, 170769, 170770, 170771, 170772,
    170774, 170775, 170776, 170777, 170778, 170779, 170780, 170781, 170782, 170783,
    170784, 170785, 170786, 170787, 170788, 170789, 170790, 170791, 170792, 170793,
    170794, 170796, 170797, 170798, 170799, 170800, 170801, 170802, 170803, 170804,
    170805, 170807, 170808, 170809, 170810, 170811, 170812, 170813, 170814, 170815,
    170816, 170823, 170840, 170841, 170842, 170845, 170846, 170847, 170848, 170849,
    170851, 170852, 170853, 170855, 170856, 170857, 170859, 170860, 170861, 170862,
    170863, 170864, 170865, 170868, 170869, 170870, 170871, 170872, 170873, 170874,
    170875, 170876, 170877, 170879, 170880, 170881, 170882, 170883, 170884, 170885,
    170886, 170887, 170888, 170890, 170891, 170892, 170893, 170894, 170895, 170896,
    170897, 170898, 170899, 170901, 170902, 170903, 170904, 170905, 170906, 170907,
    170908, 170909, 170910, 170912, 170913, 170914, 170915, 170916, 170917, 170918,
    170919, 170920, 170921, 170923, 170924, 170925, 170926, 170927, 170928, 170929,
    170930, 170931, 170932, 170934, 170935, 170936, 170937, 170938, 170939, 170940,
    170941, 170942, 170943, 170945, 170946, 170947, 170948, 170949, 170950, 170951,
    170952, 170953, 170954, 170956, 170957, 170958, 170959, 170960, 170961, 170962,
    170963, 170964, 170965, 170967, 170968, 170969, 170970, 170971, 170972, 170973,
    170974, 170975, 170976, 170979, 170980, 170981, 170982, 170983, 170984, 170985,
    170986, 170987, 170988, 170990, 170991, 170992, 170993, 170994, 170995, 170996,
    170997, 170998, 170999, 171001, 171002, 171003, 171004, 171005, 171006, 171007,
    171008, 171009, 171010, 171012, 171013, 171014, 171015, 171016, 171017, 171018,
    171019, 171020, 171021, 171023, 171024, 171025, 171026, 171027, 171028, 171029,
    171030, 171031, 171032, 171035, 171036, 171037, 171038, 171039, 171040, 171048,
    171049, 171050, 171051, 171052, 171053, 171054, 171055, 171056, 171057, 171058,
    171059, 171060, 171061, 171062, 171063, 171064, 171065, 171067, 171068, 171069,
    171070, 171071, 171072, 171073, 171080, 171081, 171084, 171085, 171086, 171087,
    171089, 171090, 171091, 171092, 171093, 171094, 171096, 171097, 171098, 171099,
    171101, 171102, 171103, 171104, 171105, 171106, 171107, 171118, 171119, 171120,
    171121, 171123, 171124, 171125, 171126, 171127, 171128, 171131, 171134, 171135,
    171136, 171137, 171138, 171139, 171140, 171141, 171142, 171143, 171144, 171145,
    171146, 171147, 171148, 171151, 171152, 171153, 171154, 171155, 171156, 171157,
    171158, 171159, 171161, 171162, 171163, 171164, 171165, 171166, 171167, 171168,
    171169, 171170, 171172, 171173, 171174, 171175, 171176, 171177, 171178, 171185,
    171186, 171187, 171188, 171189, 171190, 171191, 171192, 171195, 171196, 171197,
    171198, 171199, 171200, 171201, 171202, 171203, 171204, 171206, 171207, 171208,
    171209, 171210, 171211, 171212, 171215, 171217, 171218, 171228, 171229, 171230,
    171231, 171232, 171233, 171234, 171235, 171237, 171238, 171239, 171240, 171241,
    171242, 171243, 171244, 171245, 171246, 171247, 171248, 171249, 171250, 171251,
    171252, 171253, 171254, 171255, 171256, 171257, 171259, 171260, 171261, 171262,
    171263, 171264, 171265, 171266, 171270, 171271, 171272, 171273, 171274, 171275,
    171276, 171277, 171278, 171279, 171281, 171282, 171283, 171284, 171285, 171287,
    171296, 171298, 171299, 171300, 171301, 171302, 171304, 171305, 171306, 171307,
    171308, 171309, 171310, 171311, 171312, 171313, 171314, 171315, 171316, 171317,
    171318, 171320, 171321, 171322, 171323, 171325, 171326, 171327, 171328, 171329,
    171330, 171331, 171332, 171333, 171334, 171335, 171336, 171337, 171338, 171339,
    171340, 171341, 171342, 171343, 171344, 171345, 171346, 171347, 171348, 171349,
    171350, 171351, 171352, 171353, 171354, 171355, 171356, 171357, 171358, 171359,
    171360, 171361, 171362, 171363, 171364, 171365, 171366, 171367, 171368, 171369,
    171370, 171371, 171372, 171373, 171374, 171375, 171376, 171377, 171378, 171379,
    171380, 171381, 171382, 171383, 171384, 171385, 171386, 171390, 171395, 171396,
    171397, 171399, 171400, 171401, 171402, 171403, 171404, 171405, 171407, 171409,
    171410, 171411, 171413, 171414, 171415, 171416, 171417, 171418, 171419, 171420,
    171421, 171422, 171423, 171424, 171425, 171441, 171442, 171443, 171456, 171467,
    171473, 171474, 171476, 171487, 171489, 171490, 171492, 171493, 171494, 171495,
    171496, 171497, 171498, 171499, 171500, 171501, 171503, 171504, 171505, 171506,
    171507, 171508, 171509, 171510, 171511, 171512, 171514, 171516, 171517, 171518,
    171519, 171520, 171521, 171522, 171523, 171524, 171525, 171527, 171528, 171529,
    171530, 171531, 171532, 171533, 171534, 171535, 171536, 171538, 171539, 171540,
    171541, 171542, 171543, 171544, 171545, 171546, 171547, 171549, 171550, 171551,
    171552, 171553, 171554, 171555, 171556, 171557, 171558, 171560, 171561, 171562,
    171563, 171564, 171565, 171566, 171567, 171568, 171569, 171571, 171572, 171573,
    171574, 171575, 171576, 171577, 171578, 171579, 171580, 171581, 171582, 171583,
    171584, 171585, 171586, 171587, 171588, 171589, 171590, 171591, 171593, 171594,
    171595, 171596, 171597, 171598, 171599, 171600, 171601, 171602, 171604, 171606,
    171607, 171608, 171609, 171610, 171611, 171612, 171613, 171614, 171615, 171616,
    171617, 171619, 171620, 171621, 171622, 171623, 171624, 171625, 171628, 171629,
    171630, 171631, 171632, 171633, 171634, 171635, 171636, 171637, 171639, 171640,
    171641, 171642, 171643, 171644, 171645, 171646, 171647, 171648, 171650, 171651,
    171652, 171653, 171654, 171655, 171656, 171657, 171658, 171659, 171661, 171662,
    171663, 171664, 171665, 171666, 171667, 171672, 171673, 171674, 171675, 171676,
    171677, 171678, 171679, 171681, 171682, 171683, 171684, 171685, 171686, 171687,
    171688, 171689, 171690, 171697, 171732, 171735, 171781, 171801, 171812, 171818,
    171834, 171840, 171845, 171846, 171879, 171899, 171917, 171918, 171927, 171956,
    171971, 172008, 172067, 172071, 172131, 172132, 172133, 172136, 172137, 172138,
    172139, 172140, 172141, 172142, 172143, 172146, 172147, 172148, 172151, 172152,
    172153, 172155, 172157, 172158, 172159, 172160, 172161, 172162, 172163, 172165,
    172166, 172168, 172169, 172170, 172171, 172172, 172174, 172175, 172176, 172178,
    172179, 172180, 172181, 172182, 172183, 172184, 172186, 172187, 172188, 172189,
    172191, 172192, 172193, 172194, 172195, 172196, 172197, 172198, 172199, 172200,
    172201, 172202, 172203, 172204, 172205, 172206, 172207, 172208, 172209, 172210,
    172211, 172213, 172214, 172215, 172216, 172217, 172222, 172288, 172291, 172302,
    172368, 172373, 172375, 172377, 172399, 172413, 172414, 172417, 172429, 172450,
    172454, 172513, 172518, 172520, 172521, 172556, 172574, 172604, 172616, 172623,
    172660, 172684, 172704, 172715, 172747, 172786, 172805, 172810, 172823, 172840,
    172906, 172908, 172920, 172941, 172951, 172952, 172953, 172954, 172962, 172975,
    172979, 172980, 172984, 172985, 172992, 172993, 172994, 172995, 172996, 173009,
    173031, 173042, 173043, 173044, 173046, 173091, 173093, 173097, 173099, 173146,
    173303, 173378, 173389, 173399, 173403, 173410, 173417, 173420, 173431, 173442,
    173476, 173477, 173478, 173479, 173484, 173485, 173486, 173487, 173488, 173489,
    173490, 173491, 173492, 173493, 173494, 173495, 173496, 173497, 173500, 173501,
    173502, 173503, 173504, 173505, 173509, 173521, 173534, 173536, 173538, 173539,
    173540, 173541, 173543, 173544, 173545, 173546, 173547, 173550, 173552, 173553,
    173554, 173555, 173556, 173557, 173558, 173559, 173560, 173561, 173562, 173563,
    173564, 173565, 173567, 173568, 173575, 173580, 173581, 173582, 173583, 173584,
    173585, 173586, 173587, 173588, 173590, 173594, 173595, 173596, 173598, 173599,
    173608, 173619, 173629, 173650, 173655, 173661, 173672, 173683, 173690, 173691,
    173694, 173706, 173717, 173728, 173738, 173749, 173760, 173771, 173782, 173793,
    173799, 173801, 173802, 173803, 173804, 173805, 173806, 173807, 173808, 173809,
    173810, 173812, 173813, 173814, 173815, 173816, 173817, 173823, 173830, 173832,
    173833, 173834, 173835, 173837, 173841, 173844, 173845, 173846, 173847, 173848,
    173849, 173850, 173851, 173852, 173854, 173855, 173856, 173861, 173863, 173866,
    173867, 173878, 173879, 173880, 173907, 173908, 173910, 173911, 173912, 173913,
    173914, 173915, 173916, 173917, 173918, 173919, 173927, 173934, 173935, 173937,
    173956, 173959, 173962, 173963, 173965, 173967, 173968, 173969, 173970, 173971,
    173972, 173973, 173974, 173977, 173978, 173979, 173980, 173981, 173983, 173985,
    173994, 173996, 174001, 174002, 174003, 174004, 174005, 174006, 174007, 174008,
    174010, 174011, 174012, 174013, 174014, 174015, 174016, 174017, 174018, 174019,
    174023, 174027, 174028, 174031, 174034, 174036, 174038, 174040, 174045, 174046,
    174047, 174048, 174049, 174050, 174051, 174052, 174054, 174055, 174056, 174057,
    174058, 174059, 174060, 174061, 174062, 174063, 174065, 174066, 174067, 174068,
    174069, 174070, 174071, 174072, 174073, 174074, 174076, 174077, 174078, 174079,
    174080, 174081, 174082, 174083, 174084, 174085, 174086, 174088, 174089, 174090,
    174091, 174092, 174093, 174094, 174095, 174096, 174097, 174099, 174100, 174101,
    174102, 174103, 174104, 174105, 174106, 174107, 174108, 174110, 174111, 174112,
    174113, 174114, 174115, 174116, 174117, 174118, 174119, 174121, 174122, 174123,
    174124, 174125, 174126, 174127, 174128, 174129, 174130, 174131, 174132, 174133,
    174134, 174135, 174136, 174137, 174138, 174139, 174140, 174141, 174143, 174144,
    174145, 174146, 174147, 174148, 174149, 174150, 174151, 174152, 174154, 174155,
    174156, 174157, 174158, 174159, 174160, 174171, 174175, 174178, 174179, 174180,
    174182, 174192, 174198, 174199, 174203, 174204, 174205, 174214, 174218, 174220,
    174221, 174224, 174230, 174232, 174235, 174237, 174246, 174257, 174258, 174260,
    174262, 174263, 174267, 174268, 174269, 174270, 174271, 174272, 174273, 174276,
    174277, 174281, 174285, 174288, 174289, 174290, 174294, 174295, 174304, 174314,
    174325, 174336, 174341, 174342, 174343, 174344, 174345, 174347, 174351, 174353,
    174354, 174355, 174358, 174369, 174380, 174385, 174386, 174388, 174391, 174403,
    174414, 174425, 174426, 174428, 174435, 174446, 174455, 174462, 174473, 174483,
    174487, 174498, 174540, 174557, 174560, 174561, 174565, 174569, 174604, 174606,
    174611, 174627, 174642, 174658, 174661, 174688, 174691, 174695, 174700, 174768,
    174769, 174770, 174805, 174813, 174821, 174827, 174880, 174899, 174900, 174903,
    174911, 174923, 174930, 174936, 174938, 174942, 174944, 174950, 174967, 175073,
    175076, 175082, 175096, 175116, 175128, 175130, 175142, 175144, 175148, 175149,
    175160, 175184, 175194, 175197, 175198, 175199, 175207, 175211, 175231, 175233,
    175260, 175261, 175262, 175273, 175289, 175291, 175316, 175341, 175373, 175382,
    175397, 175403, 175433, 175435, 175449, 175455, 175457, 175483, 175533, 175544,
    175557, 175585, 175588, 175635, 175640, 175657, 175666, 175675, 175701, 175707,
    175742, 175749, 175763, 175767, 175778, 175852, 175871, 175876, 175888, 175978,
    175995, 176001, 176003, 176014, 176034, 176059, 176061, 176073, 176118, 176122,
    176220, 176341, 176373, 176374, 176429, 176443, 176457, 176462, 176475, 176517,
    176536, 176538, 176541, 176542, 176546, 176547, 176549, 176552, 176557, 176564,
    176568, 176577, 176578, 176581, 176586, 176590, 176595, 176597, 176609, 176611,
    176622, 176627, 176634, 176636, 176640, 176653, 176659, 176681, 176682, 176684,
    176702, 176707, 176718, 176724, 176733, 176738, 176740, 176768, 176769, 176792,
    176795, 176825, 176828, 176832, 176848, 176865, 176872, 176875, 176888, 176890,
    176895, 176896, 176908, 176912, 176917, 176922, 176923, 176934, 176937, 176938,
    176942, 176944, 176945, 176949, 176950, 176954, 176959, 176967, 176971, 176977,
    176980, 176981, 176982, 176983, 176991, 176994, 176995, 176996, 176997, 176998,
    176999, 177001, 177003, 177006, 177008, 177009, 177011, 177012, 177013, 177019,
    177020, 177026, 177027, 177029, 177030, 177032, 177037, 177039, 177044, 177045,
    177047, 177050, 177055, 177058, 177059, 177062, 177066, 177073, 177078, 177079,
    177088, 177091, 177096, 177117, 177174, 177238, 177260, 177268, 177278, 177279,
    177357, 177425, 177431, 177445, 177456, 177477, 177483, 177487, 177511, 177514,
    177540, 177545, 177560, 177565, 177606, 177607, 177613, 177619, 177630, 177675,
    177699, 177700, 177715, 177723, 177737, 177741, 177747, 177769, 177777, 177786,
    177799, 177803, 177814, 177818, 177827, 177832, 177837, 177896, 177934, 177955,
    177958, 177960, 177995, 177996, 177999, 178040, 178117, 178131, 178158, 178172,
    178177, 178187, 178222, 178264, 178265, 178272, 178275, 178297, 178306, 178313,
    178326, 178328, 178331, 178332, 178340, 178343, 178346, 178357, 178358, 178360,
    178365, 178368, 178370, 178373, 178384, 178388, 178410, 178415, 178425, 178549,
    178556, 178570, 178581, 178583, 178587, 178592, 178595, 178611, 178617, 178643,
    178656, 178660, 178662, 178666, 178675, 178683, 178694, 178702, 178716, 178720,
    178725, 178734, 178736, 178745, 178758, 178759, 178760, 178764, 178766, 178777,
    178780, 178806, 178811, 178828, 178844, 178857, 178858, 178862, 178887, 178905,
    178924, 178928, 178936, 178941, 178968, 178975, 178980, 179009, 179011, 179020,
    179021, 179035, 179039, 179048, 179092, 179098, 179100, 179101, 179104, 179120,
    179153, 179170, 179190, 179196, 179204, 179221, 179235, 179236, 179241, 179243,
    179257, 179258, 179262, 179268, 179269, 179281, 179285, 179290, 179291, 179309,
    179332, 179338, 179342, 179350, 179362, 179363, 179369, 179376, 179382, 179383,
    179399, 179404, 179412, 179452, 179465, 179472, 179476, 179480, 179483, 179487,
    179507, 179539, 179540, 179547, 179572, 179585, 179588, 179589, 179590, 179592,
    179617, 179674, 179675, 179680, 179681, 179682, 179812, 179815, 179817, 179819,
    179824, 179827, 179829, 179884, 179950, 179955, 180018, 180021, 180022, 180025,
    180026, 180027, 180048, 180049, 180052, 180059, 180162, 180164, 180166, 180167,
    180174, 180176, 180179, 180184, 180221, 180232, 180257, 180283, 180293, 180308,
    180310, 180313, 180315, 180325, 180326, 180333, 180344, 180406, 180442, 180446,
    180451, 180457, 180464, 180474, 180475, 180524, 180574, 180584, 180593, 180599,
    180630, 180634, 180652, 180681, 180699, 180709, 180713, 180746, 180766, 180813,
    180826, 180827, 180838, 180844, 180902, 180940, 180950, 180967, 180981, 180985,
    180998, 180999, 181012, 181013, 181014, 181015, 181019, 181021, 181022, 181040,
    181082, 181171, 181190, 181206, 181304, 181311, 181312, 181315, 181316, 181365,
    181388, 181396, 181400, 181408, 181432, 181437, 181452, 181456, 181478, 181479,
    181480, 181482, 181488, 181495, 181511, 181512, 181529, 181543, 181564, 181569,
    181591, 181657, 181672, 181677, 181678, 181679, 181680, 181683, 181685, 181708,
    181751, 181776, 181798, 181815, 181828, 181920, 181928, 181940, 181948, 181950,
    181995, 181998, 182027, 182042, 182057, 182092, 182116, 182122, 182127, 182130,
    182135, 182136, 182138, 182167, 182283, 182324, 182332, 182363, 182387, 182397,
    182448, 182471, 182492, 182494, 182495, 182496, 182502, 182507, 182534, 182538,
    182628, 182643, 182655, 182656, 182721, 182783, 182784, 182856, 182862, 182874,
    182925, 182984, 182990, 182995, 183033, 183064, 183092, 183093, 183100, 183106,
    183155, 183156, 183157, 183177, 183179, 183184, 183224, 183280, 183282, 183309,
    183456, 183458, 183462, 183500, 183531, 183577, 183582, 183585, 183589, 183591,
    183618, 183619, 183627, 183680, 183706, 183718, 183755, 183777, 183826, 183853,
    183864, 183868, 183871, 183872, 183907, 183910, 184016, 184020, 184074, 184087,
    184125, 184140, 184146, 184161, 184179, 184192, 184217, 184222, 184224, 184290,
    184303, 184330, 184353, 184355, 184398, 184420, 184510, 184516, 184519, 184520,
    184528, 184548, 184574, 184584, 184641, 184643, 184645, 184665, 184677, 184678,
    184692, 184701, 184705, 184710, 184716, 184719, 184724, 184767, 184784, 184787,
    184791, 184793, 184833, 184835, 184844, 184846, 184851, 184852, 184859, 184863,
    184881, 184898, 184902, 184930, 184944, 184960, 184962, 185043, 185047, 185058,
    185061, 185119, 185124, 185144, 185160, 185172, 185173, 185187, 185196, 185203,
    185207, 185214, 185216, 185218, 300909, 301911, 301963, 302027, 302390, 302519,
    302631, 302818, 302995, 303159, 303473, 303939, 304046, 304243, 304437, 304451,
    304833, 305466, 305701, 306315, 306659, 307187, 307420, 307653, 307875, 307949,
    308359, 308795, 309081, 309427, 309588, 309719, 309740, 309843, 309931, 311055,
    311232, 311337, 311659, 311777, 311975, 312405, 312445, 312649, 312741, 313396,
    313485, 313536, 313853, 314112, 314493, 315944, 317716, 317855, 318033, 318681,
]
