<!-- markdownlint-disable -->

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/commands/generate_docs.py#L0"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

# <kbd>module</kbd> `generate_docs.py`
Documentation generation script using lazydocs. 

This script generates comprehensive markdown documentation for the rxiv-maker Python modules that can be viewed directly on GitHub without requiring GitHub Pages. It provides detailed information about classes, methods, functions, and their signatures. 


---

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/commands/generate_docs.py#L17"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

## <kbd>function</kbd> `generate_module_docs`

```python
generate_module_docs(docs_dir, module_path)
```

Generate documentation for a specific module using lazydocs. 


---

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/commands/generate_docs.py#L43"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

## <kbd>function</kbd> `generate_enhanced_index`

```python
generate_enhanced_index(docs_dir, successful_modules)
```

Generate an enhanced index.md file with better organization. 



**Args:**
 
 - <b>`docs_dir`</b>:  Path to the docs directory 
 - <b>`successful_modules`</b>:  List of successfully generated module paths 


---

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/commands/generate_docs.py#L93"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

## <kbd>function</kbd> `main`

```python
main()
```

Generate API documentation using lazydocs with enhancements. 


