<!-- markdownlint-disable -->

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/processors/author_processor.py#L0"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

# <kbd>module</kbd> `author_processor.py`
Author information processing utilities for Rxiv-Maker. 

This module handles the generation of LaTeX author information sections, including authors and affiliations, corresponding authors, and extended author info. 


---

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/processors/author_processor.py#L8"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

## <kbd>function</kbd> `generate_authors_and_affiliations`

```python
generate_authors_and_affiliations(yaml_metadata)
```

Generate LaTeX author and affiliation blocks from YAML metadata. 


---

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/processors/author_processor.py#L110"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

## <kbd>function</kbd> `generate_corresponding_authors`

```python
generate_corresponding_authors(yaml_metadata)
```

Generate LaTeX corresponding authors section from YAML metadata. 


---

<a href="https://github.com/henriqueslab/rxiv-maker/blob/main/src/py/processors/author_processor.py#L163"><img align="right" style="float:right;" src="https://img.shields.io/badge/-source-cccccc?style=flat-square"></a>

## <kbd>function</kbd> `generate_extended_author_info`

```python
generate_extended_author_info(yaml_metadata)
```

Generate LaTeX extended author information section from YAML metadata. 


