# Rxiv-Maker: An Automated Template Engine for Streamlined Scientific Publications
<!-- note that this title is not rendered in the PDF, instead the one in the YAML metadata is used -->

## Abstract
Preprint servers have revolutionised scientific publishing, enabling rapid dissemination of research findings. However, researchers increasingly struggle with manuscript preparation without traditional journal production support. Rxiv-Maker addresses this challenge through a GitHub-native framework that converts markdown content to publication-ready PDFs using automated LaTeX processing. Unlike static documents, manuscripts become version-controlled, reproducible outputs that integrate seamlessly with collaborative development workflows. The framework supports programmatic figure generation from Python and R scripts, ensuring visualisations remain synchronised with underlying datasets and analysis pipelines. Key innovations include automated build environments, intelligent content protection during conversion, and Docker containerisation for reproducible execution across platforms. Rxiv-Maker democratises professional typesetting capabilities whilst maintaining computational transparency essential for open science. This manuscript exemplifies the framework's capabilities, being generated entirely through the automated pipeline to produce publication-quality output with embedded reproducibility guarantees.

## Main

<!-- Introduction -->

Scientific research increasingly depends on preprint servers such as arXiv, bioRxiv, and medRxiv for rapid dissemination [@beck2020;@levchenk2024;@Fraser2020_preprint_growth]. This trend, illustrated in @sfig:arxiv_growth and @sfig:preprint_trends, accelerates discovery whilst transferring quality control responsibilities from publishers to individual researchers [@Vale2019_preprints;@Tennant2016_academic_publishing]. Traditional manuscript preparation workflows remain anchored in proprietary formats that poorly integrate with version control systems, creating barriers for collaborative research [@lin2020].

This challenge proves particularly acute in computational research where algorithms, analytical methods, and processing pipelines evolve continuously. Fields ranging from computational biology to environmental modelling struggle to maintain synchronisation between evolving analysis methods and manuscript content, often resulting in publications that inadequately reflect underlying methodologies. Modern bioimage analysis exemplifies these challenges, where collaborative frameworks [@biaflows2024] and containerised analysis environments [@dl4miceverywhere2024] demonstrate the critical importance of reproducible computational workflows in scientific publishing.

Rxiv-Maker addresses these challenges through a developer-centric framework optimised for reproducible preprint preparation. Rather than pursuing universal format support, the system specialises in producing publication-quality PDFs through automated LaTeX processing, enabling seamless integration with Git workflows and continuous integration practices. The framework embeds reproducibility safeguards typically handled by journal production teams, ensuring manuscripts remain buildable across different systems and time periods.

This approach transforms manuscript preparation into a transparent, auditable process that democratises access to professional publishing workflows. The system includes a Visual Studio Code extension providing intelligent syntax highlighting, automated citation management, and seamless project integration. This extension enables researchers to leverage familiar development environments whilst maintaining rigorous version control and reproducibility guarantees essential for transparent science, bridging traditional authoring workflows with contemporary best practices in computational research.

![](FIGURES/Figure__system_diagram/Figure__system_diagram.svg)
{#fig:system_diagram tex_position="t"} **The Rxiv-Maker System Diagram.** The system integrates Markdown content, YAML metadata, Python and R scripts, and bibliography files through a processing engine. This engine leverages GitHub Actions, virtual environments, and LaTeX to produce a publication-ready scientific article, demonstrating a fully automated and reproducible pipeline.

![](FIGURES/Figure__workflow/Figure__workflow.svg)
{#fig:workflow width="\textwidth" tex_position="t"} **Rxiv-Maker Workflow: User Input vs. Automated Processing.** The framework clearly separates user responsibilities (content creation and configuration) from automated processes (parsing, conversion, compilation, and output generation). Users only need to write content and set preferences. At the same time, the system handles all technical aspects of manuscript preparation automatically, ensuring a streamlined workflow from markdown input to publication-ready PDF output.

Rxiv-Maker prioritises computational reproducibility throughout the publication process, addressing fundamental challenges where data analysis and computational workflows are central [@Donoho2010;@Sandve2013_reproducible_research;@Wilson2014_software_carpentry]. The framework enables programmatic generation of figures and tables using Python and R scripting with visualisation libraries including Matplotlib [@Hunter2007_matplotlib] and Seaborn [@Waskom2021_seaborn]. 

Figures are generated directly from source datasets during compilation, establishing transparent connections between raw data, processing pipelines, and final visualisations. When datasets are updated or algorithms refined, affected figures are automatically regenerated, ensuring consistency and eliminating outdated visualisations. The system integrates Mermaid.js [@Mermaid2023_documentation] for generating technical diagrams from text-based syntax, with the complete range of supported methods detailed in @stable:figure-formats.

This approach reframes manuscripts as executable outputs of the research process rather than static documentation. Built upon the HenriquesLab bioRxiv template [@HenriquesLab2015_template], Rxiv-Maker extends capabilities through automated processing pipelines. The architecture, detailed in @fig:system_diagram and @fig:workflow, provides robust build automation through GitHub Actions and virtual environments, with technical details described in @snote:figure-generation. 

Rxiv-Maker occupies a distinctive position within the academic authoring ecosystem. All-in-one systems like Quarto offer maximum versatility with multi-language and multi-format capabilities. Collaborative editors such as Overleaf democratise LaTeX through accessible web interfaces. Computational frameworks including MyST and Jupyter Book prioritise interactive, web-first outputs. Modern typesetting engines like Typst provide cleaner syntax and faster compilation. Rxiv-Maker specialises in developer-centric automation for reproducible PDF preprint generation, particularly suited to computational workflows where dynamic figure generation and algorithmic documentation are essential. This focused approach enables deeper specialisation for manuscripts involving evolving datasets and processing pipelines. A comprehensive comparison is provided in @stable:tool-comparison.

<!-- Results -->

Rxiv-Maker delivers an efficient workflow for producing publication-quality manuscripts that embody reproducible research principles. The system outputs professionally typeset PDF documents—exemplified by this article, generated entirely through the automated pipeline—demonstrating seamless integration of computational content with academic formatting. Markdown source files undergo automated conversion into structured LaTeX documents, compiled to produce PDFs with rigorous typography, proper pagination, and high-resolution figures maintaining publication standards.

The deployment strategy addresses computational reproducibility through Docker containerisation, encapsulating the complete environment—LaTeX distributions, Python libraries, R packages, and system dependencies—within immutable container images. GitHub Actions workflows leverage pre-compiled Docker images for standardised compilation processes, reducing build times from 8-10 minutes to approximately 2 minutes. The Docker engine mode (`RXIV_ENGINE=DOCKER`) enables researchers to generate PDFs with only Docker as a prerequisite, valuable for collaborative research across platforms or institutional settings with software restrictions [@Boettiger2015_docker_reproducibility].

PDF artefacts are automatically archived and made available, creating computational provenance from source files to final output. The system supports deployment in Google Colab notebooks for users requiring immediate feedback, maintaining reproducibility guarantees whilst offering real-time compilation. A Docker-accelerated version leverages udocker [@gomes2018] for containerized execution, reducing setup time from approximately 20 minutes to 4 minutes whilst providing pre-configured environments with all dependencies. This approach eliminates manual dependency installation and ensures consistent execution across Google Colab sessions. Available deployment strategies are compared in @stable:deployment-options.

Programmatic figure generation supports interactive environments including Jupyter notebooks [@Jupyter2016_notebook]. Python and R scripts placed within designated directories are automatically executed during compilation, loading data, performing analyses, and generating visualisations seamlessly included in the final PDF. Mermaid.js diagrams embedded within markdown are rendered into SVG images and incorporated into the document. This integration demonstrates closed-loop reproducibility, where manuscripts serve as verifiable, self-contained records of research findings.

The Visual Studio Code extension provides intelligent editing features including real-time syntax highlighting, autocompletion for bibliographic citations from BibTeX files, and seamless cross-reference management. The extension reduces cognitive load and minimises syntax errors whilst maintaining consistent formatting.

<!-- Discussion and conclusions section -->

Rxiv-Maker integrates accessible plain-text authoring with automated build environments, democratising solutions to consistency and reproducibility challenges in scientific publishing. This approach embraces literate programming principles [@Knuth1984_literate_programming], creating living documents that blend narrative communication with executable workflows whilst abstracting typesetting complexity. Integration with Git provides transparent attribution, conflict-free merging, and auditable histories of manuscript development [@Ram2013_git_science;@Perez-Riverol2016_github_bioinformatics], fostering collaborative practices essential for open science.

The rise of preprints has shifted quality control and typesetting responsibilities from journals to individual authors, creating both opportunities and challenges for scientific communication. Rxiv-Maker responds by providing automated safeguards that enable researchers to produce publication-quality work without extensive typesetting expertise, democratising access to sophisticated publishing capabilities through GitHub-native infrastructure.

The focus on PDF output via LaTeX optimises preprint workflows through specialisation for scientific publishing requirements. Future development will explore extending format support through integration with universal converters such as Pandoc [@pandoc2020], preserving typographic control and reproducibility standards. The Visual Studio Code extension addresses adoption barriers by providing familiar development environments that bridge text editing with version control workflows. Future development will prioritise deeper integration with computational environments and quality assessment tools, building upon established collaborative frameworks [@biaflows2024] and containerised approaches that enhance reproducibility [@dl4miceverywhere2024]. These developments will enhance the platform's role in collaborative manuscript preparation across diverse computational research domains. 

The system supports scientific publishing through organised project structure separating content, configuration, and computational elements. All manuscript content, metadata, and bibliographic references are version-controlled, ensuring transparency.

The markdown-to-LaTeX conversion pipeline handles complex academic syntax including figures, tables, citations, and mathematical expressions whilst preserving semantic meaning and typographical quality. The system employs a multi-pass approach protecting literal content during transformation, ensuring intricate scientific expressions are rendered accurately. The framework supports subscript and superscript notation essential for chemical formulas, allowing expressions such as $\text{H}_2\text{O}$, $\text{CO}_2$, $\text{Ca}^{2+}$, $\text{SO}_4^{2-}$, and $E=mc^2$, as well as temperature notation like 25°C.

The system's mathematical typesetting capabilities extend to numbered equations, which are essential for scientific manuscripts. For instance, the fundamental equation relating mass and energy can be expressed as:

$$E = mc^2$${#eq:einstein}

The framework also supports more complex mathematical formulations, such as the standard deviation calculation commonly used in data analysis:

$$\sigma = \sqrt{\frac{1}{N-1} \sum_{i=1}^{N} (x_i - \bar{x})^2}$${#eq:std_dev}

Additionally, the system handles chemical equilibrium expressions, which are crucial in biochemical and chemical research:

$$K_{eq} = \frac{[\text{Products}]}{[\text{Reactants}]} = \frac{[\text{Ca}^{2+}][\text{SO}_4^{2-}]}{[\text{CaSO}_4]}$${#eq:equilibrium}

These numbered equations (@eq:einstein, @eq:std_dev, and @eq:equilibrium) demonstrate the framework's capability to handle diverse mathematical notation whilst maintaining proper cross-referencing throughout the manuscript. This functionality ensures that complex scientific concepts can be presented with the precision and clarity required for academic publication.

Rxiv-Maker is optimised for reproducible PDF preprint generation within the scientific authoring ecosystem. While platforms such as Overleaf and Quarto offer multi-format capabilities, Rxiv-Maker provides focused, developer-centric workflows integrating with version control and automated build environments. This specialisation enables optimisation for preprint preparation requirements, ensuring manuscripts are professionally typeset and computationally reproducible.

The framework provides practical training in version control, automated workflows, and computational reproducibility—skills fundamental to modern scientific practice. Researchers naturally acquire technical competencies including Git proficiency, markdown authoring, continuous integration, and containerised environments. The system is designed to be accessible without extensive programming backgrounds, featuring comprehensive documentation and intuitive workflows that reduce barriers whilst fostering skill development.

The technical architecture addresses computational constraints of cloud-based build systems through intelligent caching mechanisms and selective content regeneration, enabling efficient resource use. The framework supports high-resolution graphics and advanced figure layouts whilst maintaining optimal document organisation and cross-referencing functionality.

Rxiv-Maker represents a paradigm shift in scientific publishing, transforming manuscripts from static documents into dynamic, executable research artefacts. By democratising access to professional publishing technologies whilst embedding computational reproducibility guarantees, the framework empowers researchers to produce transparent, verifiable publications that serve both immediate dissemination and long-term preservation. 

This approach addresses fundamental challenges in modern computational research, where the gap between sophisticated analytical methods and traditional publishing workflows continues to widen. Rxiv-Maker bridges this divide by treating manuscripts as version-controlled software projects, enabling the same collaborative development practices that have revolutionised software engineering to enhance scientific communication.

The framework's impact extends beyond technical capabilities to foster a culture of computational literacy and transparent science. As preprint servers continue to reshape academic publishing, tools like Rxiv-Maker become essential infrastructure for maintaining quality and reproducibility in researcher-led publication processes. The framework serves as both a practical solution for immediate publishing needs and a foundation for advancing open science principles across diverse research domains.

## Methods

This section provides technical description of the Rxiv-Maker framework, demonstrating the system's capacity to generate structured documentation from source code and plain text. System architecture is detailed in @sfig:architecture.

### Processing Pipeline
Rxiv-Maker employs a sophisticated multi-stage processing pipeline orchestrated through a central `Makefile` that converts manuscript source files into publication-ready PDFs. The pipeline ensures computational reproducibility through five controlled stages:

1. **Environment Setup**: Automated dependency resolution with containerised environments using Docker or local virtual environments with pinned package versions
2. **Content Generation**: Conditional execution of Python/R scripts and Mermaid diagram compilation based on modification timestamps
3. **Markdown Processing**: Multi-pass conversion with intelligent content protection preserving mathematical expressions, code blocks, and LaTeX commands
4. **Asset Aggregation**: Systematic collection and validation of figures, tables, and bibliographic references with integrity checking
5. **LaTeX Compilation**: Optimised `pdflatex` sequences with automatic cross-reference and citation resolution

For users without local LaTeX installations, the framework provides identical build capabilities through cloud-based GitHub Actions, democratising access to professional publishing workflows whilst maintaining reproducibility guarantees.

### Markdown-to-LaTeX Conversion
Manuscript conversion is handled by a Python processing engine managing complex academic syntax requirements through "rxiv-markdown". This multi-pass conversion system employs content protection strategies preserving computational elements such as code blocks and mathematical notation, converting specialised academic elements including dynamic citations (`@smith2023`), programmatic figures, statistical tables, and supplementary notes before applying standard markdown formatting. This approach ensures complex academic syntax is handled with precision across research domains. Supported syntax is detailed in @stable:markdown-syntax. The system supports notation essential for scientific disciplines: subscript and superscript syntax for chemical formulas such as $\text{H}_2\text{O}$ and $\text{CO}_2$, mathematical expressions including Einstein's mass-energy equivalence (@eq:einstein), chemical notation such as $\text{Ca}^{2+}$ and $\text{SO}_4^{2-}$ (@eq:equilibrium), temperature specifications like 25°C, and statistical calculations including standard deviation (@eq:std_dev). The framework supports complex mathematical expressions typical of computational workflows:

$$\frac{\partial}{\partial t} \mathbf{u} + (\mathbf{u} \cdot \nabla) \mathbf{u} = -\frac{1}{\rho} \nabla p + \nu \nabla^2 \mathbf{u}$${#eq:navier_stokes}

This approach provides accessible alternatives for common formulas whilst ensuring complex equations like the Navier-Stokes equation (@eq:navier_stokes) are rendered with professional quality. Mathematical formula support is detailed in @snote:mathematical-formulas. 

### Programmatic Content and Environments
The framework provides programmatic content generation treating figures, statistical analyses, and algorithmic diagrams as reproducible computational outputs linked to source data and processing pipelines. The build pipeline executes scripting environments including Python, R, and Mermaid, employing intelligent caching mechanisms to avoid redundant computation whilst maintaining traceability between datasets, algorithms, and visualisations (@snote:figure-generation). Rxiv-Maker implements multi-layered environment management addressing complex dependency requirements. Dependencies are rigorously pinned, isolated virtual environments support development workflows, and containerised environments ensure consistent execution across computing platforms. Cloud-based GitHub Actions provide controlled, auditable build environments guaranteeing identical computational outcomes across systems.

### Deployment Architecture and Platform Considerations
The framework provides flexible deployment strategies for diverse research environments. Local installation offers optimal performance and universal architecture compatibility, supporting AMD64 and ARM64 systems with direct access to native resources required for diagram generation. This approach enables faster iteration cycles and comprehensive debugging capabilities.

Containerised execution through Docker Engine Mode eliminates local dependency management by providing pre-configured environments containing LaTeX distributions, Python libraries, R packages, and Node.js tooling. Due to Google Chrome limitations for ARM64 Linux distributions, Docker deployment uses AMD64 base images running via Rosetta emulation on Apple Silicon systems. For optimal performance on ARM64 systems, local installation provides full capabilities without emulation overhead.

Cloud-based deployment through GitHub Actions provides architecture-agnostic automated builds for continuous integration workflows. The modular architecture enables researchers to select deployment strategies appropriate to technical constraints whilst maintaining reproducibility guarantees.

### Visual Studio Code Extension
Rxiv-Maker includes a Visual Studio Code extension providing an integrated development environment for collaborative manuscript preparation. The extension leverages the Language Server Protocol delivering real-time syntax highlighting for academic markdown syntax, intelligent autocompletion for bibliographic citations from BibTeX files, and context-aware suggestions for cross-references to figures, tables, equations, and supplementary materials. The extension integrates with the main framework through file system monitoring and automated workspace detection, recognising rxiv-maker project structures and providing appropriate editing features. Schema validation for YAML configuration files ensures project metadata adheres to reproducibility specifications, whilst integrated terminal access enables direct execution of framework commands. This provides researchers with accessible, feature-rich editing experience maintaining reproducibility guarantees whilst reducing technical barriers.

### Quality Assurance
Framework reliability is ensured through multi-level validation protocols. Unit tests validate individual components, integration tests verify end-to-end pipelines, and platform tests validate deployment environment behaviour. Pre-commit pipelines enforce code formatting, linting, and type checking, ensuring code quality.

## Data availability
arXiv monthly submission data used in this article is available at [https://arxiv.org/stats/monthly_submissions](https://arxiv.org/stats/monthly_submissions). Preprint submissions data across different hosting platforms is available at [https://github.com/esperr/pubmed-by-year](https://github.com/esperr/pubmed-by-year). The source code and data for the figures in this article are available at [https://github.com/henriques/rxiv-maker](https://github.com/henriques/rxiv-maker).

## Code availability
The Rxiv-Maker computational framework is available at [https://github.com/henriques/rxiv-maker](https://github.com/henriques/rxiv-maker). The framework includes comprehensive documentation, example manuscripts, and automated testing suites to ensure reliability across different deployment environments. Additionally, the Visual Studio Code extension for Rxiv-Maker is available at [https://github.com/HenriquesLab/vscode-rxiv-maker](https://github.com/HenriquesLab/vscode-rxiv-maker), providing researchers with an integrated development environment that includes syntax highlighting, intelligent autocompletion for citations and cross-references, schema validation for configuration files, and seamless integration with the main framework's build processes. All source code is under an MIT License, enabling free use, modification, and distribution for both academic and commercial applications.

## Author contributions
Both Bruno M. Saraiva, Guillaume Jacquemet, and Ricardo Henriques conceived the project and designed the framework. All authors contributed to writing and reviewing the manuscript.

## Acknowledgements
B.S. and R.H. acknowledge support from the European Research Council (ERC) under the European Union’s Horizon 2020 research and innovation programme (grant agreement No. 101001332) (to R.H.) and funding from the European Union through the Horizon Europe program (AI4LIFE project with grant agreement 101057970-AI4LIFE and RT-SuperES project with grant agreement 101099654-RTSuperES to R.H.). Funded by the European Union. However, the views and opinions expressed are those of the authors only and do not necessarily reflect those of the European Union. Neither the European Union nor the granting authority can be held responsible for them. This work was also supported by a European Molecular Biology Organization (EMBO) installation grant (EMBO-2020-IG-4734 to R.H.), a Chan Zuckerberg Initiative Visual Proteomics Grant (vpi-0000000044 with https://doi.org/10.37921/743590vtudfp to R.H.), and a Chan Zuckerberg Initiative Essential Open Source Software for Science (EOSS6-0000000260). This study was supported by the Academy of Finland (no. 338537 to G.J.), the Sigrid Juselius Foundation (to G.J.), the Cancer Society of Finland (Syöpäjärjestöt, to G.J.), and the Solutions for Health strategic funding to Åbo Akademi University (to G.J.). This research was supported by the InFLAMES Flagship Program of the Academy of Finland (decision no. 337531).
