%% prepare workspace
addpath('code');

%{
jcmsuiteDir = '/path/to/JCMsuite';
addpath([jcmsuiteDir '/ThirdPartySupport/Matlab']);

options = struct('Hostname','localhost','Multiplicity',7,'NThreads',1);
jcmwave_daemon_shutdown; jcmwave_daemon_add_workstation(options);
%}

%% prepare sampling

N = 3; cut = 1/0.45; keys.theta = 30;
keys.pml = [pwd '/JCMsuite/pml.txt'];
k1 = linspace(cutsqrt(0.9*cut,cut),2e-2i,25);
k2 = linspace(2e-2,cutsqrt(1.1*cut,cut),25);
k = invcutsqrt([k1 k2],cut);

%% collect data

keys.finiteElementDegree = 5; keys.P = 600; keys.n = 1.3;
dname = [pwd '/data/w_%d.mat']; wDir = [pwd '/width'];

keys.w = 51;
dname_it = sprintf(dname,keys.w*10);
f = collect_data(k,dname_it,keys,wDir);
[R,p] = aaa(f(:,1),[k1 k2],'tol',1e-6);

%% plot full Riemann surface

c = 1/0.45; r0 = 0.2; fs = 10;
r = linspace(0,r0,401);
phi = linspace(-2*pi,2*pi,4001).';
phi_ = repmat(phi,1,length(r));
z = r.*exp(1i.*phi);
zr = c+real(z); zi = imag(z);
s = sqrt(r).*sqrt(abs(2*c+z)).*exp(0.5i*(phi+angle(2*c+z)));
rz = abs(R(s)).^2;
x = linspace(c-0.1*c,c+0.1*c,1001);
rx = abs(R(cutsqrt(x,c))).^2;
p_ = invcutsqrt(p([6 7 5]),c)/c; clr = [3 6 16]; z0 = 4;
text_args = {'Fontsize',fs,'Interpreter','latex'};

d = ones(size(rz)); 
sel1 = ((phi>0&phi<pi+1)|(phi<0&phi>-pi/4))&r>0.175;
sel2 = (phi>22/12*pi|phi<-pi*9/12)&r<0.175;
rz(sel1|sel2) = nan;
args = {'EdgeColor','none','FaceLighting','gouraud','DiffuseStrength',...
    0.8,'AlphaData',d,'FaceAlpha','flat','AlphaDataMapping','none',...
    'SpecularStrength',0.2};
f4 = figure(4); clf(4); ax4 = axes(f4); ax4.NextPlot = 'add'; 
f4.Units = 'centimeters';
f4.Position(3:4) = [8.2 6.2]; ax4.LabelFontSizeMultiplier = 1;
ax4.XAxis.Visible = 'on'; ax4.YAxis.Visible = 'on';
ax4.YAxis.Direction = 'reverse';
ax4.YRuler.FirstCrossoverValue = 1.103;
ax4.ZRuler.FirstCrossoverValue = 1.103;
ax4.ZRuler.SecondCrossoverValue = 1e-4; ax4.ZTick = [0 1 z0];
ax4.ZAxis.Visible = 'on'; f4.Color = [1 1 1];
ax4.Colormap = hsv(24);
ax4.TickLabelInterpreter = 'latex';
srf = surf(zr/c,zi/c,rz,phi_(end:-1:1,:),args{:});
ax4.CLim = [-2*pi,2*pi]; ax4.ZLim = [-z0+1 z0]; ax4.XLim = [0.9 1.103];
ax4.DataAspectRatio = [1 1.2 50]; z0 = z0-1;
l = light; l.Style = 'local';
l.Position = [1.05 0.6 20]; 
ax4.View = [10,30];
plot3(ax4,x/c,zeros(size(x)),rx,'k','Linewidth',0.5)
clb = colorbar; clb.TickLabelInterpreter = 'latex';
clb.Position = [0.135 0.3 0.017,0.6];
clb.Ticks = [-2*pi,-pi,0,pi,2*pi];
clb.TickLabels = {'$-2 \pi$' '$-\pi$' '$0$' '$\pi$' '$2 \pi$'};
clb.FontSize = fs; ax4.FontSize = fs;
clb.Label.Interpreter = 'latex'; clb.Label.FontSize = fs;
clb.Label.String = 'arg$(k-k_{\mathrm{b},2})$ [rad]';
clb.Label.Position(1) = -4;
yl = ylabel(ax4,'Im($k$)/$k_{\mathrm{b},2}$',text_args{:});
yl.Position = [1.13 0.01 -z0]; yl.Rotation = 75;
xl = xlabel(ax4,'Re($k$)/$k_{\mathrm{b},2}$',text_args{:},'Rotation',-5);
xl.Position(1:2) = xl.Position(1:2)-[0.005 0.012];
zlabel(ax4,'$R_0$',text_args{:},'Position',[1.12 0 0.5]);
ax4.Position = [0.12 0.14 0.77 1];
crc = r0/c*exp(1i*linspace(0,2*pi,1001))+1;
args = {'EdgeColor','none','FaceColor',[1 1 1],'DiffuseStrength',0.9};
patch(real(crc),imag(crc),-z0*ones(1,1001),[1 1 1],args{:});
crc = 3e-3*exp(1i*linspace(0,2*pi,32));
args = {-z0*ones(size(crc))+1e-3,[1 1 1],'EdgeColor','none','FaceColor',[]};
for it = 1:3
    args{end} = ax4.Colormap(clr(it),:);
    patch(real(p_(it)+crc),imag(p_(it)+crc),args{:},'FaceAlpha',1);
end
args{end} = 'none'; args{4} = [0.5 0.5 0.5];
patch([0.9 1.1 1.1 0.9 0.9],[0 0 0 0 0],[0 0 1 1 0],args{2:end})
plot3(ax4,[1 1],[-r0/c r0/c],[-z0 -z0],'k:')
plot3(ax4,[1-r0/c 1+r0/c],[0 0],[-z0 -z0],'k-')
c1 = ax4.Colormap(clr(1),:)-[0.2 0.1 0]; 
c2 = ax4.Colormap(clr(2),:)-[0.3 0.4 0];
c3 = ax4.Colormap(clr(3),:)-[0 0.1 0.3];
text_args{2} = 8;
text(real(p_(1))+7e-3,imag(p_(1)),-z0+2e-1,'$c_3$',text_args{:},'Color',c1)
text(real(p_(2))+7e-3,imag(p_(2)),-z0+2e-1,'$a_3$',text_args{:},'Color',c2)
text(real(p_(3))-12e-3,imag(p_(3)),-z0+2e-1,'$b_3$',text_args{:},'Color',c3)
f4.PaperUnits = 'centimeters'; f4.PaperPosition = [0 0 8.2 10.5];
f4.PaperSize = [8.2 10.5];

%% sketch decomposition

rx = abs(R(cutsqrt(x,c))).^2; text_args{2} = fs;
f4b = figure(44); clf(44); ax4b = axes(f4b); ax4b.NextPlot = 'add';
f4b.Units = 'centimeters'; f4b.Position(3:4) = [8.2,3.2];
xlabel(ax4b,'Re$(k)/k_{\mathrm{b},2}$',text_args{:}); ylabel(ax4b,'$R_0$',text_args{:});
ax4b.Position = [0.15 0.35 0.78 0.55]; 
ax4b.XLim = [0.893 1.107]; ax4b.LabelFontSizeMultiplier = 1;
ax4b.YLim = [-0.15 1.15];
ax4b.FontSize = fs; ax4b.TickLabelInterpreter = 'latex'; ax4b.Box = 'on';
f4b.PaperUnits = 'centimeters'; f4b.PaperPosition = [0 0 8.2 3.2];
f4.PaperSize = [8.2 3.2];
text_args{2} = 8;
text(ax4b,real(p_(2))-5e-3,12e-2,'$a_3$',text_args{:},'Color',c2);
text(ax4b,real(p_(3))-9e-3,12e-2,'$b_3$',text_args{:},'Color',c3);
text(ax4b,real(p_(1))+9e-3,12e-2,'$c_3$',text_args{:},'Color',c1);
args = {[1 1 1],'EdgeColor',[0.5 0.5 0.5],'FaceColor','none'};

[R,pp,rr] = aaa(f(:,1),cutsqrt(k,cut),'tol',1e-6);

pp = invcutsqrt(pp,cut);  
sel = real(pp/cut)<1.1&real(pp/cut)>0.9; p = pp(sel);
r = rr(sel).*[-1;-1;1]./(pp(sel)./cutsqrt(pp(sel),cut));
fp = R(cutsqrt(conj(p),cut)); 
ms = r.*conj(fp)./(x-p)+conj(r).*fp./(x-conj(p));
plot(ax4b,x/cut,real(ms(3,:))+1,'-','Color',c2)
plot(ax4b,x/cut,real(ms(2,:))+1,':','Color',[c1 0.8])
plot(ax4b,x/cut,real(ms(1,:))+1,':','Color',[c3 0.8])
m3 = ms(2,:); m3(x>cut) = nan; m1 = ms(1,:); m1(x<cut) = nan;
plot(ax4b,x/cut,m1+1,'Color',c3); plot(ax4b,x/cut,m3+1,'Color',c1);
plot(ax4b,x/c,rx,'k','LineWidth',0.7)

patch(ax4b,[0.9 1.1 1.1 0.9 0.9],[0 0 1 1 0],args{:},'LineWidth',1)