%% prepare workspace
addpath('code');

%{
jcmsuiteDir = '/path/to/JCMsuite';
addpath([jcmsuiteDir '/ThirdPartySupport/Matlab']);

options = struct('Hostname','localhost','Multiplicity',7,'NThreads',1);
jcmwave_daemon_shutdown; jcmwave_daemon_add_workstation(options);
%}

%% display dependence of the poles on the gap width 

% prepare sampling
ws = 42:1:60; [~,n] = ismember([42 47 51 55 60],ws);
N = 3; cut = 1/0.45; keys.theta = 30;
keys.pml = [pwd '/JCMsuite/pml.txt'];
k1 = linspace(cutsqrt(0.9*cut,cut),2e-2i,25);
k2 = linspace(2e-2,cutsqrt(1.1*cut,cut),25);
k = invcutsqrt([k1 k2],cut);
x = linspace(k(1),k(end),100001);

% prepare figures
fs = 10; text_args = {'Fontsize',fs,'Interpreter','latex'}; 
f3 = figure(3); clf(3); ax3a = axes(f3); ax3a.NextPlot = 'add';
f3.Units = 'centimeters'; f3.Position(3:4) = [8.2,6.2];
ax3b = axes(f3); ax3b.NextPlot = 'add'; ax3b.XTickLabel = [];
ax3a.Position = [0.18 0.165 0.78 0.4]; 
ax3b.Position = [0.18 0.58 0.78 0.42];
ax3a.TickLabelInterpreter = 'latex'; ax3b.TickLabelInterpreter = 'latex';
ax3a.FontSize = fs; ax3a.LabelFontSizeMultiplier = 1;
ax3b.FontSize = fs; ax3b.LabelFontSizeMultiplier = 1;
ax3a.Box = 'on'; ax3b.Box = 'on'; ax3a.XLim = [0.9 1.1];
ax3b.XLim = [0.9 1.1]; ax3b.YLim = [-0.035 0.005];
c = colororder('meadow'); c = c(2,:);
args = {'EdgeColor',c,'FaceColor','none','LineWidth',0.7};
patch(ax3b,[1 1.035 1.035 1],-[0.016 0.016 6e-3 6e-3],c,args{:})
patch(ax3b,[1 0.943 0.943 1],-[0.018 0.018 0.032 0.032],c,args{:})
ylb = ylabel(ax3b,'Im$(k)/k_{\mathrm{b},2}$',text_args{:}); 
yla = ylabel(ax3a,'$R_0$',text_args{:});
xlabel(ax3a,'Re$(k)/k_{\mathrm{b},2}$',text_args{:}); 
yla.Position(1) = ylb.Position(1);
plot(ax3b,real(k)/cut,zeros(size(k)),'k.','MarkerSize',3)
c = copper(length(ws)+10); clr = colororder('meadow');
c1 = c(n(1),:); c2 = c(n(2),:); c3 = c(n(3),:);
c4 = c(n(4),:); c5 = c(n(5),:);

% collect data and plot results
keys.finiteElementDegree = 5; keys.P = 600; keys.n = 1.3;
dname = [pwd '/data/w_%d.mat']; wDir = [pwd '/width'];
args = {'tol',5e-7}; alpha = 1;
P = zeros(length(ws),N);
s = zeros(length(ws),N,'logical');

computeModes = ~exist('data/fields.mat','file');
if ~computeModes, d = load('data/fields.mat'); fields = d.fields; end

fs = cell(length(n)-1,3);
for it = 1:length(ws)
    w = ws(it); keys.w = w;
    dname_it = sprintf(dname,w*10);
    f = collect_data(k,dname_it,keys,wDir);
    [R,p_,rs1,~,zj,~,wj] = branch_cut_aaa(cut,f(:,1),k,args{:});
    [~,ps] = aaa(f(:,1),k,args{:});
    [p,p_] = p_{:}; r1 = rs1{1}(:,1);
    [p,ndx] = sort(p,'ComparisonMethod','real'); r1 = r1(ndx);
    m = r1.'./(cutsqrt(1./x,cut)-p.'); p_ = p_(ndx);
    if it==1
        [~,ndx] = mink(abs(p)+min(abs(p-cutsqrt(k,cut).'),[],2),N); 
        p = p(ndx); p_ = p_(ndx);
    else
        [~,ndx] = min(p-p_old.',[],1); p = p(ndx); p_ = p_(ndx);
    end
    s(it,:) = abs(p-cutsqrt(p_,cut))<1e-5; P(it,:) = p; p_ = p_/cut;
    if any(it==n)
        plot(ax3a,x/cut,abs(R(x)).^2,'Color',c(it,:));
        if computeModes && any(it==n(1:end-1))
            [~,ndx] = min(zj-cutsqrt(k,cut).',[],2); kj = k(ndx);
            for it_ = 1:3
                kn = p_(it_)*cut; zn = p(it_); m = it==n(1:end-1);
                fs{m,it_} = superimpose_eigenmodes(zn,kn,zj,kj,wj,keys);
            end
        end
    else
        scatter(ax3b,real(p_),imag(p_),5,c(it,:),'Marker','x');
    end
    p_old = p;
end
if computeModes
    t = [5 11 12 2 3];
    jcmpt = [pwd '/JCMsuite/export.jcmp'];
    rb = jcmwave_resultbag('eigenmodes/export.mat');
    keys_export.nx = linspace(-300e-9,300e-9,300);
    keys_export.ny = linspace(-500e-9,500e-9,500);
    ids = zeros(size(t),'int32');
    for it = 1:length(t)
        keys_export.fieldBagPath = fs{t(it)}{1};
        keys_export.outputFileName = [fs{t(it)}{1}(1:end-12) 'export.jcm'];
        ids(it) = jcmwave_solve(jcmpt,keys_export,rb,'temporary','yes');
    end
    jcmwave_daemon_wait(ids,rb);

    fields = cell(2,size(t,2));
    for it = 1:length(t)
        keys_export.fieldBagPath = fs{t(it)}{1};
        keys_export.outputFileName = [fs{t(it)}{1}(1:end-12) 'export.jcm'];
        res = rb.get_result(keys_export);
        fields{1,it} = abs(res{1}.field{1}(:,:,3)).';
        fields{1,it} = fields{1,it}/max(fields{1,it}(:));
        fields{2,it} = nan(length(keys_export.ny),10);
    end

    fields = [fields{1:end-1}];
    save('data/fields.mat','fields');
end

text_args{2} = 8;
P_ = invcutsqrt(P,cut)/cut;
for it = 1:5
    clr = c(n(it),:); p = P_(n(it),s(n(it),:)); p_ = P_(n(it),~s(n(it),:));
    scatter(ax3b,real(p),imag(p),10,clr,'Marker','x','LineWidth',1);
    sc = scatter(ax3b,real(p_),imag(p_),10,clr,'Marker','x');
    sc.LineWidth = 1; sc.MarkerEdgeAlpha = alpha;
    a = 1.08; b = 0.6-it*0.1;
    plot(ax3a,[a-0.02,a-0.005],[b b],'Color',clr)
    text(ax3a,a,b,sprintf('$w_%d$',it),'Color',clr,text_args{:})
    clr_c = clr; if it>2, clr_c = 1-(1-clr_c)*alpha; end
    text(ax3b,real(P_(n(it),1))-0.004,imag(P_(n(it),1))-0.003,...
        sprintf('$c_%d$',it),text_args{:},'Color',clr_c)
    text(ax3b,real(P_(n(it),2))-0.006+0.002*it,...
        imag(P_(n(it),2))-0.003+0.0005*it*(it>4),...
        sprintf('$a_%d$',it),text_args{:},'Color',clr)
    clr_b = clr; if it<4, clr_b = 1-(1-clr_b)*alpha; end
    text(ax3b,real(P_(n(it),3))-0.004,imag(P_(n(it),3))-0.004,...
        sprintf('$b_%d$',it),text_args{:},'Color',clr_b)
end

%% plot field distributions

f3a = figure(33); clf(33); axf3a = axes(f3a); axf3a.NextPlot = 'add';
imshow(fields,'Parent',axf3a); axf3a.Colormap = hot(256); 
axf3a.YDir = 'normal'; aData = ones(size(fields)); 
aData(isnan(fields)) = 0; axf3a.Children.AlphaData = aData;
axf3a.XLim = [0 1600]; axf3a.YLim = [0 500]; f3a.Color = [1 1 1];
f3a.Units = 'centimeters'; f3a.Position(3:4) = [8.2,2.65];
axf3a.Position = [0.125 0.06 0.9 0.88]; 
lbl = {'a_1' 'b_3' 'b_4' 'c_2' 'c_3'};
lbl = cellfun(@(x){sprintf('$\\mathbf{%s}$',x)},lbl);
for it = 1:5
    text(axf3a,20+(it-1)*310,40,lbl{it},text_args{:},'Color',[1 1 1])
end
clb = colorbar(axf3a,'Location','westoutside'); clb.Ticks = [0 1];
clb.TickLabelInterpreter = 'latex'; clb.Label.Interpreter = 'latex';
clb.FontSize = 10; clb.Position = [0.105 0.067 0.016 0.867];
clb.Label.String = '$|\mathbf{H}_z|$ [a.u.]'; clb.Units = 'normalized';
clb.Label.Position(1) = -3.5;