%% prepare workspace
addpath('code');

%{
jcmsuiteDir = '/path/to/JCMsuite';
addpath([jcmsuiteDir '/ThirdPartySupport/Matlab']);

options = struct('Hostname','localhost','Multiplicity',7,'NThreads',1);
jcmwave_daemon_shutdown; jcmwave_daemon_add_workstation(options);
%}

%% select data points
% a sampling scheme is used that uses more support points in the vicinity
% of the branch cut
k1 = linspace(1,1/0.29,257).'; cuts = 1./[0.9 0.45 0.3];
k1 = k1(~ismembertol(k1,1./[0.3 0.45 0.9],1e-5)); 
a = cutsqrt(cuts(1)+1e-4,cuts(1:2)); b = cutsqrt(cuts(2)-1e-4,cuts(1:2));
c12 = abs(a)*exp(1i*linspace(angle(a),angle(b),129));
a = cutsqrt(cuts(2)+1e-4,cuts(2:3)); b = cutsqrt(cuts(3)-1e-4,cuts(2:3));
c23 = abs(a)*exp(1i*linspace(angle(a),angle(b),129));
k2 = real([invcutsqrt(linspace(cutsqrt(1,cuts(1)),2e-2i,25),cuts(1)),...
    invcutsqrt(c12,cuts(1:2)), invcutsqrt(c23,cuts(2:3)),...
    invcutsqrt(linspace(2e-2,cutsqrt(1/0.29,cuts(3)),25),cuts(3))]).';

keys.P = 600; keys.n = 1.3; keys.w = 51; keys.theta = 30;
keys.finiteElementDegree = 5; keys.pml = [pwd '/JCMsuite/pml.txt'];

% join all the data points
k = uniquetol([k1;k2]); 

%% collect data

ndx_uniform = find(ismembertol(k,k1)); 
ndx_cuts = find(ismembertol(k,k2));
[f,r0,r,a] = collect_data(k,[pwd '/data/full.mat'],keys);

fprintf('Energy conservation: %1.1e\n',max(abs((1-(r+a)))));

step = 4; t = 1e-6; c2 = cuts(2);
sel = ndx_cuts([1:step:25 26:step:154 155:step:283 284:step:end]);
[R,pp,rr,~,zj,fj,wj] = branch_cut_aaa(cuts,f(sel,1),k(sel),'tol',t);
sel1 = k/c2>0.75; sel2 = k/c2<1.2;
[~,pp1] = branch_cut_aaa(cuts(2:3),f(sel1,1),k(sel1),'tol',t);
[~,pp2] = branch_cut_aaa(cuts(1:2),f(sel2,1),k(sel2),'tol',t);
pp1 = pp1{2}(real(pp1{2}/c2)>0.8); 
pp2 = pp2{2}(real(pp2{2}/c2)<0.8);
[R_,ppp] = aaa(f(:,1),k(:),'tol',t); 
selp = real(pp{2})<k(end)&real(pp{2})>k(1); 
pp = pp{2}(selp); rr = rr{2}(selp);
p_ref = arnoldi_resonance(pp,[pwd '/data/p_ref.mat'],keys);
[pp,ndx] = sort(pp,'descend','ComparisonMethod','real'); rr = rr(ndx);

x = linspace(k(1),k(end),1000001).'; fx = R(x);

fprintf('N: %d   Error: %1.1e\n',length(sel),max(abs(f(:,1)-R(k))));
fprintf('N: %d   Error: %1.1e\n\n',length(k),max(abs(f(:,1)-R_(k))));

%% plot specular reflection

fs = 10; text_args = {'Interpreter','latex','Fontsize',fs}; 

f2 = figure(2); clf(2); f2.Units = 'centimeters';
f2.Position(3:4) = [8.2 9];
ax2a = axes(f2); ax2a.NextPlot = 'add'; ax2a.Box = 'on';
ax2a.Position = [0.18 0.48 0.81 0.515]; ax2a.TickLabelInterpreter = 'latex';
ax2a.FontSize = fs; ax2a.XTickLabel = []; ax2a.XLim = [0.45 1.55]; 
ax2a.YLim = [-1.05 0.05]; ylabel(ax2a,'$R_0-1$',text_args{:})

ax2b = axes(f2); ax2b.NextPlot = 'add'; ax2b.Box = 'on';
ax2b.Position = [0.18 0.29 0.81 0.18]; ax2b.FontSize = fs;
ax2b.TickLabelInterpreter = 'latex'; ax2b.XLim = [0.45 1.55];
ax2b.YLim = [-0.05 0.01]; ylabel(ax2b,'Im$(k)/k_{\mathrm{b},2}$',text_args{:})

ax2c = axes(f2); ax2c.NextPlot = 'add'; ax2c.Box = 'on';
ax2c.Position = [0.18 0.1 0.81 0.18]; ax2c.FontSize = fs;
ax2c.TickLabelInterpreter = 'latex'; ax2c.XLim = [0.45 1.55]; 
ax2c.YLim = [-0.05 0.01]; xlabel(ax2c,'Re$(k)/k_{\mathrm{b},2}$',text_args{:})
ax2c.XLabel.Position(2) = -0.068;


ax2a.YLabel.Position(1) = ax2b.YLabel.Position(1);
ax2b.YLabel.Position(2) = ax2b.YLabel.Position(2)-0.032;

fp = R(conj(pp)); c = colororder('meadow');
ms = rr.'.*conj(fp.')./(x-pp.')+conj(rr.').*fp.'./(x-conj(pp.'));
la = plot(ax2a,x/c2,abs(fx).^2-1);
ax2a.ColorOrder = parula(12); ax2a.ColorOrderIndex = 1;
ls = plot(ax2a,x/c2,real(ms),'LineWidth',0.5);
lb = plot(ax2a,x/c2,abs(fx).^2-1-sum(real(ms),2));
lb.LineWidth = 0.7; lb.Color = c(2,:);
la.LineWidth = 1; la.Color = [0.5 0.5 0.5 1];
lr = plot(ax2a,k2/c2,r0(ndx_cuts)-1,'k.','MarkerSize',4);
ndx = ismembertol(real(ppp),real(pp),1e-5); ppp(ndx) = [];
ndx = ismembertol(real(pp1),real(pp),1e-5); pp1(ndx) = []; 
ndx = ismembertol(real(pp2),real(pp),1e-5); pp2(ndx) = [];
hm1 = scatter(ax2c,real(pp1)/c2,imag(pp1)/c2,15,c(2,:),'x');
hm2 = scatter(ax2c,real(pp2)/c2,imag(pp2)/c2,15,c(2,:),'x');
bcm = plot(ax2b,ppp/c2,'x','MarkerSize',3,'Color',c(2,:));
hm1.LineWidth = 1; hm2.LineWidth = 1; bcm.LineWidth = 1;
sc = scatter(ax2c,real(pp)/c2,imag(pp)/c2,15,...
    ax2a.ColorOrder(1:6,:),'x'); sc.LineWidth = 1;
copyobj(sc,ax2b);

text_args{end} = 8;
xp = 0.74; yp = -1;
for it = 1:6
    ln = plot(ax2a,xp-[0.02 0.08],[yp yp]+0.05+0.009*it);
    ls(it).Color = [ls(it).Color 0.7];
    ln.Color = [ls(it).Color 0.7]; ln.LineWidth = ls(it).LineWidth;
end
text(ax2a,xp,yp+0.07,'Modal Contributions',text_args{:});

ln = plot(ax2a,xp-[0.02 0.08],[yp yp]+0.004); 
ln.Color = lb.Color; ln.LineWidth = lb.LineWidth;
text(ax2a,xp,yp,'Residual Contribution',text_args{:});

ln = plot(ax2a,xp-[0.02 0.08],[yp yp]+0.144); 
ln.Color = la.Color; ln.LineWidth = la.LineWidth;
text(ax2a,xp,yp+0.14,'Spectrum',text_args{:});

ln = plot(ax2a,xp-0.05,yp+0.214,'.'); ln.Color = lr.Color;
ln.MarkerSize = lr.MarkerSize;
text(ax2a,xp,yp+0.21,'Reference',text_args{:});

ln = plot(ax2c,nan,nan,'x','Color',[0.5 0.5 0.5],'MarkerSize',4);
lg = legend(ln,'Poles',text_args{:}); lg.ItemTokenSize(1) = 8; 
lg.Position(1:2) = [0.36 0.26]; 

xp = 1.5; yp1 = -0.042; 
lbl = 'Single-Valued Approach';
text(ax2b,xp,yp1,lbl,text_args{:},'HorizontalAlignment','right');
lbl = 'Multi-Valued Approach';
text(ax2c,xp,yp1,lbl,text_args{:},'HorizontalAlignment','right');
d = 8e-3-4e-3i; b = pp1(end)/c2+d; c = pp1(end-1)/c2+d; a = pp(4)/c2+d;
clr = [0.4018 0.2511 0.1599];
text(ax2c,real(c),imag(c),'$c$',text_args{:},'Color',clr)
text(ax2c,real(b)+2e-3,imag(b),'$b$',text_args{:},'Color',clr)
text(ax2c,real(a),imag(a),'$a$',text_args{:},'Color',clr)

%% inset with grating

ax2d = axes(f2); ax2d.NextPlot = 'add'; ax2d.Visible = 'off';
ax2d.XTick = []; ax2d.YTick = [];
ax2d.DataAspectRatio = [1 1 1]; ax2d.Position = [0.79 0.467 0.17 0.2];
phi = linspace(0,2*pi,501); g = [219 172 52]/255;
patch(cos(phi),sin(phi),[1 1 1]);
phi1 = linspace(pi-asin(0.3),2*pi+asin(0.3),401);
x_ = [cos(phi1) 0.76 0.76 0.64 0.64 -0.44 -0.44 -0.56 -0.56];
y_ = [sin(phi1) 0.3 -0.4 -0.4 0.3 0.3 -0.4 -0.4 0.3];
patch(x_,y_,g-0.1);
patch(cos(phi),sin(phi),[1 1 1],'LineWidth',1,'FaceColor','none')