function out = superimpose_eigenmodes(zn,kn,zj,kj,wj,keys)

c0 = 299792458;
pdir = [pwd '/JCMsuite/scattering'];

rb = jcmwave_resultbag([pwd '/data/width.mat']);

fields = cell(size(zj));
for n = 1:length(zj)
    keys.omega = 2e6*pi*c0*kj(n)/keys.n;
    res = rb.get_result(keys);
    fields{n} = res{1}.file;
end

name = '/project_results/fieldbag.jcm';
ids = zeros(size(zn.'),'int32');
out = cell(size(ids));
for n = 1:length(zn)
    keys.omega = 2e6*pi*c0*kn(n)/keys.n;
    w = zn(n); outname = [pwd '/eigenmodes/' rb.get_tag(keys) name];
    Ddiff = -((1./(w-zj.')).^2) * wj;
    weights = 1/Ddiff*wj./(w-zj);
    ids(n) = superimpose(weights,fields,keys,pdir,outname);
    out{n} = outname;
end
jcmwave_daemon_wait(ids);
end
