function id = superimpose(weights,fields,keys,pdir,outname)

persistent superposition fieldbag a;
if isempty(superposition)
    superposition = [ ... superposition post rprocess
        'PostProcess { \n' ...
        '  Superposition { \n' ...
        '    OutputFileName = "%%(oPath)s"\n' ...
        '%%(fieldbags)s\n' ...
        '    Omega = %%(omega)e\n' ...
        '  } \n' ...
        '}\n'];

    fieldbag = [ ... field bags for superposition post process
        '    FieldBag { \n' ...
        '      FieldBagPath = "%s"\n' ...
        '      Weights = %s \n' ...
        '    }\n'];

    a = filesep;
end

b = strfind(outname,a);
wdir = outname(1:b(end-1)-1);
if ~exist(outname(1:b(end)-1),'dir'), mkdir(outname(1:b(end)-1)); end

fieldbags = cell(size(fields));
for it = 1:length(fields)
    field = fields{it};
    weight = weights(it);
    w = sprintf('(%.8e,%.8e)',real(weight),imag(weight));
    fieldbags{it} = sprintf(fieldbag, field, w);
end
fieldbags = [fieldbags{:}];

% create jcmpt file
jcmpt = [pdir a 'superposition.jcmpt'];
if ~exist(jcmpt,'file')
    id = fopen(jcmpt, 'w');
    fprintf(id, superposition);
    fclose(id);
end
jcmpt = jcmpt(1:end-1);


keys.fieldbags = fieldbags;
keys.oPath = outname;
id = jcmwave_solve(jcmpt,keys,'workingdir',wdir);
end