% Inverse coordinate transformation for one or two branch cuts.
function z = invcutsqrt(z,cuts)
if length(cuts)==1
    z = exp(1i*pi/4)*sqrt(-1i*(z.^2+cuts^2));
elseif length(cuts)==2
    z2 = z.^2*4; c2 = cuts.^2; 
    p2 = 1/4*(diff(c2).^2./z2+z2)+0.5*sum(c2);
    z = exp(1i*pi/4)*sqrt(-1i*p2);
end
end