function varargout = collect_data(k,fname,keys,wDir)

persistent rb;
k = k(:); % make shure the input is a column vector
c0 = 299792458; % speed of light
eps0 = 8.85418781762039e-12; % permittivity in vacuum
mu0 = 4e-7*pi; % permeability in vacuum

if nargin>1
    [pDir,nm] = fileparts(fname);
    if exist(fname,'file')
        data = load(fname);
        varargout = struct2cell(data); return
    end
elseif nargin<3
    pDir = [pwd '/data']; nm = 'scan';
    keys = struct('finiteElementDegree',5,'P',600,...
        'n',1,'w',60,'theta',30);
    if nargin==1, fname = [pDir '/' nm '.mat']; end
end
if ~exist(pDir,'dir'), mkdir(pDir); end

sc = 'JCMsuite/scattering';
if nargin<4, wDir = [pwd '/' nm]; end
jcmp = [pwd sprintf('/%s/project.jcmp',sc)];

% start jobs
if isempty(rb) || ~isequal(nm,rb.filepath_) || ~exist(rb.filepath_,'file')
    rb = jcmwave_resultbag(fname);
end
ids = zeros(1,length(k)); 
for it = 1:length(k)
    keys.omega = 2e6*pi*c0*k(it)/keys.n;
    d = [wDir filesep rb.get_tag(keys)];
    ids(it) = jcmwave_solve(jcmp,keys,rb,'workingdir',d);
end
jcmwave_daemon_wait(ids,rb);

% collect results
dnames = {'d_Material' 'd_GrooveWidth' 'd_GrooveDepth'...
    'd_Period' 'd_Omega'};
q = 'MagneticFieldStrength'; n = length(dnames)+1;
r = zeros(size(k)); % reflection
r0 = zeros(size(k)); % specular reflection
a = zeros(size(r)); % absorption
p0 = 0.5*sqrt(mu0/(keys.n^2*eps0))*cosd(30); % incidence power
f = zeros(length(r),n); % zero order Fourier coefficient (z-component)
for it = 1:length(k)
    keys.omega = 2e6*pi*c0*k(it)/keys.n;
    res = rb.get_result(keys);
    a(it) = res{3}.ElectromagneticFieldAbsorption{1}/600e-9/p0;
    ndx = res{2}.N1==0; p = res{2}.(q){1}(ndx,:); r0(it) = p*p';
    f(it,:) = [p(3) cellfun(@(x)res{2}.(x).(q){1}(ndx,3),dnames)]; 
    p = jcmwave_convert2powerflux(res{2});
    r(it) = sum(p.PowerFluxDensity{1}(:,2))/p0;
end
if nargin>1
    data = struct('f',f,'r0',r0,'r',r,'a',a);
    save(fname,'-struct','data'); 
end
varargout = {f,r0,r,a}; varargout = varargout(1:nargout);
end