function varargout = branch_cut_aaa(cuts,varargin)

if nargin<5, varargin(3:4) = {'tol',1e-5}; end
[f,z] = varargin{1:2}; z_ = cutsqrt(z,cuts);
[varargout{1:nargout}] = aaa(f,z_,varargin{3:end});
R = @(x) varargout{1}(cutsqrt(x,cuts)); varargout{1} = R;
if nargout==1, return; end

[p,ndx] = solveradeq(varargout{2},z(1),z(end),cuts);

if nargout>1, varargout{2} = {varargout{2} p}; end
if nargout>2
    r = zeros(size(p)); r_ = varargout{3}(ndx(:,1),:); n = length(cuts);
    a = p(:,1).^2-cuts.^2; b = csqrt(a); c = sum(p(:,1)./b,2); 
    r(:,1) = r_(:,1)./c*n; dr1 = r_(:,2:end)./c; dr2 = r_(:,1)./c.^2;
    r(:,2:end) = n*(dr1+dr2.*p(:,2:end).*sum(1./b.*(1-1./a),2));
    varargout{3} = {varargout{3} r};
end

varargout = varargout(1:nargout);
end

function [p,ndx] = solveradeq(p_,a,b,cuts)
p = zeros(size(p_));
phi = linspace(0,2*pi,61).';
if length(cuts)==1
    p(:,1) = exp(1i*pi/4)*sqrt(-1i*(p_(:,1).^2+cuts^2));
elseif length(cuts)==2
    z2 = p_(:,1).^2*4; c2 = cuts.^2;
    p2 = 1/4*(diff(c2).^2./z2+z2)+0.5*sum(c2);
    p(:,1) = exp(1i*pi/4)*sqrt(-1i*p2);
else
    z = linspace(a,b,1001).';
    for it = 1:size(p_,1)
        fz = 1./(cutsqrt(z,cuts)-p_(it,1));
        [~,p(it,1)] = aaa(fz,z,'degree',1);
        p_old = inf; n = 2;
        while abs(p(it,1)-p_old)/abs(p(it,1))>10*eps && n<7
            zphi = 10^(-n).*exp(1i*phi(1:end-1)) + p(it,1);
            fphi = 1./(cutsqrt(zphi,cuts)-p_(it,1));
            n = n+1; p_old = p(it,1);
            [~,p(it,1)] = aaa(fphi,zphi,'degree',1);
            if abs(cutsqrt(p(it,1),cuts)-p_(it,1))>10^(-n+2)
                p(it,:) = nan; break;
            end
            if abs(p(it,1)-p_old)>10^(-n+2); p(it,:) = nan; break; end
        end
    end
end
ndx = ~isnan(p);
p_ = reshape(p_(ndx),[],size(p,2));
p = reshape(p(ndx),[],size(p,2));
if size(p,2)>1
    A = exp(1i*pi/4).*sqrt(-1i*(p(:,1).^2-cuts.^2));
    A = 1/length(cuts)*sum(1./A,2).*p(:,1);
    p(:,2:end) = p_(:,2:end)./A;
end
end

function z = cutsqrt(z,cuts)
z = sum(csqrt(z(:).^2-cuts.^2),2)/length(cuts);
end

function z = csqrt(z)
z = exp(1i*pi/4)*sqrt(-1i*z);
end