function p = arnoldi_resonance(p,fname,keys)

pDir = fileparts(fname); if ~exist(pDir,'dir'), mkdir(pDir); end
if exist(fname,'file')
    d = load(fname); 
    p = d.p_ref; return
end
if nargin<3, keys = struct('finiteElementDegree',5,'P',600,'w',60); end

c0 = 299792458; % speed of light
[~,nm] = fileparts(fname);
wDir_ = [pwd '/workingDir/' nm '/r%d'];
jcmp = [pwd '/JCMsuite/resonance/project.jcmp'];
ids = zeros(1,length(p));
rb = jcmwave_resultbag('data/resonance.mat');
p_ref = p; p_old = zeros(size(p));
while max(abs(p_ref-p_old))>1e-8
    p_old = p_ref;
    for it = 1:length(p_old)
        keys.guess = 2e6*pi*p_old(it)*c0/keys.n;
        keys.bv = -2e6*pi*p_old(it)*[sind(30) cosd(30) 0];
        wDir = sprintf(wDir_,it);
        ids(it) = jcmwave_solve(jcmp,keys,rb,'workingdir',wDir);
    end
    jcmwave_daemon_wait(ids,rb);
    for it = 1:length(p_old)
        keys.guess = 2e6*pi*p_old(it)*c0/keys.n;
        keys.bv = -2e6*pi*p_old(it)*[sind(30) cosd(30) 0];
        res = rb.get_result(keys);
        p_ref(it) = res{1}.eigenvalues.eigenmode/(2e6*pi*c0)*keys.n;
    end
end
save(fname,'p_ref')
p = p_ref;
end
