%% prepare workspace
addpath('code');

%{
jcmsuiteDir = '/path/to/JCMsuite';
addpath([jcmsuiteDir '/ThirdPartySupport/Matlab']);

options = struct('Hostname','localhost','Multiplicity',7,'NThreads',1);
jcmwave_daemon_shutdown; jcmwave_daemon_add_workstation(options);
%}

%% collect data
d = [pwd '/data/p_%d.mat'];
cuts = 1./[0.9 0.45 0.3]+[1e-4;-1e-4];
w0 = uniquetol([cuts(:);linspace(1,1/0.29,24).']); 
p = 1:8; f = zeros(length(w0),length(p)); ec = zeros(size(p));
keys.P = 600; keys.n = 1.3; keys.w = 50; keys.theta = 30;
for it = 1:length(p)
    keys.finiteElementDegree = p(it);
    [f_,~,r,a] = collect_data(w0,sprintf(d,p(it)),keys);
    ec(it) = max(abs(1-(r+a)));
    f(:,it) = f_(:,1);
end

%% plot
% maximal absolute error of the specular reflection
err = max(abs(abs(f(:,1:end-1)).^2-abs(f(:,end)).^2),[],1);
f1 = figure(1); clf(1); f1.Units = 'centimeters'; 
f1.Position(3:4) = [18,9];
ax1 = axes(f1); ax1.NextPlot = 'add'; ax1.YScale = 'log'; ax1.Box = 'on';
ax2 = axes(f1); ax2.NextPlot = 'add'; ax2.YScale = 'log'; ax2.Box = 'on';
ax1.YLim = [1e-11 10]; ax2.YLim = ax1.YLim; ax2.YAxisLocation = 'right';
ax1.Position = [0.095 0.13 0.38 0.83]; 
ax2.Position = [0.53 0.13 0.38 0.83];
plot(ax1,p(1:end-1),err,'.-'); 
plot(ax2,p(1:end-1),ec(1:end-1),'.-')
ylabel(ax1,'Absolute error of R_0'); 
ylabel(ax2,'Energy consevation')
xlabel(ax1,'Finite Element Degree'); xlabel(ax2,'Finite Element Degree')