//
//  XCUIApplication+Ext.swift
//  SnapshotInstructorUITests
//
//  Created by Batuhan Kaynak on 5.03.2025.
//

import XCTest

extension XCUIApplication {
    private struct Constants {
        // Half way accross the screen and 10% from top
        static let topOffset = CGVector(dx: 0.5, dy: 0.1)
        
        // Half way accross the screen and 80% from top
        static let bottomOffset = CGVector(dx: 0.5, dy: 0.8)
    }
    
    var screenTopCoordinate: XCUICoordinate {
        return windows.firstMatch.coordinate(withNormalizedOffset: Constants.topOffset)
    }
    
    var screenBottomCoordinate: XCUICoordinate {
        return windows.firstMatch.coordinate(withNormalizedOffset: Constants.bottomOffset)
    }
    
    func elementWith(identifier id: String) -> XCUIElement {
        return descendants(matching: .any).matching(identifier: id).firstMatch
    }
    
    func elementWith(identifier id: String, index: Int) -> XCUIElement {
        return descendants(matching: .any).matching(identifier: id).element(boundBy: index)
    }

    func getScreen() -> UIImage {
        return windows.firstMatch.screenshot().image
    }
    
    func scrollDown() {
        screenBottomCoordinate.press(forDuration: 0.2, thenDragTo: screenTopCoordinate, withVelocity: .fast, thenHoldForDuration: .zero)
    }

    func scrollUp() {
        screenTopCoordinate.press(forDuration: 0.2, thenDragTo: screenBottomCoordinate, withVelocity: .fast, thenHoldForDuration: .zero)
    }
}
