import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class TextChangeTests: BaseUITest {
    
    override func setUp() {
        additionalLaunchArgs = ["UI-TESTING", "DISABLE-ANIMATIONS"]
        super.setUp()
    }
    
    // TEXT_CHANGE_PREMIUM_BUTTON Test
    func testTextChangePremiumButton() {
        runTestWithFlagVariants(
            flagName: "TEXT_CHANGE_PREMIUM_BUTTON",
            testName: "PremiumButton",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "PremiumBuyButton").waitForExistence(timeout: 5)
            }
        )
    }
    
    // TEXT_CHANGE_PROFILE_HEADING Test
    func testTextChangeProfileHeading() {
        runTestWithFlagVariants(
            flagName: "TEXT_CHANGE_PROFILE_HEADING",
            testName: "ProfileHeading",
            setupAction: {
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "ProfileInfoHeading").waitForExistence(timeout: 5)
            }
        )
    }
} 