import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class PaddingChangeTests: BaseUITest {
    
    // PADDING_CHANGE_PREMIUM_BANNER Test
    func testPaddingChangePremiumBanner() {
        runTestWithFlagVariants(
            flagName: Flag.PADDING_CHANGE_PREMIUM_BANNER,
            testName: "PremiumBanner",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "PremiumBanner").waitForExistence(timeout: 5)
            }
        )
    }
    
    // PADDING_CHANGE_PROFILE_INFO Test
    func testPaddingChangeProfileInfo() {
        runTestWithFlagVariants(
            flagName: Flag.PADDING_CHANGE_PROFILE_INFO,
            testName: "ProfileInfo",
            setupAction: {
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "ProfileInfoHeading").waitForExistence(timeout: 5)
            }
        )
    }
    
    // PADDING_CHANGE_FEATURE_CARDS Test
    func testPaddingChangeFeatureCards() {
        runTestWithFlagVariants(
            flagName: Flag.PADDING_CHANGE_FEATURE_CARDS,
            testName: "FeatureCards",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "FeatureCard-Photos").waitForExistence(timeout: 5)
            }
        )
    }
} 