import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class MultiCategoryTests: BaseUITest {
    
    // Premium experience test combining multiple flags
    func testPremiumExperience() {
        runTestWithMultipleFlags(
            flagNames: [Flag.COLOR_CHANGE_PREMIUM_BADGE, Flag.CONTENT_CHANGE_PREMIUM_FEATURES],
            testName: "PremiumExperience",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
                app.elementWith(identifier: "ChangeUserTypeButton").forceTapElement()
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "ProfileAvatar").waitForExistence(timeout: 5)
            }
        )
    }
    
    // Homepage experience combining content and animation changes
    func testEnhancedHomeExperience() {
        runTestWithMultipleFlags(
            flagNames: [Flag.CONTENT_CHANGE_WELCOME_MESSAGE, Flag.ANIMATION_CHANGE_BUTTON_PRESS],
            testName: "EnhancedHome",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "PremiumBuyButton").waitForExistence(timeout: 5)
                app.elementWith(identifier: "PremiumBuyButton").forceTapElement()
            }
        )
    }
    
    // Settings page combining layout and style changes
    func testEnhancedSettingsExperience() {
        runTestWithMultipleFlags(
            flagNames: [Flag.LAYOUT_CHANGE_SETTINGS_SECTIONS, Flag.COLOR_CHANGE_TOGGLE_SWITCH],
            testName: "EnhancedSettings",
            setupAction: {
                app.elementWith(identifier: "settingsTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "SettingsScreen").waitForExistence(timeout: 5)
            }
        )
    }
    
    // Enhanced profile experience combining animation phase and layout changes
    func testEnhancedProfileExperience() {
        runTestWithMultipleFlags(
            flagNames: [Flag.ANIMATION_PHASE_PROFILE_PHOTO_ROTATE, Flag.LAYOUT_CHANGE_PROFILE_AVATAR],
            testName: "EnhancedProfile",
            setupAction: {
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "ProfileAvatar").waitForExistence(timeout: 5)
            }
        )
    }
} 
