import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class LayoutChangeTests: BaseUITest {
    
    override func setUp() {
        additionalLaunchArgs = ["UI-TESTING", "DISABLE-ANIMATIONS"]
        super.setUp()
    }
    
    // LAYOUT_CHANGE_SETTINGS_SECTIONS Test
    func testLayoutChangeSettingsSections() {
        runTestWithFlagVariants(
            flagName: "LAYOUT_CHANGE_SETTINGS_SECTIONS",
            testName: "SettingsSections",
            setupAction: {
                app.elementWith(identifier: "settingsTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "SettingsScreen").waitForExistence(timeout: 5)
            }
        )
    }
    
    // LAYOUT_CHANGE_PROFILE_AVATAR Test
    func testLayoutChangeProfileAvatar() {
        runTestWithFlagVariants(
            flagName: "LAYOUT_CHANGE_PROFILE_AVATAR",
            testName: "ProfileAvatar",
            setupAction: {
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "ProfileAvatar").waitForExistence(timeout: 5)
            }
        )
    }
} 
