import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class ContentChangeTests: BaseUITest {
    
    // CONTENT_CHANGE_WELCOME_MESSAGE Test
    func testContentChangeWelcomeMessage() {
        runTestWithFlagVariants(
            flagName: "CONTENT_CHANGE_WELCOME_MESSAGE",
            testName: "WelcomeMessage",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                XCTAssertTrue(app.staticTexts.element(boundBy: 0).waitForExistence(timeout: 5))
            }
        )
    }
    
    // CONTENT_CHANGE_PREMIUM_FEATURES Test
    func testContentChangePremiumFeatures() {
        runTestWithFlagVariants(
            flagName: "CONTENT_CHANGE_PREMIUM_FEATURES",
            testName: "PremiumFeatures",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
                app.scrollDown()
                app.elementWith(identifier: "ChangeUserTypeButton").forceTapElement()
            },
            snapshotAction: {
                sleep(1)
            }
        )
    }
} 
