import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class ColorChangeTests: BaseUITest {
    
    // COLOR_CHANGE_PREMIUM_BADGE Test
    func testColorChangePremiumBadge() {
        runTestWithFlagVariants(
            flagName: "COLOR_CHANGE_PREMIUM_BADGE",
            testName: "PremiumBadge",
            setupAction: {
                app.scrollDown()
                app.elementWith(identifier: "ChangeUserTypeButton").forceTapElement()
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "PremiumBadge").waitForExistence(timeout: 5)
            }
        )
    }
    
    // COLOR_CHANGE_TOGGLE_SWITCH Test
    func testColorChangeToggleSwitch() {
        runTestWithFlagVariants(
            flagName: "COLOR_CHANGE_TOGGLE_SWITCH",
            testName: "ToggleSwitch",
            setupAction: {
                app.elementWith(identifier: "settingsTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "DarkModeToggle").waitForExistence(timeout: 5)
            }
        )
    }
    
    // COLOR_CHANGE_PROFILE_STATS Test
    func testColorChangeProfileStats() {
        runTestWithFlagVariants(
            flagName: "COLOR_CHANGE_PROFILE_STATS",
            testName: "ProfileStats",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
                app.elementWith(identifier: "ChangeUserTypeButton").forceTapElement()
                app.elementWith(identifier: "profileTab").forceTapElement()
                app.scrollDown()
            },
            snapshotAction: {
                
            }
        )
    }
} 
