import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class AnimationPhaseTests: BaseUITest {
    
    // ANIMATION_PHASE_PREMIUM_PULSE Test
    func testAnimationPhasePremiumPulse() {
        runTestWithFlagVariants(
            flagName: Flag.ANIMATION_PHASE_PREMIUM_PULSE,
            testName: "PremiumPulse",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "PremiumBanner").waitForExistence(timeout: 5)
                sleep(1)
            }
        )
    }
    
    // ANIMATION_PHASE_PROFILE_PHOTO_ROTATE Test
    func testAnimationPhaseProfilePhotoRotate() {
        runTestWithFlagVariants(
            flagName: Flag.ANIMATION_PHASE_PROFILE_PHOTO_ROTATE,
            testName: "ProfilePhotoRotate",
            setupAction: {
                app.elementWith(identifier: "profileTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "ProfileAvatar").waitForExistence(timeout: 5)
                sleep(2)
            }
        )
    }
} 
