import XCTest
import SnapshotTestingCore
import SwiftUI
import Combine
@testable import SnapshotInstructor

final class AnimationChangeTests: BaseUITest {
    
    // ANIMATION_CHANGE_LOADING_SPINNER Test
    func testAnimationChangeLoadingSpinner() {
        runTestWithFlagVariants(
            flagName: "ANIMATION_CHANGE_LOADING_SPINNER",
            testName: "LoadingSpinner",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
                app.scrollDown()
                app.elementWith(identifier: "RefreshButton").forceTapElement()
            },
            snapshotAction: {
                sleep(1)
            }
        )
    }
    
    // ANIMATION_CHANGE_BUTTON_PRESS Test
    func testAnimationChangeButtonPress() {
        runTestWithFlagVariants(
            flagName: "ANIMATION_CHANGE_BUTTON_PRESS",
            testName: "ButtonPress",
            setupAction: {
                app.elementWith(identifier: "homeTab").forceTapElement()
            },
            snapshotAction: {
                app.elementWith(identifier: "PremiumBuyButton").waitForExistence(timeout: 5)
                app.elementWith(identifier: "PremiumBuyButton").forceTapElement()
            }
        )
    }
} 
