import SwiftUI

class TestingHelper {
    static let isUITesting: Bool = {
        return ProcessInfo.processInfo.arguments.contains("UI-TESTING")
    }()
    
    static let shouldDisableAnimations: Bool = {
        return ProcessInfo.processInfo.arguments.contains("DISABLE-ANIMATIONS")
    }()
    
    static var shouldEnableAnimations: Bool {
        // Always enable animations if we're testing an animation feature flag
        if hasAnimationFeatureFlag {
            return true
        }
        return !(isUITesting && shouldDisableAnimations)
    }
    
    static let hasAnimationFeatureFlag: Bool = {
        let args = ProcessInfo.processInfo.arguments
        return args.contains { arg in
            arg.contains("ENABLE_FLAG_ANIMATION")
        }
    }()
    
    static let fixedRotationDegrees: Double = 180
}

extension View {
    func applyTestingConstraints() -> some View {
        self
            .animation(TestingHelper.shouldEnableAnimations ? .default : .none, value: UUID())
    }
}
