import Foundation

enum FeatureFlags: String, CaseIterable {
    case PADDING_CHANGE_PREMIUM_BANNER
    case PADDING_CHANGE_PROFILE_INFO
    case PADDING_CHANGE_FEATURE_CARDS
    
    case COLOR_CHANGE_PREMIUM_BADGE
    case COLOR_CHANGE_TOGGLE_SWITCH
    case COLOR_CHANGE_PROFILE_STATS
    
    case TEXT_CHANGE_PREMIUM_BUTTON
    case TEXT_CHANGE_PROFILE_HEADING
    
    case LAYOUT_CHANGE_SETTINGS_SECTIONS
    case LAYOUT_CHANGE_PROFILE_AVATAR
    
    // New animation change flags
    case ANIMATION_CHANGE_LOADING_SPINNER
    case ANIMATION_CHANGE_BUTTON_PRESS
    
    // New content change flags
    case CONTENT_CHANGE_PREMIUM_FEATURES
    case CONTENT_CHANGE_WELCOME_MESSAGE
    
    // Animation phase flags - controls animation timing and effects
    case ANIMATION_PHASE_PREMIUM_PULSE
    case ANIMATION_PHASE_PROFILE_PHOTO_ROTATE
    
    private static var enabledFlags: Set<FeatureFlags> = []
    private static var didLoadFromArguments = false
    
    private static func loadFlagsFromArguments() {
        if didLoadFromArguments {
            return
        }
        
        let arguments = ProcessInfo.processInfo.arguments
        print("📱 App launch arguments: \(arguments)")
        
        for flag in FeatureFlags.allCases {
            let flagArgument = "ENABLE_FLAG_\(flag.rawValue)"
            if arguments.contains(flagArgument) {
                enabledFlags.insert(flag)
                print("🚩 Enabled feature flag: \(flag.rawValue)")
            }
        }
        
        print("📋 All enabled flags: \(enabledFlags.map { $0.rawValue }.joined(separator: ", "))")
        didLoadFromArguments = true
    }
    
    static func isEnabled(_ flag: FeatureFlags) -> Bool {
        loadFlagsFromArguments()
        
        let isEnabled = enabledFlags.contains(flag)
        if isEnabled {
            print("✅ Flag is enabled: \(flag.rawValue)")
        }
        return isEnabled
    }
    
    static func enable(_ flag: FeatureFlags) {
        loadFlagsFromArguments()
        enabledFlags.insert(flag)
        print("🔧 Manually enabled flag: \(flag.rawValue)")
    }
    
    static func disable(_ flag: FeatureFlags) {
        loadFlagsFromArguments()
        enabledFlags.remove(flag)
        print("🔧 Manually disabled flag: \(flag.rawValue)")
    }
    
    static func reset() {
        enabledFlags.removeAll()
        print("🧹 Reset all flags")
    }
} 

