import SwiftUI
import Combine

enum UserType {
    case free
    case premium
}

@Observable class UserStateManager: ObservableObject {
    static let shared = UserStateManager()
    
    var userType: UserType = .free
    var greeting: String = ""
    var locale: Locale = .current
    
    private let possibleGreetings = [
        "Hello there!",
        "Welcome back!",
        "Great to see you!",
        "How are you today?",
        "Ready to explore?"
    ]
    
    private init() {
        updateRandomGreeting()
    }
    
    func toggleUserType() {
        userType = userType == .free ? .premium : .free
    }
    
    func updateRandomGreeting() {
        guard let randomGreeting = possibleGreetings.randomElement() else { return }
        greeting = randomGreeting
    }
    
    func setLocale(_ identifier: String) {
        locale = Locale(identifier: identifier)
    }
    
    func resetToDefault() {
        userType = .free
        updateRandomGreeting()
        locale = .current
    }
} 
