import SwiftUI

struct MainTabView: View {
    @State private var selectedTab = 0
    
    var body: some View {
        TabView(selection: $selectedTab) {
            NavigationView {
                HomeScreen()
            }
            .tabItem {
                Label("Home", systemImage: "house.fill")
                    .accessibilityIdentifier("homeTab")
            }
            .tag(0)
            
            NavigationView {
                ProfileScreen()
            }
            .tabItem {
                Label("Profile", systemImage: "person.fill")
                    .accessibilityIdentifier("profileTab")
            }
            .tag(1)
            
            NavigationView {
                SettingsScreen()
            }
            .tabItem {
                Label("Settings", systemImage: "gear")
                    .accessibilityIdentifier("settingsTab")
            }
            .tag(2)
        }
    }
}

#Preview {
    MainTabView()
} 
