import SwiftUI

struct PremiumContent: View {
    var body: some View {
        VStack(spacing: 16) {
            HStack {
                Image(systemName: "crown.fill")
                    .foregroundColor(.yellow)
                    .font(.title)
                Text("Premium Content")
                    .font(.title2)
                    .fontWeight(.bold)
                    .foregroundColor(.primary)
            }
            
            Text("Thank you for being a premium member! Enjoy exclusive features and content.")
                .multilineTextAlignment(.center)
                .font(.body)
                .foregroundColor(.secondary)
                .padding(.horizontal)
            
            VStack(alignment: .leading, spacing: 12) {
                premiumFeatureRow(icon: "checkmark.seal.fill", title: "Ad-Free Experience", description: "No more interruptions")
                premiumFeatureRow(icon: "icloud.and.arrow.down.fill", title: "Unlimited Downloads", description: "Save as much as you want")
                premiumFeatureRow(icon: "bolt.fill", title: "Priority Support", description: "Get help when you need it")
                premiumFeatureRow(icon: "wand.and.stars", title: "Exclusive Content", description: "Only for premium members")
            }
            .padding()
            .background(Color(.systemBackground))
            .cornerRadius(12)
            .shadow(color: Color.black.opacity(0.1), radius: 5, x: 0, y: 2)
            .padding(.horizontal)
        }
        .padding()
    }
    
    private func premiumFeatureRow(icon: String, title: String, description: String) -> some View {
        HStack(spacing: 12) {
            Image(systemName: icon)
                .foregroundColor(.blue)
                .font(.system(size: 22))
                .frame(width: 24, height: 24)
            
            VStack(alignment: .leading, spacing: 2) {
                Text(title)
                    .font(.headline)
                    .foregroundColor(.primary)
                Text(description)
                    .font(.subheadline)
                    .foregroundColor(.secondary)
            }
            
            Spacer()
        }
    }
}

#Preview {
    PremiumContent()
        .preferredColorScheme(.light)
} 