import SwiftUI

struct PremiumBanner: View {
    @State private var isAnimating = false
    @State private var buttonScale: CGFloat = 1.0
    
    var animationsEnabled: Bool = TestingHelper.shouldEnableAnimations
    
    var body: some View {
        VStack(alignment: .leading, spacing: 12) {
            HStack {
                Image(systemName: "star.fill")
                    .foregroundColor(.yellow)
                Text("Upgrade Now!")
                    .font(.headline)
                    .foregroundColor(.white)
                Spacer()
            }
            
            Text("Get access to premium features and unlock the full experience!")
                .font(.subheadline)
                .foregroundColor(.white.opacity(0.9))
            
            Button(action: {
                if animationsEnabled && FeatureFlags.isEnabled(.ANIMATION_CHANGE_BUTTON_PRESS) {
                    withAnimation(.spring(response: 0.3, dampingFraction: 0.6)) {
                        buttonScale = 0.95
                    }
                    
                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
                        withAnimation(.spring(response: 0.3, dampingFraction: 0.6)) {
                            buttonScale = 1.0
                        }
                    }
                }
            }) {
                Text(FeatureFlags.isEnabled(.TEXT_CHANGE_PREMIUM_BUTTON) ? "Unlock Premium!" : "Buy Premium Today!")
                    .font(.headline)
                    .foregroundColor(.black)
                    .padding(.vertical, 8)
                    .padding(.horizontal, 16)
                    .background(Color.yellow)
                    .cornerRadius(8)
            }
            .scaleEffect(buttonScale)
            .padding(.top, 8)
            .accessibilityIdentifier("PremiumBuyButton")
        }
        .padding(16)
        .padding(.top, FeatureFlags.isEnabled(.PADDING_CHANGE_PREMIUM_BANNER) ? 16 : 0)
        .background(
            LinearGradient(
                gradient: Gradient(colors: [Color.blue, Color.purple]),
                startPoint: .leading,
                endPoint: .trailing
            )
        )
        .cornerRadius(12)
        .shadow(radius: 4)
        .padding(.horizontal)
        .scaleEffect(isAnimating ? (FeatureFlags.isEnabled(.ANIMATION_PHASE_PREMIUM_PULSE) ? 1.08 : 1.03) : 1.0)
        .opacity(isAnimating ? (FeatureFlags.isEnabled(.ANIMATION_PHASE_PREMIUM_PULSE) ? 1.0 : 0.9) : 0.9)
        .onAppear {
            if animationsEnabled {
                if FeatureFlags.isEnabled(.ANIMATION_PHASE_PREMIUM_PULSE) {
                    isAnimating = true
                    
                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.1) {
                        withAnimation(Animation.easeInOut(duration: 0.5).repeatForever(autoreverses: true)) {
                            isAnimating = true
                        }
                    }
                } else {
                    withAnimation(Animation.easeInOut(duration: 1.5).repeatForever(autoreverses: true)) {
                        isAnimating = true
                    }
                }
            } else {
                isAnimating = true
            }
        }
//        .applyTestingConstraints()
        .accessibilityIdentifier("PremiumBanner")
    }
}

#Preview {
    PremiumBanner()
} 
