# LLMShot

A tool for analyzing UI snapshot differences using LLMs. This project helps identify visual differences between expected and actual UI screenshots, categorize the differences, simulate ignoring them, and generate comprehensive analysis reports.

## Requirements

- Python 3.8+
- Ollama (with gemma3:4b and gemma3:12b models installed)
- Pillow
- NumPy
- colorama

## Installation

1. Clone the repository:
   ```bash
   git clone https://github.com/yourusername/SnapshotInstructor.git
   cd SnapshotInstructor
   ```

2. Install required Python packages:
   ```bash
   pip install numpy pillow colorama
   ```

3. Install Ollama:
   - Follow the instructions at [ollama.ai](https://ollama.ai) to install Ollama
   - Pull the required models:
     ```bash
     ollama pull gemma3:4b
     ollama pull gemma3:12b
     ```

4. Prepare your own dataset:
   - Create a `dataset` directory in the project root
   - Execute tests in Xcode
   - Run `generate_dataset.sh`
   - Each test directory should contain:
     - `reference.png`: Expected UI state
     - `failure.png`: Current UI state with potential issues
     - `diff.png`: Visualization of differences
     - `metadata.json`: Test details and categories

## Usage

### Interactive Mode

Run the tool with no arguments to use the interactive menu:

```bash
python process_snapshots.py
```

This will present a menu with these options:
1. **Select Model**: Choose between 4b or 12b models
2. **Run Standard Analysis**: Analyze all snapshots and identify differences
3. **Run 'Ignore Reason' Analysis (From Analysis)**: Ignore the main difference found in the standard analysis
4. **Run 'Ignore Reason' Analysis (From Metadata)**: Ignore the first category from metadata
5. **Run 'Analyze and Ignore' Analysis**: Detect and ignore the main difference in a single step

### Automated Mode

Run all analyses with both models in batch mode:

```bash
python process_snapshots.py --all
```

This will:
1. Run all four analysis modes with the 4b model
2. Run all four analysis modes with the 12b model
3. Generate a comprehensive report

## Generating Reports

After running analyses, generate a visual HTML report:

```bash
python generate_report.py
```

The report will be created in the `reports/` directory and automatically opened in your default browser.

## ReportED Features

- **Metrics Dashboard**: See aggregated accuracy and performance metrics across all analysis modes
- **Test Case Browser**: View individual test cases with images and detailed analysis
- **Visual Comparison**: Compare reference and failure images with highlighted differences
