#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Sep  6 17:10:21 2024

@author: brown
"""

import pandas as pd
import os
	

# Loading data (only the two first columns of the file 'defense_finder_systems_wophages_nored100.tsv')
df = pd.read_csv("./st_woallphages_nored100_defsys.tsv", sep='\t', index_col = False, names = ['Strains','Types'])

# Create a binary matrix with defense systems as rows and strains as columns
binary_matrix = df.pivot_table(index='Strains', 
                               columns='Types', 
                               aggfunc='size', 
                               fill_value=0)

binary_matrix.to_csv("binary_matrix_wophages.tsv",sep="\t") 
