#!/bin/bash
#SBATCH -p week2
#SBATCH -N 1
#SBATCH -n 64
#SBATCH -J iqtree
#SBATCH -w cr03

#module load MAFFT

####Assembly of the complete sequences of the gene cores

#perl assembly_seq.pl >seqs_phylo_importance.fasta

#perl uniq_seq.pl seqs_phylo_importance.fasta

####Sequence alignment and removal of misaligned areas

#"/apps/ebuild/.local/easybuild/software/MAFFT/7.305-foss-2016b-with-extensions/bin/mafft" --auto --phylipout --thread 32 --reorder "seq_importance_uniq.fasta" > "seq_importance_uniq.mafft"

#clipkit seq_importance_uniq.mafft -m kpi

####Phylogeny building (previous step to optimize the model)

#iqtree2 -s seq_uniq.mafft.clipkit.uniqueseq.phy -m MFP -T 64

iqtree2 -s seq_uniq.mafft.clipkit.uniqueseq.phy --seed 12345 -T 64 -bb 1000 -m VT+R10
