#!/usr/bin/perl
use strict;

my $file=$ARGV[0];

open (IN, "$file");

my %hash;
my %cont;
my $seq;
my $id;

while (my $linea=<IN>){
	chomp $linea;
	if ($linea=~/^>(.+)/){
		$id=$linea;
		$id=~s/>//g;
	} else {
		$seq=$linea;
		$hash{$seq}.=$id."-";
		$cont{$seq}++;
	}
}

my $contador;

open (OUT1, ">groups.txt");
open (OUT2, ">seq__uniq.fasta");

print OUT1 "Group\tCount\tStrain\n";

foreach my $var (keys %hash){
	my $name;
	if ($cont{$var}==1){
		$name=$hash{$var};
		$name=~s/-//g;
	} else {
		$contador++;
		$name="Group_".$contador;
		$hash{$var}=~s/-$//;
		print OUT1 "$name\t$cont{$var}\t$hash{$var}\n";
	}
	print OUT2 ">$name\n$var\n";
}

close IN;

close OUT1;

close OUT2;
