#!/usr/bin/perl
use strict;

open (IN, "all_proteomes.fasta");

my %seq;
my $id;
my $sec;

while (my $linea=<IN>){
	chomp $linea;
	if ($linea=~/^>(.+)/){
		$id=$linea;
		$id=~s/\s(.+)//g;
		$id=~s/>//g;
		$sec="";
	} else {
		$sec.=$linea;
		$seq{$id}=$sec;
	}
}

open (IN2, "clustered_proteins_fil");

my %genes;

while (my $linea=<IN2>){
	chomp $linea;
	my @lista= split (/:\s/, $linea);
	#$lista[1]=~s/_.{1,5}//g;
	#print "$lista[1]\n";
	my @lista_gene=split (/\t/, $lista[1]);
	foreach my $aa (@lista_gene){
		my $cepa=$aa;
		$cepa=~s/_.{1,5}//g;
		$genes{$cepa}{$lista[0]}=$aa;
		#print "$lista[0]\t$cepa\t$aa\n";
	}
}

open (IN3, "id_strain");

my @strains;

while (my $linea=<IN3>){
	chomp $linea;
	push @strains, $linea
}

open (IN4, "orden_genes.txt");

my @gen;

while (my $linea=<IN4>){
	chomp $linea;
	push @gen, $linea
}

foreach my $var1 (@strains){
	print ">$var1\n";
	foreach my $var2 (@gen){
		print "$seq{$genes{$var1}{$var2}}"
	}
	print "\n";
}
