#!/usr/bin/perl
use strict;

my $ST = $ARGV[0] || 1;
my $DS = $ARGV[1] || "defsys_presaus_ann.tsv";
my $PH = $ARGV[2] || "logical_viruses.tsv";
my %ab;

# Strains
open in, "/home/user/MLST/ST$ST.ab";
while (<in>) {
  chomp;
  $ab{$_} =1;
}
close in;

# Defense systems
open DS, $DS;
my ($a1, @DS) = split/\t/, <DS>;
chomp $DS[$#DS];

my %D;
my @DS2;
while (<DS>) {
  chomp;

  my ($ab, @d) = split/\t/;
  next unless $ab{$ab};
  @d = grep/[A-Za-z]/, @d;
  my $d = join ",", @d;
  $D{$ab} = $d;
  push @DS2, $d unless grep/^$d$/, @DS2;
}
close DS;

# Phages
my %c;
open PH, $PH;
my ($a1, @PH) = split/\t/, <PH>;
chomp $PH[$#PH];

while (<PH>) {
  chomp;

  my ($ab, @p) = split/\t/;
  next unless $ab{$ab};
  for (my $x = 0; $x <= $#PH; $x++) {
    next unless $p[$x] eq "1";
    my $p = $PH[$x];
    $c{$D{$ab}}{$p}++;
  }
}
close PH;

# Output
print "Defense_system\tPhage\tn\n";
foreach my $d (@DS2) {
  foreach my $p (@PH) {
    $c{$d}{$p} = 0 if !$c{$d}{$p};
    print "$d\t$p\t$c{$d}{$p}\n";
  }
}

exit;

