% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl.R
\name{get_apl_cutoff}
\alias{get_apl_cutoff}
\title{Calculates the S_alpha cutoff based on random directions or permutations of the data}
\usage{
get_apl_cutoff(
  caobj,
  method = "random",
  group = caobj@group,
  counts = NULL,
  quant = 0.99,
  apl_cutoff_reps = 100,
  axis = "cols"
)
}
\arguments{
\item{caobj}{A cacomp object.}

\item{method}{Method to use for computing the cutoff.
Either "random" or "permutation".}

\item{group}{A vector of group indices.}

\item{counts}{The original count matrix that was used to compute the caobj.}

\item{quant}{The quantile to use for the cutoff.}

\item{apl_cutoff_reps}{The number of repetitions to use.
Should be between 3-10 for permutation, and >=100 for random.}

\item{axis}{The axis for which the cutoff should be calculated, either "cols" or "rows".}
}
\value{
The cutoff angle alpha in radians.
}
\description{
Calculates the S_alpha cutoff based on random directions or permutations of the data
}
