% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirclust.R
\name{dirclust}
\alias{dirclust}
\title{Basic clustering by directions in CA space}
\usage{
dirclust(
  points,
  k,
  epochs = NULL,
  init = "kmeanspp",
  lines = NULL,
  log = FALSE,
  cadir = NULL,
  convergence_thr = 0.001,
  max_iter = 50
)
}
\arguments{
\item{points}{Matrix of points to be clustered.
Points are expected to be rows.}

\item{k}{Number of clusters.}

\item{epochs}{Number of iterations.}

\item{init}{Initialization method for the lines. Options are 'rand' and
'kmeanspp'.}

\item{lines}{Optional. Row-wise matrix of lines.
If not NULL, then the provided lines are used for initialization.}

\item{log}{Logical. If TRUE, then the function returns a list with
the computed distances and directions at each step.}

\item{cadir}{If a cadir object is provided, uses this instead of \code{lines} to
initialize the clustering.}

\item{convergence_thr}{Angle between directions from different iterations in
degrees below or equal which convergence is reached.}

\item{max_iter}{Maximum number of iterations if no convergence.}
}
\value{
An element of class cadir.
}
\description{
Basic clustering by directions in CA space
}
