% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celltype_anno.R
\name{annotate_by_goa,cadir-method}
\alias{annotate_by_goa,cadir-method}
\title{Annotate CAbiNet results by gene overrepresentation
analysis results.}
\usage{
\S4method{annotate_by_goa}{cadir}(obj, goa_res, alpha = 0.05)
}
\arguments{
\item{obj}{\code{cadir} object with biclustering results. Alternatively could be
a caclust object.}

\item{goa_res}{List of goa results for each bicluster.}

\item{alpha}{Adjusted p-value cutoff.
Only results with padj < alpha will be used.}
}
\value{
Object of the same type as \code{obj}.
}
\description{
\code{annotate_by_goa} takes a biclustering results such as outputted by \code{caclust}
and annotates it with the gene overrepresentation analysis results (goa).

Conflicts between clusters that have the
same highest ranking gene set are solved
with the Hungarian/Munkres algorithm.
}
